/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class EntryGroup
extends CompositeEntryBase {
    public static final MapCodec<EntryGroup> CODEC = EntryGroup.createCodec(EntryGroup::new);

    EntryGroup(List<LootPoolEntryContainer> var0, List<LootItemCondition> var1) {
        super(var0, var1);
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.GROUP;
    }

    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> var0) {
        return switch (var0.size()) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> var0.get(0);
            case 2 -> {
                ComposableEntryContainer var1 = var0.get(0);
                ComposableEntryContainer var2 = var0.get(1);
                yield (var2, var3) -> {
                    var1.expand(var2, var3);
                    var2.expand(var2, var3);
                    return true;
                };
            }
            default -> (var1, var2) -> {
                for (ComposableEntryContainer var4 : var0) {
                    var4.expand(var1, var2);
                }
                return true;
            };
        };
    }

    public static Builder list(LootPoolEntryContainer.Builder<?> ... var0) {
        return new Builder(var0);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... var0) {
            for (LootPoolEntryContainer.Builder<?> var4 : var0) {
                this.entries.add((Object)var4.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder append(LootPoolEntryContainer.Builder<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return new EntryGroup((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }

        @Override
        protected /* synthetic */ LootPoolEntryContainer.Builder getThis() {
            return this.getThis();
        }
    }
}

