/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.Tag;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final String BLOCK_ENTITY_ID = "block_entity";
    private static final Getter BLOCK_ENTITY_PROVIDER = new Getter(){

        @Override
        public Tag get(LootContext var0) {
            BlockEntity var1 = var0.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            return var1 != null ? var1.saveWithFullMetadata(var1.getLevel().registryAccess()) : null;
        }

        @Override
        public String getId() {
            return ContextNbtProvider.BLOCK_ENTITY_ID;
        }

        @Override
        public Set<ContextKey<?>> getReferencedContextParams() {
            return Set.of(LootContextParams.BLOCK_ENTITY);
        }
    };
    public static final ContextNbtProvider BLOCK_ENTITY = new ContextNbtProvider(BLOCK_ENTITY_PROVIDER);
    private static final Codec<Getter> GETTER_CODEC = Codec.STRING.xmap(var0 -> {
        if (var0.equals(BLOCK_ENTITY_ID)) {
            return BLOCK_ENTITY_PROVIDER;
        }
        LootContext.EntityTarget var1 = LootContext.EntityTarget.getByName(var0);
        return ContextNbtProvider.forEntity(var1);
    }, Getter::getId);
    public static final MapCodec<ContextNbtProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)GETTER_CODEC.fieldOf("target").forGetter(var0 -> var0.getter)).apply((Applicative)var02, ContextNbtProvider::new));
    public static final Codec<ContextNbtProvider> INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, var0 -> var0.getter);
    private final Getter getter;

    private static Getter forEntity(final LootContext.EntityTarget var0) {
        return new Getter(){

            @Override
            @Nullable
            public Tag get(LootContext var02) {
                Entity var1 = var02.getOptionalParameter(var0.getParam());
                return var1 != null ? NbtPredicate.getEntityTagToCompare(var1) : null;
            }

            @Override
            public String getId() {
                return var0.name();
            }

            @Override
            public Set<ContextKey<?>> getReferencedContextParams() {
                return Set.of(var0.getParam());
            }
        };
    }

    private ContextNbtProvider(Getter var0) {
        this.getter = var0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public Tag get(LootContext var0) {
        return this.getter.get(var0);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.getter.getReferencedContextParams();
    }

    public static NbtProvider forContextEntity(LootContext.EntityTarget var0) {
        return new ContextNbtProvider(ContextNbtProvider.forEntity(var0));
    }

    static interface Getter {
        @Nullable
        public Tag get(LootContext var1);

        public String getId();

        public Set<ContextKey<?>> getReferencedContextParams();
    }
}

