/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.util.BitSet;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IndexMerger;

public final class BitSetDiscreteVoxelShape
extends DiscreteVoxelShape {
    private final BitSet storage;
    private int xMin;
    private int yMin;
    private int zMin;
    private int xMax;
    private int yMax;
    private int zMax;

    public BitSetDiscreteVoxelShape(int var0, int var1, int var2) {
        super(var0, var1, var2);
        this.storage = new BitSet(var0 * var1 * var2);
        this.xMin = var0;
        this.yMin = var1;
        this.zMin = var2;
    }

    public static BitSetDiscreteVoxelShape withFilledBounds(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8) {
        BitSetDiscreteVoxelShape var9 = new BitSetDiscreteVoxelShape(var0, var1, var2);
        var9.xMin = var3;
        var9.yMin = var4;
        var9.zMin = var5;
        var9.xMax = var6;
        var9.yMax = var7;
        var9.zMax = var8;
        for (int var10 = var3; var10 < var6; ++var10) {
            for (int var11 = var4; var11 < var7; ++var11) {
                for (int var12 = var5; var12 < var8; ++var12) {
                    var9.fillUpdateBounds(var10, var11, var12, false);
                }
            }
        }
        return var9;
    }

    public BitSetDiscreteVoxelShape(DiscreteVoxelShape var0) {
        super(var0.xSize, var0.ySize, var0.zSize);
        if (var0 instanceof BitSetDiscreteVoxelShape) {
            this.storage = (BitSet)((BitSetDiscreteVoxelShape)var0).storage.clone();
        } else {
            this.storage = new BitSet(this.xSize * this.ySize * this.zSize);
            for (int var1 = 0; var1 < this.xSize; ++var1) {
                for (int var2 = 0; var2 < this.ySize; ++var2) {
                    for (int var3 = 0; var3 < this.zSize; ++var3) {
                        if (!var0.isFull(var1, var2, var3)) continue;
                        this.storage.set(this.getIndex(var1, var2, var3));
                    }
                }
            }
        }
        this.xMin = var0.firstFull(Direction.Axis.X);
        this.yMin = var0.firstFull(Direction.Axis.Y);
        this.zMin = var0.firstFull(Direction.Axis.Z);
        this.xMax = var0.lastFull(Direction.Axis.X);
        this.yMax = var0.lastFull(Direction.Axis.Y);
        this.zMax = var0.lastFull(Direction.Axis.Z);
    }

    protected int getIndex(int var0, int var1, int var2) {
        return (var0 * this.ySize + var1) * this.zSize + var2;
    }

    @Override
    public boolean isFull(int var0, int var1, int var2) {
        return this.storage.get(this.getIndex(var0, var1, var2));
    }

    private void fillUpdateBounds(int var0, int var1, int var2, boolean var3) {
        this.storage.set(this.getIndex(var0, var1, var2));
        if (var3) {
            this.xMin = Math.min(this.xMin, var0);
            this.yMin = Math.min(this.yMin, var1);
            this.zMin = Math.min(this.zMin, var2);
            this.xMax = Math.max(this.xMax, var0 + 1);
            this.yMax = Math.max(this.yMax, var1 + 1);
            this.zMax = Math.max(this.zMax, var2 + 1);
        }
    }

    @Override
    public void fill(int var0, int var1, int var2) {
        this.fillUpdateBounds(var0, var1, var2, true);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public int firstFull(Direction.Axis var0) {
        return var0.choose(this.xMin, this.yMin, this.zMin);
    }

    @Override
    public int lastFull(Direction.Axis var0) {
        return var0.choose(this.xMax, this.yMax, this.zMax);
    }

    static BitSetDiscreteVoxelShape join(DiscreteVoxelShape var0, DiscreteVoxelShape var1, IndexMerger var2, IndexMerger var3, IndexMerger var4, BooleanOp var5) {
        BitSetDiscreteVoxelShape var6 = new BitSetDiscreteVoxelShape(var2.size() - 1, var3.size() - 1, var4.size() - 1);
        int[] var72 = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        var2.forMergedIndexes((var7, var8, var9) -> {
            boolean[] var102 = new boolean[]{false};
            var3.forMergedIndexes((var10, var11, var122) -> {
                boolean[] var132 = new boolean[]{false};
                var4.forMergedIndexes((var12, var13, var14) -> {
                    if (var5.apply(var0.isFullWide(var7, var10, var12), var1.isFullWide(var8, var11, var13))) {
                        var7.storage.set(var6.getIndex(var9, var122, var14));
                        var10[2] = Math.min(var72[2], var14);
                        var10[5] = Math.max(var72[5], var14);
                        var11[0] = true;
                    }
                    return true;
                });
                if (var132[0]) {
                    var8[1] = Math.min(var72[1], var122);
                    var8[4] = Math.max(var72[4], var122);
                    var9[0] = true;
                }
                return true;
            });
            if (var102[0]) {
                var6[0] = Math.min(var72[0], var9);
                var6[3] = Math.max(var72[3], var9);
            }
            return true;
        });
        var6.xMin = var72[0];
        var6.yMin = var72[1];
        var6.zMin = var72[2];
        var6.xMax = var72[3] + 1;
        var6.yMax = var72[4] + 1;
        var6.zMax = var72[5] + 1;
        return var6;
    }

    protected static void forAllBoxes(DiscreteVoxelShape var0, DiscreteVoxelShape.IntLineConsumer var1, boolean var2) {
        BitSetDiscreteVoxelShape var3 = new BitSetDiscreteVoxelShape(var0);
        for (int var4 = 0; var4 < var3.ySize; ++var4) {
            for (int var5 = 0; var5 < var3.xSize; ++var5) {
                int var6 = -1;
                for (int var7 = 0; var7 <= var3.zSize; ++var7) {
                    if (var3.isFullWide(var5, var4, var7)) {
                        if (var2) {
                            if (var6 != -1) continue;
                            var6 = var7;
                            continue;
                        }
                        var1.consume(var5, var4, var7, var5 + 1, var4 + 1, var7 + 1);
                        continue;
                    }
                    if (var6 == -1) continue;
                    int var8 = var5;
                    int var9 = var4;
                    var3.clearZStrip(var6, var7, var5, var4);
                    while (var3.isZStripFull(var6, var7, var8 + 1, var4)) {
                        var3.clearZStrip(var6, var7, var8 + 1, var4);
                        ++var8;
                    }
                    while (var3.isXZRectangleFull(var5, var8 + 1, var6, var7, var9 + 1)) {
                        for (int var10 = var5; var10 <= var8; ++var10) {
                            var3.clearZStrip(var6, var7, var10, var9 + 1);
                        }
                        ++var9;
                    }
                    var1.consume(var5, var4, var6, var8 + 1, var9 + 1, var7);
                    var6 = -1;
                }
            }
        }
    }

    private boolean isZStripFull(int var0, int var1, int var2, int var3) {
        if (var2 >= this.xSize || var3 >= this.ySize) {
            return false;
        }
        return this.storage.nextClearBit(this.getIndex(var2, var3, var0)) >= this.getIndex(var2, var3, var1);
    }

    private boolean isXZRectangleFull(int var0, int var1, int var2, int var3, int var4) {
        for (int var5 = var0; var5 < var1; ++var5) {
            if (this.isZStripFull(var2, var3, var5, var4)) continue;
            return false;
        }
        return true;
    }

    private void clearZStrip(int var0, int var1, int var2, int var3) {
        this.storage.clear(this.getIndex(var2, var3, var0), this.getIndex(var2, var3, var1));
    }

    public boolean isInterior(int var0, int var1, int var2) {
        boolean var3 = var0 > 0 && var0 < this.xSize - 1 && var1 > 0 && var1 < this.ySize - 1 && var2 > 0 && var2 < this.zSize - 1;
        return var3 && this.isFull(var0, var1, var2) && this.isFull(var0 - 1, var1, var2) && this.isFull(var0 + 1, var1, var2) && this.isFull(var0, var1 - 1, var2) && this.isFull(var0, var1 + 1, var2) && this.isFull(var0, var1, var2 - 1) && this.isFull(var0, var1, var2 + 1);
    }
}

