/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Fire;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;

public final class CraftFire
extends CraftBlockData
implements Fire,
Ageable,
MultipleFacing {
    private static final IntegerProperty AGE = CraftFire.getInteger(FireBlock.class, "age");
    private static final BooleanProperty[] FACES = new BooleanProperty[]{CraftFire.getBoolean(FireBlock.class, "north", true), CraftFire.getBoolean(FireBlock.class, "east", true), CraftFire.getBoolean(FireBlock.class, "south", true), CraftFire.getBoolean(FireBlock.class, "west", true), CraftFire.getBoolean(FireBlock.class, "up", true), CraftFire.getBoolean(FireBlock.class, "down", true)};

    public CraftFire() {
    }

    public CraftFire(BlockState state) {
        super(state);
    }

    public int getAge() {
        return this.get(AGE);
    }

    public void setAge(int age) {
        this.set(AGE, age);
    }

    public int getMaximumAge() {
        return CraftFire.getMax(AGE);
    }

    public boolean hasFace(BlockFace face) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null || !this.get(FACES[i]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }
}

