/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.ResinClump;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;

public final class CraftMultiface
extends CraftBlockData
implements ResinClump,
MultipleFacing,
Waterlogged {
    private static final BooleanProperty[] FACES = new BooleanProperty[]{CraftMultiface.getBoolean(MultifaceBlock.class, "north", true), CraftMultiface.getBoolean(MultifaceBlock.class, "east", true), CraftMultiface.getBoolean(MultifaceBlock.class, "south", true), CraftMultiface.getBoolean(MultifaceBlock.class, "west", true), CraftMultiface.getBoolean(MultifaceBlock.class, "up", true), CraftMultiface.getBoolean(MultifaceBlock.class, "down", true)};
    private static final BooleanProperty WATERLOGGED = CraftMultiface.getBoolean(MultifaceBlock.class, "waterlogged");

    public CraftMultiface() {
    }

    public CraftMultiface(BlockState state) {
        super(state);
    }

    public boolean hasFace(BlockFace face) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null || !this.get(FACES[i]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

