/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMob;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;

public class CraftEnderDragon
extends CraftMob
implements org.bukkit.entity.EnderDragon,
CraftEnemy {
    public CraftEnderDragon(CraftServer server, EnderDragon entity) {
        super(server, entity);
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EnderDragonPart part : this.getHandle().subEntities) {
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
        }
        return builder.build();
    }

    @Override
    public EnderDragon getHandle() {
        return (EnderDragon)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderDragon";
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().getEntityData().get(EnderDragon.DATA_PHASE)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().getPhaseManager().setPhase(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(EnderDragonPhase phase) {
        return EnderDragon.Phase.values()[phase.getId()];
    }

    public static EnderDragonPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return EnderDragonPhase.getById(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().getDragonFight() != null ? new CraftDragonBattle(this.getHandle().getDragonFight()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().dragonDeathTime;
    }
}

