/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, net.minecraft.world.entity.animal.sniffer.Sniffer entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.sniffer.Sniffer getHandle() {
        return (net.minecraft.world.entity.animal.sniffer.Sniffer)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().getExploredPositions().map(blockPosition -> CraftLocation.toBukkit(blockPosition.pos(), this.server.getServer().getLevel(blockPosition.dimension()))).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        BlockPos blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, this.getHandle().getExploredPositions().filter(blockPositionExplored -> !blockPositionExplored.equals(blockPosition)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().storeExploredPosition(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().getState());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().transitionTo(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().calculateDigPosition().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().canDig();
    }

    private Sniffer.State stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> Sniffer.State.IDLING;
            case Sniffer.State.FEELING_HAPPY -> Sniffer.State.FEELING_HAPPY;
            case Sniffer.State.SCENTING -> Sniffer.State.SCENTING;
            case Sniffer.State.SNIFFING -> Sniffer.State.SNIFFING;
            case Sniffer.State.SEARCHING -> Sniffer.State.SEARCHING;
            case Sniffer.State.DIGGING -> Sniffer.State.DIGGING;
            case Sniffer.State.RISING -> Sniffer.State.RISING;
        };
    }

    private Sniffer.State stateToBukkit(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> Sniffer.State.IDLING;
            case Sniffer.State.FEELING_HAPPY -> Sniffer.State.FEELING_HAPPY;
            case Sniffer.State.SCENTING -> Sniffer.State.SCENTING;
            case Sniffer.State.SNIFFING -> Sniffer.State.SNIFFING;
            case Sniffer.State.SEARCHING -> Sniffer.State.SEARCHING;
            case Sniffer.State.DIGGING -> Sniffer.State.DIGGING;
            case Sniffer.State.RISING -> Sniffer.State.RISING;
        };
    }
}

