/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Main;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R5.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends bwc<anb>
implements amu,
ehg,
ej {
    public static final Logger l = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float m = 0.8f;
    private static final int n = 100;
    private static final long o = 30L * bdg.a / 20L;
    private static final int p = 20;
    private static final long q = 10L * bdg.a;
    private static final int r = 100;
    private static final long s = 5L * bdg.a;
    private static final long t = 10L * bdg.b;
    private static final int u = 12;
    private static final int v = 5;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int c = 29999984;
    public static final dmy d = new dmy("Demo World", dmr.a, false, bxg.c, false, new dmq(cyf.h), dns.d);
    public static final GameProfile e = new GameProfile(ag.e, "Anonymous Player");
    public fcs.c f;
    public final fcv g;
    private final List<Runnable> z = Lists.newArrayList();
    private bvk A;
    private Consumer<btr> B;
    private Consumer<Path> C;
    private boolean D;
    @Nullable
    private c E;
    private boolean F;
    private ave G;
    public final aum H;
    @Nullable
    private alb I;
    @Nullable
    private alb.a J;
    private final bck K;
    public final DataFixer L;
    private String M;
    private int N = -1;
    private final js<amn> O;
    private Map<amd<dmu>, aub> P;
    private ayb Q;
    private volatile boolean R = true;
    private boolean S;
    private int T;
    private int U = 6000;
    protected final Proxy h;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    @Nullable
    private String Z;
    private int aa;
    private final long[] ab;
    private long ac = 0L;
    @Nullable
    private KeyPair ad;
    @Nullable
    private GameProfile ae;
    private boolean af;
    private volatile boolean ag;
    private long ah;
    protected final amz i;
    private long ai;
    public final Thread aj;
    private long ak;
    private long al;
    private long am;
    private long an;
    private boolean ao = false;
    private long ap;
    private boolean aq;
    private final awz ar;
    private final amx as;
    @Nullable
    private fcj at;
    private final anh au;
    private final amt av;
    private boolean aw;
    private float ax;
    public final Executor ay;
    @Nullable
    private String az;
    public a aA;
    private final ezb aB;
    private final amy aC;
    protected fdd j;
    private final deq aD;
    private eby aE;
    private int aF;
    private volatile boolean aG;
    private static final AtomicReference<RuntimeException> aH = new AtomicReference();
    private final ana aI;
    private final DiscontinuousFrame aJ;
    public final anc.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public Terminal terminal;
    public static int currentTick = (int)(System.currentTimeMillis() / 50L);
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public el vanillaCommandDispatcher;
    private boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    public final double[] recentTps = new double[3];
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").build());

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).y(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> l.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)function.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, anc.a worldLoader, Thread thread, fcs.c convertable_conversionsession, awz resourcepackrepository, and worldstem, Proxy proxy, DataFixer datafixer, amz services, aum worldloadlistenerfactory) {
        super("Server");
        this.A = bvj.a;
        this.B = methodprofilerresults -> this.aU();
        this.C = path -> {};
        this.K = bck.a();
        this.P = Maps.newLinkedHashMap();
        this.ab = new long[100];
        this.ak = ag.d();
        this.al = ag.d();
        this.an = ag.d();
        this.as = new amx(this);
        this.au = new anh();
        this.aI = new ana();
        this.O = worldstem.c();
        this.j = worldstem.d();
        this.h = proxy;
        this.ar = resourcepackrepository;
        this.aA = new a(worldstem.a(), worldstem.b());
        this.i = services;
        if (services.f() != null) {
            services.f().a(this);
        }
        this.aC = new amy(this);
        this.H = worldloadlistenerfactory;
        this.f = convertable_conversionsession;
        this.g = convertable_conversionsession.g();
        this.L = datafixer;
        this.av = new amt(this, this.aA.b.a());
        jn.b holdergetter = this.O.a().f(mn.i).a(this.j.K());
        this.aB = new ezb(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.aj = thread;
        this.ay = ag.h();
        this.aD = deq.a(this.j.K());
        this.aA.b.c().a(this.j.K());
        this.aE = eby.a(this.O.a(), this.j.K());
        this.aJ = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        if (System.console() == null && System.getProperty("org.jline.terminal.provider") == null) {
            System.setProperty("org.jline.terminal.provider", "dumb");
            org.bukkit.craftbukkit.Main.useJline = false;
        }
        try {
            this.terminal = TerminalBuilder.builder().dumb(false).build();
        }
        catch (Throwable e2) {
            try {
                System.setProperty("org.jline.terminal.provider", "dumb");
                org.bukkit.craftbukkit.Main.useJline = false;
                this.terminal = TerminalBuilder.builder().build();
            }
            catch (IOException ex2) {
                l.warn((String)null, (Throwable)ex2);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    private void a(fcm worldpersistentdata) {
        worldpersistentdata.a(amx.a);
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!bub.f.c()) {
            // empty if block
        }
        boolean flag = false;
        bue profiledduration = bub.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish(true);
        }
        if (flag) {
            try {
                bub.f.b();
            }
            catch (Throwable throwable) {
                l.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String s2) {
        fcs.c worldSession = this.f;
        jz.b iregistrycustom_dimension = this.O.a();
        jy<ehz> dimensions = iregistrycustom_dimension.f(mn.bv);
        for (ehz worldDimension : dimensions) {
            aub world;
            fcw worlddata;
            Dynamic<?> dynamic;
            String name;
            amd<ehz> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == ehz.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == ehz.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != ehz.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == ehz.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = fcs.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = fcs.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    l.info("---- Migration of old " + worldType + " folder required ----");
                    l.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    l.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    l.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        l.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            l.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                l.warn("Unable to migrate world data.");
                            }
                            l.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            l.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            l.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        l.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = fcs.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (fih | IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            if (worldSession.m()) {
                fct worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | ut | va ioexception) {
                    fcs.b convertable_b = worldSession.e();
                    l.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    l.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | ut | va ioexception1) {
                        l.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        l.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    l.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    l.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            anc.a worldloader_a = this.worldLoader;
            jy<ehz> iregistry = worldloader_a.d().f(mn.bv);
            if (dynamic != null) {
                fcp leveldataanddimensions = fcs.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (fcw)leveldataanddimensions.a();
            } else {
                ekv worlddimensions;
                eky worldoptions;
                dmy worldsettings;
                if (this.X()) {
                    worldsettings = d;
                    worldoptions = eky.b;
                    worlddimensions = euo.a(worldloader_a.c());
                } else {
                    arj dedicatedserverproperties = ((ari)this).a();
                    worldsettings = new dmy(dedicatedserverproperties.l, dedicatedserverproperties.k, dedicatedserverproperties.t, dedicatedserverproperties.j, false, new dmq(worldloader_a.b().b()), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.aa.a(true) : dedicatedserverproperties.aa;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                ekv.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new fcw(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, worlddata, bds.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            fcw iworlddataserver = worlddata;
            boolean flag = worlddata.A();
            eky worldoptions = worlddata.y();
            long i2 = worldoptions.c();
            long j2 = dnz.a(i2);
            ImmutableList list = ImmutableList.of((Object)new ekm(), (Object)new ekl(), (Object)new cub(), (Object)new cln(), (Object)new cum(iworlddataserver));
            ehz worlddimension = dimensions.c(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            amd<dmu> worldKey = amd.a(mn.bu, dimensionKey.a());
            if (dimensionKey == ehz.b) {
                this.j = worlddata;
                this.j.a(((ari)this).a().k);
                worldloadlistener = this.H.create(this.j.o().d(dmq.ac));
                world = new aub(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<dmg>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                fcm worldpersistentdata = world.x();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.g());
                this.at = new fcj(worldpersistentdata);
            } else {
                worldloadlistener = this.H.create(this.j.o().d(dmq.ac));
                world = new aub(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<dmg>)ImmutableList.of(), true, this.J().O(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.Q().a());
            this.initWorld(world, worlddata, this.j, worldoptions);
            this.addLevel(world);
            this.ag().a(world);
            if (worlddata.E() == null) continue;
            this.aM().a(worlddata.E(), this.ba());
        }
        this.t();
        for (aub worldserver : this.L()) {
            this.prepareLevels(worldserver.n().a.F, worldserver);
            worldserver.P.b();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    public void initWorld(aub worldserver, fcx iworlddataserver, fdd saveData, eky worldoptions) {
        boolean flag = saveData.A();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        eft worldborder = worldserver.F_();
        worldborder.a(iworlddataserver.p());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.n()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.e(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.j);
                }
            }
            catch (Throwable throwable) {
                p crashreport = p.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new aa(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(aub worldserver, fcx iworlddataserver, boolean flag, boolean flag1) {
        if (flag1) {
            iworlddataserver.a(jb.c.b(80), 0.0f);
        } else {
            int i2;
            aty chunkproviderserver = worldserver.n();
            dlz chunkcoordintpair = new dlz(chunkproviderserver.i().b().a());
            if (worldserver.generator != null) {
                Random rand = new Random(worldserver.F());
                Location spawn = worldserver.generator.getFixedSpawnLocation((World)worldserver.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != worldserver.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + iworlddataserver.e() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    iworlddataserver.a(new jb(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            if ((i2 = chunkproviderserver.g().a(worldserver)) < worldserver.L_()) {
                jb blockposition = chunkcoordintpair.l();
                i2 = worldserver.a(eka.a.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            iworlddataserver.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < bcb.i(11); ++j1) {
                jb blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = atv.a(worldserver, new dlz(chunkcoordintpair.h + j2, chunkcoordintpair.i + k2))) != null) {
                    iworlddataserver.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (flag) {
                worldserver.K_().a(mn.aP).flatMap(iregistry -> iregistry.a(rs.m)).ifPresent(holder_c -> ((ems)holder_c.a()).a(worldserver, chunkproviderserver.g(), worldserver.A, iworlddataserver.a()));
            }
        }
    }

    private void a(fdd savedata) {
        savedata.a(bxg.a);
        savedata.d(true);
        fcx iworlddataserver = savedata.I();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(dmr.d);
    }

    public void prepareLevels(aul worldloadlistener, aub worldserver) {
        int j2;
        this.forceTicks = true;
        l.info("Preparing start region for dimension {}", (Object)worldserver.aj().a());
        jb blockposition = worldserver.ab();
        worldloadlistener.a(new dlz(blockposition));
        aty chunkproviderserver = worldserver.n();
        this.an = ag.d();
        worldserver.a(blockposition, worldserver.ac());
        int i2 = worldserver.P().d(dmq.ac);
        int n2 = j2 = i2 > 0 ? bcb.i(aul.a(i2)) : 0;
        while (chunkproviderserver.b() < j2) {
            this.executeModerately();
        }
        this.executeModerately();
        aub worldserver1 = worldserver;
        dnr ticketstorage = worldserver1.x().b(dnr.b);
        if (ticketstorage != null) {
            ticketstorage.a();
        }
        this.executeModerately();
        worldloadlistener.b();
        worldserver.a(this.W());
        this.forceTicks = false;
    }

    public dmr u() {
        return this.j.k();
    }

    public boolean v_() {
        return this.j.l();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3 = false;
        for (aub worldserver : this.L()) {
            if (!flag) {
                l.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.aj().a());
            }
            worldserver.a((bcj)null, flag1, worldserver.e && !flag2);
            flag3 = true;
        }
        if (flag1) {
            for (aub worldserver2 : this.L()) {
                l.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver2.n().a.n());
            }
            l.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        try {
            this.aG = true;
            this.ag().h();
            flag3 = this.a(flag, flag1, flag2);
        }
        finally {
            this.aG = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void v() {
        Iterator<aub> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (this.A.e()) {
            this.aW();
        }
        l.info("Stopping server");
        if (this.server != null) {
            this.server.disablePlugins();
        }
        this.ah().b();
        this.aG = true;
        if (this.Q != null) {
            l.info("Saving players");
            this.Q.h();
            this.Q.s();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        l.info("Saving worlds");
        for (aub worldserver : this.L()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        while (this.P.values().stream().anyMatch(worldserver1 -> worldserver1.n().a.e())) {
            this.an = ag.d() + bdg.b;
            for (aub worldserver12 : this.L()) {
                worldserver12.n().p();
                worldserver12.n().a(() -> true, false);
            }
            this.w_();
        }
        this.a(false, true, false);
        for (aub worldserver2 : this.L()) {
            if (worldserver2 == null) continue;
            try {
                worldserver2.close();
            }
            catch (IOException ioexception) {
                l.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.aG = false;
        this.aA.close();
        try {
            this.f.close();
        }
        catch (IOException ioexception1) {
            l.error("Failed to unlock level {}", (Object)this.f.f(), (Object)ioexception1);
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            l.info("Saving usercache.json");
            this.at().c();
        }
    }

    public String w() {
        return this.M;
    }

    @Override
    public void a_(String s2) {
        this.M = s2;
    }

    public boolean x() {
        return this.R;
    }

    public void a(boolean flag) {
        this.R = false;
        if (flag) {
            try {
                this.aj.join();
            }
            catch (InterruptedException interruptedexception) {
                l.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg2, double exp2, double tps) {
        return avg2 * exp2 + tps * (1.0 - exp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void y() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.an = ag.d();
            this.J = this.bC().orElse(null);
            this.I = this.bF();
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = ag.c();
            long tickCount = 1L;
            while (this.R) {
                boolean flag;
                long i2;
                if (!this.E() && this.aC.a() && this.aC.d()) {
                    i2 = 0L;
                    this.ah = this.an = ag.d();
                } else {
                    i2 = this.aC.h();
                    long j2 = ag.d() - this.an;
                    if (j2 > o + 20L * i2 && this.an - this.ah >= q + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            l.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / bdg.b), (Object)k2);
                        }
                        this.an += k2 * i2;
                        this.ah = this.an;
                    }
                }
                if (tickCount++ % 100L == 0L) {
                    long curTime = ag.c();
                    double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                    this.recentTps[0] = MinecraftServer.calcTps(this.recentTps[0], 0.92, currentTps);
                    this.recentTps[1] = MinecraftServer.calcTps(this.recentTps[1], 0.9835, currentTps);
                    this.recentTps[2] = MinecraftServer.calcTps(this.recentTps[2], 0.9945, currentTps);
                    tickSection = curTime;
                }
                boolean bl2 = flag = i2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new c(ag.d(), this.T);
                }
                currentTick = (int)(System.currentTimeMillis() / 50L);
                this.an += i2;
                try (bts.a profiler_a = bts.a(this.bI());){
                    btt gameprofilerfiller = bts.a();
                    gameprofilerfiller.a("tick");
                    this.aJ.start();
                    this.a(flag ? () -> false : this::bu);
                    this.aJ.end();
                    gameprofilerfiller.b("nextTickWait");
                    this.aq = true;
                    this.ap = Math.max(ag.d() + i2, this.an);
                    this.bs();
                    this.w_();
                    this.bt();
                    if (flag) {
                        this.aC.e();
                    }
                    gameprofilerfiller.c();
                    this.br();
                }
                finally {
                    this.aS();
                }
                this.ag = true;
                bub.f.a(this.ax);
            }
            return;
        }
        catch (Throwable throwable2) {
            l.error("Encountered an unexpected exception", throwable2);
            p crashreport = MinecraftServer.b(throwable2);
            this.b(crashreport.f());
            Path path = this.D().resolve("crash-reports").resolve("crash-" + ag.f() + "-server.txt");
            if (crashreport.a(path, z.a)) {
                l.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                l.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.v();
            }
            catch (Throwable throwable3) {
                l.error("Exception stopping the server", throwable3);
            }
            finally {
                if (this.i.f() != null) {
                    this.i.f().a();
                }
                WatchdogThread.doStop();
                try {
                    this.terminal.close();
                }
                catch (Exception tickSection) {}
                this.i();
            }
        }
    }

    private void br() {
        long i2 = ag.d();
        if (this.g()) {
            this.f().a(i2 - this.ak);
        }
        this.ak = i2;
    }

    private void bs() {
        if (this.g()) {
            this.al = ag.d();
            this.am = 0L;
        }
    }

    private void bt() {
        if (this.g()) {
            brx samplelogger = this.f();
            samplelogger.a(ag.d() - this.al - this.am, brz.c.ordinal());
            samplelogger.a(this.am, brz.d.ordinal());
        }
    }

    private static p b(Throwable throwable) {
        p crashreport;
        aa reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            aa reportedexception1;
            if (!(throwable1 instanceof aa)) continue;
            reportedexception = reportedexception1 = (aa)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new p("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bu() {
        return this.forceTicks || this.bB() || ag.d() < (this.aq ? this.ap : this.an);
    }

    private void executeModerately() {
        this.bA();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean z() {
        RuntimeException runtimeexception = aH.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException runtimeexception) {
        aH.compareAndSet(null, runtimeexception);
    }

    @Override
    public void b(BooleanSupplier booleansupplier) {
        super.b(() -> MinecraftServer.z() && booleansupplier.getAsBoolean());
    }

    protected void w_() {
        this.bA();
        this.ao = true;
        try {
            this.b(() -> !this.bu());
        }
        finally {
            this.ao = false;
        }
    }

    @Override
    public void A() {
        boolean flag = this.g();
        long i2 = flag ? ag.d() : 0L;
        long j2 = this.ao ? this.an - ag.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j2);
        if (flag) {
            this.am += ag.d() - i2;
        }
    }

    public anb a(Runnable runnable) {
        return new anb(this.T, runnable);
    }

    protected boolean a(anb ticktask) {
        return ticktask.a() + 3 < this.T || this.bu();
    }

    @Override
    public boolean B() {
        boolean flag;
        this.aq = flag = this.bv();
        return flag;
    }

    private boolean bv() {
        if (super.B()) {
            return true;
        }
        if (this.aC.a() || this.bu()) {
            for (aub worldserver : this.L()) {
                if (!worldserver.n().d()) continue;
                return true;
            }
        }
        return false;
    }

    public void b(anb ticktask) {
        bts.a().f("runTask");
        super.d(ticktask);
    }

    private Optional<alb.a> bC() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.f.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new alb.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                l.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> C() {
        return this.f.j();
    }

    public Path D() {
        return Path.of("", new String[0]);
    }

    public void a(p crashreport) {
    }

    public void i() {
    }

    public boolean E() {
        return false;
    }

    public void a(BooleanSupplier booleansupplier) {
        WatchdogThread.tick();
        long i2 = ag.d();
        int j2 = this.bq() * 20;
        if (j2 > 0) {
            this.aF = this.Q.m() == 0 && !this.aC.a() ? ++this.aF : 0;
            if (this.aF >= j2) {
                if (this.aF == j2) {
                    l.info("Server empty for {} seconds, pausing", (Object)this.bq());
                    this.bD();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                this.G();
                return;
            }
        }
        SpigotTimings.serverTickTimer.startTiming();
        ++this.T;
        this.aC.m();
        this.c(booleansupplier);
        if (i2 - this.ai >= s) {
            this.ai = i2;
            this.I = this.bF();
        }
        --this.U;
        if (this.autosavePeriod > 0 && this.U <= 0) {
            this.bD();
        }
        btt gameprofilerfiller = bts.a();
        gameprofilerfiller.a("tallying");
        long k2 = ag.d() - i2;
        int l2 = this.T % 100;
        this.ac -= this.ab[l2];
        this.ac += k2;
        this.ab[l2] = k2;
        this.ax = this.ax * 0.8f + (float)k2 / (float)bdg.b * 0.19999999f;
        this.a(i2);
        gameprofilerfiller.c();
        SpigotTimings.serverTickTimer.stopTiming();
        CustomTimingsHandler.tick();
    }

    private void bD() {
        this.U = this.autosavePeriod;
        SpigotTimings.worldSaveTimer.startTiming();
        l.debug("Autosave started");
        btt gameprofilerfiller = bts.a();
        gameprofilerfiller.a("save");
        this.b(true, false, false);
        gameprofilerfiller.c();
        l.debug("Autosave finished");
        SpigotTimings.worldSaveTimer.stopTiming();
    }

    private void a(long i2) {
        if (this.g()) {
            this.f().a(ag.d() - i2, brz.b.ordinal());
        }
    }

    private int bE() {
        float f2;
        if (this.aC.a()) {
            long i2 = this.aQ() + 1L;
            f2 = (float)bdg.a / (float)i2;
        } else {
            f2 = this.aC.f();
        }
        int j2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void F() {
        int i2 = this.bE();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract brx f();

    public abstract boolean g();

    private alb bF() {
        alb.b serverping_serverpingplayersample = this.bG();
        return new alb(xo.a(this.Z), Optional.of(serverping_serverpingplayersample), Optional.of(alb.c.a()), Optional.ofNullable(this.J), this.aA());
    }

    private alb.b bG() {
        List<auc> list = this.Q.t();
        int i2 = this.O();
        if (this.an()) {
            return new alb.b(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), 12);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = bcb.a(this.K, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            auc entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.Y() ? entityplayer.gr() : e));
        }
        ag.c(objectarraylist, this.K);
        return new alb.b(i2, list.size(), (List<GameProfile>)objectarraylist);
    }

    protected void c(BooleanSupplier booleansupplier) {
        btt gameprofilerfiller = bts.a();
        this.ag().t().forEach(entityplayer -> entityplayer.g.f());
        SpigotTimings.schedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat();
        SpigotTimings.schedulerTimer.stopTiming();
        gameprofilerfiller.a("commandFunctions");
        SpigotTimings.commandFunctionsTimer.startTiming();
        this.aE().b();
        SpigotTimings.commandFunctionsTimer.stopTiming();
        gameprofilerfiller.b("levels");
        SpigotTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        SpigotTimings.processQueueTimer.stopTiming();
        SpigotTimings.timeUpdateTimer.startTiming();
        if (this.T % 20 == 0) {
            for (int i2 = 0; i2 < this.ag().l.size(); ++i2) {
                auc entityplayer2 = this.ag().l.get(i2);
                entityplayer2.g.b(new agn(entityplayer2.y().ae(), entityplayer2.getPlayerTime(), entityplayer2.y().P().c(dmq.m)));
            }
        }
        SpigotTimings.timeUpdateTimer.stopTiming();
        for (aub worldserver : this.L()) {
            gameprofilerfiller.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.aj().a());
            });
            gameprofilerfiller.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(booleansupplier);
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                p crashreport = p.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new aa(crashreport);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("connection");
        SpigotTimings.connectionTimer.startTiming();
        this.G();
        SpigotTimings.connectionTimer.stopTiming();
        gameprofilerfiller.b("players");
        SpigotTimings.playerListTimer.startTiming();
        this.Q.d();
        SpigotTimings.playerListTimer.stopTiming();
        if (this.aC.i()) {
            th.a.c();
        }
        gameprofilerfiller.b("server gui refresh");
        SpigotTimings.tickablesTimer.startTiming();
        for (int i3 = 0; i3 < this.z.size(); ++i3) {
            this.z.get(i3).run();
        }
        SpigotTimings.tickablesTimer.stopTiming();
        gameprofilerfiller.b("send chunks");
        for (auc entityplayer2 : this.Q.t()) {
            entityplayer2.g.g.a(entityplayer2);
            entityplayer2.g.g();
        }
        gameprofilerfiller.c();
    }

    public void G() {
        this.ah().c();
    }

    private void b(aub worldserver) {
        this.Q.a(new agn(worldserver.ae(), worldserver.af(), worldserver.P().c(dmq.m)), worldserver.aj());
    }

    public void H() {
        btt gameprofilerfiller = bts.a();
        gameprofilerfiller.a("timeSync");
        for (aub worldserver : this.L()) {
            this.b(worldserver);
        }
        gameprofilerfiller.c();
    }

    public boolean a(dmu world) {
        return true;
    }

    public void b(Runnable runnable) {
        this.z.add(runnable);
    }

    protected void b(String s2) {
        this.az = s2;
    }

    public boolean I() {
        return !this.aj.isAlive();
    }

    public Path c(String s2) {
        return this.D().resolve(s2);
    }

    public final aub J() {
        return this.P.get(dmu.i);
    }

    @Nullable
    public aub a(amd<dmu> resourcekey) {
        return this.P.get(resourcekey);
    }

    public void addLevel(aub level) {
        Map<amd<dmu>, aub> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.aj(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(aub level) {
        Map<amd<dmu>, aub> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.aj());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<amd<dmu>> K() {
        return this.P.keySet();
    }

    public Iterable<aub> L() {
        return this.P.values();
    }

    @Override
    public String M() {
        return ac.b().c();
    }

    @Override
    public int N() {
        return this.Q.m();
    }

    @Override
    public int O() {
        return this.Q.n();
    }

    public String[] P() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Spigot";
    }

    public ae b(ae systemreport) {
        systemreport.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            systemreport.a("Player Count", () -> {
                int i2 = this.Q.m();
                return i2 + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t());
            });
        }
        systemreport.a("Active Data Packs", () -> awz.a(this.ar.g()));
        systemreport.a("Available Data Packs", () -> awz.a(this.ar.d()));
        systemreport.a("Enabled Feature Flags", () -> cyf.e.b(this.j.K()).stream().map(ame::toString).collect(Collectors.joining(", ")));
        systemreport.a("World Generation", () -> this.j.B().toString());
        systemreport.a("World Seed", () -> String.valueOf(this.j.y().c()));
        ana suppressedexceptioncollector = this.aI;
        Objects.requireNonNull(this.aI);
        systemreport.a("Suppressed Exceptions", suppressedexceptioncollector::a);
        if (this.az != null) {
            systemreport.a("Server Id", () -> this.az);
        }
        return this.a(systemreport);
    }

    public abstract ae a(ae var1);

    public bca Q() {
        return bca.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(xo ichatbasecomponent) {
        l.info(ichatbasecomponent.getString());
    }

    public KeyPair R() {
        return this.ad;
    }

    public int S() {
        return this.N;
    }

    public void a(int i2) {
        this.N = i2;
    }

    @Nullable
    public GameProfile T() {
        return this.ae;
    }

    public void b(@Nullable GameProfile gameprofile) {
        this.ae = gameprofile;
    }

    public boolean U() {
        return this.ae != null;
    }

    protected void V() {
        l.info("Generating keypair");
        try {
            this.ad = bax.b();
        }
        catch (bay cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void a(bxg enumdifficulty, boolean flag) {
        if (flag || !this.j.r()) {
            this.j.a(this.j.l() ? bxg.d : enumdifficulty);
            this.bH();
            this.ag().t().forEach(this::c);
        }
    }

    public int b(int i2) {
        return i2;
    }

    private void bH() {
        for (aub worldserver : this.L()) {
            worldserver.a(this.W());
        }
    }

    public void b(boolean flag) {
        this.j.d(flag);
        this.ag().t().forEach(this::c);
    }

    private void c(auc entityplayer) {
        fco worlddata = entityplayer.y().D_();
        entityplayer.g.b(new adc(worlddata.q(), worlddata.r()));
    }

    public boolean W() {
        return this.j.q() != bxg.a;
    }

    public boolean X() {
        return this.af;
    }

    public void c(boolean flag) {
        this.af = flag;
    }

    public Optional<b> Y() {
        return Optional.empty();
    }

    public boolean Z() {
        return this.Y().filter(b::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean aa() {
        return this.V;
    }

    @Override
    public void d(boolean flag) {
        this.V = flag;
    }

    public boolean ab() {
        return this.W;
    }

    public void e(boolean flag) {
        this.W = flag;
    }

    public abstract boolean p();

    public boolean ac() {
        return this.X;
    }

    public void f(boolean flag) {
        this.X = flag;
    }

    public boolean ad() {
        return this.Y;
    }

    public void g(boolean flag) {
        this.Y = flag;
    }

    public abstract boolean q();

    @Override
    public String ae() {
        return this.Z;
    }

    @Override
    public void d(String s2) {
        this.Z = s2;
    }

    public boolean af() {
        return this.S;
    }

    public ayb ag() {
        return this.Q;
    }

    public void a(ayb playerlist) {
        this.Q = playerlist;
    }

    public abstract boolean r();

    public void a(dmr enumgamemode) {
        this.j.a(enumgamemode);
    }

    public ave ah() {
        return this.G == null ? (this.G = new ave(this)) : this.G;
    }

    public boolean ai() {
        return this.ag;
    }

    public boolean aj() {
        return false;
    }

    public boolean a(@Nullable dmr enumgamemode, boolean flag, int i2) {
        return false;
    }

    public int ak() {
        return this.T;
    }

    public int al() {
        return 16;
    }

    public boolean a(aub worldserver, jb blockposition, cut entityhuman) {
        return false;
    }

    public boolean am() {
        return true;
    }

    public boolean an() {
        return false;
    }

    public Proxy ao() {
        return this.h;
    }

    public int ap() {
        return this.aa;
    }

    public void c(int i2) {
        this.aa = i2;
    }

    public MinecraftSessionService aq() {
        return this.i.c();
    }

    @Nullable
    public bcq ar() {
        return this.i.a();
    }

    public GameProfileRepository as() {
        return this.i.e();
    }

    @Nullable
    public axx at() {
        return this.i.f();
    }

    @Nullable
    public alb au() {
        return this.I;
    }

    public void av() {
        this.ai = 0L;
    }

    public int aw() {
        return 29999984;
    }

    @Override
    public boolean ax() {
        return super.ax() && !this.af();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.af()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread ay() {
        return this.aj;
    }

    public int az() {
        return 256;
    }

    public boolean aA() {
        return false;
    }

    public long aB() {
        return this.an;
    }

    public DataFixer aC() {
        return this.L;
    }

    public int a(@Nullable aub worldserver) {
        return worldserver != null ? worldserver.P().d(dmq.t) : 10;
    }

    public amr aD() {
        return this.aA.b.e();
    }

    public amt aE() {
        return this.av;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = collection.stream();
            awz resourcepackrepository = this.ar;
            Objects.requireNonNull(this.ar);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(aww::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            axh ireloadableresourcemanager = new axh(awd.b, (List<awb>)immutablelist);
            List<jy.a<?>> list = baf.a((axo)ireloadableresourcemanager, this.O.a());
            return ((CompletableFuture)amp.a(ireloadableresourcemanager, this.O, list, this.j.K(), this.n() ? el.a.b : el.a.c, this.l(), this.ay, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    ireloadableresourcemanager.close();
                }
            })).thenApply(datapackresources -> new a(ireloadableresourcemanager, (amp)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.aA.close();
            this.aA = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.ar.b(collection);
            dns worlddataconfiguration = new dns(MinecraftServer.a(this.ar, true), this.j.K());
            this.j.a(worlddataconfiguration);
            this.aA.b.g();
            this.aA.b.c().a(this.j.K());
            this.ag().h();
            this.ag().u();
            this.av.a(this.aA.b.a());
            this.aB.a(this.aA.a);
            this.aE = eby.a(this.O.a(), this.j.K());
        }, (Executor)this);
        if (this.bx()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static dns a(awz resourcepackrepository, dns worlddataconfiguration, boolean flag, boolean flag1) {
        dmh datapackconfiguration = worlddataconfiguration.a();
        cyd featureflagset = flag ? cyd.a() : worlddataconfiguration.b();
        cyd featureflagset1 = flag ? cyf.e.a() : worlddataconfiguration.b();
        resourcepackrepository.a();
        if (flag1) {
            return MinecraftServer.a(resourcepackrepository, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcepackrepository.d(s2)) {
                set.add(s2);
                continue;
            }
            l.warn("Missing data pack {}", (Object)s2);
        }
        for (aww resourcepackloader : resourcepackrepository.d()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            cyd featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    l.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    l.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)cyf.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            l.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)cyf.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            l.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcepackrepository, set, featureflagset, true);
    }

    private static dns a(awz resourcepackrepository, Collection<String> collection, cyd featureflagset, boolean flag) {
        resourcepackrepository.b(collection);
        MinecraftServer.a(resourcepackrepository, featureflagset);
        dmh datapackconfiguration = MinecraftServer.a(resourcepackrepository, flag);
        cyd featureflagset1 = resourcepackrepository.f().c(featureflagset);
        return new dns(datapackconfiguration, featureflagset1);
    }

    private static void a(awz resourcepackrepository, cyd featureflagset) {
        cyd featureflagset1 = resourcepackrepository.f();
        cyd featureflagset2 = featureflagset.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcepackrepository.e());
            for (aww resourcepackloader : resourcepackrepository.d()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != axa.d) continue;
                String s2 = resourcepackloader.g();
                cyd featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(featureflagset)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                l.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcepackrepository.b((Collection<String>)set);
        }
    }

    private static dmh a(awz resourcepackrepository, boolean flag) {
        Collection<String> collection = resourcepackrepository.e();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = flag ? resourcepackrepository.c().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new dmh((List<String>)list, list1);
    }

    public void a(ek commandlistenerwrapper) {
        if (this.aN()) {
            ayb playerlist = commandlistenerwrapper.l().ag();
            ayj whitelist = playerlist.i();
            for (auc entityplayer : Lists.newArrayList(playerlist.t())) {
                if (whitelist.a(entityplayer.gr())) continue;
                entityplayer.g.a(xo.c("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public awz aF() {
        return this.ar;
    }

    public el aG() {
        return this.aA.b.d();
    }

    public ek aH() {
        aub worldserver = this.J();
        return new ek(this, worldserver == null ? fis.c : fis.a(worldserver.ab()), fir.a, worldserver, 4, "Server", xo.b("Server"), this, null);
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public dht aI() {
        return this.aA.b.c();
    }

    public amx aJ() {
        return this.as;
    }

    public fcj aK() {
        if (this.at == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.at;
    }

    public dmq aL() {
        return this.J().P();
    }

    public anh aM() {
        return this.au;
    }

    public boolean aN() {
        return this.aw;
    }

    public void h(boolean flag) {
        this.aw = flag;
    }

    public float aO() {
        return this.ax;
    }

    public amy aP() {
        return this.aC;
    }

    public long aQ() {
        return this.ac / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aR() {
        return this.ab;
    }

    public int c(GameProfile gameprofile) {
        if (this.ag().f(gameprofile)) {
            ayd oplistentry = (ayd)this.ag().k().b(gameprofile);
            return oplistentry != null ? oplistentry.a() : (this.a(gameprofile) ? 4 : (this.U() ? (this.ag().v() ? 4 : 0) : this.k()));
        }
        return 0;
    }

    public abstract boolean a(GameProfile var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<amd<dmu>, aub> map_entry : this.P.entrySet()) {
                ame minecraftkey = map_entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                map_entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            l.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.by()));
            writer.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aO())));
            writer.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ab)));
            writer.write(String.format(Locale.ROOT, "queue: %s\n", ag.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final dmq gamerules = this.aL();
            gamerules.a(new dmq.c(){

                @Override
                public <T extends dmq.g<T>> void a(dmq.e<T> gamerules_gamerulekey, dmq.f<T> gamerules_gameruledefinition) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", gamerules_gamerulekey.a(), gamerules.b(gamerules_gamerulekey)));
                }
            });
            for (String s2 : list) {
                writer.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                writer.write(s22);
                writer.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(bcc.a());
            }
            catch (Throwable throwable) {
                l.warn("Failed to list native modules", throwable);
                if (writer != null) {
                    ((Writer)writer).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
            for (bcc.a nativemodulelister_a2 : list) {
                writer.write(nativemodulelister_a2.toString());
                ((Writer)writer).write(10);
            }
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    public static jz getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private btt bI() {
        if (this.D) {
            this.A = bvi.a(new bvm(ag.c, this.n()), ag.c, ag.i(), new bvo("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A.c();
        return btw.a(this.A.f(), btw.a("Server"));
    }

    public void aS() {
        this.A.d();
    }

    public boolean aT() {
        return this.A.e();
    }

    public void a(Consumer<btr> consumer, Consumer<Path> consumer1) {
        this.B = methodprofilerresults -> {
            this.aU();
            consumer.accept((btr)methodprofilerresults);
        };
        this.C = consumer1;
        this.D = true;
    }

    public void aU() {
        this.A = bvj.a;
    }

    public void aV() {
        this.A.a();
    }

    public void aW() {
        this.A.b();
    }

    public Path a(fcq savedfile) {
        return this.f.a(savedfile);
    }

    public boolean aX() {
        return true;
    }

    public ezb aY() {
        return this.aB;
    }

    public fdd aZ() {
        return this.j;
    }

    public jz.b ba() {
        return this.O.a();
    }

    public js<amn> bb() {
        return this.O;
    }

    public amo.a bc() {
        return this.aA.b.b();
    }

    public avl a(auc entityplayer) {
        return avl.e;
    }

    public aud b(auc entityplayer) {
        return this.X() ? new atn(entityplayer) : new aud(entityplayer);
    }

    @Nullable
    public dmr bd() {
        return null;
    }

    public axo be() {
        return this.aA.a;
    }

    public boolean bf() {
        return this.aG;
    }

    public boolean bg() {
        return this.F || this.E != null;
    }

    public void bh() {
        this.F = true;
    }

    public btr bi() {
        if (this.E == null) {
            return btn.a;
        }
        btr methodprofilerresults = this.E.a(ag.d(), this.T);
        this.E = null;
        return methodprofilerresults;
    }

    public int bj() {
        return 1000000;
    }

    public void a(xo ichatbasecomponent, xk.a chatmessagetype_a, @Nullable String s2) {
        String s1 = chatmessagetype_a.a(ichatbasecomponent).getString();
        if (s2 != null) {
            l.info("[{}] {}", (Object)s2, (Object)s1);
        } else {
            l.info("{}", (Object)s1);
        }
    }

    public xj bk() {
        return xj.a;
    }

    public boolean bl() {
        return true;
    }

    public void a(auc entityplayer, brv remotedebugsampletype) {
    }

    public void handleCustomClickAction(ame minecraftkey, Optional<vi> optional, auc player) {
        l.debug("Received custom click action {} with payload {}", (Object)minecraftkey, optional.orElse(null));
        CraftEventFactory.callPlayerCustomClickEvent(minecraftkey, optional, player);
    }

    public boolean bm() {
        return false;
    }

    private void a(p crashreport, dlz chunkcoordintpair, ehr regionstorageinfo) {
        ag.i().execute(() -> {
            try {
                Path path = this.c("debug");
                w.c(path);
                String s2 = w.a(regionstorageinfo.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + ag.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    l.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                q crashreportsystemdetails = crashreport.a("Chunk Info");
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Level", regionstorageinfo::a);
                crashreportsystemdetails.a("Dimension", () -> regionstorageinfo.b().a().toString());
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Storage", regionstorageinfo::c);
                Objects.requireNonNull(chunkcoordintpair);
                crashreportsystemdetails.a("Position", chunkcoordintpair::toString);
                crashreport.a(path1, z.e);
                l.info("Saved details to {}", (Object)crashreport.e());
            }
            catch (Exception exception) {
                l.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable throwable, ehr regionstorageinfo, dlz chunkcoordintpair) {
        l.error("Failed to load chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aI.a("chunk/load", throwable);
        this.a(p.a(throwable, "Chunk load failure"), chunkcoordintpair, regionstorageinfo);
    }

    @Override
    public void b(Throwable throwable, ehr regionstorageinfo, dlz chunkcoordintpair) {
        l.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aI.a("chunk/save", throwable);
        this.a(p.a(throwable, "Chunk save failure"), chunkcoordintpair, regionstorageinfo);
    }

    public void a(Throwable throwable, zy<?> packettype) {
        this.aI.a("packet/" + packettype.toString(), throwable);
    }

    public deq bn() {
        return this.aD;
    }

    public eby bo() {
        return this.aE;
    }

    public amw bp() {
        return amw.a;
    }

    protected int bq() {
        return 0;
    }

    public record a(axe a, amp b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class c {
        final long a;
        final int b;

        c(long i2, int j2) {
            this.a = i2;
            this.b = j2;
        }

        btr a(final long i2, final int j2) {
            return new btr(){

                @Override
                public List<btv> a(String s2) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return i2;
                }

                @Override
                public int d() {
                    return j2;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record b(UUID a, String b, String c, boolean d, @Nullable xo e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

