/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(mn.ab));
    private final NamespacedKey key;
    private final md<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(md<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.ab);
        Particle bukkit = (Particle)Registry.PARTICLE_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static md<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (md)CraftRegistry.getMinecraftRegistry(mn.ab).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> mc createParticleParam(Particle particle, D data) {
        CraftParticle craftParticle;
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (Object)"particle cannot be null");
        data = CraftParticle.convertLegacy(data);
        if (particle.getDataType() != Void.class) {
            Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"missing required data %s", (Object)particle.getDataType());
        }
        if (data != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        Preconditions.checkArgument(((craftParticle = (CraftParticle)CRAFT_PARTICLE_REGISTRY.get(particle.getKey())) != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public CraftParticle(NamespacedKey key, md<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public md<?> getHandle() {
        return this.particle;
    }

    public abstract mc createParticleParam(D var1);

    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, md<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, md<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, md<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public mc createParticleParam(Void data) {
                return (mi)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, md<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString((String)name), function);
        }

        public CraftParticleRegistry(jy<md<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, null, FieldRename.PARTICLE_TYPE_RENAME);
        }

        @Override
        public CraftParticle<?> createBukkit(NamespacedKey namespacedKey, jl<md<?>> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle.a());
        }

        static {
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public mc createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new lz(color.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public mc createParticleParam(ItemStack data) {
                    return new ma(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public mc createParticleParam(BlockData data) {
                    return new lw(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public mc createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to2 = data.getToColor();
                    return new ly(from.asRGB(), to2.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public mc createParticleParam(Vibration data) {
                    ejf source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new eix(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        bzm destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new eiz(destination, destination.cW());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + String.valueOf(data.getDestination()));
                    }
                    return new mk(source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> floatFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public mc createParticleParam(Float data) {
                    return new mg(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public mc createParticleParam(Integer data) {
                    return new mh(data);
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> colorFunction = (name, particle) -> new CraftParticle<Color>(name, particle, Color.class){

                @Override
                public mc createParticleParam(Color color) {
                    return lx.a((md<lx>)particle, color.asARGB());
                }
            };
            BiFunction<NamespacedKey, md<?>, CraftParticle<?>> trailFunction = (name, particle) -> new CraftParticle<Particle.Trail>(name, particle, Particle.Trail.class){

                @Override
                public mc createParticleParam(Particle.Trail data) {
                    return new mj(CraftLocation.toVec3D(data.getTarget()), data.getColor().asRGB(), data.getDuration());
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", floatFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
            CraftParticleRegistry.add("entity_effect", colorFunction);
            CraftParticleRegistry.add("tinted_leaves", colorFunction);
            CraftParticleRegistry.add("dust_pillar", blockDataFunction);
            CraftParticleRegistry.add("block_crumble", blockDataFunction);
            CraftParticleRegistry.add("trail", trailFunction);
        }
    }
}

