/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAbstractArrow
extends CraftProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, cvb entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().u;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().h(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().t();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().s();
    }

    public void setCritical(boolean critical) {
        this.getHandle().b(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().c(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().c((bzm)null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public boolean isInBlock() {
        return this.getHandle().e();
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        jb pos = this.getHandle().dx();
        return this.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().b.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().b = cvb.a.a(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().t = value;
    }

    public boolean isShotFromCrossbow() {
        dcv firedFromWeapon = this.getHandle().ed();
        return firedFromWeapon != null && firedFromWeapon.a(dcz.xA);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().aP);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aP = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        return CraftItemStack.asBukkitCopy(this.getHandle().ed());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aQ = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public cvb getHandle() {
        return (cvb)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }
}

