/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import java.util.stream.Collectors;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, cxe entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ap());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ap());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().aX);
    }

    @Override
    public cxe getHandle() {
        return (cxe)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(bzv<?> boatType) {
        if (boatType == bzv.aI || boatType == bzv.aJ) {
            return Boat.Type.OAK;
        }
        if (boatType == bzv.n || boatType == bzv.o) {
            return Boat.Type.BIRCH;
        }
        if (boatType == bzv.b || boatType == bzv.c) {
            return Boat.Type.ACACIA;
        }
        if (boatType == bzv.x || boatType == bzv.y) {
            return Boat.Type.CHERRY;
        }
        if (boatType == bzv.av || boatType == bzv.aw) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == bzv.br || boatType == bzv.bs) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == bzv.G || boatType == bzv.H) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == bzv.aC || boatType == bzv.aD) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == bzv.k || boatType == bzv.j) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(cxe.a enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case cxe.a.e -> Boat.Status.IN_AIR;
            case cxe.a.d -> Boat.Status.ON_LAND;
            case cxe.a.b -> Boat.Status.UNDER_WATER;
            case cxe.a.c -> Boat.Status.UNDER_FLOWING_WATER;
            case cxe.a.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(bzv<?> boatType) {
        if (boatType == bzv.br || boatType == bzv.bs) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == bzv.n || boatType == bzv.o) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == bzv.av || boatType == bzv.aw) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == bzv.b || boatType == bzv.c) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == bzv.G || boatType == bzv.H) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

