/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final ui data;
    private final EntityType type;

    private CraftEntitySnapshot(ui data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        bzm internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        bzm internal = this.createInternal(location.getWorld());
        internal.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private bzm createInternal(World world) {
        aub nms = ((CraftWorld)world).getHandle();
        bzm internal = bzv.a(this.data, (dmu)nms, bzu.r, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).a(nms, bzu.r);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        fda val = fcy.a(bci.a, (jn.a)nms.K_(), this.data);
        internal.e(val);
        return internal;
    }

    public ui getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        fcz tag = fcz.a(bci.a, entity.getHandle().eb());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.b(), entity.getType());
    }

    public static CraftEntitySnapshot create(ui tag, EntityType type) {
        if (tag == null || tag.j() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(ui tag) {
        EntityType type = tag.a("id", bzv.a).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }
}

