/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.event;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Raid;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R5.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.CraftExplosionResult;
import org.bukkit.craftbukkit.v1_21_R5.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R5.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BellResonateEvent;
import org.bukkit.event.block.BellRingEvent;
import org.bukkit.event.block.BlockBrushEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.TrialSpawnerSpawnEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.entity.VillagerReputationChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerCustomClickEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRecipeBookSettingsChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class CraftEventFactory {
    public static jb sourceBlockOverride = null;
    private static final com.google.common.base.Function<? super Double, Double> ZERO = Functions.constant((Object)-0.0);

    private static boolean canBuild(dmu world, Player player, int x2, int z2) {
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.aj() != dmu.i) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().k().c()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        jb chunkcoordinates = world.ab();
        int distanceFromSpawn = Math.max(Math.abs(x2 - chunkcoordinates.u()), Math.abs(z2 - chunkcoordinates.w()));
        return distanceFromSpawn > spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callPlayerSignOpenEvent(cut player, ecn tileEntitySign, boolean front, PlayerSignOpenEvent.Cause cause) {
        CraftBlock block = CraftBlock.at(tileEntitySign.i(), tileEntitySign.aA_());
        Sign sign = (Sign)CraftBlockStates.getBlockState(block);
        Side side = front ? Side.FRONT : Side.BACK;
        return CraftEventFactory.callPlayerSignOpenEvent((Player)player.getBukkitEntity(), sign, side, cause);
    }

    public static boolean callPlayerSignOpenEvent(Player player, Sign sign, Side side, PlayerSignOpenEvent.Cause cause) {
        PlayerSignOpenEvent event = new PlayerSignOpenEvent(player, sign, side, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Either<cut.a, bdk> callPlayerBedEnterEvent(cut player, jb bed2, Either<cut.a, bdk> nmsBedResult) {
        PlayerBedEnterEvent.BedEnterResult bedEnterResult = (PlayerBedEnterEvent.BedEnterResult)nmsBedResult.mapBoth((Function)new com.google.common.base.Function<cut.a, PlayerBedEnterEvent.BedEnterResult>(){

            public PlayerBedEnterEvent.BedEnterResult apply(cut.a t2) {
                switch (t2) {
                    case a: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
                    }
                    case b: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
                    }
                    case c: {
                        return PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
                    }
                    case f: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
                    }
                }
                return PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
            }
        }, t2 -> PlayerBedEnterEvent.BedEnterResult.OK).map(Function.identity(), Function.identity());
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((Player)player.getBukkitEntity(), (Block)CraftBlock.at(player.ai(), bed2), bedEnterResult);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right((Object)((Object)bdk.a));
        }
        if (result == Event.Result.DENY) {
            return Either.left((Object)((Object)cut.a.e));
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(cut entityHuman, cmd entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)entityAnimal.getBukkitEntity(), (HumanEntity)(entityHuman != null ? entityHuman.getBukkitEntity() : null), loveTicks);
        Bukkit.getPluginManager().callEvent((Event)entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(dmu world, jb blockposition, cut who, bxi enumhand, List<dcv> itemsToHarvest) {
        ArrayList bukkitItemsToHarvest = new ArrayList(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Player player = (Player)who.getBukkitEntity();
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent(player, (Block)CraftBlock.at(world, blockposition), CraftEquipmentSlot.getHand(enumhand), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent((Event)playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketEntityEvent callPlayerFishBucketEvent(cam fish, cut entityHuman, dcv originalBucket, dcv entityBucket, bxi enumhand) {
        Player player = (Player)entityHuman.getBukkitEntity();
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        Object event = fish instanceof clz ? new PlayerBucketFishEvent(player, (Fish)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand) : new PlayerBucketEntityEvent(player, (Entity)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TradeSelectEvent callTradeSelectEvent(auc player, int newIndex, czx merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent((MerchantView)merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent((Event)tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static boolean handleBellRingEvent(dmu world, jb position, jh direction, bzm entity) {
        CraftBlock block = CraftBlock.at(world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent((Block)block, bukkitDirection, (Entity)(entity != null ? entity.getBukkitEntity() : null));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Stream<cam> handleBellResonateEvent(dmu world, jb position, List<LivingEntity> bukkitEntities) {
        CraftBlock block = CraftBlock.at(world, position);
        BellResonateEvent event = new BellResonateEvent((Block)block, bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getResonatedEntities().stream().map(bukkitEntity -> ((CraftLivingEntity)bukkitEntity).getHandle());
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(aub world, cut who, bxi hand, List<BlockState> blockStates, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)who.getBukkitEntity();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        boolean canBuild = true;
        for (int i2 = 0; i2 < blockStates.size(); ++i2) {
            if (CraftEventFactory.canBuild(world, player, blockStates.get(i2).getX(), blockStates.get(i2).getZ())) continue;
            canBuild = false;
            break;
        }
        ItemStack item = hand == bxi.a ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, blockClicked, item, player, canBuild);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(aub world, cut who, bxi hand, BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        EquipmentSlot equipmentSlot;
        ItemStack item;
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)who.getBukkitEntity();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(world, player, placedBlock.getX(), placedBlock.getZ());
        if (hand == bxi.a) {
            item = player.getInventory().getItemInMainHand();
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            item = player.getInventory().getItemInOffHand();
            equipmentSlot = EquipmentSlot.OFF_HAND;
        }
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, BlockState state, auc player, List<cqz> items) {
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, (Player)player.getBukkitEntity(), Lists.transform(items, item -> (Item)item.getBukkitEntity()));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (cqz item2 : items) {
                item2.ai().b(item2);
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(dgq itemactioncontext, bzm entity) {
        return CraftEventFactory.callEntityPlaceEvent(itemactioncontext.q(), itemactioncontext.a(), itemactioncontext.k(), itemactioncontext.o(), entity, itemactioncontext.p());
    }

    public static EntityPlaceEvent callEntityPlaceEvent(dmu world, jb clickPosition, jh clickedFace, cut human, bzm entity, bxi enumhand) {
        Player who = human == null ? null : (Player)human.getBukkitEntity();
        CraftBlock blockClicked = CraftBlock.at(world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), who, (Block)blockClicked, blockFace, CraftEquipmentSlot.getHand(enumhand));
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(dmu world, auc who, jb changed, jb clicked, jh clickedFace, dcv itemInHand, bxi enumhand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemInHand, dcz.rF, enumhand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(dmu world, cut who, jb changed, jb clicked, jh clickedFace, dcv itemInHand, dcr bucket, bxi enumhand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket, enumhand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, dmu world, cut who, jb changed, jb clicked, jh clickedFace, dcv itemstack, dcr item, bxi enumhand) {
        PlayerBucketFillEvent event;
        Player player = (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftItemType.minecraftToBukkit(itemstack.h());
        CraftServer craftServer = (CraftServer)player.getServer();
        CraftBlock block = CraftBlock.at(world, changed);
        CraftBlock blockClicked = CraftBlock.at(world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (ItemStack)itemInHand, hand);
            event.setCancelled(!CraftEventFactory.canBuild(world, player, changed.u(), changed.w()));
        } else {
            event = new PlayerBucketEmptyEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (ItemStack)itemInHand, hand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, player, changed.u(), changed.w()));
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(cut who, Action action, dcv itemstack, bxi hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", who, action, itemstack));
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, null, jh.d, itemstack, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(cut who, Action action, jb position, jh direction, dcv itemstack, bxi hand) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, false, hand, null);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(cut who, Action action, jb position, jh direction, dcv itemstack, boolean cancelledBlock, bxi hand, fis targetPos) {
        Vector clickedPos = null;
        if (position != null && targetPos != null) {
            clickedPos = CraftVector.toBukkit(targetPos.d(fis.a(position)));
        }
        CraftBlock blockClicked = null;
        if (position != null) {
            blockClicked = CraftBlock.at(who.ai(), position);
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, blockClicked, CraftBlock.notchToBlockFace(direction), itemstack, cancelledBlock, hand, clickedPos);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(cut who, Action action, Block blockClicked, BlockFace blockFace, dcv itemstack, boolean cancelledBlock, bxi hand, Vector clickedPos) {
        Player player = (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        if (blockClicked == null) {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, (ItemStack)itemInHand, blockClicked, blockFace, hand == null ? null : (hand == bxi.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND), clickedPos);
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(cam original, cam coverted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(coverted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(cam original, List<cam> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (cam entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent((Entity)original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(cam who, dcv bow2, dcv consumableItem, bzm entityArrow, bxi hand, float force, boolean consumeItem) {
        EquipmentSlot handSlot;
        LivingEntity shooter = (LivingEntity)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow2);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        EquipmentSlot equipmentSlot = handSlot = hand == bxi.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (ItemStack)itemInHand, (ItemStack)itemConsumable, (Entity)arrow, handSlot, force, consumeItem);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(cuf vilager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)vilager.getBukkitEntity(), future, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(auc who, jb pos, dcv itemstack, boolean instaBreak) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at(who.y(), pos);
        BlockDamageEvent event = new BlockDamageEvent((Player)player, (Block)blockClicked, (ItemStack)itemInHand, instaBreak);
        player.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageAbortEvent callBlockDamageAbortEvent(auc who, jb pos, dcv itemstack) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at(who.y(), pos);
        BlockDamageAbortEvent event = new BlockDamageAbortEvent((Player)player, (Block)blockClicked, (ItemStack)itemInHand);
        player.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean doEntityAddEventCalling(dmu world, bzm entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        ItemSpawnEvent event = null;
        if (entity instanceof cam && !(entity instanceof auc)) {
            boolean isMonster;
            boolean isAnimal = entity instanceof cmd || entity instanceof cnn || entity instanceof cma;
            boolean bl2 = isMonster = entity instanceof crv || entity instanceof crp || entity instanceof cse;
            if (spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM && (isAnimal && !world.getWorld().getAllowAnimals() || isMonster && !world.getWorld().getAllowMonsters())) {
                entity.discard(null);
                return false;
            }
            event = CraftEventFactory.callCreatureSpawnEvent((cam)entity, spawnReason);
        } else if (entity instanceof cqz) {
            event = CraftEventFactory.callItemSpawnEvent((cqz)entity);
        } else if (entity.getBukkitEntity() instanceof Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause = LightningStrikeEvent.Cause.UNKNOWN;
            switch (spawnReason) {
                case COMMAND: {
                    cause = LightningStrikeEvent.Cause.COMMAND;
                    break;
                }
                case CUSTOM: {
                    cause = LightningStrikeEvent.Cause.CUSTOM;
                    break;
                }
                case SPAWNER: {
                    cause = LightningStrikeEvent.Cause.SPAWNER;
                }
            }
            if (cause == LightningStrikeEvent.Cause.UNKNOWN && spawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
                return true;
            }
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entity.getBukkitEntity(), cause);
        } else if (!(entity instanceof auc)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.dU())) {
            bzm vehicle = entity.dm();
            if (vehicle != null) {
                vehicle.discard(null);
            }
            for (bzm passenger : entity.de()) {
                passenger.discard(null);
            }
            entity.discard(null);
            return false;
        }
        if (entity instanceof caa) {
            caa xp2 = (caa)entity;
            double radius = world.spigotConfig.expMerge;
            if (radius > 0.0) {
                List<bzm> entities = world.a_(entity, entity.cV().c(radius, radius, radius));
                for (bzm e2 : entities) {
                    caa loopItem;
                    if (!(e2 instanceof caa) || (loopItem = (caa)e2).dU()) continue;
                    xp2.c(xp2.e() + loopItem.e());
                    loopItem.discard(null);
                }
            }
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(bzm entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent((Entity)bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(cam entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)entityliving.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(cao entity, cut tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        EntityTameEvent event = new EntityTameEvent((LivingEntity)bukkitEntity, (AnimalTamer)bukkitTamer);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(cqz entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(cqz entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callItemMergeEvent(cqz merging, cqz mergingWith) {
        Item entityMerging = (Item)merging.getBukkitEntity();
        Item entityMergingWith = (Item)mergingWith.getBukkitEntity();
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PotionSplashEvent callPotionSplashEvent(cvd potion, fiq position, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == fiq.a.b) {
            fio positionBlock = (fio)position;
            hitBlock = CraftBlock.at(potion.ai(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == fiq.a.c) {
            hitEntity = ((fip)position).a().getBukkitEntity();
        }
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, (Entity)hitEntity, (Block)hitBlock, hitFace, affectedEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(cvd potion, fiq position, bze cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        AreaEffectCloud effectCloud = (AreaEffectCloud)cloud.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == fiq.a.b) {
            fio positionBlock = (fio)position;
            hitBlock = CraftBlock.at(potion.ai(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == fiq.a.c) {
            hitEntity = ((fip)position).a().getBukkitEntity();
        }
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, (Entity)hitEntity, (Block)hitBlock, hitFace, effectCloud);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(dmv world, jb pos, eeb newBlock) {
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent((Block)state.getBlock(), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(dmu world, jb pos, eeb newBlock, int flag) {
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos, flag);
        state.setData(newBlock);
        MoistureChangeEvent event = new MoistureChangeEvent((Block)state.getBlock(), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBlockSpreadEvent(dmu world, jb source, jb target, eeb block) {
        return CraftEventFactory.handleBlockSpreadEvent(world, source, target, block, 2);
    }

    public static boolean handleBlockSpreadEvent(dmv world, jb source, jb target, eeb block, int flag) {
        if (!(world instanceof dmu)) {
            world.a(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent((Block)state.getBlock(), (Block)CraftBlock.at(world, sourceBlockOverride != null ? sourceBlockOverride : source), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static EntityDeathEvent callEntityDeathEvent(cam victim, byb damageSource) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, new ArrayList<ItemStack>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(cam victim, byb damageSource, List<ItemStack> drops) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        CraftWorld world = (CraftWorld)entity.getWorld();
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)entity, (DamageSource)bukkitDamageSource, drops, victim.getExpReward(world.getHandle(), damageSource.d()));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        victim.expToDrop = event.getDroppedExp();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(auc victim, byb damageSource, List<ItemStack> drops, String deathMessage, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        PlayerDeathEvent event = new PlayerDeathEvent((Player)entity, (DamageSource)bukkitDamageSource, drops, victim.getExpReward(victim.y(), damageSource.d()), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        event.setKeepLevel(victim.keepLevel);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (ItemStack stack : event.getDrops()) {
            CraftItemStack craftItemStack;
            if (stack == null || stack.getType() == Material.AIR) continue;
            if (stack instanceof CraftItemStack && (craftItemStack = (CraftItemStack)stack).isForInventoryDrop()) {
                victim.drop(CraftItemStack.asNMSCopy(stack), true, false, false);
                continue;
            }
            victim.forceDrops = true;
            victim.a(victim.y(), CraftItemStack.asNMSCopy(stack));
            victim.forceDrops = false;
        }
        return event;
    }

    public static ServerListPingEvent callServerListPingEvent(SocketAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent("", ((InetSocketAddress)address).getAddress(), motd, numPlayers, maxPlayers);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    private static EntityDamageEvent handleEntityDamageEvent(bzm entity, byb source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(bzm entity, byb source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        bzm damager;
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        bzm bzm2 = damager = source.getDamager() != null ? source.getDamager() : source.d();
        if (source.a(azp.l)) {
            if (damager == null) {
                return CraftEventFactory.callEntityDamageEvent(source.getDirectBlock(), source.getDirectBlockState(), entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
            }
            EntityDamageEvent.DamageCause damageCause = damager.getBukkitEntity() instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
            return CraftEventFactory.callEntityDamageEvent(damager, entity, damageCause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (damager != null || source.c() != null) {
            EntityDamageEvent.DamageCause cause;
            EntityDamageEvent.DamageCause damageCause = cause = source.isSweep() ? EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK : EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (damager instanceof cvo) {
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if (source.a(bye.P)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            } else if (source.a(bye.S)) {
                cause = EntityDamageEvent.DamageCause.SONIC_BOOM;
            } else if (source.a(bye.z) || source.a(bye.x) || source.a(bye.y)) {
                cause = EntityDamageEvent.DamageCause.FALLING_BLOCK;
            } else if (source.a(bye.c)) {
                cause = EntityDamageEvent.DamageCause.LIGHTNING;
            } else if (source.a(bye.l)) {
                cause = EntityDamageEvent.DamageCause.FALL;
            } else if (source.a(bye.s)) {
                cause = EntityDamageEvent.DamageCause.DRAGON_BREATH;
            } else if (source.a(bye.q)) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.a(bye.o)) {
            return CraftEventFactory.callEntityDamageEvent(source.getDirectBlock(), source.getDirectBlockState(), entity, EntityDamageEvent.DamageCause.VOID, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.a(bye.e)) {
            return CraftEventFactory.callEntityDamageEvent(source.getDirectBlock(), source.getDirectBlockState(), entity, EntityDamageEvent.DamageCause.LAVA, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.getDirectBlock() != null) {
            EntityDamageEvent.DamageCause cause;
            if (source.a(bye.k) || source.a(bye.u) || source.a(bye.w) || source.a(bye.z) || source.a(bye.y)) {
                cause = EntityDamageEvent.DamageCause.CONTACT;
            } else if (source.a(bye.f)) {
                cause = EntityDamageEvent.DamageCause.HOT_FLOOR;
            } else if (source.a(bye.q)) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            } else if (source.a(bye.a)) {
                cause = EntityDamageEvent.DamageCause.FIRE;
            } else if (source.a(bye.b)) {
                cause = EntityDamageEvent.DamageCause.CAMPFIRE;
            } else {
                throw new IllegalStateException(String.format("Unhandled damage of %s by %s from %s [%s]", entity, source.getDirectBlock(), source.f(), source.l().g()));
            }
            return CraftEventFactory.callEntityDamageEvent(source.getDirectBlock(), source.getDirectBlockState(), entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        EntityDamageEvent.DamageCause cause = source.a(bye.a) ? EntityDamageEvent.DamageCause.FIRE : (source.a(bye.j) ? EntityDamageEvent.DamageCause.STARVATION : (source.a(bye.r) ? EntityDamageEvent.DamageCause.WITHER : (source.a(bye.g) ? EntityDamageEvent.DamageCause.SUFFOCATION : (source.a(bye.i) ? EntityDamageEvent.DamageCause.DROWNING : (source.a(bye.d) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.isMelting() ? EntityDamageEvent.DamageCause.MELTING : (source.isPoison() ? EntityDamageEvent.DamageCause.POISON : (source.a(bye.q) ? EntityDamageEvent.DamageCause.MAGIC : (source.a(bye.l) ? EntityDamageEvent.DamageCause.FALL : (source.a(bye.n) ? EntityDamageEvent.DamageCause.FLY_INTO_WALL : (source.a(bye.h) ? EntityDamageEvent.DamageCause.CRAMMING : (source.a(bye.t) ? EntityDamageEvent.DamageCause.DRYOUT : (source.a(bye.v) ? EntityDamageEvent.DamageCause.FREEZE : (source.a(bye.V) ? EntityDamageEvent.DamageCause.KILL : (source.a(bye.U) ? EntityDamageEvent.DamageCause.WORLD_BORDER : EntityDamageEvent.DamageCause.CUSTOM)))))))))))))));
        return CraftEventFactory.callEntityDamageEvent(null, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(bzm damager, bzm damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        Object event = damager != null ? new EntityDamageByEntityEvent((Entity)damager.getBukkitEntity(), (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions) : new EntityDamageEvent((Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent(event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(Block damager, BlockState damagerState, bzm damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, damagerState, (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent((EntityDamageEvent)event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(EntityDamageEvent event, bzm damagee, boolean cancelled) {
        event.setCancelled(cancelled);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        } else {
            damagee.lastDamageCancelled = true;
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(bzm damagee, byb source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source.a(bye.v)) {
            modifiers.put(EntityDamageEvent.DamageModifier.FREEZING, freezingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.FREEZING, freezing);
        }
        if (source.a(bye.x) || source.a(bye.y)) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof cut) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(bzm entity, byb source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(bzm entity, byb source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static EntityDamageEvent callNonLivingEntityDamageEvent(bzm entity, byb source, double damage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
    }

    public static boolean handleNonLivingEntityDamageEvent(bzm entity, byb source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(entity, source, damage, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(cut entity, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(cut entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(cut entity, caa orb, dcv nmsMendedItem, bzw slot, int repairAmount) {
        Player player = (Player)entity.getBukkitEntity();
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, (ItemStack)bukkitStack, CraftEquipmentSlot.getSlot(slot), (ExperienceOrb)orb.getBukkitEntity(), repairAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockGrowEvent(dmu world, jb pos, eeb block) {
        return CraftEventFactory.handleBlockGrowEvent(world, pos, block, 3);
    }

    public static boolean handleBlockGrowEvent(dmu world, jb pos, eeb newData, int flag) {
        Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static BlockBrushEvent callBlockBrushEvent(dmu world, jb pos, eeb newData, int flag, cut entity) {
        Player player = (Player)entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at(world, pos);
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockBrushEvent event = new BlockBrushEvent((Block)block, (BlockState)state, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(dmu world, jb block, eeb newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent((Block)CraftBlock.at(world, block), (BlockData)CraftBlockData.fromData(newData));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(cut entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(cut entity, int level, dcv item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(bzm pig, bzm lightning, bzm pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)pig.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (PigZombie)pigzombie.getBukkitEntity());
        pig.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callHorseJumpEvent(bzm horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)horse.getBukkitEntity(), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean callEntityChangeBlockEvent(bzm entity, jb position, eeb newBlock) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, position, newBlock, false);
    }

    public static boolean callEntityChangeBlockEvent(bzm entity, jb position, eeb newBlock, boolean cancelled) {
        Block block = entity.ai().getWorld().getBlockAt(position.u(), position.v(), position.w());
        EntityChangeBlockEvent event = new EntityChangeBlockEvent((Entity)entity.getBukkitEntity(), block, (BlockData)CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static CreeperPowerEvent callCreeperPowerEvent(bzm creeper, bzm lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(bzm entity, bzm target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent((Entity)entity.getBukkitEntity(), (Entity)(target == null ? null : target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(bzm entity, cam target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(bzm entity, jb pos) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at(entity.ai(), pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, (Block)block);
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static cym callInventoryOpenEvent(auc player, cym container) {
        return CraftEventFactory.callInventoryOpenEvent(player, container, false);
    }

    public static cym callInventoryOpenEvent(auc player, cym container, boolean cancelled) {
        if (player.cn != player.cm) {
            player.g.a(new aie(player.cn.l));
        }
        CraftServer server = player.y().getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.cn.transferTo(container, craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.cn, craftPlayer);
            return null;
        }
        return container;
    }

    public static dcv callPreCraftEvent(cze matrix, bxc resultInventory, dcv result, InventoryView lastCraftView, Optional<dhr<dhb>> recipe) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, recipe.map(dhr::b).orElse(null) instanceof dhy);
        Bukkit.getPluginManager().callEvent((Event)event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static CrafterCraftEvent callCrafterCraftEvent(jb pos, dmu world, cze inventoryCrafting, dcv result, ju<dcv> remaining, dhr<dhb> holder) {
        CraftBlock block = CraftBlock.at(world, pos);
        CraftItemStack itemStack = CraftItemStack.asCraftMirror(result);
        CraftingRecipe craftingRecipe = (CraftingRecipe)holder.toBukkitRecipe();
        List bukkitRemaining = remaining.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        CrafterCraftEvent crafterCraftEvent = new CrafterCraftEvent((Block)block, craftingRecipe, (ItemStack)itemStack, bukkitRemaining);
        Bukkit.getPluginManager().callEvent((Event)crafterCraftEvent);
        return crafterCraftEvent;
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(bzm entity) {
        Projectile bukkitEntity = (Projectile)entity.getBukkitEntity();
        ProjectileLaunchEvent event = new ProjectileLaunchEvent((Entity)bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(bzm entity, fiq position) {
        if (position.d() == fiq.a.a) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == fiq.a.b) {
            fio positionBlock = (fio)position;
            hitBlock = CraftBlock.at(entity.ai(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == fiq.a.c) {
            hitEntity = ((fip)position).a().getBukkitEntity();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)entity.getBukkitEntity(), (Entity)hitEntity, (Block)hitBlock, hitFace);
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(bzm entity, fiq position, int exp2) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == fiq.a.b) {
            fio positionBlock = (fio)position;
            hitBlock = CraftBlock.at(entity.ai(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == fiq.a.c) {
            hitEntity = ((fip)position).a().getBukkitEntity();
        }
        ExpBottleEvent event = new ExpBottleEvent(bottle, (Entity)hitEntity, (Block)hitBlock, hitFace, exp2);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(dmu world, jb pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), oldCurrent, newCurrent);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(dmu world, jb pos, efc instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), Instrument.getByType((byte)((byte)instrument.ordinal())), new Note(note));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(auc human, dcv brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)human.getBukkitEntity(), (ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(dmu world, jb block, jb source) {
        CraftWorld bukkitWorld = world.getWorld();
        Block igniter = bukkitWorld.getBlockAt(source.u(), source.v(), source.w());
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(block.u(), block.v(), block.w()), switch (igniter.getType()) {
            case Material.LAVA -> BlockIgniteEvent.IgniteCause.LAVA;
            case Material.DISPENSER -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            default -> BlockIgniteEvent.IgniteCause.SPREAD;
        }, igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(dmu world, jb pos, bzm igniter) {
        bzm shooter;
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        BlockIgniteEvent.IgniteCause cause = switch (bukkitIgniter.getType()) {
            case EntityType.END_CRYSTAL -> BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
            case EntityType.LIGHTNING_BOLT -> BlockIgniteEvent.IgniteCause.LIGHTNING;
            case EntityType.SMALL_FIREBALL, EntityType.FIREBALL -> BlockIgniteEvent.IgniteCause.FIREBALL;
            case EntityType.ARROW -> BlockIgniteEvent.IgniteCause.ARROW;
            default -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
        };
        if (igniter instanceof cvo && (shooter = ((cvo)igniter).ah_()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(pos.u(), pos.v(), pos.w()), cause, (Entity)bukkitIgniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(dmu world, jb blockposition, dmn explosion) {
        CraftEntity igniter = explosion.d() == null ? null : explosion.d().getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, blockposition), BlockIgniteEvent.IgniteCause.EXPLOSION, (Entity)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(dmu world, jb pos, BlockIgniteEvent.IgniteCause cause, bzm igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), cause, (Entity)igniter.getBukkitEntity());
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleInventoryCloseEvent(cut human) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.cn.getBukkitView());
        human.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        human.cn.transferTo(human.cm, human.getBukkitEntity());
    }

    public static dcv handleEditBookEvent(auc player, int itemInHandIndex, dcv itemInHand, dcv newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent((Player)player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.h() == dcz.vB);
        player.y().getCraftServer().getPluginManager().callEvent((Event)editBookEvent);
        if (itemInHand != null && itemInHand.h() == dcz.vA) {
            if (!editBookEvent.isCancelled()) {
                if (editBookEvent.isSigning()) {
                    itemInHand.setItem(dcz.vB);
                }
                BookMeta meta = editBookEvent.getNewBookMeta();
                CraftItemStack.setItemMeta(itemInHand, (ItemMeta)meta);
            } else {
                player.getBukkitEntity().updateInventory();
            }
        }
        return itemInHand;
    }

    public static void callRecipeBookSettingsEvent(auc player, dac type, boolean open, boolean filter) {
        PlayerRecipeBookSettingsChangeEvent.RecipeBookType bukkitType = PlayerRecipeBookSettingsChangeEvent.RecipeBookType.values()[type.ordinal()];
        Bukkit.getPluginManager().callEvent((Event)new PlayerRecipeBookSettingsChangeEvent((Player)player.getBukkitEntity(), bukkitType, open, filter));
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(bzm entity, cut player, bxi enumhand) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(enumhand));
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(bzm entity, bzm leashHolder, cut player, bxi enumhand) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent((Entity)entity.getBukkitEntity(), (Entity)leashHolder.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(enumhand));
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerRiptideEvent(cut player, dcv tridentItemStack, float velocityX, float velocityY, float velocityZ) {
        PlayerRiptideEvent event = new PlayerRiptideEvent((Player)player.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(tridentItemStack), new Vector(velocityX, velocityY, velocityZ));
        player.ai().getCraftServer().getPluginManager().callEvent((Event)event);
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(bzm animal, Block dispenser, CraftItemStack is2) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, (Entity)animal.getBukkitEntity(), (ItemStack)is2);
        Bukkit.getPluginManager().callEvent((Event)bse);
        return bse;
    }

    public static boolean handlePlayerShearEntityEvent(cut player, bzm sheared, dcv shears, bxi hand) {
        if (!(player instanceof auc)) {
            return true;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)player.getBukkitEntity(), (Entity)sheared.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(shears), hand == bxi.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Cancellable handleStatisticsIncrease(cut entityHuman, azg<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((auc)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + String.valueOf(statistic));
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: 
            case TOTAL_WORLD_TIME: 
            case TIME_SINCE_REST: 
            case AVIATE_ONE_CM: 
            case STRIDER_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, material);
        }
        entityHuman.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return (Cancellable)event;
    }

    public static FireworkExplodeEvent callFireworkExplodeEvent(cvj firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)firework.getBukkitEntity());
        firework.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(AnvilView view, dcv item) {
        PrepareAnvilEvent event = new PrepareAnvilEvent(view, (ItemStack)CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent((Event)event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static PrepareGrindstoneEvent callPrepareGrindstoneEvent(InventoryView view, dcv item) {
        PrepareGrindstoneEvent event = new PrepareGrindstoneEvent(view, (ItemStack)CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent((Event)event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, dcv item) {
        PrepareSmithingEvent event = new PrepareSmithingEvent(view, (ItemStack)CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent((Event)event);
        event.getInventory().setResult(event.getResult());
        return event;
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(bzm spawnee, jb pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.ai(), pos).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent((Entity)entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TrialSpawnerSpawnEvent callTrialSpawnerSpawnEvent(bzm spawnee, jb pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.ai(), pos).getState();
        if (!(state instanceof TrialSpawner)) {
            state = null;
        }
        TrialSpawnerSpawnEvent event = new TrialSpawnerSpawnEvent((Entity)entity, (TrialSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDispenseLootEvent callBlockDispenseLootEvent(aub worldServer, jb blockPosition, cut player, List<dcv> rewardLoot) {
        List craftItemStacks = rewardLoot.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        BlockDispenseLootEvent event = new BlockDispenseLootEvent(player == null ? null : (Player)player.getBukkitEntity(), (Block)CraftBlock.at(worldServer, blockPosition), craftItemStacks);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VaultDisplayItemEvent callVaultDisplayItemEvent(aub worldServer, jb blockPosition, dcv displayitemStack) {
        VaultDisplayItemEvent event = new VaultDisplayItemEvent((Block)CraftBlock.at(worldServer, blockPosition), CraftItemStack.asBukkitCopy(displayitemStack));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(cam entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((LivingEntity)entity.getBukkitEntity(), gliding);
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(cam entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)entity.getBukkitEntity(), swimming);
        entity.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(bze cloud, List<LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)cloud.getBukkitEntity(), entities);
        cloud.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(bzm entity) {
        Vehicle bukkitEntity = (Vehicle)entity.getBukkitEntity();
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(cam child, cam mother, cam father, cam breeder, dcv bredWith, int experience) {
        LivingEntity breederEntity = (LivingEntity)(breeder == null ? null : breeder.getBukkitEntity());
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)child.getBukkitEntity(), (LivingEntity)mother.getBukkitEntity(), (LivingEntity)father.getBukkitEntity(), breederEntity, (ItemStack)bredWithStack, experience);
        child.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(dmv world, jb blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent((Block)block, block.getBlockData());
        if (world instanceof dmu) {
            ((dmu)world).q().server.getPluginManager().callEvent((Event)event);
        }
        return event;
    }

    public static boolean handleBlockFormEvent(dmu world, jb pos, eeb block) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(cam entity, @Nullable byq oldEffect, @Nullable byq newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(cam entity, @Nullable byq oldEffect, @Nullable byq newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(cam entity, @Nullable byq oldEffect, @Nullable byq newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(cam entity, @Nullable byq oldEffect, @Nullable byq newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        Preconditions.checkState((bukkitOldEffect != null || bukkitNewEffect != null ? 1 : 0) != 0, (Object)"Old and new potion effect are both null");
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((LivingEntity)entity.getBukkitEntity(), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockFormEvent(dmu world, jb pos, eeb block, @Nullable bzm entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3, entity);
    }

    public static boolean handleBlockFormEvent(dmu world, jb pos, eeb block, int flag) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, flag, null);
    }

    public static boolean handleBlockFormEvent(dmu world, jb pos, eeb block, int flag, @Nullable bzm entity) {
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent((Block)blockState.getBlock(), (BlockState)blockState) : new EntityBlockFormEvent((Entity)entity.getBukkitEntity(), (Block)blockState.getBlock(), (BlockState)blockState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBatToggleSleepEvent(bzm bat2, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)bat2.getBukkitEntity(), awake);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handlePlayerRecipeListUpdateEvent(cut who, ame recipe) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)who.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipe));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(bzm who, cqz item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)who.getBukkitEntity(), (Item)item.getBukkitEntity(), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callRaidTriggerEvent(cwj raid, dmu world, auc player) {
        RaidTriggerEvent event = new RaidTriggerEvent((Raid)new CraftRaid(raid, world), (World)world.getWorld(), (Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(cwj raid, dmu world, List<Player> players) {
        RaidFinishEvent event = new RaidFinishEvent((Raid)new CraftRaid(raid, world), (World)world.getWorld(), players);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidStopEvent(cwj raid, dmu world, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent((Raid)new CraftRaid(raid, world), (World)world.getWorld(), reason);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidSpawnWaveEvent(cwj raid, dmu world, cwk leader, List<cwk> raiders) {
        CraftRaider craftLeader = (CraftRaider)leader.getBukkitEntity();
        ArrayList<Raider> craftRaiders = new ArrayList<Raider>();
        for (cwk entityRaider : raiders) {
            craftRaiders.add((Raider)entityRaider.getBukkitEntity());
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent((Raid)new CraftRaid(raid, world), (World)world.getWorld(), (Raider)craftLeader, craftRaiders);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static LootGenerateEvent callLootGenerateEvent(bxc inventory, fdo lootTable, fdj lootInfo, List<dcv> loot, boolean plugin) {
        CraftWorld world = lootInfo.d().getWorld();
        bzm entity = lootInfo.c(fgd.a);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent((World)world, (Entity)(entity != null ? entity.getBukkitEntity() : null), inventory.getOwner(), (LootTable)lootTable.craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callStriderTemperatureChangeEvent(csi strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)strider.getBukkitEntity(), shivering);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handleEntitySpellCastEvent(csf caster, csf.a spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)caster.getBukkitEntity(), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(cam entity, int oldAmount, int newAmount, boolean isReset) {
        LivingEntity bukkitEntity = (LivingEntity)entity.getBukkitEntity();
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(cut humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent((HumanEntity)humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(cti piglin, List<dcv> outcome, dcv input) {
        PiglinBarterEvent event = new PiglinBarterEvent((Piglin)piglin.getBukkitEntity(), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callEntitiesLoadEvent(dmu world, dlz coords, List<bzm> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(bzm::getBukkitEntity).collect(Collectors.toList()));
        EntitiesLoadEvent event = new EntitiesLoadEvent((Chunk)new CraftChunk((aub)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callEntitiesUnloadEvent(dmu world, dlz coords, List<bzm> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(bzm::getBukkitEntity).collect(Collectors.toList()));
        EntitiesUnloadEvent event = new EntitiesUnloadEvent((Chunk)new CraftChunk((aub)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static boolean callTNTPrimeEvent(dmu world, jb pos, TNTPrimeEvent.PrimeCause cause, bzm causingEntity, jb causePosition) {
        CraftEntity bukkitEntity = causingEntity == null ? null : causingEntity.getBukkitEntity();
        CraftBlock bukkitBlock = causePosition == null ? null : CraftBlock.at(world, causePosition);
        TNTPrimeEvent event = new TNTPrimeEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitEntity, (Block)bukkitBlock);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeBookClickEvent callRecipeBookClickEvent(auc player, Recipe recipe, boolean shiftClick) {
        PlayerRecipeBookClickEvent event = new PlayerRecipeBookClickEvent((Player)player.getBukkitEntity(), recipe, shiftClick);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTeleportEvent callEntityTeleportEvent(bzm nmsEntity, double x2, double y2, double z2) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        Location to2 = new Location(entity.getWorld(), x2, y2, z2, nmsEntity.dP(), nmsEntity.dR());
        return CraftEventFactory.callEntityTeleportEvent(nmsEntity, to2);
    }

    public static EntityTeleportEvent callEntityTeleportEvent(bzm nmsEntity, Location to2) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity, entity.getLocation(), to2);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callEntityInteractEvent(bzm nmsEntity, Block block) {
        EntityInteractEvent event = new EntityInteractEvent((Entity)nmsEntity.getBukkitEntity(), block);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static List<Block> handleExplodeEvent(dnk serverExplosion, List<jb> blockPositions) {
        CraftWorld bworld = serverExplosion.a().getWorld();
        ObjectArrayList blockList = new ObjectArrayList();
        for (int i1 = blockPositions.size() - 1; i1 >= 0; --i1) {
            jb cpos = blockPositions.get(i1);
            Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
            if (bblock.getType().isAir()) continue;
            blockList.add(bblock);
        }
        if (serverExplosion.d() != null || serverExplosion.k().getCausingDamager() != null) {
            EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(serverExplosion.d() != null ? serverExplosion.d() : serverExplosion.k().getCausingDamager(), (List<Block>)blockList, serverExplosion.yield, serverExplosion.b());
            serverExplosion.wasCanceled = event.isCancelled();
            serverExplosion.yield = event.getYield();
            return event.blockList();
        }
        Location location = CraftLocation.toBukkit(serverExplosion.f(), (World)bworld);
        Block block = location.getBlock();
        BlockState blockState = serverExplosion.k().getDirectBlockState() != null ? serverExplosion.k().getDirectBlockState() : block.getState();
        BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<Block>)blockList, serverExplosion.yield, serverExplosion.b());
        serverExplosion.wasCanceled = event.isCancelled();
        serverExplosion.yield = event.getYield();
        return event.blockList();
    }

    public static EntityExplodeEvent callEntityExplodeEvent(bzm entity, List<Block> blocks, float yield, dmn.a effect) {
        EntityExplodeEvent event = new EntityExplodeEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), blocks, yield, CraftExplosionResult.toBukkit(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockExplodeEvent callBlockExplodeEvent(Block block, BlockState state, List<Block> blocks, float yield, dmn.a effect) {
        BlockExplodeEvent event = new BlockExplodeEvent(block, state, blocks, yield, CraftExplosionResult.toBukkit(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(Explosive explosive) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent(explosive);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(bzm nmsEntity, float size, boolean fire) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)nmsEntity.getBukkitEntity(), size, fire);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityKnockbackEvent callEntityKnockbackEvent(CraftLivingEntity entity, bzm attacker, EntityKnockbackEvent.KnockbackCause cause, double force, fis raw, double x2, double y2, double z2) {
        Vector bukkitRaw = new Vector(-raw.d, raw.e, -raw.f);
        Object event = attacker != null ? new EntityKnockbackByEntityEvent((LivingEntity)entity, (Entity)attacker.getBukkitEntity(), cause, force, bukkitRaw, new Vector(x2, y2, z2)) : new EntityKnockbackEvent((LivingEntity)entity, cause, force, bukkitRaw, new Vector(x2, y2, z2));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callEntityRemoveEvent(bzm entity, EntityRemoveEvent.Cause cause) {
        if (entity instanceof auc) {
            return;
        }
        if (cause == null) {
            return;
        }
        if (!entity.inWorld) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityRemoveEvent((Entity)entity.getBukkitEntity(), cause));
    }

    public static VillagerReputationChangeEvent callVillagerReputationChangeEvent(Villager villager, UUID targetUuid, Villager.ReputationEvent reason, Villager.ReputationType reputationType, int oldValue, int newValue, int maxValue) {
        VillagerReputationChangeEvent event = new VillagerReputationChangeEvent(villager, targetUuid, reason, reputationType, oldValue, newValue, maxValue);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerCustomClickEvent callPlayerCustomClickEvent(ame minecraftkey, Optional<vi> optional, auc player) {
        NamespacedKey id2 = CraftNamespacedKey.fromMinecraft(minecraftkey);
        JsonElement data = optional.map(nbt -> (JsonElement)uw.a.a(JsonOps.INSTANCE, (vi)nbt)).orElse(null);
        PlayerCustomClickEvent event = new PlayerCustomClickEvent((Player)player.getBukkitEntity(), id2, data);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }
}

