/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R5.generator.CraftBiomeParameterPoint;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CustomWorldChunkManager
extends dob {
    private final WorldInfo worldInfo;
    private final BiomeProvider biomeProvider;
    private final jy<dnx> registry;

    private static List<jl<dnx>> biomeListToBiomeBaseList(List<Biome> biomes, jy<dnx> registry) {
        ArrayList<jl<dnx>> biomeBases = new ArrayList<jl<dnx>>();
        for (Biome biome : biomes) {
            Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot use the biome %s", (Object)biome);
            biomeBases.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        return biomeBases;
    }

    public CustomWorldChunkManager(WorldInfo worldInfo, BiomeProvider biomeProvider, jy<dnx> registry) {
        this.worldInfo = worldInfo;
        this.biomeProvider = biomeProvider;
        this.registry = registry;
    }

    @Override
    protected MapCodec<? extends dob> a() {
        throw new UnsupportedOperationException("Cannot serialize CustomWorldChunkManager");
    }

    @Override
    public jl<dnx> getNoiseBiome(int x2, int y2, int z2, dog.f sampler) {
        Biome biome = this.biomeProvider.getBiome(this.worldInfo, x2 << 2, y2 << 2, z2 << 2, CraftBiomeParameterPoint.createBiomeParameterPoint(sampler, sampler.a(x2, y2, z2)));
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        return CraftBiome.bukkitToMinecraftHolder(biome);
    }

    @Override
    protected Stream<jl<dnx>> b() {
        return CustomWorldChunkManager.biomeListToBiomeBaseList(this.biomeProvider.getBiomes(this.worldInfo), this.registry).stream();
    }
}

