/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.persistence;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataAdapterContext;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNBTTagConfigSerializer;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class CraftPersistentDataContainer
implements PersistentDataContainer {
    private final Map<String, vi> customDataTags = new HashMap<String, vi>();
    private final CraftPersistentDataTypeRegistry registry;
    private final CraftPersistentDataAdapterContext adapterContext;

    public CraftPersistentDataContainer(Map<String, vi> customTags, CraftPersistentDataTypeRegistry registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CraftPersistentDataContainer(CraftPersistentDataTypeRegistry registry) {
        this.registry = registry;
        this.adapterContext = new CraftPersistentDataAdapterContext(this.registry);
    }

    public <T, Z> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"The provided type cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"The provided value cannot be null");
        this.customDataTags.put(key.toString(), this.registry.wrap(type, type.toPrimitive(value, (PersistentDataAdapterContext)this.adapterContext)));
    }

    public <T, Z> boolean has(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"The provided type cannot be null");
        vi value = this.customDataTags.get(key.toString());
        if (value == null) {
            return false;
        }
        return this.registry.isInstanceOf(type, value);
    }

    public boolean has(NamespacedKey key) {
        return this.customDataTags.get(key.toString()) != null;
    }

    public <T, Z> Z get(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"The provided type cannot be null");
        vi value = this.customDataTags.get(key.toString());
        if (value == null) {
            return null;
        }
        return (Z)type.fromPrimitive(this.registry.extract(type, value), (PersistentDataAdapterContext)this.adapterContext);
    }

    @NotNull
    public <T, Z> Z getOrDefault(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z defaultValue) {
        Z z2 = this.get(key, type);
        return z2 != null ? z2 : defaultValue;
    }

    @NotNull
    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.customDataTags.keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    public void remove(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        this.customDataTags.remove(key.toString());
    }

    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    @NotNull
    public void copyTo(PersistentDataContainer other, boolean replace) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"The target container cannot be null");
        CraftPersistentDataContainer target = (CraftPersistentDataContainer)other;
        if (replace) {
            target.customDataTags.putAll(this.customDataTags);
        } else {
            this.customDataTags.forEach(target.customDataTags::putIfAbsent);
        }
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftPersistentDataContainer)) {
            return false;
        }
        Map<String, vi> myRawMap = this.getRaw();
        Map<String, vi> theirRawMap = ((CraftPersistentDataContainer)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    public ui toTagCompound() {
        ui tag = new ui();
        for (Map.Entry<String, vi> entry : this.customDataTags.entrySet()) {
            tag.a(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public void store(fdc output) {
        Preconditions.checkArgument((boolean)(output instanceof fcz), (Object)"Must be an NBT output");
        ((fcz)output).b().a(this.toTagCompound());
    }

    public void put(String key, vi base) {
        this.customDataTags.put(key, base);
    }

    public void putAll(Map<String, vi> map) {
        this.customDataTags.putAll(map);
    }

    public void putAll(ui compound) {
        for (String key : compound.e()) {
            this.customDataTags.put(key, compound.a(key));
        }
    }

    public void putAll(fda input) {
        Preconditions.checkArgument((boolean)(input instanceof fcy), (Object)"Must be an NBT input");
        this.putAll(((fcy)input).c);
    }

    public Map<String, vi> getRaw() {
        return this.customDataTags;
    }

    public CraftPersistentDataTypeRegistry getDataTagTypeRegistry() {
        return this.registry;
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.customDataTags.hashCode();
    }

    public String serialize() {
        return CraftNBTTagConfigSerializer.serialize(this.toTagCompound());
    }
}

