/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.projectiles;

import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final ebu dispenserBlock;

    public CraftBlockProjectileSource(ebu dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return this.dispenserBlock.i().getWorld().getBlockAt(this.dispenserBlock.aA_().u(), this.dispenserBlock.aA_().v(), this.dispenserBlock.aA_().w());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        lk sourceblock = new lk((aub)this.dispenserBlock.i(), this.dispenserBlock.aA_(), this.dispenserBlock.m(), this.dispenserBlock);
        jh enumdirection = sourceblock.d().c(dsf.b);
        dmu world = this.dispenserBlock.i();
        dcr item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = dcz.rJ;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = dcz.rY;
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            item = dcz.tE;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = dcz.vx;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? dcz.wU : dcz.wR;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            item = TippedArrow.class.isAssignableFrom(projectile) ? dcz.wT : (SpectralArrow.class.isAssignableFrom(projectile) ? dcz.wS : dcz.pB);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            item = AbstractWindCharge.class.isAssignableFrom(projectile) ? dcz.vz : dcz.vy;
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = dcz.vW;
        }
        Preconditions.checkArgument((boolean)(item instanceof ddp), (Object)"Projectile not supported");
        dcv itemstack = new dcv(item);
        ddp projectileItem = (ddp)((Object)item);
        ddp.a dispenseConfig = projectileItem.a();
        jv iposition = dispenseConfig.b().getDispensePosition(sourceblock, enumdirection);
        cvo launch = projectileItem.a(world, iposition, itemstack, enumdirection);
        if (Fireball.class.isAssignableFrom(projectile)) {
            cvc customFireball = null;
            if (WitherSkull.class.isAssignableFrom(projectile)) {
                customFireball = bzv.bN.a(world, bzu.k);
                launch = customFireball;
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = bzv.K.a(world, bzu.k);
            } else if (BreezeWindCharge.class.isAssignableFrom(projectile)) {
                customFireball = bzv.t.a(world, bzu.k);
                launch = customFireball;
            } else if (LargeFireball.class.isAssignableFrom(projectile)) {
                customFireball = bzv.Z.a(world, bzu.k);
                launch = customFireball;
            }
            if (customFireball != null) {
                customFireball.a_(iposition.a(), iposition.b(), iposition.c());
                bck randomsource = world.H_();
                double d0 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d1 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d2 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                fis vec3d = new fis(d0, d1, d2);
                customFireball.a(vec3d, 0.1);
            }
        }
        if (launch instanceof cvb) {
            cvb arrow = (cvb)launch;
            arrow.b = cvb.a.b;
        }
        launch.projectileSource = this;
        projectileItem.a(launch, enumdirection.j(), enumdirection.k(), enumdirection.l(), dispenseConfig.d(), dispenseConfig.c());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

