/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldUUID {
    private static final Logger LOGGER = LogManager.getLogger();

    private WorldUUID() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID getUUID(File baseDir) {
        File file1 = new File(baseDir, "uid.dat");
        if (file1.exists()) {
            FilterInputStream dis2 = null;
            try {
                dis2 = new DataInputStream(new FileInputStream(file1));
                UUID uUID = new UUID(((DataInputStream)dis2).readLong(), ((DataInputStream)dis2).readLong());
                return uUID;
            }
            catch (IOException ex2) {
                LOGGER.warn("Failed to read " + String.valueOf(file1) + ", generating new random UUID", (Throwable)ex2);
            }
            finally {
                if (dis2 != null) {
                    try {
                        dis2.close();
                    }
                    catch (IOException ex2) {}
                }
            }
        }
        UUID uuid = UUID.randomUUID();
        FilterOutputStream dos2 = null;
        try {
            dos2 = new DataOutputStream(new FileOutputStream(file1));
            ((DataOutputStream)dos2).writeLong(uuid.getMostSignificantBits());
            ((DataOutputStream)dos2).writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException ex3) {
            LOGGER.warn("Failed to write " + String.valueOf(file1), (Throwable)ex3);
        }
        finally {
            if (dos2 != null) {
                try {
                    dos2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return uuid;
    }
}

