/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static fin maxBB = new fin(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(bzm entity) {
        if (entity instanceof cwk) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof crv || entity instanceof cse) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof cau || entity instanceof clv) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(bzm entity, SpigotWorldConfig config) {
        if (config == null) {
            return false;
        }
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof cut || entity instanceof cvw || entity instanceof cps || entity instanceof cpp || entity instanceof cqm || entity instanceof cvc || entity instanceof cal || entity instanceof cra || entity instanceof cpr || entity instanceof cvj || entity instanceof cwc;
    }

    public static void activateEntities(dmu world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (cut cut2 : world.A()) {
            cut2.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && cut2.am()) continue;
            maxBB = cut2.cV().c(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = cut2.cV().c(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = cut2.cV().c(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = cut2.cV().c(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = cut2.cV().c(monsterActivationRange, 256.0, monsterActivationRange);
            world.I().a(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(bzm entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.cV())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(bzm entity) {
        if (entity.at || entity.aH() > 0) {
            return true;
        }
        if (!(entity instanceof cvb) ? !entity.aK() || !entity.aR.isEmpty() || entity.cc() : !((cvb)entity).e()) {
            return true;
        }
        if (entity instanceof cam) {
            cam living = (cam)entity;
            if (living.bj > 0 || living.ce.size() > 0) {
                return true;
            }
            if (entity instanceof cau && ((cau)entity).e() != null) {
                return true;
            }
            if (entity instanceof cuf && ((cuf)entity).Y_()) {
                return true;
            }
            if (entity instanceof cmd) {
                cmd animal = (cmd)entity;
                if (animal.g_() || animal.gR()) {
                    return true;
                }
                if (entity instanceof cpd && ((cpd)entity).t()) {
                    return true;
                }
            }
            if (entity instanceof crh && ((crh)entity).t()) {
                return true;
            }
        }
        return entity instanceof caa;
    }

    public static boolean checkIfActive(bzm entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof cvj || entity instanceof cqz && (entity.as + entity.ar() + 1) % 4 == 0) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl2 = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.as % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        fin boundingBox = new fin(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

