/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> b;
    private final IChunkAccess c;
    private final WorldServer d;
    private final long e;
    private final WorldData f;
    private final RandomSource h;
    private final DimensionManager i;
    private final TickListWorldGen<Block> j = new TickListWorldGen(blockposition -> this.A((BlockPosition)blockposition).q());
    private final TickListWorldGen<FluidType> k = new TickListWorldGen(blockposition -> this.A((BlockPosition)blockposition).r());
    private final BiomeManager l;
    private final ChunkStep m;
    @Nullable
    private Supplier<String> n;
    private final AtomicLong o = new AtomicLong();
    private static final MinecraftKey p = MinecraftKey.b("worldgen_region_random");

    public RegionLimitedWorldAccess(WorldServer worldserver, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkStep chunkstep, IChunkAccess ichunkaccess) {
        this.m = chunkstep;
        this.b = staticcache2d;
        this.c = ichunkaccess;
        this.d = worldserver;
        this.e = worldserver.F();
        this.f = worldserver.D_();
        this.h = worldserver.n().i().a(p).a(this.c.f().l());
        this.i = worldserver.G_();
        this.l = new BiomeManager(this, BiomeManager.a(this.e));
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.d.n().a.b(chunkcoordintpair, i2);
    }

    public ChunkCoordIntPair b() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> supplier) {
        this.n = supplier;
    }

    @Override
    public IChunkAccess a(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        GenerationChunkHolder generationchunkholder;
        ChunkStatus chunkstatus1;
        int k2 = this.c.f().e(i2, j2);
        ChunkStatus chunkStatus = chunkstatus1 = k2 >= this.m.b().b() ? null : this.m.b().a(k2);
        if (chunkstatus1 != null) {
            IChunkAccess ichunkaccess;
            generationchunkholder = this.b.a(i2, j2);
            if (chunkstatus.c(chunkstatus1) && (ichunkaccess = generationchunkholder.a(chunkstatus1)) != null) {
                return ichunkaccess;
            }
        } else {
            generationchunkholder = null;
        }
        CrashReport crashreport = CrashReport.a(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk request details");
        crashreportsystemdetails.a("Requested chunk", String.format(Locale.ROOT, "%d, %d", i2, j2));
        crashreportsystemdetails.a("Generating status", () -> this.m.a().f());
        Objects.requireNonNull(chunkstatus);
        crashreportsystemdetails.a("Requested status", chunkstatus::f);
        crashreportsystemdetails.a("Actual status", () -> generationchunkholder == null ? "[out of cache bounds]" : generationchunkholder.q().f());
        crashreportsystemdetails.a("Maximum allowed status", () -> chunkstatus1 == null ? "null" : chunkstatus1.f());
        ChunkDependencies chunkdependencies = this.m.b();
        Objects.requireNonNull(chunkdependencies);
        crashreportsystemdetails.a("Dependencies", chunkdependencies::toString);
        crashreportsystemdetails.a("Requested distance", k2);
        ChunkCoordIntPair chunkcoordintpair = this.c.f();
        Objects.requireNonNull(chunkcoordintpair);
        crashreportsystemdetails.a("Generating chunk", chunkcoordintpair::toString);
        throw new ReportedException(crashreport);
    }

    @Override
    public boolean b(int i2, int j2) {
        int k2 = this.c.f().e(i2, j2);
        return k2 < this.m.b().b();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        return this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w())).a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        return this.A(blockposition).b_(blockposition);
    }

    @Override
    @Nullable
    public EntityHuman a(double d0, double d1, double d2, double d3, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int E_() {
        return 0;
    }

    @Override
    public BiomeManager I_() {
        return this.l;
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.d.a(i2, j2, k2);
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine C_() {
        return this.d.C_();
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.l()) {
            return false;
        }
        return this.a(blockposition, Blocks.a.m(), 3, i2);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        IChunkAccess ichunkaccess = this.A(blockposition);
        TileEntity tileentity = ichunkaccess.c_(blockposition);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunkaccess.f(blockposition);
        IBlockData iblockdata = ichunkaccess.a_(blockposition);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.b("id", ""))) {
                if (!iblockdata.x()) {
                    return null;
                }
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
            } else {
                tileentity = TileEntity.a(blockposition, iblockdata, nbttagcompound, this.d.K_());
            }
            if (tileentity != null) {
                ichunkaccess.a(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.x()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)blockposition);
        }
        return null;
    }

    @Override
    public boolean f_(BlockPosition blockposition) {
        int i2 = SectionPosition.a(blockposition.u());
        int j2 = SectionPosition.a(blockposition.w());
        ChunkCoordIntPair chunkcoordintpair = this.b();
        int k2 = Math.abs(chunkcoordintpair.h - i2);
        int l2 = Math.abs(chunkcoordintpair.i - j2);
        if (k2 <= this.m.d() && l2 <= this.m.d()) {
            LevelHeightAccessor levelheightaccessor;
            return !this.c.A() || !(levelheightaccessor = this.c.B()).e(blockposition.v());
        }
        SystemUtils.b("Detected setBlock in a far chunk [" + i2 + ", " + j2 + "], pos: " + String.valueOf(blockposition) + ", status: " + String.valueOf(this.m.a()) + (String)(this.n == null ? "" : ", currently generating: " + this.n.get()));
        return false;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        if (!this.f_(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.A(blockposition);
        IBlockData iblockdata1 = ichunkaccess.a(blockposition, iblockdata, i2);
        if (iblockdata1 != null) {
            this.d.a(blockposition, iblockdata1, iblockdata);
        }
        if (iblockdata.x()) {
            if (ichunkaccess.n().d() == ChunkType.b) {
                TileEntity tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
                if (tileentity != null) {
                    ichunkaccess.a(tileentity);
                } else {
                    ichunkaccess.d(blockposition);
                }
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.a("x", blockposition.u());
                nbttagcompound.a("y", blockposition.v());
                nbttagcompound.a("z", blockposition.w());
                nbttagcompound.a("id", "DUMMY");
                ichunkaccess.a(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.x()) {
            ichunkaccess.d(blockposition);
        }
        if (iblockdata.l(this, blockposition) && (i2 & 0x10) == 0) {
            this.f(blockposition);
        }
        return true;
    }

    private void f(BlockPosition blockposition) {
        this.A(blockposition).e(blockposition);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i2 = SectionPosition.a(entity.dB());
        int j2 = SectionPosition.a(entity.dH());
        this.a(i2, j2).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        return this.a(blockposition, Blocks.a.m(), 3);
    }

    @Override
    public WorldBorder F_() {
        return this.d.F_();
    }

    @Override
    public boolean B_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer a() {
        return this.d;
    }

    @Override
    public IRegistryCustom K_() {
        return this.d.K_();
    }

    @Override
    public FeatureFlagSet L() {
        return this.d.L();
    }

    @Override
    public WorldData D_() {
        return this.f;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        if (!this.b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.d.an(), this.d.af(), 0L, this.d.as());
    }

    @Override
    @Nullable
    public MinecraftServer q() {
        return this.d.q();
    }

    @Override
    public IChunkProvider T() {
        return this.d.n();
    }

    @Override
    public long F() {
        return this.e;
    }

    @Override
    public LevelTickAccess<Block> V() {
        return this.j;
    }

    @Override
    public LevelTickAccess<FluidType> U() {
        return this.k;
    }

    @Override
    public int Q() {
        return this.d.Q();
    }

    @Override
    public RandomSource H_() {
        return this.h;
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        return this.a(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    @Override
    public void a(@Nullable Entity entity, int i2, BlockPosition blockposition, int j2) {
    }

    @Override
    public void a(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
    }

    @Override
    public DimensionManager G_() {
        return this.i;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> A() {
        return Collections.emptyList();
    }

    @Override
    public int L_() {
        return this.d.L_();
    }

    @Override
    public int M_() {
        return this.d.M_();
    }

    @Override
    public long J_() {
        return this.o.getAndIncrement();
    }
}

