/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final IChatBaseComponent b = IChatBaseComponent.c("disconnect.ignoring_status_request");
    private final MinecraftServer c;
    private final NetworkManager d;

    public HandshakeListener(MinecraftServer minecraftserver, NetworkManager networkmanager) {
        this.c = minecraftserver;
        this.d = networkmanager;
    }

    @Override
    public void a(PacketHandshakingInSetProtocol packethandshakinginsetprotocol) {
        this.d.hostname = packethandshakinginsetprotocol.e() + ":" + packethandshakinginsetprotocol.f();
        switch (packethandshakinginsetprotocol.g()) {
            case b: {
                this.a(packethandshakinginsetprotocol, false);
                break;
            }
            case a: {
                ServerPing serverping = this.c.au();
                this.d.a(StatusProtocols.d);
                if (this.c.am() && serverping != null) {
                    this.d.a(StatusProtocols.b, new PacketStatusListener(serverping, this.d));
                    break;
                }
                this.d.a(b);
                break;
            }
            case c: {
                if (!this.c.bm()) {
                    this.d.a(LoginProtocols.d);
                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.c("multiplayer.disconnect.transfers_disabled");
                    this.d.a(new PacketLoginOutDisconnect(ichatbasecomponent));
                    this.d.a(ichatbasecomponent);
                    break;
                }
                this.a(packethandshakinginsetprotocol, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)packethandshakinginsetprotocol.g()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PacketHandshakingInSetProtocol packethandshakinginsetprotocol, boolean flag) {
        this.d.a(LoginProtocols.d);
        try {
            long currentTime = System.currentTimeMillis();
            long connectionThrottle = this.c.server.getConnectionThrottle();
            InetAddress address = ((InetSocketAddress)this.d.d()).getAddress();
            HashMap<InetAddress, Long> hashMap = throttleTracker;
            synchronized (hashMap) {
                if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                    throttleTracker.put(address, currentTime);
                    IChatMutableComponent chatmessage = IChatBaseComponent.b("Connection throttled! Please wait before reconnecting.");
                    this.d.a(new PacketLoginOutDisconnect(chatmessage));
                    this.d.a(chatmessage);
                    return;
                }
                throttleTracker.put(address, currentTime);
                if (++throttleCounter > 200) {
                    throttleCounter = 0;
                    Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<InetAddress, Long> entry = iter.next();
                        if (entry.getValue() <= connectionThrottle) continue;
                        iter.remove();
                    }
                }
            }
        }
        catch (Throwable t2) {
            LogManager.getLogger().debug("Failed to check connection throttle", t2);
        }
        if (packethandshakinginsetprotocol.b() != SharedConstants.b().d()) {
            IChatMutableComponent ichatbasecomponent = packethandshakinginsetprotocol.b() < SharedConstants.b().d() ? IChatBaseComponent.b(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.b().c())) : IChatBaseComponent.b(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.b().c()));
            this.d.a(new PacketLoginOutDisconnect(ichatbasecomponent));
            this.d.a(ichatbasecomponent);
        } else {
            this.d.a(LoginProtocols.b, new LoginListener(this.c, this.d, flag));
            String[] split = packethandshakinginsetprotocol.e().split("\u0000");
            if (SpigotConfig.bungee) {
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                    IChatMutableComponent chatmessage = IChatBaseComponent.b("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                    this.d.a(new PacketLoginOutDisconnect(chatmessage));
                    this.d.a(chatmessage);
                    return;
                }
                this.d.hostname = split[0];
                this.d.o = new InetSocketAddress(split[1], ((InetSocketAddress)this.d.d()).getPort());
                this.d.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                if (split.length == 4) {
                    this.d.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                }
            } else if ((split.length == 3 || split.length == 4) && HOST_PATTERN.matcher(split[1]).matches()) {
                IChatMutableComponent chatmessage = IChatBaseComponent.b("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.d.a(new PacketLoginOutDisconnect(chatmessage));
                this.d.a(chatmessage);
                return;
            }
        }
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
    }

    @Override
    public boolean c() {
        return this.d.i();
    }
}

