/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudDurationScaleFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudPotionFix;
import net.minecraft.util.datafix.fixes.AttributeIdPrefixFix;
import net.minecraft.util.datafix.fixes.AttributeModifierIdFix;
import net.minecraft.util.datafix.fixes.BannerEntityCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.BeehiveFieldRenameFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockEntityFurnaceBurnTimeFix;
import net.minecraft.util.datafix.fixes.BlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.BlockPosFormatAndRenamesFix;
import net.minecraft.util.datafix.fixes.BlockPropertyRenameAndFix;
import net.minecraft.util.datafix.fixes.BoatSplitFix;
import net.minecraft.util.datafix.fixes.CarvingStepRemoveFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChestedHorsesInventoryZeroIndexingFix;
import net.minecraft.util.datafix.fixes.ChunkConverterPalette;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteLightFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkTicketUnpackPosFix;
import net.minecraft.util.datafix.fixes.ContainerBlockEntityLockPredicateFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.CustomModelDataExpandFix;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterAdvancement;
import net.minecraft.util.datafix.fixes.DataConverterAdvancementBase;
import net.minecraft.util.datafix.fixes.DataConverterArmorStand;
import net.minecraft.util.datafix.fixes.DataConverterAttributes;
import net.minecraft.util.datafix.fixes.DataConverterBanner;
import net.minecraft.util.datafix.fixes.DataConverterBannerColour;
import net.minecraft.util.datafix.fixes.DataConverterBedBlock;
import net.minecraft.util.datafix.fixes.DataConverterBedItem;
import net.minecraft.util.datafix.fixes.DataConverterBiome;
import net.minecraft.util.datafix.fixes.DataConverterBitStorageAlign;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterBlockName;
import net.minecraft.util.datafix.fixes.DataConverterBlockRename;
import net.minecraft.util.datafix.fixes.DataConverterCatType;
import net.minecraft.util.datafix.fixes.DataConverterChunkLightRemove;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus2;
import net.minecraft.util.datafix.fixes.DataConverterChunkStructuresTemplateRename;
import net.minecraft.util.datafix.fixes.DataConverterColorlessShulkerEntity;
import net.minecraft.util.datafix.fixes.DataConverterCoral;
import net.minecraft.util.datafix.fixes.DataConverterCoralFan;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameEntity;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameItem;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameTile;
import net.minecraft.util.datafix.fixes.DataConverterDropChances;
import net.minecraft.util.datafix.fixes.DataConverterDye;
import net.minecraft.util.datafix.fixes.DataConverterEntity;
import net.minecraft.util.datafix.fixes.DataConverterEntityBlockState;
import net.minecraft.util.datafix.fixes.DataConverterEntityCatSplit;
import net.minecraft.util.datafix.fixes.DataConverterEntityCodSalmon;
import net.minecraft.util.datafix.fixes.DataConverterEntityProjectileOwner;
import net.minecraft.util.datafix.fixes.DataConverterEntityPufferfish;
import net.minecraft.util.datafix.fixes.DataConverterEntityRavagerRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityShulkerRotation;
import net.minecraft.util.datafix.fixes.DataConverterEntityTippedArrow;
import net.minecraft.util.datafix.fixes.DataConverterEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterEntityZombifiedPiglinRename;
import net.minecraft.util.datafix.fixes.DataConverterEquipment;
import net.minecraft.util.datafix.fixes.DataConverterFlatten;
import net.minecraft.util.datafix.fixes.DataConverterFlattenSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterFlattenState;
import net.minecraft.util.datafix.fixes.DataConverterFurnaceRecipesUsed;
import net.minecraft.util.datafix.fixes.DataConverterGossip;
import net.minecraft.util.datafix.fixes.DataConverterGuardian;
import net.minecraft.util.datafix.fixes.DataConverterHanging;
import net.minecraft.util.datafix.fixes.DataConverterHealth;
import net.minecraft.util.datafix.fixes.DataConverterHeightmapRenaming;
import net.minecraft.util.datafix.fixes.DataConverterHorse;
import net.minecraft.util.datafix.fixes.DataConverterIglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.DataConverterItemFrame;
import net.minecraft.util.datafix.fixes.DataConverterItemLoreComponentize;
import net.minecraft.util.datafix.fixes.DataConverterItemName;
import net.minecraft.util.datafix.fixes.DataConverterItemStackEnchantment;
import net.minecraft.util.datafix.fixes.DataConverterItemStackUUID;
import net.minecraft.util.datafix.fixes.DataConverterJigsawProperties;
import net.minecraft.util.datafix.fixes.DataConverterJigsawRotation;
import net.minecraft.util.datafix.fixes.DataConverterJukeBox;
import net.minecraft.util.datafix.fixes.DataConverterKeybind;
import net.minecraft.util.datafix.fixes.DataConverterKeybind2;
import net.minecraft.util.datafix.fixes.DataConverterLang;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterLeavesBiome;
import net.minecraft.util.datafix.fixes.DataConverterLevelDataGeneratorOptions;
import net.minecraft.util.datafix.fixes.DataConverterMap;
import net.minecraft.util.datafix.fixes.DataConverterMapId;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterMemoryExpiry;
import net.minecraft.util.datafix.fixes.DataConverterMinecart;
import net.minecraft.util.datafix.fixes.DataConverterMiscUUID;
import net.minecraft.util.datafix.fixes.DataConverterMissingDimension;
import net.minecraft.util.datafix.fixes.DataConverterMobSpawner;
import net.minecraft.util.datafix.fixes.DataConverterNewVillage;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveRenderType;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerBlockEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerRename;
import net.minecraft.util.datafix.fixes.DataConverterOptionsAddTextBackground;
import net.minecraft.util.datafix.fixes.DataConverterPOI;
import net.minecraft.util.datafix.fixes.DataConverterPOIRebuild;
import net.minecraft.util.datafix.fixes.DataConverterPainting;
import net.minecraft.util.datafix.fixes.DataConverterPiston;
import net.minecraft.util.datafix.fixes.DataConverterPlayerUUID;
import net.minecraft.util.datafix.fixes.DataConverterPotionId;
import net.minecraft.util.datafix.fixes.DataConverterPotionWater;
import net.minecraft.util.datafix.fixes.DataConverterProtoChunk;
import net.minecraft.util.datafix.fixes.DataConverterRecipeRename;
import net.minecraft.util.datafix.fixes.DataConverterRecipes;
import net.minecraft.util.datafix.fixes.DataConverterRedstoneConnections;
import net.minecraft.util.datafix.fixes.DataConverterRemoveGolemGossip;
import net.minecraft.util.datafix.fixes.DataConverterRiding;
import net.minecraft.util.datafix.fixes.DataConverterSaddle;
import net.minecraft.util.datafix.fixes.DataConverterSavedDataUUID;
import net.minecraft.util.datafix.fixes.DataConverterSettingRename;
import net.minecraft.util.datafix.fixes.DataConverterShoulderEntity;
import net.minecraft.util.datafix.fixes.DataConverterShulker;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxBlock;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxItem;
import net.minecraft.util.datafix.fixes.DataConverterSkeleton;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterStatistic;
import net.minecraft.util.datafix.fixes.DataConverterStriderGravity;
import net.minecraft.util.datafix.fixes.DataConverterStructureReference;
import net.minecraft.util.datafix.fixes.DataConverterTileEntity;
import net.minecraft.util.datafix.fixes.DataConverterTrappedChest;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUID;
import net.minecraft.util.datafix.fixes.DataConverterVBO;
import net.minecraft.util.datafix.fixes.DataConverterVillagerFollowRange;
import net.minecraft.util.datafix.fixes.DataConverterVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DataConverterVillagerProfession;
import net.minecraft.util.datafix.fixes.DataConverterVillagerTrade;
import net.minecraft.util.datafix.fixes.DataConverterWallProperty;
import net.minecraft.util.datafix.fixes.DataConverterWolf;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettings;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.fixes.DataConverterZombie;
import net.minecraft.util.datafix.fixes.DataConverterZombieType;
import net.minecraft.util.datafix.fixes.DataConverterZombieVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DecoratedPotFieldRenameFix;
import net.minecraft.util.datafix.fixes.DropChancesFormatFix;
import net.minecraft.util.datafix.fixes.DropInvalidSignDataFix;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EmptyItemInHotbarFix;
import net.minecraft.util.datafix.fixes.EmptyItemInVillagerTradeFix;
import net.minecraft.util.datafix.fixes.EntityAttributeBaseValueFix;
import net.minecraft.util.datafix.fixes.EntityBrushableBlockFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityFallDistanceFloatToDoubleFix;
import net.minecraft.util.datafix.fixes.EntityFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntitySalmonSizeFix;
import net.minecraft.util.datafix.fixes.EntitySpawnerItemVariantComponentFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.EquipmentFormatFix;
import net.minecraft.util.datafix.fixes.EquippableAssetRenameFix;
import net.minecraft.util.datafix.fixes.FeatureFlagRemoveFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.FireResistantToDamageResistantComponentFix;
import net.minecraft.util.datafix.fixes.FixProjectileStoredItem;
import net.minecraft.util.datafix.fixes.FixWolfHealth;
import net.minecraft.util.datafix.fixes.FoodToConsumableFix;
import net.minecraft.util.datafix.fixes.ForcedChunkToTicketFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.HorseBodyArmorItemFix;
import net.minecraft.util.datafix.fixes.InlineBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.InvalidBlockEntityLockFix;
import net.minecraft.util.datafix.fixes.InvalidLockComponentFix;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.ItemStackCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.JukeboxTicksSinceSongStartedFix;
import net.minecraft.util.datafix.fixes.LegacyDimensionIdFix;
import net.minecraft.util.datafix.fixes.LegacyDragonFightFix;
import net.minecraft.util.datafix.fixes.LegacyHoverEventFix;
import net.minecraft.util.datafix.fixes.LevelLegacyWorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.LockComponentPredicateFix;
import net.minecraft.util.datafix.fixes.LodestoneCompassComponentFix;
import net.minecraft.util.datafix.fixes.MapBannerBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.MobEffectIdFix;
import net.minecraft.util.datafix.fixes.NamedEntityConvertUncheckedFix;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRarityFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsMenuBlurrinessFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.ParticleUnflatteningFix;
import net.minecraft.util.datafix.fixes.PlayerEquipmentFix;
import net.minecraft.util.datafix.fixes.PlayerHeadBlockProfileFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.PrimedTntBlockStateFixer;
import net.minecraft.util.datafix.fixes.ProjectileStoredWeaponFix;
import net.minecraft.util.datafix.fixes.RaidRenamesDataFix;
import net.minecraft.util.datafix.fixes.RandomSequenceSettingsFix;
import net.minecraft.util.datafix.fixes.RemapChunkStatusFix;
import net.minecraft.util.datafix.fixes.RemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.RemoveEmptyItemInBrushableBlockFix;
import net.minecraft.util.datafix.fixes.RenameEnchantmentsFix;
import net.minecraft.util.datafix.fixes.SaddleEquipmentSlotFix;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplayNameFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplaySlotFix;
import net.minecraft.util.datafix.fixes.SignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TextComponentHoverAndClickEventFix;
import net.minecraft.util.datafix.fixes.TextComponentStringifiedFlagsFix;
import net.minecraft.util.datafix.fixes.ThrownPotionSplitFix;
import net.minecraft.util.datafix.fixes.TippedArrowPotionToItemFix;
import net.minecraft.util.datafix.fixes.TooltipDisplayComponentFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix;
import net.minecraft.util.datafix.fixes.UnflattenTextComponentFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.VillagerSetCanPickUpLootFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV102;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1022;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV106;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV107;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1125;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV135;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV143;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_1;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_2;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_3;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_4;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_5;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_6;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1460;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1466;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1470;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1481;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1483;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1486;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1510;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1800;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1801;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1904;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1906;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1909;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1920;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1928;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1929;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1931;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2502;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2505;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2509;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2519;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2522;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2551;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2568;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV700;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV701;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV702;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV703;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV704;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV705;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV808;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;
import net.minecraft.util.datafix.schemas.V1458;
import net.minecraft.util.datafix.schemas.V1488;
import net.minecraft.util.datafix.schemas.V2511_1;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;
import net.minecraft.util.datafix.schemas.V3438;
import net.minecraft.util.datafix.schemas.V3439;
import net.minecraft.util.datafix.schemas.V3439_1;
import net.minecraft.util.datafix.schemas.V3448;
import net.minecraft.util.datafix.schemas.V3682;
import net.minecraft.util.datafix.schemas.V3683;
import net.minecraft.util.datafix.schemas.V3685;
import net.minecraft.util.datafix.schemas.V3689;
import net.minecraft.util.datafix.schemas.V3799;
import net.minecraft.util.datafix.schemas.V3807;
import net.minecraft.util.datafix.schemas.V3808;
import net.minecraft.util.datafix.schemas.V3808_1;
import net.minecraft.util.datafix.schemas.V3808_2;
import net.minecraft.util.datafix.schemas.V3813;
import net.minecraft.util.datafix.schemas.V3816;
import net.minecraft.util.datafix.schemas.V3818;
import net.minecraft.util.datafix.schemas.V3818_3;
import net.minecraft.util.datafix.schemas.V3818_4;
import net.minecraft.util.datafix.schemas.V3818_5;
import net.minecraft.util.datafix.schemas.V3825;
import net.minecraft.util.datafix.schemas.V3938;
import net.minecraft.util.datafix.schemas.V4059;
import net.minecraft.util.datafix.schemas.V4067;
import net.minecraft.util.datafix.schemas.V4070;
import net.minecraft.util.datafix.schemas.V4071;
import net.minecraft.util.datafix.schemas.V4290;
import net.minecraft.util.datafix.schemas.V4292;
import net.minecraft.util.datafix.schemas.V4300;
import net.minecraft.util.datafix.schemas.V4301;
import net.minecraft.util.datafix.schemas.V4302;
import net.minecraft.util.datafix.schemas.V4306;
import net.minecraft.util.datafix.schemas.V4307;
import net.minecraft.util.datafix.schemas.V4312;
import net.minecraft.util.datafix.schemas.V4420;
import net.minecraft.util.datafix.schemas.V4421;

public class DataConverterRegistry {
    private static final BiFunction<Integer, Schema, Schema> b = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> c = DataConverterSchemaNamed::new;
    private static final DataFixerBuilder.Result d = DataConverterRegistry.b();
    public static final int a = 4295;

    private DataConverterRegistry() {
    }

    public static DataFixer a() {
        return d.fixer();
    }

    private static DataFixerBuilder.Result b() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.b().a().b());
        DataConverterRegistry.a(datafixerbuilder);
        return datafixerbuilder.build();
    }

    public static CompletableFuture<?> a(Set<DSL.TypeReference> set) {
        if (set.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return d.optimize(set, (Executor)executor);
    }

    /*
     * WARNING - void declaration
     */
    private static void a(DataFixerBuilder datafixerbuilder) {
        void schema268;
        void schema267;
        void schema266;
        void schema265;
        void schema264;
        void schema263;
        void schema262;
        void schema261;
        void schema260;
        void schema259;
        void schema258;
        void schema257;
        void schema256;
        void schema255;
        void schema254;
        void schema253;
        void schema252;
        void schema251;
        void schema250;
        void schema249;
        void schema248;
        void schema247;
        void schema246;
        void schema245;
        void schema244;
        datafixerbuilder.addSchema(99, DataConverterSchemaV99::new);
        Schema schema = datafixerbuilder.addSchema(100, DataConverterSchemaV100::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEquipment(schema));
        Schema schema1 = datafixerbuilder.addSchema(101, b);
        datafixerbuilder.addFixer((DataFix)new VillagerSetCanPickUpLootFix(schema1));
        Schema schema2 = datafixerbuilder.addSchema(102, DataConverterSchemaV102::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterMaterialId(schema2, true));
        datafixerbuilder.addFixer((DataFix)new DataConverterPotionId(schema2, false));
        Schema schema3 = datafixerbuilder.addSchema(105, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterSpawnEgg(schema3, true));
        Schema schema4 = datafixerbuilder.addSchema(106, DataConverterSchemaV106::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterMobSpawner(schema4, true));
        Schema schema5 = datafixerbuilder.addSchema(107, DataConverterSchemaV107::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterMinecart(schema5));
        Schema schema6 = datafixerbuilder.addSchema(108, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterUUID(schema6, true));
        Schema schema7 = datafixerbuilder.addSchema(109, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterHealth(schema7, true));
        Schema schema8 = datafixerbuilder.addSchema(110, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterSaddle(schema8, true));
        Schema schema9 = datafixerbuilder.addSchema(111, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterHanging(schema9, true));
        Schema schema10 = datafixerbuilder.addSchema(113, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterDropChances(schema10, true));
        Schema schema11 = datafixerbuilder.addSchema(135, DataConverterSchemaV135::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterRiding(schema11, true));
        Schema schema12 = datafixerbuilder.addSchema(143, DataConverterSchemaV143::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityTippedArrow(schema12, true));
        Schema schema13 = datafixerbuilder.addSchema(147, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterArmorStand(schema13, true));
        Schema schema14 = datafixerbuilder.addSchema(165, b);
        datafixerbuilder.addFixer((DataFix)new SignTextStrictJsonFix(schema14));
        datafixerbuilder.addFixer((DataFix)new WrittenBookPagesStrictJsonFix(schema14));
        Schema schema15 = datafixerbuilder.addSchema(501, DataConverterSchemaV501::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema15, "Add 1.10 entities fix", DataConverterTypes.E));
        Schema schema16 = datafixerbuilder.addSchema(502, b);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema16, "cooked_fished item renamer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : s2));
        datafixerbuilder.addFixer((DataFix)new DataConverterZombie(schema16, false));
        Schema schema17 = datafixerbuilder.addSchema(505, b);
        datafixerbuilder.addFixer((DataFix)new DataConverterVBO(schema17, false));
        Schema schema18 = datafixerbuilder.addSchema(700, DataConverterSchemaV700::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterGuardian(schema18, true));
        Schema schema19 = datafixerbuilder.addSchema(701, DataConverterSchemaV701::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterSkeleton(schema19, true));
        Schema schema20 = datafixerbuilder.addSchema(702, DataConverterSchemaV702::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterZombieType(schema20));
        Schema schema21 = datafixerbuilder.addSchema(703, DataConverterSchemaV703::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterHorse(schema21, true));
        Schema schema22 = datafixerbuilder.addSchema(704, DataConverterSchemaV704::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterTileEntity(schema22, true));
        Schema schema23 = datafixerbuilder.addSchema(705, DataConverterSchemaV705::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntity(schema23, true));
        Schema schema24 = datafixerbuilder.addSchema(804, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterBanner(schema24, true));
        Schema schema25 = datafixerbuilder.addSchema(806, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterPotionWater(schema25, false));
        Schema schema26 = datafixerbuilder.addSchema(808, DataConverterSchemaV808::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema26, "added shulker box", DataConverterTypes.t));
        Schema schema27 = datafixerbuilder.addSchema(808, 1, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterShulker(schema27, false));
        Schema schema28 = datafixerbuilder.addSchema(813, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterShulkerBoxItem(schema28, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterShulkerBoxBlock(schema28, false));
        Schema schema29 = datafixerbuilder.addSchema(816, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterLang(schema29, false));
        Schema schema30 = datafixerbuilder.addSchema(820, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema30, "totem item renamer", DataConverterRegistry.a("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema31 = datafixerbuilder.addSchema(1022, DataConverterSchemaV1022::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterShoulderEntity(schema31, "added shoulder entities to players", DataConverterTypes.c));
        Schema schema32 = datafixerbuilder.addSchema(1125, DataConverterSchemaV1125::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterBedBlock(schema32, true));
        datafixerbuilder.addFixer((DataFix)new DataConverterBedItem(schema32, false));
        Schema schema33 = datafixerbuilder.addSchema(1344, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterKeybind(schema33, false));
        Schema schema34 = datafixerbuilder.addSchema(1446, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterKeybind2(schema34, false));
        Schema schema35 = datafixerbuilder.addSchema(1450, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterFlattenState(schema35, false));
        Schema schema36 = datafixerbuilder.addSchema(1451, DataConverterSchemaV1451::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema36, "AddTrappedChestFix", DataConverterTypes.t));
        Schema schema37 = datafixerbuilder.addSchema(1451, 1, DataConverterSchemaV1451_1::new);
        datafixerbuilder.addFixer((DataFix)new ChunkConverterPalette(schema37, true));
        Schema schema38 = datafixerbuilder.addSchema(1451, 2, DataConverterSchemaV1451_2::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterPiston(schema38, true));
        Schema schema39 = datafixerbuilder.addSchema(1451, 3, DataConverterSchemaV1451_3::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityBlockState(schema39, true));
        datafixerbuilder.addFixer((DataFix)new DataConverterMap(schema39, false));
        Schema schema40 = datafixerbuilder.addSchema(1451, 4, DataConverterSchemaV1451_4::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterBlockName(schema40, true));
        datafixerbuilder.addFixer((DataFix)new DataConverterFlatten(schema40, false));
        Schema schema41 = datafixerbuilder.addSchema(1451, 5, DataConverterSchemaV1451_5::new);
        datafixerbuilder.addFixer((DataFix)new RemoveBlockEntityTagFix(schema41, Set.of("minecraft:noteblock", "minecraft:flower_pot")));
        datafixerbuilder.addFixer((DataFix)new DataConverterFlattenSpawnEgg(schema41, false, "minecraft:spawn_egg"));
        datafixerbuilder.addFixer((DataFix)new DataConverterWolf(schema41, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterBannerColour(schema41, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterWorldGenSettings(schema41, false));
        Schema schema42 = datafixerbuilder.addSchema(1451, 6, DataConverterSchemaV1451_6::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterStatistic(schema42, true));
        datafixerbuilder.addFixer((DataFix)new DataConverterJukeBox(schema42, false));
        Schema schema43 = datafixerbuilder.addSchema(1451, 7, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterVillagerTrade(schema43));
        Schema schema44 = datafixerbuilder.addSchema(1456, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterItemFrame(schema44, false));
        Schema schema45 = datafixerbuilder.addSchema(1458, V1458::new);
        datafixerbuilder.addFixer(new DataFix(schema45, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(DataConverterTypes.c), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
                    String s2 = dynamic.get("CustomName").asString("");
                    return s2.isEmpty() ? dynamic.remove("CustomName") : dynamic.set("CustomName", LegacyComponentDataFixUtils.a(dynamic.getOps(), s2));
                }));
            }
        });
        datafixerbuilder.addFixer((DataFix)new DataConverterCustomNameEntity(schema45));
        datafixerbuilder.addFixer((DataFix)new DataConverterCustomNameItem(schema45));
        datafixerbuilder.addFixer((DataFix)new DataConverterCustomNameTile(schema45));
        Schema schema46 = datafixerbuilder.addSchema(1460, DataConverterSchemaV1460::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterPainting(schema46, false));
        Schema schema47 = datafixerbuilder.addSchema(1466, DataConverterSchemaV1466::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema47, "Add DUMMY block entity", DataConverterTypes.t));
        datafixerbuilder.addFixer((DataFix)new DataConverterProtoChunk(schema47, true));
        Schema schema48 = datafixerbuilder.addSchema(1470, DataConverterSchemaV1470::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema48, "Add 1.13 entities fix", DataConverterTypes.E));
        Schema schema49 = datafixerbuilder.addSchema(1474, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterColorlessShulkerEntity(schema49, false));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema49, "Colorless shulker block fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema49, "Colorless shulker item fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        Schema schema50 = datafixerbuilder.addSchema(1475, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema50, "Flowing fixer", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema51 = datafixerbuilder.addSchema(1480, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema51, "Rename coral blocks", DataConverterRegistry.b(DataConverterCoral.a)));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema51, "Rename coral items", DataConverterRegistry.b(DataConverterCoral.a)));
        Schema schema52 = datafixerbuilder.addSchema(1481, DataConverterSchemaV1481::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema52, "Add conduit", DataConverterTypes.t));
        Schema schema53 = datafixerbuilder.addSchema(1483, DataConverterSchemaV1483::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityPufferfish(schema53, true));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema53, "Rename pufferfish egg item", DataConverterRegistry.b(DataConverterEntityPufferfish.a)));
        Schema schema54 = datafixerbuilder.addSchema(1484, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema54, "Rename seagrass items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema54, "Rename seagrass blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        datafixerbuilder.addFixer((DataFix)new DataConverterHeightmapRenaming(schema54, false));
        Schema schema55 = datafixerbuilder.addSchema(1486, DataConverterSchemaV1486::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityCodSalmon(schema55, true));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema55, "Rename cod/salmon egg items", DataConverterRegistry.b(DataConverterEntityCodSalmon.b)));
        Schema schema56 = datafixerbuilder.addSchema(1487, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema56, "Rename prismarine_brick(s)_* blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema56, "Rename prismarine_brick(s)_* items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema57 = datafixerbuilder.addSchema(1488, V1488::new);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema57, "Rename kelp/kelptop", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema57, "Rename kelptop", DataConverterRegistry.a("minecraft:kelp_top", "minecraft:kelp")));
        datafixerbuilder.addFixer((DataFix)new NamedEntityWriteReadFix(schema57, true, "Command block block entity custom name fix", DataConverterTypes.t, "minecraft:command_block"){

            @Override
            protected <T> Dynamic<T> a(Dynamic<T> dynamic) {
                return DataConverterCustomNameTile.a(dynamic);
            }
        });
        datafixerbuilder.addFixer(new DataFix(schema57, false){

            protected TypeRewriteRule makeRule() {
                Type type = this.getInputSchema().getType(DataConverterTypes.E);
                OpticFinder opticfinder = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
                OpticFinder opticfinder1 = type.findField("CustomName");
                OpticFinder opticfinder2 = DSL.typeFinder((Type)this.getInputSchema().getType(DataConverterTypes.A));
                return this.fixTypeEverywhereTyped("Command block minecart custom name fix", type, typed -> {
                    String s2 = typed.getOptional(opticfinder).orElse("");
                    return !"minecraft:commandblock_minecart".equals(s2) ? typed : typed.updateTyped(opticfinder1, typed1 -> typed1.update(opticfinder2, pair -> pair.mapSecond(LegacyComponentDataFixUtils::a)));
                });
            }
        });
        datafixerbuilder.addFixer((DataFix)new DataConverterIglooMetadataRemoval(schema57, false));
        Schema schema58 = datafixerbuilder.addSchema(1490, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema58, "Rename melon_block", DataConverterRegistry.a("minecraft:melon_block", "minecraft:melon")));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema58, "Rename melon_block/melon/speckled_melon", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema59 = datafixerbuilder.addSchema(1492, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterChunkStructuresTemplateRename(schema59, false));
        Schema schema60 = datafixerbuilder.addSchema(1494, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterItemStackEnchantment(schema60, false));
        Schema schema61 = datafixerbuilder.addSchema(1496, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterLeaves(schema61, false));
        Schema schema62 = datafixerbuilder.addSchema(1500, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterBlockEntityKeepPacked(schema62, false));
        Schema schema63 = datafixerbuilder.addSchema(1501, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterAdvancement(schema63, false));
        Schema schema64 = datafixerbuilder.addSchema(1502, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema64, "Recipes fix", DataConverterTypes.M, DataConverterRegistry.b(DataConverterRecipes.a)));
        Schema schema65 = datafixerbuilder.addSchema(1506, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterLevelDataGeneratorOptions(schema65, false));
        Schema schema66 = datafixerbuilder.addSchema(1510, DataConverterSchemaV1510::new);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema66, "Block renamening fix", DataConverterRegistry.b(DataConverterEntityRename.b)));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema66, "Item renamening fix", DataConverterRegistry.b(DataConverterEntityRename.c)));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema66, "Recipes renamening fix", DataConverterTypes.M, DataConverterRegistry.b(DataConverterRecipeRename.a)));
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityRename(schema66, true));
        datafixerbuilder.addFixer((DataFix)new StatsRenameFix(schema66, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema67 = datafixerbuilder.addSchema(1514, c);
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplayNameFix(schema67, "ObjectiveDisplayNameFix", DataConverterTypes.K));
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplayNameFix(schema67, "TeamDisplayNameFix", DataConverterTypes.L));
        datafixerbuilder.addFixer((DataFix)new DataConverterObjectiveRenderType(schema67));
        Schema schema68 = datafixerbuilder.addSchema(1515, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema68, "Rename coral fan blocks", DataConverterRegistry.b(DataConverterCoralFan.a)));
        Schema schema69 = datafixerbuilder.addSchema(1624, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterTrappedChest(schema69, false));
        Schema schema70 = datafixerbuilder.addSchema(1800, DataConverterSchemaV1800::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema70, "Added 1.14 mobs fix", DataConverterTypes.E));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema70, "Rename dye items", DataConverterRegistry.b(DataConverterDye.a)));
        Schema schema71 = datafixerbuilder.addSchema(1801, DataConverterSchemaV1801::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema71, "Added Illager Beast", DataConverterTypes.E));
        Schema schema72 = datafixerbuilder.addSchema(1802, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema72, "Rename sign blocks & stone slabs", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema72, "Rename sign item & stone slabs", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema73 = datafixerbuilder.addSchema(1803, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterItemLoreComponentize(schema73));
        Schema schema74 = datafixerbuilder.addSchema(1904, DataConverterSchemaV1904::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema74, "Added Cats", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityCatSplit(schema74, false));
        Schema schema75 = datafixerbuilder.addSchema(1905, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterChunkStatus(schema75, false));
        Schema schema76 = datafixerbuilder.addSchema(1906, DataConverterSchemaV1906::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema76, "Add POI Blocks", DataConverterTypes.t));
        Schema schema77 = datafixerbuilder.addSchema(1909, DataConverterSchemaV1909::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema77, "Add jigsaw", DataConverterTypes.t));
        Schema schema78 = datafixerbuilder.addSchema(1911, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterChunkStatus2(schema78, false));
        Schema schema79 = datafixerbuilder.addSchema(1914, c);
        datafixerbuilder.addFixer((DataFix)new WeaponSmithChestLootTableFix(schema79, false));
        Schema schema80 = datafixerbuilder.addSchema(1917, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterCatType(schema80, false));
        Schema schema81 = datafixerbuilder.addSchema(1918, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterVillagerProfession(schema81, "minecraft:villager"));
        datafixerbuilder.addFixer((DataFix)new DataConverterVillagerProfession(schema81, "minecraft:zombie_villager"));
        Schema schema82 = datafixerbuilder.addSchema(1920, DataConverterSchemaV1920::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterNewVillage(schema82, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema82, "Add campfire", DataConverterTypes.t));
        Schema schema83 = datafixerbuilder.addSchema(1925, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterMapId(schema83));
        Schema schema84 = datafixerbuilder.addSchema(1928, DataConverterSchemaV1928::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityRavagerRename(schema84, true));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema84, "Rename ravager egg item", DataConverterRegistry.b(DataConverterEntityRavagerRename.a)));
        Schema schema85 = datafixerbuilder.addSchema(1929, DataConverterSchemaV1929::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema85, "Add Wandering Trader and Trader Llama", DataConverterTypes.E));
        Schema schema86 = datafixerbuilder.addSchema(1931, DataConverterSchemaV1931::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema86, "Added Fox", DataConverterTypes.E));
        Schema schema87 = datafixerbuilder.addSchema(1936, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterOptionsAddTextBackground(schema87, false));
        Schema schema88 = datafixerbuilder.addSchema(1946, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterPOI(schema88, false));
        Schema schema89 = datafixerbuilder.addSchema(1948, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterOminousBannerRename(schema89));
        Schema schema90 = datafixerbuilder.addSchema(1953, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterOminousBannerBlockEntityRename(schema90, false));
        Schema schema91 = datafixerbuilder.addSchema(1955, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterVillagerLevelXp(schema91, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterZombieVillagerLevelXp(schema91, false));
        Schema schema92 = datafixerbuilder.addSchema(1961, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterChunkLightRemove(schema92, false));
        Schema schema93 = datafixerbuilder.addSchema(1963, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterRemoveGolemGossip(schema93, false));
        Schema schema94 = datafixerbuilder.addSchema(2100, DataConverterSchemaV2100::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema94, "Added Bee and Bee Stinger", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema94, "Add beehive", DataConverterTypes.t));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema94, "Rename sugar recipe", DataConverterTypes.M, DataConverterRegistry.a("minecraft:sugar", "minecraft:sugar_from_sugar_cane")));
        datafixerbuilder.addFixer((DataFix)new DataConverterAdvancementBase(schema94, false, "Rename sugar recipe advancement", DataConverterRegistry.a("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema95 = datafixerbuilder.addSchema(2202, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterLeavesBiome(schema95, false));
        Schema schema96 = datafixerbuilder.addSchema(2209, c);
        UnaryOperator<String> unaryoperator = DataConverterRegistry.a("minecraft:bee_hive", "minecraft:beehive");
        datafixerbuilder.addFixer(DataConverterItemName.a(schema96, "Rename bee_hive item to beehive", unaryoperator));
        datafixerbuilder.addFixer((DataFix)new PoiTypeRenameFix(schema96, "Rename bee_hive poi to beehive", unaryoperator));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema96, "Rename bee_hive block to beehive", unaryoperator));
        Schema schema97 = datafixerbuilder.addSchema(2211, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterStructureReference(schema97, false));
        Schema schema98 = datafixerbuilder.addSchema(2218, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterPOIRebuild(schema98, false));
        Schema schema99 = datafixerbuilder.addSchema(2501, DataConverterSchemaV2501::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterFurnaceRecipesUsed(schema99, true));
        Schema schema100 = datafixerbuilder.addSchema(2502, DataConverterSchemaV2502::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema100, "Added Hoglin", DataConverterTypes.E));
        Schema schema101 = datafixerbuilder.addSchema(2503, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterWallProperty(schema101, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterAdvancementBase(schema101, false, "Composter category change", DataConverterRegistry.a("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema102 = datafixerbuilder.addSchema(2505, DataConverterSchemaV2505::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema102, "Added Piglin", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterMemoryExpiry(schema102, "minecraft:villager"));
        Schema schema103 = datafixerbuilder.addSchema(2508, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema103, "Renamed fungi items to fungus", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema103, "Renamed fungi blocks to fungus", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema104 = datafixerbuilder.addSchema(2509, DataConverterSchemaV2509::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityZombifiedPiglinRename(schema104));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema104, "Rename zombie pigman egg item", DataConverterRegistry.b(DataConverterEntityZombifiedPiglinRename.a)));
        Schema schema105 = datafixerbuilder.addSchema(2511, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityProjectileOwner(schema105));
        Schema schema106 = datafixerbuilder.addSchema(2511, 1, V2511_1::new);
        datafixerbuilder.addFixer((DataFix)new NamedEntityConvertUncheckedFix(schema106, "SplashPotionItemFieldRenameFix", DataConverterTypes.E, "minecraft:potion"));
        Schema schema107 = datafixerbuilder.addSchema(2514, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityUUID(schema107));
        datafixerbuilder.addFixer((DataFix)new DataConverterBlockEntityUUID(schema107));
        datafixerbuilder.addFixer((DataFix)new DataConverterPlayerUUID(schema107));
        datafixerbuilder.addFixer((DataFix)new DataConverterMiscUUID(schema107));
        datafixerbuilder.addFixer((DataFix)new DataConverterSavedDataUUID(schema107));
        datafixerbuilder.addFixer((DataFix)new DataConverterItemStackUUID(schema107));
        Schema schema108 = datafixerbuilder.addSchema(2516, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterGossip(schema108, "minecraft:villager"));
        datafixerbuilder.addFixer((DataFix)new DataConverterGossip(schema108, "minecraft:zombie_villager"));
        Schema schema109 = datafixerbuilder.addSchema(2518, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterJigsawProperties(schema109, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterJigsawRotation(schema109));
        Schema schema110 = datafixerbuilder.addSchema(2519, DataConverterSchemaV2519::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema110, "Added Strider", DataConverterTypes.E));
        Schema schema111 = datafixerbuilder.addSchema(2522, DataConverterSchemaV2522::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema111, "Added Zoglin", DataConverterTypes.E));
        Schema schema112 = datafixerbuilder.addSchema(2523, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterAttributes(schema112, "Attribute renames", DataConverterRegistry.a((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"minecraft:generic.max_health").put((Object)"Max Health", (Object)"minecraft:generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"minecraft:horse.jump_strength").put((Object)"Jump Strength", (Object)"minecraft:horse.jump_strength").put((Object)"generic.followRange", (Object)"minecraft:generic.follow_range").put((Object)"Follow Range", (Object)"minecraft:generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"minecraft:generic.movement_speed").put((Object)"Movement Speed", (Object)"minecraft:generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"minecraft:generic.flying_speed").put((Object)"Flying Speed", (Object)"minecraft:generic.flying_speed").put((Object)"generic.attackDamage", (Object)"minecraft:generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"minecraft:generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"minecraft:generic.attack_speed").put((Object)"generic.armorToughness", (Object)"minecraft:generic.armor_toughness").build())));
        Schema schema113 = datafixerbuilder.addSchema(2527, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterBitStorageAlign(schema113));
        Schema schema114 = datafixerbuilder.addSchema(2528, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema115 = datafixerbuilder.addSchema(2529, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterStriderGravity(schema115, false));
        Schema schema116 = datafixerbuilder.addSchema(2531, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterRedstoneConnections(schema116));
        Schema schema117 = datafixerbuilder.addSchema(2533, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterVillagerFollowRange(schema117));
        Schema schema118 = datafixerbuilder.addSchema(2535, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterEntityShulkerRotation(schema118));
        Schema schema119 = datafixerbuilder.addSchema(2537, c);
        datafixerbuilder.addFixer((DataFix)new LegacyDimensionIdFix(schema119));
        Schema schema120 = datafixerbuilder.addSchema(2538, c);
        datafixerbuilder.addFixer((DataFix)new LevelLegacyWorldGenSettingsFix(schema120));
        Schema schema121 = datafixerbuilder.addSchema(2550, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterWorldGenSettingsBuilding(schema121));
        Schema schema122 = datafixerbuilder.addSchema(2551, DataConverterSchemaV2551::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterShoulderEntity(schema122, "add types to WorldGenData", DataConverterTypes.P));
        Schema schema123 = datafixerbuilder.addSchema(2552, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema123, "Nether biome rename", DataConverterTypes.N, DataConverterRegistry.a("minecraft:nether", "minecraft:nether_wastes")));
        Schema schema124 = datafixerbuilder.addSchema(2553, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema124, "Biomes fix", DataConverterTypes.N, DataConverterRegistry.b(DataConverterBiome.a)));
        Schema schema125 = datafixerbuilder.addSchema(2558, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterMissingDimension(schema125, false));
        datafixerbuilder.addFixer((DataFix)new DataConverterSettingRename(schema125, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema126 = datafixerbuilder.addSchema(2568, DataConverterSchemaV2568::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema126, "Added Piglin Brute", DataConverterTypes.E));
        Schema schema127 = datafixerbuilder.addSchema(2571, V2571::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema127, "Added Goat", DataConverterTypes.E));
        Schema schema128 = datafixerbuilder.addSchema(2679, c);
        datafixerbuilder.addFixer((DataFix)new CauldronRenameFix(schema128, false));
        Schema schema129 = datafixerbuilder.addSchema(2680, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema129, "Renamed grass path item to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema129, "Renamed grass path block to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema130 = datafixerbuilder.addSchema(2684, V2684::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema130, "Added Sculk Sensor", DataConverterTypes.t));
        Schema schema131 = datafixerbuilder.addSchema(2686, V2686::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema131, "Added Axolotl", DataConverterTypes.E));
        Schema schema132 = datafixerbuilder.addSchema(2688, V2688::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema132, "Added Glow Squid", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema132, "Added Glow Item Frame", DataConverterTypes.E));
        Schema schema133 = datafixerbuilder.addSchema(2690, c);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        datafixerbuilder.addFixer(DataConverterItemName.a(schema133, "Renamed copper block items to new oxidized terms", DataConverterRegistry.b((Map<String, String>)immutablemap)));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema133, "Renamed copper blocks to new oxidized terms", DataConverterRegistry.b((Map<String, String>)immutablemap)));
        Schema schema134 = datafixerbuilder.addSchema(2691, c);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        datafixerbuilder.addFixer(DataConverterItemName.a(schema134, "Rename copper item suffixes", DataConverterRegistry.b((Map<String, String>)immutablemap1)));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema134, "Rename copper blocks suffixes", DataConverterRegistry.b((Map<String, String>)immutablemap1)));
        Schema schema135 = datafixerbuilder.addSchema(2693, c);
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema135, DataConverterTypes.P, "has_increased_height_already", false));
        Schema schema136 = datafixerbuilder.addSchema(2696, c);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        datafixerbuilder.addFixer(DataConverterItemName.a(schema136, "Renamed grimstone block items to deepslate", DataConverterRegistry.b((Map<String, String>)immutablemap2)));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema136, "Renamed grimstone blocks to deepslate", DataConverterRegistry.b((Map<String, String>)immutablemap2)));
        Schema schema137 = datafixerbuilder.addSchema(2700, c);
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema137, "Renamed cave vines blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema138 = datafixerbuilder.addSchema(2701, c);
        datafixerbuilder.addFixer((DataFix)new SavedDataFeaturePoolElementFix(schema138));
        Schema schema139 = datafixerbuilder.addSchema(2702, c);
        datafixerbuilder.addFixer((DataFix)new AbstractArrowPickupFix(schema139));
        Schema schema140 = datafixerbuilder.addSchema(2704, V2704::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema140, "Added Goat", DataConverterTypes.E));
        Schema schema141 = datafixerbuilder.addSchema(2707, V2707::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema141, "Added Marker", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema141, DataConverterTypes.P, "has_increased_height_already", true));
        Schema schema142 = datafixerbuilder.addSchema(2710, c);
        datafixerbuilder.addFixer((DataFix)new StatsRenameFix(schema142, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema143 = datafixerbuilder.addSchema(2717, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema143, "Rename azalea_leaves_flowers", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema143, "Rename azalea_leaves_flowers items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema144 = datafixerbuilder.addSchema(2825, c);
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema144, DataConverterTypes.P, "has_increased_height_already", false));
        Schema schema145 = datafixerbuilder.addSchema(2831, V2831::new);
        datafixerbuilder.addFixer((DataFix)new SpawnerDataFix(schema145));
        Schema schema146 = datafixerbuilder.addSchema(2832, V2832::new);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix(schema146));
        datafixerbuilder.addFixer((DataFix)new ChunkHeightAndBiomeFix(schema146));
        Schema schema147 = datafixerbuilder.addSchema(2833, c);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema147));
        Schema schema148 = datafixerbuilder.addSchema(2838, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema148, "Caves and Cliffs biome renames", DataConverterTypes.N, DataConverterRegistry.b(CavesAndCliffsRenames.a)));
        Schema schema149 = datafixerbuilder.addSchema(2841, c);
        datafixerbuilder.addFixer((DataFix)new ChunkProtoTickListFix(schema149));
        Schema schema150 = datafixerbuilder.addSchema(2842, V2842::new);
        datafixerbuilder.addFixer((DataFix)new ChunkRenamesFix(schema150));
        Schema schema151 = datafixerbuilder.addSchema(2843, c);
        datafixerbuilder.addFixer((DataFix)new OverreachingTickFix(schema151));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema151, "Remove Deep Warm Ocean", DataConverterTypes.N, DataConverterRegistry.a("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema152 = datafixerbuilder.addSchema(2846, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterAdvancementBase(schema152, false, "Rename some C&C part 2 advancements", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema153 = datafixerbuilder.addSchema(2852, c);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema153));
        Schema schema154 = datafixerbuilder.addSchema(2967, c);
        datafixerbuilder.addFixer((DataFix)new StructureSettingsFlattenFix(schema154));
        Schema schema155 = datafixerbuilder.addSchema(2970, c);
        datafixerbuilder.addFixer((DataFix)new StructuresBecomeConfiguredFix(schema155));
        Schema schema156 = datafixerbuilder.addSchema(3076, V3076::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema156, "Added Sculk Catalyst", DataConverterTypes.t));
        Schema schema157 = datafixerbuilder.addSchema(3077, c);
        datafixerbuilder.addFixer((DataFix)new ChunkDeleteIgnoredLightDataFix(schema157));
        Schema schema158 = datafixerbuilder.addSchema(3078, V3078::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema158, "Added Frog", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema158, "Added Tadpole", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema158, "Added Sculk Shrieker", DataConverterTypes.t));
        Schema schema159 = datafixerbuilder.addSchema(3081, V3081::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema159, "Added Warden", DataConverterTypes.E));
        Schema schema160 = datafixerbuilder.addSchema(3082, V3082::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema160, "Added Chest Boat", DataConverterTypes.E));
        Schema schema161 = datafixerbuilder.addSchema(3083, V3083::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema161, "Added Allay", DataConverterTypes.E));
        Schema schema162 = datafixerbuilder.addSchema(3084, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema162, "game_event_renames_3084", DataConverterTypes.H, DataConverterRegistry.b((Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build())));
        Schema schema163 = datafixerbuilder.addSchema(3086, c);
        DSL.TypeReference typereference = DataConverterTypes.E;
        Int2ObjectOpenHashMap int2objectopenhashmap = SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T int2objectopenhashmap1) -> {
            int2objectopenhashmap1.defaultReturnValue((Object)"minecraft:tabby");
            int2objectopenhashmap1.put(0, (Object)"minecraft:tabby");
            int2objectopenhashmap1.put(1, (Object)"minecraft:black");
            int2objectopenhashmap1.put(2, (Object)"minecraft:red");
            int2objectopenhashmap1.put(3, (Object)"minecraft:siamese");
            int2objectopenhashmap1.put(4, (Object)"minecraft:british");
            int2objectopenhashmap1.put(5, (Object)"minecraft:calico");
            int2objectopenhashmap1.put(6, (Object)"minecraft:persian");
            int2objectopenhashmap1.put(7, (Object)"minecraft:ragdoll");
            int2objectopenhashmap1.put(8, (Object)"minecraft:white");
            int2objectopenhashmap1.put(9, (Object)"minecraft:jellie");
            int2objectopenhashmap1.put(10, (Object)"minecraft:all_black");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        datafixerbuilder.addFixer((DataFix)new EntityVariantFix(schema163, "Change cat variant type", typereference, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        ImmutableMap immutablemap3 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        datafixerbuilder.addFixer((DataFix)new CriteriaRenameFix(schema163, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", s2 -> (String)immutablemap3.getOrDefault(s2, s2)));
        Schema schema164 = datafixerbuilder.addSchema(3087, c);
        typereference = DataConverterTypes.E;
        int2objectopenhashmap = SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T int2objectopenhashmap1) -> {
            int2objectopenhashmap1.put(0, (Object)"minecraft:temperate");
            int2objectopenhashmap1.put(1, (Object)"minecraft:warm");
            int2objectopenhashmap1.put(2, (Object)"minecraft:cold");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        datafixerbuilder.addFixer((DataFix)new EntityVariantFix(schema164, "Change frog variant type", typereference, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        Schema schema165 = datafixerbuilder.addSchema(3090, c);
        datafixerbuilder.addFixer((DataFix)new EntityFieldsRenameFix(schema165, "EntityPaintingFieldsRenameFix", "minecraft:painting", Map.of("Motive", "variant", "Facing", "facing")));
        Schema schema166 = datafixerbuilder.addSchema(3093, c);
        datafixerbuilder.addFixer((DataFix)new EntityGoatMissingStateFix(schema166));
        Schema schema167 = datafixerbuilder.addSchema(3094, c);
        datafixerbuilder.addFixer((DataFix)new GoatHornIdFix(schema167));
        Schema schema168 = datafixerbuilder.addSchema(3097, c);
        datafixerbuilder.addFixer((DataFix)new FilteredBooksFix(schema168));
        datafixerbuilder.addFixer((DataFix)new FilteredSignsFix(schema168));
        Map<String, String> map = Map.of("minecraft:british", "minecraft:british_shorthair");
        datafixerbuilder.addFixer((DataFix)new VariantRenameFix(schema168, "Rename british shorthair", DataConverterTypes.E, "minecraft:cat", map));
        datafixerbuilder.addFixer((DataFix)new CriteriaRenameFix(schema168, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", s2 -> map.getOrDefault(s2, (String)s2)));
        Set<String> set = Set.of("minecraft:unemployed", "minecraft:nitwit");
        Objects.requireNonNull(set);
        datafixerbuilder.addFixer((DataFix)new PoiTypeRemoveFix(schema168, "Remove unpopulated villager PoI types", set::contains));
        Schema schema169 = datafixerbuilder.addSchema(3108, c);
        datafixerbuilder.addFixer((DataFix)new BlendingDataRemoveFromNetherEndFix(schema169));
        Schema schema170 = datafixerbuilder.addSchema(3201, c);
        datafixerbuilder.addFixer((DataFix)new OptionsProgrammerArtFix(schema170));
        Schema schema171 = datafixerbuilder.addSchema(3202, V3202::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema171, "Added Hanging Sign", DataConverterTypes.t));
        Schema schema172 = datafixerbuilder.addSchema(3203, V3203::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema172, "Added Camel", DataConverterTypes.E));
        Schema schema173 = datafixerbuilder.addSchema(3204, V3204::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema173, "Added Chiseled Bookshelf", DataConverterTypes.t));
        Schema schema174 = datafixerbuilder.addSchema(3209, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterFlattenSpawnEgg(schema174, false, "minecraft:pig_spawn_egg"));
        Schema schema175 = datafixerbuilder.addSchema(3214, c);
        datafixerbuilder.addFixer((DataFix)new OptionsAmbientOcclusionFix(schema175));
        Schema schema176 = datafixerbuilder.addSchema(3319, c);
        datafixerbuilder.addFixer((DataFix)new OptionsAccessibilityOnboardFix(schema176));
        Schema schema177 = datafixerbuilder.addSchema(3322, c);
        datafixerbuilder.addFixer((DataFix)new EffectDurationFix(schema177));
        Schema schema178 = datafixerbuilder.addSchema(3325, V3325::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema178, "Added displays", DataConverterTypes.E));
        Schema schema179 = datafixerbuilder.addSchema(3326, V3326::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema179, "Added Sniffer", DataConverterTypes.E));
        Schema schema180 = datafixerbuilder.addSchema(3327, V3327::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema180, "Archaeology", DataConverterTypes.t));
        Schema schema181 = datafixerbuilder.addSchema(3328, V3328::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema181, "Added interaction", DataConverterTypes.E));
        Schema schema182 = datafixerbuilder.addSchema(3438, V3438::new);
        datafixerbuilder.addFixer(BlockEntityRenameFix.a(schema182, "Rename Suspicious Sand to Brushable Block", DataConverterRegistry.a("minecraft:suspicious_sand", "minecraft:brushable_block")));
        datafixerbuilder.addFixer((DataFix)new EntityBrushableBlockFieldsRenameFix(schema182));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema182, "Pottery shard renaming", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:pottery_shard_archer", (Object)"minecraft:archer_pottery_shard", (Object)"minecraft:pottery_shard_prize", (Object)"minecraft:prize_pottery_shard", (Object)"minecraft:pottery_shard_arms_up", (Object)"minecraft:arms_up_pottery_shard", (Object)"minecraft:pottery_shard_skull", (Object)"minecraft:skull_pottery_shard"))));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema182, "Added calibrated sculk sensor", DataConverterTypes.t));
        Schema schema183 = datafixerbuilder.addSchema(3439, V3439::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(schema183, "Updated sign text format for Signs", "minecraft:sign"));
        Schema schema184 = datafixerbuilder.addSchema(3439, 1, V3439_1::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(schema184, "Updated sign text format for Hanging Signs", "minecraft:hanging_sign"));
        Schema schema185 = datafixerbuilder.addSchema(3440, c);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema185, "Replace experimental 1.20 overworld", DataConverterTypes.O, DataConverterRegistry.a("minecraft:overworld_update_1_20", "minecraft:overworld")));
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema185, "Remove 1.20 feature toggle", Set.of("minecraft:update_1_20")));
        Schema schema186 = datafixerbuilder.addSchema(3447, c);
        datafixerbuilder.addFixer(DataConverterItemName.a(schema186, "Pottery shard item renaming to Pottery sherd", DataConverterRegistry.b(Stream.of("minecraft:angler_pottery_shard", "minecraft:archer_pottery_shard", "minecraft:arms_up_pottery_shard", "minecraft:blade_pottery_shard", "minecraft:brewer_pottery_shard", "minecraft:burn_pottery_shard", "minecraft:danger_pottery_shard", "minecraft:explorer_pottery_shard", "minecraft:friend_pottery_shard", "minecraft:heart_pottery_shard", "minecraft:heartbreak_pottery_shard", "minecraft:howl_pottery_shard", "minecraft:miner_pottery_shard", "minecraft:mourner_pottery_shard", "minecraft:plenty_pottery_shard", "minecraft:prize_pottery_shard", "minecraft:sheaf_pottery_shard", "minecraft:shelter_pottery_shard", "minecraft:skull_pottery_shard", "minecraft:snort_pottery_shard").collect(Collectors.toMap(Function.identity(), s2 -> s2.replace("_pottery_shard", "_pottery_sherd"))))));
        Schema schema187 = datafixerbuilder.addSchema(3448, V3448::new);
        datafixerbuilder.addFixer((DataFix)new DecoratedPotFieldRenameFix(schema187));
        Schema schema188 = datafixerbuilder.addSchema(3450, c);
        datafixerbuilder.addFixer((DataFix)new RemapChunkStatusFix(schema188, "Remove liquid_carvers and heightmap chunk statuses", DataConverterRegistry.b(Map.of("minecraft:liquid_carvers", "minecraft:carvers", "minecraft:heightmaps", "minecraft:spawn"))));
        Schema schema189 = datafixerbuilder.addSchema(3451, c);
        datafixerbuilder.addFixer((DataFix)new ChunkDeleteLightFix(schema189));
        Schema schema190 = datafixerbuilder.addSchema(3459, c);
        datafixerbuilder.addFixer((DataFix)new LegacyDragonFightFix(schema190));
        Schema schema191 = datafixerbuilder.addSchema(3564, c);
        datafixerbuilder.addFixer((DataFix)new DropInvalidSignDataFix(schema191, "minecraft:sign"));
        Schema schema192 = datafixerbuilder.addSchema(3564, 1, c);
        datafixerbuilder.addFixer((DataFix)new DropInvalidSignDataFix(schema192, "minecraft:hanging_sign"));
        Schema schema193 = datafixerbuilder.addSchema(3565, c);
        datafixerbuilder.addFixer((DataFix)new RandomSequenceSettingsFix(schema193));
        Schema schema194 = datafixerbuilder.addSchema(3566, c);
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplaySlotFix(schema194));
        Schema schema195 = datafixerbuilder.addSchema(3568, c);
        datafixerbuilder.addFixer((DataFix)new MobEffectIdFix(schema195));
        Schema schema196 = datafixerbuilder.addSchema(3682, V3682::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema196, "Added Crafter", DataConverterTypes.t));
        Schema schema197 = datafixerbuilder.addSchema(3683, V3683::new);
        datafixerbuilder.addFixer((DataFix)new PrimedTntBlockStateFixer(schema197));
        Schema schema198 = datafixerbuilder.addSchema(3685, V3685::new);
        datafixerbuilder.addFixer((DataFix)new FixProjectileStoredItem(schema198));
        Schema schema199 = datafixerbuilder.addSchema(3689, V3689::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema199, "Added Breeze", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema199, "Added Trial Spawner", DataConverterTypes.t));
        Schema schema200 = datafixerbuilder.addSchema(3692, c);
        UnaryOperator<String> unaryoperator1 = DataConverterRegistry.b(Map.of("minecraft:grass", "minecraft:short_grass"));
        datafixerbuilder.addFixer(DataConverterBlockRename.a(schema200, "Rename grass block to short_grass", unaryoperator1));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema200, "Rename grass item to short_grass", unaryoperator1));
        Schema schema201 = datafixerbuilder.addSchema(3799, V3799::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema201, "Added Armadillo", DataConverterTypes.E));
        Schema schema202 = datafixerbuilder.addSchema(3800, c);
        UnaryOperator<String> unaryoperator2 = DataConverterRegistry.b(Map.of("minecraft:scute", "minecraft:turtle_scute"));
        datafixerbuilder.addFixer(DataConverterItemName.a(schema202, "Rename scute item to turtle_scute", unaryoperator2));
        Schema schema203 = datafixerbuilder.addSchema(3803, c);
        datafixerbuilder.addFixer((DataFix)new RenameEnchantmentsFix(schema203, "Rename sweeping enchant to sweeping_edge", Map.of("minecraft:sweeping", "minecraft:sweeping_edge")));
        Schema schema204 = datafixerbuilder.addSchema(3807, V3807::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema204, "Added Vault", DataConverterTypes.t));
        Schema schema205 = datafixerbuilder.addSchema(3807, 1, c);
        datafixerbuilder.addFixer((DataFix)new MapBannerBlockPosFormatFix(schema205));
        Schema schema206 = datafixerbuilder.addSchema(3808, V3808::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema206, "minecraft:horse", "ArmorItem", true));
        Schema schema207 = datafixerbuilder.addSchema(3808, 1, V3808_1::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema207, "minecraft:llama", "DecorItem", false));
        Schema schema208 = datafixerbuilder.addSchema(3808, 2, V3808_2::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema208, "minecraft:trader_llama", "DecorItem", false));
        Schema schema209 = datafixerbuilder.addSchema(3809, c);
        datafixerbuilder.addFixer((DataFix)new ChestedHorsesInventoryZeroIndexingFix(schema209));
        Schema schema210 = datafixerbuilder.addSchema(3812, c);
        datafixerbuilder.addFixer((DataFix)new FixWolfHealth(schema210));
        Schema schema211 = datafixerbuilder.addSchema(3813, V3813::new);
        datafixerbuilder.addFixer((DataFix)new BlockPosFormatAndRenamesFix(schema211));
        Schema schema212 = datafixerbuilder.addSchema(3814, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterAttributes(schema212, "Rename jump strength attribute", DataConverterRegistry.a("minecraft:horse.jump_strength", "minecraft:generic.jump_strength")));
        Schema schema213 = datafixerbuilder.addSchema(3816, V3816::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema213, "Added Bogged", DataConverterTypes.E));
        Schema schema214 = datafixerbuilder.addSchema(3818, V3818::new);
        datafixerbuilder.addFixer((DataFix)new BeehiveFieldRenameFix(schema214));
        datafixerbuilder.addFixer((DataFix)new EmptyItemInHotbarFix(schema214));
        Schema schema215 = datafixerbuilder.addSchema(3818, 1, c);
        datafixerbuilder.addFixer((DataFix)new BannerPatternFormatFix(schema215));
        Schema schema216 = datafixerbuilder.addSchema(3818, 2, c);
        datafixerbuilder.addFixer((DataFix)new TippedArrowPotionToItemFix(schema216));
        Schema schema217 = datafixerbuilder.addSchema(3818, 3, V3818_3::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterShoulderEntity(schema217, "Inject data component types", DataConverterTypes.x));
        Schema schema218 = datafixerbuilder.addSchema(3818, 4, V3818_4::new);
        datafixerbuilder.addFixer((DataFix)new ParticleUnflatteningFix(schema218));
        Schema schema219 = datafixerbuilder.addSchema(3818, 5, V3818_5::new);
        datafixerbuilder.addFixer((DataFix)new ItemStackComponentizationFix(schema219));
        Schema schema220 = datafixerbuilder.addSchema(3818, 6, c);
        datafixerbuilder.addFixer((DataFix)new AreaEffectCloudPotionFix(schema220));
        Schema schema221 = datafixerbuilder.addSchema(3820, c);
        datafixerbuilder.addFixer((DataFix)new PlayerHeadBlockProfileFix(schema221));
        datafixerbuilder.addFixer((DataFix)new LodestoneCompassComponentFix(schema221));
        Schema schema222 = datafixerbuilder.addSchema(3825, V3825::new);
        datafixerbuilder.addFixer((DataFix)new ItemStackCustomNameToOverrideComponentFix(schema222));
        datafixerbuilder.addFixer((DataFix)new BannerEntityCustomNameToOverrideComponentFix(schema222));
        datafixerbuilder.addFixer((DataFix)new TrialSpawnerConfigFix(schema222));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema222, "Added Ominous Item Spawner", DataConverterTypes.E));
        Schema schema223 = datafixerbuilder.addSchema(3828, c);
        datafixerbuilder.addFixer((DataFix)new EmptyItemInVillagerTradeFix(schema223));
        Schema schema224 = datafixerbuilder.addSchema(3833, c);
        datafixerbuilder.addFixer((DataFix)new RemoveEmptyItemInBrushableBlockFix(schema224));
        Schema schema225 = datafixerbuilder.addSchema(3938, V3938::new);
        datafixerbuilder.addFixer((DataFix)new ProjectileStoredWeaponFix(schema225));
        Schema schema226 = datafixerbuilder.addSchema(3939, c);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema226, "Remove 1.21 feature toggle", Set.of("minecraft:update_1_21")));
        Schema schema227 = datafixerbuilder.addSchema(3943, c);
        datafixerbuilder.addFixer((DataFix)new OptionsMenuBlurrinessFix(schema227));
        Schema schema228 = datafixerbuilder.addSchema(3945, c);
        datafixerbuilder.addFixer((DataFix)new AttributeModifierIdFix(schema228));
        datafixerbuilder.addFixer((DataFix)new JukeboxTicksSinceSongStartedFix(schema228));
        Schema schema229 = datafixerbuilder.addSchema(4054, c);
        datafixerbuilder.addFixer((DataFix)new OminousBannerRarityFix(schema229));
        Schema schema230 = datafixerbuilder.addSchema(4055, c);
        datafixerbuilder.addFixer((DataFix)new AttributeIdPrefixFix(schema230));
        Schema schema231 = datafixerbuilder.addSchema(4057, c);
        datafixerbuilder.addFixer((DataFix)new CarvingStepRemoveFix(schema231));
        Schema schema232 = datafixerbuilder.addSchema(4059, V4059::new);
        datafixerbuilder.addFixer((DataFix)new FoodToConsumableFix(schema232));
        Schema schema233 = datafixerbuilder.addSchema(4061, c);
        datafixerbuilder.addFixer((DataFix)new TrialSpawnerConfigInRegistryFix(schema233));
        Schema schema234 = datafixerbuilder.addSchema(4064, c);
        datafixerbuilder.addFixer((DataFix)new FireResistantToDamageResistantComponentFix(schema234));
        Schema schema235 = datafixerbuilder.addSchema(4067, V4067::new);
        datafixerbuilder.addFixer((DataFix)new BoatSplitFix(schema235));
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema235, "Remove Bundle experimental feature flag", Set.of("minecraft:bundle")));
        Schema schema236 = datafixerbuilder.addSchema(4068, c);
        datafixerbuilder.addFixer((DataFix)new LockComponentPredicateFix(schema236));
        datafixerbuilder.addFixer((DataFix)new ContainerBlockEntityLockPredicateFix(schema236));
        Schema schema237 = datafixerbuilder.addSchema(4070, V4070::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema237, "Added Pale Oak Boat and Pale Oak Chest Boat", DataConverterTypes.E));
        Schema schema238 = datafixerbuilder.addSchema(4071, V4071::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema238, "Added Creaking", DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices(schema238, "Added Creaking Heart", DataConverterTypes.t));
        Schema schema239 = datafixerbuilder.addSchema(4081, c);
        datafixerbuilder.addFixer((DataFix)new EntitySalmonSizeFix(schema239));
        Schema schema240 = datafixerbuilder.addSchema(4173, c);
        datafixerbuilder.addFixer((DataFix)new EntityFieldsRenameFix(schema240, "Rename TNT Minecart fuse", "minecraft:tnt_minecart", Map.of("TNTFuse", "fuse")));
        Schema schema241 = datafixerbuilder.addSchema(4175, c);
        datafixerbuilder.addFixer((DataFix)new EquippableAssetRenameFix(schema241));
        datafixerbuilder.addFixer((DataFix)new CustomModelDataExpandFix(schema241));
        Schema schema242 = datafixerbuilder.addSchema(4176, c);
        datafixerbuilder.addFixer((DataFix)new InvalidBlockEntityLockFix(schema242));
        datafixerbuilder.addFixer((DataFix)new InvalidLockComponentFix(schema242));
        Schema schema243 = datafixerbuilder.addSchema(4180, c);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema243, "Remove Winter Drop toggle", Set.of("minecraft:winter_drop")));
        Schema schema269 = datafixerbuilder.addSchema(4181, c);
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema244, "minecraft:furnace"));
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema244, "minecraft:smoker"));
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema244, "minecraft:blast_furnace"));
        Schema schema270 = datafixerbuilder.addSchema(4187, c);
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Villager follow range fix undo", "minecraft:villager", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Bee follow range fix", "minecraft:bee", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Allay follow range fix", "minecraft:allay", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Llama follow range fix", "minecraft:llama", "minecraft:follow_range", d0 -> d0 == 40.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Piglin Brute follow range fix", "minecraft:piglin_brute", "minecraft:follow_range", d0 -> d0 == 16.0 ? 12.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema245, "Warden follow range fix", "minecraft:warden", "minecraft:follow_range", d0 -> d0 == 16.0 ? 24.0 : d0));
        Schema schema271 = datafixerbuilder.addSchema(4290, V4290::new);
        datafixerbuilder.addFixer((DataFix)new UnflattenTextComponentFix((Schema)schema246));
        Schema schema272 = datafixerbuilder.addSchema(4291, c);
        datafixerbuilder.addFixer((DataFix)new LegacyHoverEventFix((Schema)schema247));
        datafixerbuilder.addFixer((DataFix)new TextComponentStringifiedFlagsFix((Schema)schema247));
        Schema schema273 = datafixerbuilder.addSchema(4292, V4292::new);
        datafixerbuilder.addFixer((DataFix)new TextComponentHoverAndClickEventFix((Schema)schema248));
        Schema schema274 = datafixerbuilder.addSchema(4293, c);
        datafixerbuilder.addFixer((DataFix)new DropChancesFormatFix((Schema)schema249));
        Schema schema275 = datafixerbuilder.addSchema(4294, c);
        datafixerbuilder.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)schema250, "CreakingHeartBlockStateFix", "minecraft:creaking_heart", "active", "creaking_heart_state", s2 -> s2.equals("true") ? "awake" : "uprooted"));
        Schema schema276 = datafixerbuilder.addSchema(4295, c);
        datafixerbuilder.addFixer((DataFix)new BlendingDataFix((Schema)schema251));
        Schema schema277 = datafixerbuilder.addSchema(4296, c);
        datafixerbuilder.addFixer((DataFix)new AreaEffectCloudDurationScaleFix((Schema)schema252));
        Schema schema278 = datafixerbuilder.addSchema(4297, c);
        datafixerbuilder.addFixer((DataFix)new ForcedChunkToTicketFix((Schema)schema253));
        Schema schema279 = datafixerbuilder.addSchema(4299, c);
        datafixerbuilder.addFixer((DataFix)new EntitySpawnerItemVariantComponentFix((Schema)schema254));
        Schema schema280 = datafixerbuilder.addSchema(4300, V4300::new);
        datafixerbuilder.addFixer((DataFix)new SaddleEquipmentSlotFix((Schema)schema255));
        Schema schema281 = datafixerbuilder.addSchema(4301, V4301::new);
        datafixerbuilder.addFixer((DataFix)new EquipmentFormatFix((Schema)schema256));
        Schema schema282 = datafixerbuilder.addSchema(4302, V4302::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices((Schema)schema257, "Added Test and Test Instance Block Entities", DataConverterTypes.t));
        Schema schema283 = datafixerbuilder.addSchema(4303, c);
        datafixerbuilder.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)schema258, DataConverterTypes.E));
        datafixerbuilder.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)schema258, DataConverterTypes.c));
        Schema schema284 = datafixerbuilder.addSchema(4305, c);
        datafixerbuilder.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)schema259, "rename test block mode", "minecraft:test_block", "test_block_mode", "mode", s2 -> s2));
        Schema schema285 = datafixerbuilder.addSchema(4306, V4306::new);
        datafixerbuilder.addFixer((DataFix)new ThrownPotionSplitFix((Schema)schema260));
        Schema schema286 = datafixerbuilder.addSchema(4307, V4307::new);
        datafixerbuilder.addFixer((DataFix)new TooltipDisplayComponentFix((Schema)schema261));
        Schema schema287 = datafixerbuilder.addSchema(4309, c);
        datafixerbuilder.addFixer((DataFix)new RaidRenamesDataFix((Schema)schema262));
        datafixerbuilder.addFixer((DataFix)new ChunkTicketUnpackPosFix((Schema)schema262));
        Schema schema288 = datafixerbuilder.addSchema(4311, c);
        datafixerbuilder.addFixer((DataFix)new DataConverterAdvancementBase((Schema)schema263, false, "Use lodestone category change", DataConverterRegistry.a("minecraft:nether/use_lodestone", "minecraft:adventure/use_lodestone")));
        Schema schema289 = datafixerbuilder.addSchema(4312, V4312::new);
        datafixerbuilder.addFixer((DataFix)new PlayerEquipmentFix((Schema)schema264));
        Schema schema290 = datafixerbuilder.addSchema(4314, c);
        datafixerbuilder.addFixer((DataFix)new InlineBlockPosFormatFix((Schema)schema265));
        Schema schema291 = datafixerbuilder.addSchema(4420, V4420::new);
        datafixerbuilder.addFixer((DataFix)new NamedEntityConvertUncheckedFix((Schema)schema266, "AreaEffectCloudCustomParticleFix", DataConverterTypes.E, "minecraft:area_effect_cloud"));
        Schema schema292 = datafixerbuilder.addSchema(4421, V4421::new);
        datafixerbuilder.addFixer((DataFix)new DataConverterAddChoices((Schema)schema267, "Added Happy Ghast", DataConverterTypes.E));
        Schema schema293 = datafixerbuilder.addSchema(4424, c);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix((Schema)schema268, "Remove Locator Bar experimental feature flag", Set.of("minecraft:locator_bar")));
    }

    private static UnaryOperator<String> a(Map<String, String> map) {
        return s2 -> map.getOrDefault(s2, (String)s2);
    }

    private static UnaryOperator<String> b(Map<String, String> map) {
        return s2 -> map.getOrDefault(DataConverterSchemaNamed.a(s2), (String)s2);
    }

    private static UnaryOperator<String> a(String s2, String s1) {
        return s22 -> Objects.equals(DataConverterSchemaNamed.a(s22), s2) ? s1 : s22;
    }
}

