/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 8;
    private static final int e = 16;
    private static final int f = 32;
    private static final int g = 64;
    private static final int h = 128;
    private static final Set<String> i = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> j = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> k = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> l = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter m = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema var0) {
        super(var0, true);
    }

    private static void a(a var02, Dynamic<?> var12) {
        Object var4;
        Object var3;
        int var22 = var02.a("HideFlags").asInt(0);
        var02.a("Damage", "minecraft:damage", var12.createInt(0));
        var02.a("RepairCost", "minecraft:repair_cost", var12.createInt(0));
        var02.a("CustomModelData", "minecraft:custom_model_data");
        var02.a("BlockStateTag").result().ifPresent(var1 -> var02.a("minecraft:block_state", ItemStackComponentizationFix.b(var1)));
        var02.a("EntityTag", "minecraft:entity_data");
        var02.a("BlockEntityTag", false, var1 -> {
            String var2 = DataConverterSchemaNamed.a(var1.get("id").asString(""));
            Dynamic var3 = (var1 = ItemStackComponentizationFix.a(var02, var1, var2)).remove("id");
            if (var3.equals((Object)var1.emptyMap())) {
                return var3;
            }
            return var1;
        });
        var02.a("BlockEntityTag", "minecraft:block_entity_data");
        if (var02.a("Unbreakable").asBoolean(false)) {
            var3 = var12.emptyMap();
            if ((var22 & 4) != 0) {
                var3 = var3.set("show_in_tooltip", var12.createBoolean(false));
            }
            var02.a("minecraft:unbreakable", (Dynamic<?>)var3);
        }
        ItemStackComponentizationFix.a(var02, var12, "Enchantments", "minecraft:enchantments", (var22 & 1) != 0);
        if (var02.b("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.a(var02, var12, "StoredEnchantments", "minecraft:stored_enchantments", (var22 & 0x20) != 0);
        }
        var02.a("display", false, var2 -> ItemStackComponentizationFix.a(var02, var2, var22));
        ItemStackComponentizationFix.b(var02, var12, var22);
        ItemStackComponentizationFix.c(var02, var12, var22);
        var3 = var02.a("Trim").result();
        if (((Optional)var3).isPresent()) {
            var4 = (Dynamic)((Optional)var3).get();
            if ((var22 & 0x80) != 0) {
                var4 = var4.set("show_in_tooltip", var4.createBoolean(false));
            }
            var02.a("minecraft:trim", (Dynamic<?>)var4);
        }
        if ((var22 & 0x20) != 0) {
            var02.a("minecraft:hide_additional_tooltip", var12.emptyMap());
        }
        if (var02.b("minecraft:crossbow")) {
            var02.a("Charged");
            var02.a("ChargedProjectiles", "minecraft:charged_projectiles", var12.createList(Stream.empty()));
        }
        if (var02.b("minecraft:bundle")) {
            var02.a("Items", "minecraft:bundle_contents", var12.createList(Stream.empty()));
        }
        if (var02.b("minecraft:filled_map")) {
            var02.a("map", "minecraft:map_id");
            var4 = var02.a("Decorations").asStream().map(ItemStackComponentizationFix::e).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (var0, var1) -> var0));
            if (!var4.isEmpty()) {
                var02.a("minecraft:map_decorations", var12.createMap((Map)var4));
            }
        }
        if (var02.a(i)) {
            ItemStackComponentizationFix.b(var02, var12);
        }
        if (var02.b("minecraft:writable_book")) {
            ItemStackComponentizationFix.c(var02, var12);
        }
        if (var02.b("minecraft:written_book")) {
            ItemStackComponentizationFix.d(var02, var12);
        }
        if (var02.b("minecraft:suspicious_stew")) {
            var02.a("effects", "minecraft:suspicious_stew_effects");
        }
        if (var02.b("minecraft:debug_stick")) {
            var02.a("DebugProperty", "minecraft:debug_stick_state");
        }
        if (var02.a(j)) {
            ItemStackComponentizationFix.f(var02, var12);
        }
        if (var02.b("minecraft:goat_horn")) {
            var02.a("instrument", "minecraft:instrument");
        }
        if (var02.b("minecraft:knowledge_book")) {
            var02.a("Recipes", "minecraft:recipes");
        }
        if (var02.b("minecraft:compass")) {
            ItemStackComponentizationFix.g(var02, var12);
        }
        if (var02.b("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.b(var02);
        }
        if (var02.b("minecraft:firework_star")) {
            ItemStackComponentizationFix.a(var02);
        }
        if (var02.b("minecraft:player_head")) {
            var02.a("SkullOwner").result().ifPresent(var1 -> var02.a("minecraft:profile", ItemStackComponentizationFix.a(var1)));
        }
    }

    private static Dynamic<?> b(Dynamic<?> var0) {
        return (Dynamic)DataFixUtils.orElse(var0.asMapOpt().result().map(var02 -> var02.collect(Collectors.toMap(Pair::getFirst, var0 -> {
            Optional var3;
            String var1 = ((Dynamic)var0.getFirst()).asString("");
            Dynamic var2 = (Dynamic)var0.getSecond();
            if (l.contains(var1) && (var3 = var2.asBoolean().result()).isPresent()) {
                return var2.createString(String.valueOf(var3.get()));
            }
            var3 = var2.asNumber().result();
            if (var3.isPresent()) {
                return var2.createString(((Number)var3.get()).toString());
            }
            return var2;
        }))).map(arg_0 -> var0.createMap(arg_0)), var0);
    }

    private static Dynamic<?> a(a var0, Dynamic<?> var1, int var2) {
        Optional var5;
        boolean var4;
        var0.a("minecraft:custom_name", var1.get("Name"));
        var0.a("minecraft:lore", var1.get("Lore"));
        Optional<Integer> var3 = var1.get("color").asNumber().result().map(Number::intValue);
        boolean bl = var4 = (var2 & 0x40) != 0;
        if (var3.isPresent() || var4) {
            var5 = var1.emptyMap().set("rgb", var1.createInt(var3.orElse(10511680).intValue()));
            if (var4) {
                var5 = var5.set("show_in_tooltip", var1.createBoolean(false));
            }
            var0.a("minecraft:dyed_color", (Dynamic<?>)var5);
        }
        if ((var5 = var1.get("LocName").asString().result()).isPresent()) {
            var0.a("minecraft:item_name", LegacyComponentDataFixUtils.b(var1.getOps(), (String)var5.get()));
        }
        if (var0.b("minecraft:filled_map")) {
            var0.a("minecraft:map_color", var1.get("MapColor"));
            var1 = var1.remove("MapColor");
        }
        return var1.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static <T> Dynamic<T> a(a var02, Dynamic<T> var1, String var2) {
        var02.a("minecraft:lock", var1.get("Lock"));
        var1 = var1.remove("Lock");
        Optional var3 = var1.get("LootTable").result();
        if (var3.isPresent()) {
            Dynamic var4 = var1.emptyMap().set("loot_table", (Dynamic)var3.get());
            long var5 = var1.get("LootTableSeed").asLong(0L);
            if (var5 != 0L) {
                var4 = var4.set("seed", var1.createLong(var5));
            }
            var02.a("minecraft:container_loot", var4);
            var1 = var1.remove("LootTable").remove("LootTableSeed");
        }
        return switch (var2) {
            case "minecraft:skull" -> {
                var02.a("minecraft:note_block_sound", var1.get("note_block_sound"));
                yield var1.remove("note_block_sound");
            }
            case "minecraft:decorated_pot" -> {
                var02.a("minecraft:pot_decorations", var1.get("sherds"));
                Optional var6 = var1.get("item").result();
                if (var6.isPresent()) {
                    var02.a("minecraft:container", var1.createList(Stream.of(var1.emptyMap().set("slot", var1.createInt(0)).set("item", (Dynamic)var6.get()))));
                }
                yield var1.remove("sherds").remove("item");
            }
            case "minecraft:banner" -> {
                var02.a("minecraft:banner_patterns", var1.get("patterns"));
                Optional var6 = var1.get("Base").asNumber().result();
                if (var6.isPresent()) {
                    var02.a("minecraft:base_color", var1.createString(ExtraDataFixUtils.a(((Number)var6.get()).intValue())));
                }
                yield var1.remove("patterns").remove("Base");
            }
            case "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter" -> {
                List var6 = var1.get("Items").asList(var0 -> var0.emptyMap().set("slot", var0.createInt(var0.get("Slot").asByte((byte)0) & 0xFF)).set("item", var0.remove("Slot")));
                if (!var6.isEmpty()) {
                    var02.a("minecraft:container", var1.createList(var6.stream()));
                }
                yield var1.remove("Items");
            }
            case "minecraft:beehive" -> {
                var02.a("minecraft:bees", var1.get("bees"));
                yield var1.remove("bees");
            }
            default -> var1;
        };
    }

    private static void a(a var02, Dynamic<?> var1, String var2, String var3, boolean var4) {
        OptionalDynamic<?> var5 = var02.a(var2);
        List var6 = var5.asList(Function.identity()).stream().flatMap(var0 -> ItemStackComponentizationFix.c(var0).stream()).toList();
        if (!var6.isEmpty() || var4) {
            Dynamic var7 = var1.emptyMap();
            Dynamic var8 = var1.emptyMap();
            for (Pair var10 : var6) {
                var8 = var8.set((String)var10.getFirst(), var1.createInt(((Integer)var10.getSecond()).intValue()));
            }
            var7 = var7.set("levels", var8);
            if (var4) {
                var7 = var7.set("show_in_tooltip", var1.createBoolean(false));
            }
            var02.a(var3, var7);
        }
        if (var5.result().isPresent() && var6.isEmpty()) {
            var02.a("minecraft:enchantment_glint_override", var1.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> c(Dynamic<?> var02) {
        return var02.get("id").asString().apply2stable((var0, var1) -> Pair.of((Object)var0, (Object)MathHelper.a(var1.intValue(), 0, 255)), var02.get("lvl").asNumber()).result();
    }

    private static void b(a var0, Dynamic<?> var1, int var2) {
        ItemStackComponentizationFix.b(var0, var1, "CanDestroy", "minecraft:can_break", (var2 & 8) != 0);
        ItemStackComponentizationFix.b(var0, var1, "CanPlaceOn", "minecraft:can_place_on", (var2 & 0x10) != 0);
    }

    private static void b(a var02, Dynamic<?> var1, String var2, String var3, boolean var4) {
        Optional var5 = var02.a(var2).result();
        if (var5.isEmpty()) {
            return;
        }
        Dynamic var6 = var1.emptyMap().set("predicates", var1.createList(((Dynamic)var5.get()).asStream().map(var0 -> (Dynamic)DataFixUtils.orElse((Optional)var0.asString().map(var1 -> ItemStackComponentizationFix.a(var0, var1)).result(), (Object)var0))));
        if (var4) {
            var6 = var6.set("show_in_tooltip", var1.createBoolean(false));
        }
        var02.a(var3, var6);
    }

    private static Dynamic<?> a(Dynamic<?> var0, String var1) {
        int var2 = var1.indexOf(91);
        int var3 = var1.indexOf(123);
        int var4 = var1.length();
        if (var2 != -1) {
            var4 = var2;
        }
        if (var3 != -1) {
            var4 = Math.min(var4, var3);
        }
        String var5 = var1.substring(0, var4);
        Dynamic var6 = var0.emptyMap().set("blocks", var0.createString(var5.trim()));
        int var7 = var1.indexOf(93);
        if (var2 != -1 && var7 != -1) {
            Dynamic var8 = var0.emptyMap();
            Iterable var9 = m.split((CharSequence)var1.substring(var2 + 1, var7));
            for (String var11 : var9) {
                int var12 = var11.indexOf(61);
                if (var12 == -1) continue;
                String var13 = var11.substring(0, var12).trim();
                String var14 = var11.substring(var12 + 1).trim();
                var8 = var8.set(var13, var0.createString(var14));
            }
            var6 = var6.set("state", var8);
        }
        int var8 = var1.indexOf(125);
        if (var3 != -1 && var8 != -1) {
            var6 = var6.set("nbt", var0.createString(var1.substring(var3, var8 + 1)));
        }
        return var6;
    }

    private static void c(a var0, Dynamic<?> var1, int var2) {
        OptionalDynamic<?> var3 = var0.a("AttributeModifiers");
        if (var3.result().isEmpty()) {
            return;
        }
        boolean var4 = (var2 & 2) != 0;
        List var5 = var3.asList(ItemStackComponentizationFix::d);
        Dynamic var6 = var1.emptyMap().set("modifiers", var1.createList(var5.stream()));
        if (var4) {
            var6 = var6.set("show_in_tooltip", var1.createBoolean(false));
        }
        var0.a("minecraft:attribute_modifiers", var6);
    }

    private static Dynamic<?> d(Dynamic<?> var02) {
        Dynamic var1 = var02.emptyMap().set("name", var02.createString("")).set("amount", var02.createDouble(0.0)).set("operation", var02.createString("add_value"));
        var1 = Dynamic.copyField(var02, (String)"AttributeName", (Dynamic)var1, (String)"type");
        var1 = Dynamic.copyField(var02, (String)"Slot", (Dynamic)var1, (String)"slot");
        var1 = Dynamic.copyField(var02, (String)"UUID", (Dynamic)var1, (String)"uuid");
        var1 = Dynamic.copyField(var02, (String)"Name", (Dynamic)var1, (String)"name");
        var1 = Dynamic.copyField(var02, (String)"Amount", (Dynamic)var1, (String)"amount");
        var1 = Dynamic.copyAndFixField(var02, (String)"Operation", (Dynamic)var1, (String)"operation", var0 -> var0.createString(switch (var0.asInt(0)) {
            default -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
        }));
        return var1;
    }

    private static Pair<Dynamic<?>, Dynamic<?>> e(Dynamic<?> var0) {
        Dynamic var1 = (Dynamic)DataFixUtils.orElseGet((Optional)var0.get("id").result(), () -> var0.createString(""));
        Dynamic var2 = var0.emptyMap().set("type", var0.createString(ItemStackComponentizationFix.a(var0.get("type").asInt(0)))).set("x", var0.createDouble(var0.get("x").asDouble(0.0))).set("z", var0.createDouble(var0.get("z").asDouble(0.0))).set("rotation", var0.createFloat((float)var0.get("rot").asDouble(0.0)));
        return Pair.of((Object)var1, (Object)var2);
    }

    private static String a(int var0) {
        return switch (var0) {
            default -> "player";
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
        };
    }

    private static void b(a var02, Dynamic<?> var1) {
        Dynamic<?> var2 = var1.emptyMap();
        Optional<String> var3 = var02.a("Potion").asString().result().filter(var0 -> !var0.equals("minecraft:empty"));
        if (var3.isPresent()) {
            var2 = var2.set("potion", var1.createString(var3.get()));
        }
        var2 = var02.a("CustomPotionColor", var2, "custom_color");
        if (!(var2 = var02.a("custom_potion_effects", var2, "custom_effects")).equals((Object)var1.emptyMap())) {
            var02.a("minecraft:potion_contents", var2);
        }
    }

    private static void c(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = ItemStackComponentizationFix.e(var0, var1);
        if (var2 != null) {
            var0.a("minecraft:writable_book_content", var1.emptyMap().set("pages", var2));
        }
    }

    private static void d(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = ItemStackComponentizationFix.e(var0, var1);
        String var3 = var0.a("title").asString("");
        Optional var4 = var0.a("filtered_title").asString().result();
        Dynamic var5 = var1.emptyMap();
        var5 = var5.set("title", ItemStackComponentizationFix.a(var1, var3, var4));
        var5 = var0.a("author", var5, "author");
        var5 = var0.a("resolved", var5, "resolved");
        var5 = var0.a("generation", var5, "generation");
        if (var2 != null) {
            var5 = var5.set("pages", var2);
        }
        var0.a("minecraft:written_book_content", var5);
    }

    @Nullable
    private static Dynamic<?> e(a var02, Dynamic<?> var1) {
        List var2 = var02.a("pages").asList(var0 -> var0.asString(""));
        Map var3 = var02.a("filtered_pages").asMap(var0 -> var0.asString("0"), var0 -> var0.asString(""));
        if (var2.isEmpty()) {
            return null;
        }
        ArrayList var4 = new ArrayList(var2.size());
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            String var6 = (String)var2.get(var5);
            String var7 = (String)var3.get(String.valueOf(var5));
            var4.add(ItemStackComponentizationFix.a(var1, var6, Optional.ofNullable(var7)));
        }
        return var1.createList(var4.stream());
    }

    private static Dynamic<?> a(Dynamic<?> var0, String var1, Optional<String> var2) {
        Dynamic var3 = var0.emptyMap().set("raw", var0.createString(var1));
        if (var2.isPresent()) {
            var3 = var3.set("filtered", var0.createString(var2.get()));
        }
        return var3;
    }

    private static void f(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = var1.emptyMap();
        for (String var4 : k) {
            var2 = var0.a(var4, var2, var4);
        }
        if (!var2.equals((Object)var1.emptyMap())) {
            var0.a("minecraft:bucket_entity_data", var2);
        }
    }

    private static void g(a var0, Dynamic<?> var1) {
        Optional var2 = var0.a("LodestonePos").result();
        Optional var3 = var0.a("LodestoneDimension").result();
        if (var2.isEmpty() && var3.isEmpty()) {
            return;
        }
        boolean var4 = var0.a("LodestoneTracked").asBoolean(true);
        Dynamic var5 = var1.emptyMap();
        if (var2.isPresent() && var3.isPresent()) {
            var5 = var5.set("target", var1.emptyMap().set("pos", (Dynamic)var2.get()).set("dimension", (Dynamic)var3.get()));
        }
        if (!var4) {
            var5 = var5.set("tracked", var1.createBoolean(false));
        }
        var0.a("minecraft:lodestone_tracker", var5);
    }

    private static void a(a var0) {
        var0.a("Explosion", true, var1 -> {
            var0.a("minecraft:firework_explosion", ItemStackComponentizationFix.f(var1));
            return var1.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void b(a var0) {
        var0.a("Fireworks", true, var1 -> {
            Stream<Dynamic> var2 = var1.get("Explosions").asStream().map(ItemStackComponentizationFix::f);
            int var3 = var1.get("Flight").asInt(0);
            var0.a("minecraft:fireworks", var1.emptyMap().set("explosions", var1.createList(var2)).set("flight_duration", var1.createByte((byte)var3)));
            return var1.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> f(Dynamic<?> var0) {
        var0 = var0.set("shape", var0.createString(switch (var0.get("Type").asInt(0)) {
            default -> "small_ball";
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
        })).remove("Type");
        var0 = var0.renameField("Colors", "colors");
        var0 = var0.renameField("FadeColors", "fade_colors");
        var0 = var0.renameField("Trail", "has_trail");
        var0 = var0.renameField("Flicker", "has_twinkle");
        return var0;
    }

    public static Dynamic<?> a(Dynamic<?> var0) {
        Optional var1 = var0.asString().result();
        if (var1.isPresent()) {
            if (ItemStackComponentizationFix.a((String)var1.get())) {
                return var0.emptyMap().set("name", var0.createString((String)var1.get()));
            }
            return var0.emptyMap();
        }
        String var2 = var0.get("Name").asString("");
        Optional var3 = var0.get("Id").result();
        Dynamic<?> var4 = ItemStackComponentizationFix.a(var0.get("Properties"));
        Dynamic var5 = var0.emptyMap();
        if (ItemStackComponentizationFix.a(var2)) {
            var5 = var5.set("name", var0.createString(var2));
        }
        if (var3.isPresent()) {
            var5 = var5.set("id", (Dynamic)var3.get());
        }
        if (var4 != null) {
            var5 = var5.set("properties", var4);
        }
        return var5;
    }

    private static boolean a(String var02) {
        if (var02.length() > 16) {
            return false;
        }
        return var02.chars().filter(var0 -> var0 <= 32 || var0 >= 127).findAny().isEmpty();
    }

    @Nullable
    private static Dynamic<?> a(OptionalDynamic<?> var03) {
        Map var12 = var03.asMap(var0 -> var0.asString(""), var02 -> var02.asList(var0 -> {
            String var1 = var0.get("Value").asString("");
            Optional var2 = var0.get("Signature").asString().result();
            return Pair.of((Object)var1, (Object)var2);
        }));
        if (var12.isEmpty()) {
            return null;
        }
        return var03.createList(var12.entrySet().stream().flatMap(var1 -> ((List)var1.getValue()).stream().map(var2 -> {
            Dynamic var3 = var03.emptyMap().set("name", var03.createString((String)var1.getKey())).set("value", var03.createString((String)var2.getFirst()));
            Optional var4 = (Optional)var2.getSecond();
            if (var4.isPresent()) {
                return var3.set("signature", var03.createString((String)var4.get()));
            }
            return var3;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(DataConverterTypes.u), this.getOutputSchema().getType(DataConverterTypes.u), var02 -> {
            Optional<Dynamic> var1 = net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(var02).map(var0 -> {
                ItemStackComponentizationFix.a(var0, var0.e);
                return var0.a();
            });
            return (Dynamic)DataFixUtils.orElse(var1, (Object)var02);
        });
    }

    static class a {
        private final String a;
        private final int b;
        private Dynamic<?> c;
        private final Dynamic<?> d;
        Dynamic<?> e;

        private a(String var0, int var1, Dynamic<?> var2) {
            this.a = DataConverterSchemaNamed.a(var0);
            this.b = var1;
            this.c = var2.emptyMap();
            this.e = var2.get("tag").orElseEmptyMap();
            this.d = var2.remove("tag");
        }

        public static Optional<a> a(Dynamic<?> var0) {
            return var0.get("id").asString().apply2stable((var1, var2) -> new a((String)var1, var2.intValue(), (Dynamic<?>)var0.remove("id").remove("Count")), var0.get("Count").asNumber()).result();
        }

        public OptionalDynamic<?> a(String var0) {
            OptionalDynamic var1 = this.e.get(var0);
            this.e = this.e.remove(var0);
            return var1;
        }

        public void a(String var0, Dynamic<?> var1) {
            this.c = this.c.set(var0, var1);
        }

        public void a(String var0, OptionalDynamic<?> var12) {
            var12.result().ifPresent(var1 -> {
                this.c = this.c.set(var0, var1);
            });
        }

        public Dynamic<?> a(String var0, Dynamic<?> var1, String var2) {
            Optional var3 = this.a(var0).result();
            if (var3.isPresent()) {
                return var1.set(var2, (Dynamic)var3.get());
            }
            return var1;
        }

        public void a(String var0, String var1, Dynamic<?> var2) {
            Optional var3 = this.a(var0).result();
            if (var3.isPresent() && !((Dynamic)var3.get()).equals(var2)) {
                this.a(var1, (Dynamic)var3.get());
            }
        }

        public void a(String var0, String var12) {
            this.a(var0).result().ifPresent(var1 -> this.a(var12, (Dynamic<?>)var1));
        }

        public void a(String var0, boolean var1, UnaryOperator<Dynamic<?>> var2) {
            OptionalDynamic var3 = this.e.get(var0);
            if (var1 && var3.result().isEmpty()) {
                return;
            }
            Dynamic var4 = var3.orElseEmptyMap();
            this.e = (var4 = (Dynamic)var2.apply(var4)).equals((Object)var4.emptyMap()) ? this.e.remove(var0) : this.e.set(var0, var4);
        }

        public Dynamic<?> a() {
            Dynamic var0 = this.e.emptyMap().set("id", this.e.createString(this.a)).set("count", this.e.createInt(this.b));
            if (!this.e.equals((Object)this.e.emptyMap())) {
                this.c = this.c.set("minecraft:custom_data", this.e);
            }
            if (!this.c.equals((Object)this.e.emptyMap())) {
                var0 = var0.set("components", this.c);
            }
            return net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(var0, this.d);
        }

        private static <T> Dynamic<T> a(Dynamic<T> var0, Dynamic<?> var12) {
            DynamicOps var22 = var0.getOps();
            return var22.getMap(var0.getValue()).flatMap(var2 -> var22.mergeToMap(var12.convert(var22).getValue(), var2)).map(var1 -> new Dynamic(var22, var1)).result().orElse(var0);
        }

        public boolean b(String var0) {
            return this.a.equals(var0);
        }

        public boolean a(Set<String> var0) {
            return var0.contains(this.a);
        }

        public boolean c(String var0) {
            return this.c.get(var0).result().isPresent();
        }
    }
}

