/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final int j = 0;
    private static final int k = 0;
    private static final float l = 0.0f;
    private static final float m = 0.0f;
    private static final float n = 1.0f;
    private static final float o = 0.5f;
    private static final float p = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public static final int c = -1;
    public static final int d = 600;
    private static final int q = 20;
    private static final int r = 20;
    private static final ColorParticleOption s = ColorParticleOption.a(Particles.u, -1);
    @Nullable
    private ParticleParam t;
    public PotionContents u = PotionContents.a;
    private float aM = 1.0f;
    private final Map<Entity, Integer> aN = Maps.newHashMap();
    private int aO = -1;
    public int aP = 20;
    public int aQ = 20;
    public int aR = 0;
    public float aS = 0.0f;
    public float aT = 0.0f;
    @Nullable
    private EntityReference<EntityLiving> aU;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entitytypes, World world) {
        super(entitytypes, world);
        this.aq = true;
    }

    public EntityAreaEffectCloud(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.e, world);
        this.a_(d0, d1, d2);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, Float.valueOf(3.0f));
        datawatcher_a.a(g, false);
        datawatcher_a.a(h, s);
    }

    public void a(float f2) {
        if (!this.ai().C) {
            this.au().a(f, Float.valueOf(MathHelper.a(f2, 0.0f, 32.0f)));
        }
    }

    @Override
    public void j_() {
        double d0 = this.dC();
        double d1 = this.dE();
        double d2 = this.dI();
        super.j_();
        this.a_(d0, d1, d2);
    }

    public float c() {
        return this.au().a(f).floatValue();
    }

    public void a(PotionContents potioncontents) {
        this.u = potioncontents;
        this.q();
    }

    public void a(@Nullable ParticleParam particleparam) {
        this.t = particleparam;
        this.q();
    }

    public void b(float f2) {
        this.aM = f2;
    }

    public void q() {
        if (this.t != null) {
            this.ay.a(h, this.t);
        } else {
            int i2 = ARGB.f(this.u.b());
            this.ay.a(h, ColorParticleOption.a(s.a(), i2));
        }
    }

    public void a(MobEffect mobeffect) {
        this.a(this.u.a(mobeffect));
    }

    public ParticleParam e() {
        return this.au().a(h);
    }

    protected void a(boolean flag) {
        this.au().a(g, flag);
    }

    public boolean f() {
        return this.au().a(g);
    }

    public int h() {
        return this.aO;
    }

    public void a(int i2) {
        this.aO = i2;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.as >= this.aP + this.aO) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void g() {
        super.g();
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver);
        } else {
            this.s();
        }
    }

    private void s() {
        boolean flag = this.f();
        float f2 = this.c();
        if (!flag || !this.ar.h()) {
            float f1;
            int i2;
            ParticleParam particleparam = this.e();
            if (flag) {
                i2 = 2;
                f1 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * f2 * f2);
                f1 = f2;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                float f22 = this.ar.i() * ((float)Math.PI * 2);
                float f3 = MathHelper.c(this.ar.i()) * f1;
                double d0 = this.dC() + (double)(MathHelper.b(f22) * f3);
                double d1 = this.dE();
                double d2 = this.dI() + (double)(MathHelper.a(f22) * f3);
                if (particleparam.a() == Particles.u) {
                    if (flag && this.ar.h()) {
                        this.ai().b(s, d0, d1, d2, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.ai().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                if (flag) {
                    this.ai().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                this.ai().b(particleparam, d0, d1, d2, (0.5 - this.ar.j()) * 0.15, 0.01f, (0.5 - this.ar.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer worldserver) {
        if (this.aO != -1 && this.as - this.aP >= this.aO) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag1;
            boolean flag = this.f();
            boolean bl = flag1 = this.as < this.aP;
            if (flag != flag1) {
                this.a(flag1);
            }
            if (!flag1) {
                float f2 = this.c();
                if (this.aT != 0.0f) {
                    if ((f2 += this.aT) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.as % 5 == 0) {
                    this.aN.entrySet().removeIf(entry -> this.as >= (Integer)entry.getValue());
                    if (!this.u.c()) {
                        this.aN.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        PotionContents potioncontents = this.u;
                        Objects.requireNonNull(list);
                        potioncontents.a(list::add, this.aM);
                        List<EntityLiving> list1 = this.ai().a(EntityLiving.class, this.cV());
                        if (!list1.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving entityliving : list1) {
                                double d1;
                                double d0;
                                double d2;
                                if (this.aN.containsKey(entityliving) || !entityliving.fS()) continue;
                                Stream stream = list.stream();
                                Objects.requireNonNull(entityliving);
                                if (stream.noneMatch(entityliving::b) || !((d2 = (d0 = entityliving.dC() - this.dC()) * d0 + (d1 = entityliving.dI() - this.dI()) * d1) <= (double)(f2 * f2))) continue;
                                entities.add((LivingEntity)entityliving.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                                    this.aN.put(entityliving, this.as + this.aQ);
                                    for (MobEffect mobeffect : list) {
                                        if (mobeffect.c().a().a()) {
                                            mobeffect.c().a().a(worldserver, this, this.n(), entityliving, mobeffect.e(), 0.5);
                                            continue;
                                        }
                                        entityliving.addEffect(new MobEffect(mobeffect), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.aS != 0.0f) {
                                        if ((f2 += this.aS) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(f2);
                                    }
                                    if (this.aR == 0 || this.aO == -1) continue;
                                    this.aO += this.aR;
                                    if (this.aO > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.aS;
    }

    public void c(float f2) {
        this.aS = f2;
    }

    public float k() {
        return this.aT;
    }

    public void d(float f2) {
        this.aT = f2;
    }

    public int l() {
        return this.aR;
    }

    public void b(int i2) {
        this.aR = i2;
    }

    public int m() {
        return this.aP;
    }

    public void c(int i2) {
        this.aP = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.aU = entityliving != null ? new EntityReference<EntityLiving>(entityliving) : null;
    }

    @Nullable
    public EntityLiving n() {
        return EntityReference.a(this.aU, this.ai(), EntityLiving.class);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.as = valueinput.a("Age", 0);
        this.aO = valueinput.a("Duration", -1);
        this.aP = valueinput.a("WaitTime", 20);
        this.aQ = valueinput.a("ReapplicationDelay", 20);
        this.aR = valueinput.a("DurationOnUse", 0);
        this.aS = valueinput.a("RadiusOnUse", 0.0f);
        this.aT = valueinput.a("RadiusPerTick", 0.0f);
        this.a(valueinput.a("Radius", 3.0f));
        this.aU = EntityReference.a(valueinput, "Owner");
        this.a((ParticleParam)valueinput.a("custom_particle", Particles.bk).orElse(null));
        this.a(valueinput.a("potion_contents", PotionContents.c).orElse(PotionContents.a));
        this.aM = valueinput.a("potion_duration_scale", 1.0f);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a("Age", this.as);
        valueoutput.a("Duration", this.aO);
        valueoutput.a("WaitTime", this.aP);
        valueoutput.a("ReapplicationDelay", this.aQ);
        valueoutput.a("DurationOnUse", this.aR);
        valueoutput.a("RadiusOnUse", this.aS);
        valueoutput.a("RadiusPerTick", this.aT);
        valueoutput.a("Radius", this.c());
        valueoutput.b("custom_particle", Particles.bk, this.t);
        EntityReference.a(this.aU, valueoutput, "Owner");
        if (!this.u.equals(PotionContents.a)) {
            valueoutput.a("potion_contents", PotionContents.c, this.u);
        }
        if (this.aM != 1.0f) {
            valueoutput.a("potion_duration_scale", this.aM);
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (f.equals(datawatcherobject)) {
            this.j_();
        }
        super.a(datawatcherobject);
    }

    @Override
    public EnumPistonReaction k_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return false;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.R ? EntityAreaEffectCloud.c(datacomponenttype, this.u) : (datacomponenttype == DataComponents.S ? EntityAreaEffectCloud.c(datacomponenttype, Float.valueOf(this.aM)) : super.a(datacomponenttype));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.R);
        this.a(datacomponentgetter, DataComponents.S);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.R) {
            this.a(EntityAreaEffectCloud.c(DataComponents.R, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.S) {
            this.b(EntityAreaEffectCloud.c(DataComponents.S, t0).floatValue());
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

