/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class TemptingSensor
extends Sensor<EntityCreature> {
    private static final PathfinderTargetCondition a = PathfinderTargetCondition.b().d();
    private final Predicate<ItemStack> b;

    public TemptingSensor(Predicate<ItemStack> predicate) {
        this.b = predicate;
    }

    @Override
    protected void a(WorldServer worldserver, EntityCreature entitycreature) {
        BehaviorController<?> behaviorcontroller = entitycreature.eh();
        PathfinderTargetCondition pathfindertargetcondition = a.c().a((float)entitycreature.i(GenericAttributes.F));
        Stream<EntityPlayer> stream = worldserver.A().stream().filter(IEntitySelector.f).filter(entityplayer -> pathfindertargetcondition.a(worldserver, entitycreature, (EntityLiving)entityplayer)).filter(this::a).filter(entityplayer -> !entitycreature.z((Entity)entityplayer));
        Objects.requireNonNull(entitycreature);
        List list = stream.sorted(Comparator.comparingDouble(entitycreature::g)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            EntityHuman entityhuman = (EntityHuman)list.get(0);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityhuman, EntityTargetEvent.TargetReason.TEMPT);
            if (event.isCancelled()) {
                return;
            }
            if (event.getTarget() instanceof HumanEntity) {
                behaviorcontroller.a(MemoryModuleType.P, ((CraftHumanEntity)event.getTarget()).getHandle());
            } else {
                behaviorcontroller.b(MemoryModuleType.P);
            }
        } else {
            behaviorcontroller.b(MemoryModuleType.P);
        }
    }

    private boolean a(EntityHuman entityhuman) {
        return this.a(entityhuman.fh()) || this.a(entityhuman.fi());
    }

    private boolean a(ItemStack itemstack) {
        return this.b.test(itemstack);
    }

    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.P);
    }
}

