/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize cs = EntityTypes.A.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> ct = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.y);
    private static final boolean cu = false;
    public float ck;
    public float cl;
    public float cm;
    public float co;
    public float cp = 1.0f;
    private float cv = 1.0f;
    public int cq = this.ar.a(6000) + 6000;
    public boolean cr = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void H() {
        this.ch.a(0, new PathfinderGoalFloat(this));
        this.ch.a(1, new PathfinderGoalPanic(this, 1.4));
        this.ch.a(2, new PathfinderGoalBreed(this, 1.0));
        this.ch.a(3, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.a(TagsItem.aI), false));
        this.ch.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.ch.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ch.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.ch.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.g_() ? cs : super.e(entitypose);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gM().a(GenericAttributes.t, 4.0).a(GenericAttributes.w, 0.25);
    }

    @Override
    public void e_() {
        super.e_();
        this.co = this.ck;
        this.cm = this.cl;
        this.cl += (this.aK() ? -1.0f : 4.0f) * 0.3f;
        this.cl = MathHelper.a(this.cl, 0.0f, 1.0f);
        if (!this.aK() && this.cp < 1.0f) {
            this.cp = 1.0f;
        }
        this.cp *= 0.9f;
        Vec3D vec3d = this.dA();
        if (!this.aK() && vec3d.e < 0.0) {
            this.i(vec3d.d(1.0, 0.6, 1.0));
        }
        this.ck += this.cp * 2.0f;
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bO() && !this.g_() && !this.t() && --this.cq <= 0) {
                this.forceDrops = true;
                if (this.a(worldserver, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eX, 1.0f, (this.ar.i() - this.ar.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.t);
                }
                this.forceDrops = false;
                this.cq = this.ar.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean bd() {
        return this.al > this.cv;
    }

    @Override
    protected void bc() {
        this.cv = this.al + this.cl / 2.0f;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.eV;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.eY;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.eW;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.eZ, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityChicken entitychicken = EntityTypes.A.a(worldserver, EntitySpawnReason.e);
        if (entitychicken != null && entityageable instanceof EntityChicken) {
            EntityChicken entitychicken1 = (EntityChicken)entityageable;
            entitychicken.b(this.ar.h() ? this.n() : entitychicken1.n());
        }
        return entitychicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        VariantUtils.a(SpawnContext.a(worldaccess, this.dx()), Registries.aN).ifPresent(this::b);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.aI);
    }

    @Override
    protected int e(WorldServer worldserver) {
        return this.t() ? 10 : super.e(worldserver);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ct, VariantUtils.a(this.eb(), ChickenVariants.a));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cr = valueinput.a("IsChickenJockey", false);
        valueinput.e("EggLayTime").ifPresent(integer -> {
            this.cq = integer;
        });
        VariantUtils.a(valueinput, Registries.aN).ifPresent(this::b);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsChickenJockey", this.cr);
        valueoutput.a("EggLayTime", this.cq);
        VariantUtils.a(valueoutput, this.n());
    }

    public void b(Holder<ChickenVariant> holder) {
        this.ay.a(ct, holder);
    }

    public Holder<ChickenVariant> n() {
        return this.ay.a(ct);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aJ ? EntityChicken.c(datacomponenttype, new EitherHolder<ChickenVariant>(this.n())) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aJ);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aJ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aJ, t0).a(this.eb());
            if (optional.isPresent()) {
                this.b(optional.get());
                return true;
            }
            return false;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    public boolean h(double d0) {
        return this.t();
    }

    @Override
    protected void a(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.a(entity, entity_movefunction);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).br = this.br;
        }
    }

    public boolean t() {
        return this.cr;
    }

    public void x(boolean flag) {
        this.cr = flag;
    }
}

