/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int f = 220;
    private static final int ck = 0;
    private final float[] cl = new float[2];
    private final float[] cm = new float[2];
    private final float[] cn = new float[2];
    private final float[] co = new float[2];
    private final int[] cp = new int[2];
    private final int[] cq = new int[2];
    private int cr;
    public final BossBattleServer cs = (BossBattleServer)new BossBattleServer(this.Q_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a ct = (entityliving, worldserver) -> !entityliving.ap().a(TagsEntity.y) && entityliving.fT();
    private static final PathfinderTargetCondition cu = PathfinderTargetCondition.a().a(20.0).a(ct);

    public EntityWither(EntityTypes<? extends EntityWither> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.ce = new ControllerMoveFlying(this, 10, false);
        this.x(this.fa());
        this.cc = 50;
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.d(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    protected void H() {
        this.ch.a(0, new a());
        this.ch.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.ch.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.ch.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.ch.a(7, new PathfinderGoalRandomLookaround(this));
        this.ci.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ci.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, ct));
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, 0);
        datawatcher_a.a(b, 0);
        datawatcher_a.a(c, 0);
        datawatcher_a.a(e, 0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Invul", this.gH());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.b(valueinput.a("Invul", 0));
        if (this.i_()) {
            this.cs.a(this.Q_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        super.b(ichatbasecomponent);
        this.cs.a(this.Q_());
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.Eb;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Ee;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.Ed;
    }

    @Override
    public void e_() {
        Entity entity;
        Vec3D vec3d = this.dA().d(1.0, 0.6, 1.0);
        if (!this.ai().C && this.c(0) > 0 && (entity = this.ai().a(this.c(0))) != null) {
            double d0 = vec3d.e;
            if (this.dE() < entity.dE() || !this.gI() && this.dE() < entity.dE() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.d, d0, vec3d.f);
            Vec3D vec3d1 = new Vec3D(entity.dC() - this.dC(), 0.0, entity.dI() - this.dI());
            if (vec3d1.j() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.d * 0.3 - vec3d.d * 0.6, 0.0, vec3d2.f * 0.3 - vec3d.f * 0.6);
            }
        }
        this.i(vec3d);
        if (vec3d.j() > 0.05) {
            this.v((float)MathHelper.d(vec3d.f, vec3d.d) * 57.295776f - 90.0f);
        }
        super.e_();
        for (int i2 = 0; i2 < 2; ++i2) {
            this.co[i2] = this.cm[i2];
            this.cn[i2] = this.cl[i2];
        }
        for (int j2 = 0; j2 < 2; ++j2) {
            int k2 = this.c(j2 + 1);
            Entity entity1 = null;
            if (k2 > 0) {
                entity1 = this.ai().a(k2);
            }
            if (entity1 != null) {
                double d1 = this.r(j2 + 1);
                double d2 = this.s(j2 + 1);
                double d3 = this.t(j2 + 1);
                double d4 = entity1.dC() - d1;
                double d5 = entity1.dG() - d2;
                double d6 = entity1.dI() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.cl[j2] = this.a(this.cl[j2], f1, 40.0f);
                this.cm[j2] = this.a(this.cm[j2], f2, 10.0f);
                continue;
            }
            this.cm[j2] = this.a(this.cm[j2], this.br, 10.0f);
        }
        boolean flag = this.gI();
        for (int l2 = 0; l2 < 3; ++l2) {
            double d8 = this.r(l2);
            double d9 = this.s(l2);
            double d10 = this.t(l2);
            float f2 = 0.3f * this.eq();
            this.ai().a(Particles.ah, d8 + this.ar.k() * (double)f2, d9 + this.ar.k() * (double)f2, d10 + this.ar.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.ai().A.a(4) != 0) continue;
            this.ai().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.5f), d8 + this.ar.k() * (double)f2, d9 + this.ar.k() * (double)f2, d10 + this.ar.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.gH() > 0) {
            float f3 = 3.3f * this.eq();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.ai().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.9f), this.dC() + this.ar.k(), this.dE() + (double)(this.ar.i() * f3), this.dI() + this.ar.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.gH() > 0) {
            int i2 = this.gH() - 1;
            this.cs.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    worldserver.a((Entity)this, this.dC(), this.dG(), this.dI(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.be()) {
                    int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : MinecraftServer.getServer().ag().l) {
                        double deltaX = this.dC() - player.dC();
                        double deltaZ = this.dI() - player.dI();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (worldserver.spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.witherSpawnSoundRadius * worldserver.spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dC() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dI() + deltaZ / deltaLength * (double)viewDistance;
                            player.g.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dE(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.g.b(new PacketPlayOutWorldEvent(1023, this.dx(), 0, true));
                    }
                }
            }
            this.b(i2);
            if (this.as % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            super.a(worldserver);
            for (int j2 = 1; j2 < 3; ++j2) {
                EntityLiving entityliving1;
                int i1;
                if (this.as < this.cp[j2 - 1]) continue;
                this.cp[j2 - 1] = this.as + 10 + this.ar.a(10);
                if (worldserver.an() == EnumDifficulty.c || worldserver.an() == EnumDifficulty.d) {
                    int k2 = j2 - 1;
                    int l2 = this.cq[j2 - 1];
                    this.cq[k2] = this.cq[j2 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.ar, this.dC() - 10.0, this.dC() + 10.0);
                        double d1 = MathHelper.a(this.ar, this.dE() - 5.0, this.dE() + 5.0);
                        double d2 = MathHelper.a(this.ar, this.dI() - 10.0, this.dI() + 10.0);
                        this.a(j2 + 1, d0, d1, d2, true);
                        this.cq[j2 - 1] = 0;
                    }
                }
                if ((i1 = this.c(j2)) > 0) {
                    EntityLiving entityliving = (EntityLiving)worldserver.a(i1);
                    if (entityliving != null && this.c(entityliving) && this.g((Entity)entityliving) <= 900.0 && this.F(entityliving)) {
                        this.a(j2 + 1, entityliving);
                        this.cp[j2 - 1] = this.as + 40 + this.ar.a(20);
                        this.cq[j2 - 1] = 0;
                        continue;
                    }
                    this.a(j2, 0);
                    continue;
                }
                List<EntityLiving> list = worldserver.a(EntityLiving.class, cu, this, this.cV().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.ar.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(j2, entityliving1.ar());
            }
            if (this.e() != null) {
                this.a(0, this.e().ar());
            } else {
                this.a(0, 0);
            }
            if (this.cr > 0) {
                --this.cr;
                if (this.cr == 0 && worldserver.P().c(GameRules.d)) {
                    boolean flag = false;
                    int j1 = MathHelper.d(this.ds() / 2.0f + 1.0f);
                    int k1 = MathHelper.d(this.dt());
                    for (BlockPosition blockposition : BlockPosition.b(this.dB() - j1, this.dD(), this.dH() - j1, this.dB() + j1, this.dD() + k1, this.dH() + j1)) {
                        IBlockData iblockdata = worldserver.a_(blockposition);
                        if (!EntityWither.c(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.m())) continue;
                        flag = worldserver.a(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        worldserver.a((Entity)null, 1022, this.dx(), 0);
                    }
                }
            }
            if (this.as % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cs.a(this.eL() / this.fa());
        }
    }

    public static boolean c(IBlockData iblockdata) {
        return !iblockdata.l() && !iblockdata.a(TagsBlock.aK);
    }

    public void l() {
        this.b(220);
        this.cs.a(0.0f);
        this.x(this.fa() / 3.0f);
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
    }

    @Override
    public void d(EntityPlayer entityplayer) {
        super.d(entityplayer);
        this.cs.a(entityplayer);
    }

    @Override
    public void e(EntityPlayer entityplayer) {
        super.e(entityplayer);
        this.cs.b(entityplayer);
    }

    private double r(int i2) {
        if (i2 <= 0) {
            return this.dC();
        }
        float f2 = (this.br + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dC() + (double)f1 * 1.3 * (double)this.eq();
    }

    private double s(int i2) {
        float f2 = i2 <= 0 ? 3.0f : 2.2f;
        return this.dE() + (double)(f2 * this.eq());
    }

    private double t(int i2) {
        if (i2 <= 0) {
            return this.dI();
        }
        float f2 = (this.br + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.dI() + (double)f1 * 1.3 * (double)this.eq();
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.h(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    private void a(int i2, EntityLiving entityliving) {
        this.a(i2, entityliving.dC(), entityliving.dE() + (double)entityliving.cW() * 0.5, entityliving.dI(), i2 == 0 && this.ar.i() < 0.001f);
    }

    private void a(int i2, double d0, double d1, double d2, boolean flag) {
        if (!this.be()) {
            this.ai().a((Entity)null, 1024, this.dx(), 0);
        }
        double d3 = this.r(i2);
        double d4 = this.s(i2);
        double d5 = this.t(i2);
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        Vec3D vec3d = new Vec3D(d6, d7, d8);
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.ai(), this, vec3d.d());
        entitywitherskull.c(this);
        if (flag) {
            entitywitherskull.a(true);
        }
        entitywitherskull.a_(d3, d4, d5);
        this.ai().b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        this.a(0, entityliving);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (!damagesource.a(DamageTypeTags.t) && !(damagesource.d() instanceof EntityWither)) {
            Entity entity;
            if (this.gH() > 0 && !damagesource.a(DamageTypeTags.d)) {
                return false;
            }
            if (this.gI() && ((entity = damagesource.c()) instanceof EntityArrow || entity instanceof WindCharge)) {
                return false;
            }
            Entity entity1 = damagesource.d();
            if (entity1 != null && entity1.ap().a(TagsEntity.y)) {
                return false;
            }
            if (this.cr <= 0) {
                this.cr = 20;
            }
            int i2 = 0;
            while (i2 < this.cq.length) {
                int n2 = i2++;
                this.cq[n2] = this.cq[n2] + 3;
            }
            return super.a(worldserver, damagesource, f2);
        }
        return false;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        EntityItem entityitem = this.a(worldserver, Items.vU);
        if (entityitem != null) {
            entityitem.s();
        }
    }

    @Override
    public void dJ() {
        if (this.ai().an() == EnumDifficulty.a && this.ag()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bz = 0;
        }
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gM().a(GenericAttributes.t, 300.0).a(GenericAttributes.w, 0.6f).a(GenericAttributes.m, 0.6f).a(GenericAttributes.n, 40.0).a(GenericAttributes.a, 4.0);
    }

    public float[] n() {
        return this.cm;
    }

    public float[] t() {
        return this.cl;
    }

    public int gH() {
        return this.ay.a(e);
    }

    public void b(int i2) {
        this.ay.a(e, i2);
    }

    public int c(int i2) {
        return this.ay.a(d.get(i2));
    }

    public void a(int i2, int j2) {
        this.ay.a(d.get(i2), j2);
    }

    public boolean gI() {
        return this.eL() <= this.fa() / 2.0f;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public boolean b(MobEffect mobeffect) {
        return mobeffect.a(MobEffects.t) ? false : super.b(mobeffect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.gH() > 0;
        }
    }
}

