/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> !(entity instanceof EntityRavager) && entity.bO();
    private static final Predicate<Entity> f = entity -> e.test((Entity)entity) && !entity.ap().equals(EntityTypes.g);
    private static final Predicate<EntityLiving> ck = entityliving -> !(entityliving instanceof EntityRavager) && entityliving.bO() && entityliving.di();
    private static final double cl = 0.3;
    private static final double cm = 0.35;
    private static final int cn = 8356754;
    private static final float co = 0.57254905f;
    private static final float cp = 0.5137255f;
    private static final float cq = 0.49803922f;
    public static final int a = 10;
    public static final int b = 40;
    private static final int cr = 0;
    private static final int cs = 0;
    private static final int ct = 0;
    private int cu = 0;
    private int cv = 0;
    private int cw = 0;

    public EntityRavager(EntityTypes<? extends EntityRavager> entitytypes, World world) {
        super((EntityTypes<? extends EntityRaider>)entitytypes, world);
        this.cc = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void H() {
        super.H();
        this.ch.a(0, new PathfinderGoalFloat(this));
        this.ch.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.ch.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.ch.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.ch.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.ci.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ci.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (entityliving, worldserver) -> !entityliving.g_()));
        this.ci.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void Z() {
        boolean flag = !(this.cY() instanceof EntityInsentient) || this.cY().ap().a(TagsEntity.c);
        boolean flag1 = !(this.dm() instanceof AbstractBoat);
        this.ch.a(PathfinderGoal.Type.a, flag);
        this.ch.a(PathfinderGoal.Type.c, flag && flag1);
        this.ch.a(PathfinderGoal.Type.b, flag);
        this.ch.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder l() {
        return EntityMonster.gM().a(GenericAttributes.t, 100.0).a(GenericAttributes.w, 0.3).a(GenericAttributes.q, 0.75).a(GenericAttributes.c, 12.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.n, 32.0).a(GenericAttributes.C, 1.0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("AttackTick", this.cu);
        valueoutput.a("StunTick", this.cv);
        valueoutput.a("RoarTick", this.cw);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cu = valueinput.a("AttackTick", 0);
        this.cv = valueinput.a("StunTick", 0);
        this.cw = valueinput.a("RoarTick", 0);
    }

    @Override
    public SoundEffect ag_() {
        return SoundEffects.ws;
    }

    @Override
    public int gh() {
        return 45;
    }

    @Override
    public void e_() {
        super.e_();
        if (this.bO()) {
            if (this.fm()) {
                this.h(GenericAttributes.w).a(0.0);
            } else {
                double d0 = this.e() != null ? 0.35 : 0.3;
                double d1 = this.h(GenericAttributes.w).b();
                this.h(GenericAttributes.w).a(MathHelper.d(0.1, d1, d0));
            }
            World world = this.ai();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.ac && worldserver.P().c(GameRules.d)) {
                    boolean flag = false;
                    AxisAlignedBB axisalignedbb = this.cV().g(0.2);
                    for (BlockPosition blockposition : BlockPosition.b(MathHelper.a(axisalignedbb.a), MathHelper.a(axisalignedbb.b), MathHelper.a(axisalignedbb.c), MathHelper.a(axisalignedbb.d), MathHelper.a(axisalignedbb.e), MathHelper.a(axisalignedbb.f))) {
                        IBlockData iblockdata = worldserver.a_(blockposition);
                        Block block = iblockdata.b();
                        if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.m())) continue;
                        flag = worldserver.a(blockposition, true, this) || flag;
                    }
                    if (!flag && this.aK()) {
                        this.s();
                    }
                }
            }
            if (this.cw > 0) {
                --this.cw;
                if (this.cw == 10) {
                    this.gS();
                }
            }
            if (this.cu > 0) {
                --this.cu;
            }
            if (this.cv > 0) {
                --this.cv;
                this.gR();
                if (this.cv == 0) {
                    this.a(SoundEffects.wx, 1.0f, 1.0f);
                    this.cw = 20;
                }
            }
        }
    }

    private void gR() {
        if (this.ar.a(6) == 0) {
            double d0 = this.dC() - (double)this.ds() * Math.sin(this.br * ((float)Math.PI / 180)) + (this.ar.j() * 0.6 - 0.3);
            double d1 = this.dE() + (double)this.dt() - 0.3;
            double d2 = this.dI() + (double)this.ds() * Math.cos(this.br * ((float)Math.PI / 180)) + (this.ar.j() * 0.6 - 0.3);
            this.ai().a(ColorParticleOption.a(Particles.u, 0.49803922f, 0.5137255f, 0.57254905f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fm() {
        return super.fm() || this.cu > 0 || this.cv > 0 || this.cw > 0;
    }

    @Override
    public boolean F(Entity entity) {
        return this.cv <= 0 && this.cw <= 0 ? super.F(entity) : false;
    }

    @Override
    protected void d(EntityLiving entityliving) {
        if (this.cw == 0) {
            if (this.ar.j() < 0.5) {
                this.cv = 40;
                this.a(SoundEffects.ww, 1.0f, 1.0f);
                this.ai().a((Entity)this, (byte)39);
                entityliving.h(this);
            } else {
                this.G(entityliving);
            }
            entityliving.ag = true;
        }
    }

    private void gS() {
        World world;
        if (this.bO() && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Predicate<Entity> predicate = worldserver.P().c(GameRules.d) ? e : f;
            for (EntityLiving entityLiving : this.ai().a(EntityLiving.class, this.cV().g(4.0), predicate)) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(worldserver, this.ea().b(this), 6.0f);
                }
                if (entityLiving instanceof EntityHuman) continue;
                this.G(entityLiving);
            }
            this.c(GameEvent.u);
            worldserver.a((Entity)this, (byte)69);
        }
    }

    private void hb() {
        for (EntityLiving entityliving : this.ai().a(EntityLiving.class, this.cV().g(4.0), ck)) {
            this.G(entityliving);
        }
    }

    private void G(Entity entity) {
        double d0 = entity.dC() - this.dC();
        double d1 = entity.dI() - this.dI();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.i(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.cu = 10;
            this.a(SoundEffects.wr, 1.0f, 1.0f);
        } else if (b0 == 39) {
            this.cv = 40;
        } else if (b0 == 69) {
            this.hc();
            this.hb();
        }
        super.b(b0);
    }

    private void hc() {
        Vec3D vec3d = this.cV().f();
        for (int i2 = 0; i2 < 40; ++i2) {
            double d0 = this.ar.k() * 0.2;
            double d1 = this.ar.k() * 0.2;
            double d2 = this.ar.k() * 0.2;
            this.ai().a(Particles.ae, vec3d.d, vec3d.e, vec3d.f, d0, d1, d2);
        }
    }

    public int m() {
        return this.cu;
    }

    public int t() {
        return this.cv;
    }

    public int gQ() {
        return this.cw;
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        this.cu = 10;
        worldserver.a((Entity)this, (byte)4);
        this.a(SoundEffects.wr, 1.0f, 1.0f);
        return super.c(worldserver, entity);
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return SoundEffects.wq;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.wu;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.wt;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.wv, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cV());
    }

    @Override
    public void a(WorldServer worldserver, int i2, boolean flag) {
    }

    @Override
    public boolean gH() {
        return false;
    }

    @Override
    protected AxisAlignedBB gz() {
        AxisAlignedBB axisalignedbb = super.gz();
        return axisalignedbb.f(0.05, 0.0, 0.05);
    }
}

