/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cj = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean ck = false;
    public float d;
    public float e;
    public float f;
    private boolean cl = false;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.cR();
        this.ce = new ControllerMoveSlime(this);
    }

    @Override
    protected void H() {
        this.ch.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.ch.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.ch.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.ch.a(5, new PathfinderGoalSlimeIdle(this));
        this.ci.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dE() - this.dE()) <= 4.0));
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory do() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cj, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.ay.a(cj, j2);
        this.ay();
        this.j_();
        this.h(GenericAttributes.t).a(j2 * j2);
        this.h(GenericAttributes.w).a(0.2f + 0.1f * (float)j2);
        this.h(GenericAttributes.c).a(j2);
        if (flag) {
            this.x(this.fa());
        }
        this.cc = j2;
    }

    public int gH() {
        return this.ay.a(cj);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Size", this.gH() - 1);
        valueoutput.a("wasOnGround", this.cl);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(valueinput.a("Size", 0) + 1, false);
        super.a(valueinput);
        this.cl = valueinput.a("wasOnGround", false);
    }

    public boolean gI() {
        return this.gH() <= 1;
    }

    protected ParticleParam m() {
        return Particles.X;
    }

    @Override
    protected boolean ag() {
        return this.gH() > 0;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aK() && !this.cl) {
            float f2 = this.a(this.aw()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.ar.i() * ((float)Math.PI * 2);
                float f3 = this.ar.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.ai().a(this.m(), this.dC() + (double)f4, this.dE(), this.dI() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gF(), this.fk(), ((this.ar.i() - this.ar.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aK() && this.cl) {
            this.d = 1.0f;
        }
        this.cl = this.aK();
        this.t();
    }

    protected void t() {
        this.d *= 0.6f;
    }

    protected int n() {
        return this.ar.a(20) + 10;
    }

    @Override
    public void j_() {
        double d0 = this.dC();
        double d1 = this.dE();
        double d2 = this.dI();
        super.j_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cj.equals(datawatcherobject)) {
            this.j_();
            this.v(this.bt);
            this.br = this.bt;
            if (this.bm() && this.ar.a(20) == 0) {
                this.bv();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> ap() {
        return super.ap();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gH();
        if (!this.ai().C && i2 > 1 && this.eM()) {
            float f2 = this.a(this.aw()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ar.a(3);
            ScoreboardTeam scoreboardteam = this.cu();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime converted = this.convertTo(this.ap(), new ConversionParams(ConversionType.b, false, false, scoreboardteam), EntitySpawnReason.k, entityslime -> {
                    entityslime.a(j2, true);
                    entityslime.b(this.dC() + (double)f22, this.dE() + 0.5, this.dI() + (double)f3, this.ar.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.ai().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gD()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (this.gD()) {
            this.i(entityhuman);
        }
    }

    protected void i(EntityLiving entityliving) {
        World world = this.ai();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            if (this.bO() && this.h(entityliving) && this.F(entityliving) && entityliving.a(worldserver, damagesource = this.ea().b(this), this.gE())) {
                this.a(SoundEffects.yE, 1.0f, (this.ar.i() - this.ar.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return new Vec3D(0.0, (double)entitysize.b() - 0.015625 * (double)this.gH() * (double)f2, 0.0);
    }

    protected boolean gD() {
        return !this.gI() && this.dl();
    }

    protected float gE() {
        return (float)this.i(GenericAttributes.c);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gI() ? SoundEffects.zJ : SoundEffects.yG;
    }

    @Override
    protected SoundEffect f_() {
        return this.gI() ? SoundEffects.zI : SoundEffects.yF;
    }

    protected SoundEffect gF() {
        return this.gI() ? SoundEffects.zL : SoundEffects.yI;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        if (generatoraccess.an() != EnumDifficulty.a) {
            boolean flag;
            if (EntitySpawnReason.a(entityspawnreason)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (generatoraccess.v(blockposition).a(BiomeTags.as) && blockposition.v() > 50 && blockposition.v() < 70 && randomsource.i() < 0.5f && randomsource.i() < generatoraccess.as() && generatoraccess.C(blockposition) <= randomsource.a(8)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.h, chunkcoordintpair.i, ((GeneratorAccessSeed)generatoraccess).F(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float fk() {
        return 0.4f * (float)this.gH();
    }

    @Override
    public int gg() {
        return 0;
    }

    protected boolean gJ() {
        return this.gH() > 0;
    }

    @Override
    public void s() {
        Vec3D vec3d = this.dA();
        this.n(vec3d.d, this.fn(), vec3d.f);
        this.aE = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.H_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    float l() {
        float f2 = this.gI() ? 1.4f : 0.8f;
        return ((this.ar.i() - this.ar.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gG() {
        return this.gI() ? SoundEffects.zK : SoundEffects.yH;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return super.e(entitypose).a(this.gH());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.dP() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.v(this.b(this.d.dP(), this.l, 90.0f));
            this.d.bt = this.d.dP();
            this.d.br = this.d.dP();
            if (this.k != ControllerMove.Operation.b) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aK()) {
                    this.d.B((float)(this.h * this.d.i(GenericAttributes.w)));
                    if (this.m-- <= 0) {
                        this.m = this.n.n();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.R().a();
                        if (this.n.gJ()) {
                            this.n.a(this.n.gG(), this.n.fk(), this.n.l());
                        }
                    } else {
                        this.n.bC = 0.0f;
                        this.n.bE = 0.0f;
                        this.d.B(0.0f);
                    }
                } else {
                    this.d.B((float)(this.h * this.d.i(GenericAttributes.w)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.S().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bm() || this.a.bA()) && this.a.Q() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.ec().i() < 0.8f) {
                this.a.R().a();
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.Q() instanceof ControllerMoveSlime);
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.e();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dP(), this.a.gD());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.e() == null && (this.a.aK() || this.a.bm() || this.a.bA() || this.a.d(MobEffects.y)) && this.a.Q() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ec().a(60));
                this.b = this.a.ec().a(360);
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.cc();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.Q();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

