/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger a = LogUtils.getLogger();
    private final RandomSource b = RandomSource.a();
    private boolean c;
    private int d;
    private static final int f = 10;
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int i;
    private int j;
    public int k;
    public int l;
    private float m;
    private boolean n = true;
    @Nullable
    public Entity o;
    public HookState p = HookState.a;
    private final int q;
    private final int r;
    private final InterpolationHandler s = new InterpolationHandler(this);
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world, int i2, int j2) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.q = Math.max(0, i2);
        this.r = Math.max(0, j2);
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world) {
        this(entitytypes, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman entityhuman, World world, int i2, int j2) {
        this(EntityTypes.bV, world, i2, j2);
        this.c(entityhuman);
        float f2 = entityhuman.dR();
        float f1 = entityhuman.dP();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = entityhuman.dC() - (double)f3 * 0.3;
        double d1 = entityhuman.dG();
        double d2 = entityhuman.dI() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.g();
        vec3d = vec3d.d(0.6 / d3 + this.ar.a(0.5, 0.0103365), 0.6 / d3 + this.ar.a(0.5, 0.0103365), 0.6 / d3 + this.ar.a(0.5, 0.0103365));
        this.i(vec3d);
        this.v((float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.e, vec3d.i()) * 57.2957763671875));
        this.aa = this.dP();
        this.ab = this.dR();
    }

    @Override
    @Nonnull
    public InterpolationHandler l_() {
        return this.s;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(g, 0);
        datawatcher_a.a(h, false);
    }

    @Override
    protected boolean w() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (g.equals(datawatcherobject)) {
            int i2 = this.au().a(g);
            Entity entity = this.o = i2 > 0 ? this.ai().a(i2 - 1) : null;
        }
        if (h.equals(datawatcherobject)) {
            this.c = this.au().a(h);
            if (this.c) {
                this.n(this.dA().d, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.dA().f);
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(double d0) {
        double d1 = 64.0;
        return d0 < 4096.0;
    }

    @Override
    public void g() {
        this.b.b(this.cK().getLeastSignificantBits() ^ this.ai().ae());
        this.l_().e();
        super.g();
        EntityHuman entityhuman = this.f();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.ai().C || !this.a(entityhuman)) {
            boolean flag;
            if (this.aK()) {
                ++this.i;
                if (this.i >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.i = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.dx();
            Fluid fluid = this.ai().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a(this.ai(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.p == HookState.a) {
                if (this.o != null) {
                    this.i(Vec3D.c);
                    this.p = HookState.b;
                    return;
                }
                if (flag) {
                    this.i(this.dA().d(0.3, 0.2, 0.3));
                    this.p = HookState.c;
                    return;
                }
                this.l();
            } else {
                if (this.p == HookState.b) {
                    if (this.o != null) {
                        if (!this.o.dU() && this.o.ai().aj() == this.ai().aj()) {
                            this.a_(this.o.dC(), this.o.e(0.8), this.o.dI());
                        } else {
                            this.C(null);
                            this.p = HookState.a;
                        }
                    }
                    return;
                }
                if (this.p == HookState.c) {
                    Vec3D vec3d = this.dA();
                    double d0 = this.dE() + vec3d.e - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.n(vec3d.d * 0.9, vec3d.e - d0 * (double)this.ar.i() * 0.2, vec3d.f * 0.9);
                    if (this.j <= 0 && this.l <= 0) {
                        this.n = true;
                    } else {
                        boolean bl2 = this.n = this.n && this.d < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.i(this.dA().b(0.0, -0.1 * (double)this.b.i() * (double)this.b.i(), 0.0));
                        }
                        if (!this.ai().C) {
                            this.a(blockposition);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a) && !this.aK() && this.o == null) {
                this.i(this.dA().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dA());
            this.aL();
            this.z();
            if (this.p == HookState.a && (this.aK() || this.ac)) {
                this.i(Vec3D.c);
            }
            double d1 = 0.92;
            this.i(this.dA().c(0.92));
            this.ay();
        }
    }

    private boolean a(EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.fh();
        ItemStack itemstack1 = entityhuman.fi();
        boolean flag = itemstack.a(Items.su);
        boolean flag1 = itemstack1.a(Items.su);
        if (!entityhuman.dU() && entityhuman.bO() && (flag || flag1) && this.g(entityhuman) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void l() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) || entity.bO() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        if (!this.ai().C) {
            this.C(movingobjectpositionentity.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        this.i(this.dA().d().c(movingobjectpositionblock.a(this)));
    }

    public void C(@Nullable Entity entity) {
        this.o = entity;
        this.au().a(g, entity == null ? 0 : entity.ar() + 1);
    }

    private void a(BlockPosition blockposition) {
        WorldServer worldserver = (WorldServer)this.ai();
        int i2 = 1;
        BlockPosition blockposition1 = blockposition.d();
        if (this.rainInfluenced && this.ar.i() < 0.25f && this.ai().r(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ar.i() < 0.5f && !this.ai().h(blockposition1)) {
            --i2;
        }
        if (this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                this.k = 0;
                this.l = 0;
                this.au().a(h, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.l > 0) {
            this.l -= i2;
            if (this.l > 0) {
                double d2;
                double d1;
                this.m += (float)this.ar.a(0.0, 9.188);
                float f2 = this.m * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dC() + (double)(f1 * (float)this.l * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dE()) + 1.0f)) - 1.0, d2 = this.dI() + (double)(f22 * (float)this.l * 0.1f)));
                if (iblockdata.a(Blocks.J)) {
                    if (this.ar.i() < 0.15f) {
                        worldserver.a(Particles.d, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.jK, 0.25f, 1.0f + (this.ar.i() - this.ar.i()) * 0.4f);
                double d3 = this.dE() + 0.5;
                worldserver.a(Particles.d, this.dC(), d3, this.dI(), (int)(1.0f + this.ds() * 20.0f), (double)this.ds(), 0.0, (double)this.ds(), (double)0.2f);
                worldserver.a(Particles.E, this.dC(), d3, this.dI(), (int)(1.0f + this.ds() * 20.0f), (double)this.ds(), 0.0, (double)this.ds(), (double)0.2f);
                this.j = MathHelper.a(this.ar, 20, 40);
                this.au().a(h, true);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            float f5 = 0.15f;
            if (this.k < 20) {
                f5 += (float)(20 - this.k) * 0.05f;
            } else if (this.k < 40) {
                f5 += (float)(40 - this.k) * 0.02f;
            } else if (this.k < 60) {
                f5 += (float)(60 - this.k) * 0.01f;
            }
            if (this.ar.i() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.a(this.ar, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.a(this.ar, 25.0f, 60.0f);
                double d4 = this.dC() + (double)(MathHelper.a(f6) * f7) * 0.1;
                IBlockData iblockdata1 = worldserver.a_(BlockPosition.a(d4, (d5 = (double)((float)MathHelper.a(this.dE()) + 1.0f)) - 1.0, d6 = this.dI() + (double)(MathHelper.b(f6) * f7) * 0.1));
                if (iblockdata1.a(Blocks.J)) {
                    worldserver.a(Particles.ap, d4, d5, d6, 2 + this.ar.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.k <= 0) {
                this.m = MathHelper.a(this.ar, this.minLureAngle, this.maxLureAngle);
                this.l = MathHelper.a(this.ar, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.k = MathHelper.a(this.ar, this.minWaitTime, this.maxWaitTime);
            this.k -= this.applyLure ? this.r : 0;
        }
    }

    private boolean b(BlockPosition blockposition) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(blockposition.b(-2, i2, -2), blockposition.b(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition blockposition, BlockPosition blockposition1) {
        return BlockPosition.d(blockposition, blockposition1).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition blockposition) {
        IBlockData iblockdata = this.ai().a_(blockposition);
        if (!iblockdata.l() && !iblockdata.a(Blocks.fF)) {
            Fluid fluid = iblockdata.y();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.g(this.ai(), blockposition).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean e() {
        return this.n;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
    }

    @Override
    protected void a(ValueInput valueinput) {
    }

    public int a(ItemStack itemstack) {
        EntityHuman entityhuman = this.f();
        if (!this.ai().C && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.o != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.o.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.d(this.o);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, Collections.emptyList());
                this.ai().a((Entity)this, (byte)31);
                i2 = this.o instanceof EntityItem ? 3 : 5;
            } else if (this.j > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.ai()).a(LootContextParameters.f, this.dv()).a(LootContextParameters.i, itemstack).a(LootContextParameters.a, this).a((float)this.q + entityhuman.em()).a(LootContextParameterSets.f);
                LootTable loottable = this.ai().q().bc().a(LootTables.am);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    EntityItem entityitem = new EntityItem(this.ai(), this.dC(), this.dE(), this.dI(), itemstack1);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)entityitem.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ar.a(6) + 1);
                    this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dC() - this.dC();
                    double d1 = entityhuman.dE() - this.dE();
                    double d2 = entityhuman.dI() - this.dI();
                    double d3 = 0.1;
                    entityitem.n(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.ai().b(entityitem);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.ai().b(new EntityExperienceOrb(entityhuman.ai(), entityhuman.dC(), entityhuman.dE() + 0.5, entityhuman.dI() + 0.5, playerFishEvent2.getExpToDrop()));
                    }
                    if (!itemstack1.a(TagsItem.bb)) continue;
                    entityhuman.a(StatisticList.S, 1);
                }
                i2 = 1;
            }
            if (this.aK()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte b0) {
        EntityHuman entityhuman;
        Entity entity;
        if (b0 == 31 && this.ai().C && (entity = this.o) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).gq()) {
            this.d(this.o);
        }
        super.b(b0);
    }

    public void d(Entity entity) {
        Entity entity1 = this.ah_();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dC() - this.dC(), entity1.dE() - this.dE(), entity1.dI() - this.dI()).c(0.1);
            entity.i(entity.dA().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission bj() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void av() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook entityfishinghook) {
        EntityHuman entityhuman = this.f();
        if (entityhuman != null) {
            entityhuman.cG = entityfishinghook;
        }
    }

    @Nullable
    public EntityHuman f() {
        EntityHuman entityhuman1;
        Entity entity = this.ah_();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        return entityhuman;
    }

    @Nullable
    public Entity i() {
        return this.o;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.ah_();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? this.ar() : entity.ar());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (this.f() == null) {
            int i2 = packetplayoutspawnentity.p();
            a.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.ai().a(i2), (Object)i2);
            this.discard(null);
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

