/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    private static final boolean a = false;
    private static final boolean b = false;
    @Nullable
    protected EntityReference<Entity> e;
    private boolean c = false;
    private boolean d = false;
    @Nullable
    private Entity f;
    private boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> entitytypes, World world) {
        super(entitytypes, world);
    }

    protected void a(@Nullable EntityReference<Entity> entityreference) {
        this.e = entityreference;
    }

    public void c(@Nullable Entity entity) {
        this.a(entity != null ? new EntityReference<Entity>(entity) : null);
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Override
    @Nullable
    public Entity ah_() {
        return EntityReference.a(this.e, this.ai(), Entity.class);
    }

    public Entity y() {
        return (Entity)MoreObjects.firstNonNull((Object)this.ah_(), (Object)this);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        EntityReference.a(this.e, valueoutput, "Owner");
        if (this.c) {
            valueoutput.a("LeftOwner", true);
        }
        valueoutput.a("HasBeenShot", this.d);
    }

    protected boolean e(Entity entity) {
        return this.e != null && this.e.a(entity);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(EntityReference.a(valueinput, "Owner"));
        this.c = valueinput.a("LeftOwner", false);
        this.d = valueinput.a("HasBeenShot", false);
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)entity;
            this.e = iprojectile.e;
        }
    }

    @Override
    public void g() {
        if (!this.d) {
            this.a(GameEvent.K, this.ah_());
            this.d = true;
        }
        if (!this.c) {
            this.c = this.f();
        }
        super.g();
    }

    private boolean f() {
        Entity entity = this.ah_();
        if (entity != null) {
            AxisAlignedBB axisalignedbb = this.cV().b(this.dA()).g(1.0);
            return entity.dh().dc().filter(IEntitySelector.h).noneMatch(entity1 -> axisalignedbb.c(entity1.cV()));
        }
        return true;
    }

    public Vec3D d(double d0, double d1, double d2, float f2, float f1) {
        return new Vec3D(d0, d1, d2).d().b(this.ar.a(0.0, 0.0172275 * (double)f1), this.ar.a(0.0, 0.0172275 * (double)f1), this.ar.a(0.0, 0.0172275 * (double)f1)).c((double)f2);
    }

    public void c(double d0, double d1, double d2, float f2, float f1) {
        Vec3D vec3d = this.d(d0, d1, d2, f2, f1);
        this.i(vec3d);
        this.aE = true;
        double d3 = vec3d.i();
        this.v((float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.e, d3) * 57.2957763671875));
        this.aa = this.dP();
        this.ab = this.dR();
    }

    public void a(Entity entity, float f2, float f1, float f22, float f3, float f4) {
        float f5 = -MathHelper.a(f1 * ((float)Math.PI / 180)) * MathHelper.b(f2 * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((f2 + f22) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(f1 * ((float)Math.PI / 180)) * MathHelper.b(f2 * ((float)Math.PI / 180));
        this.c(f5, f6, f7, f3, f4);
        Vec3D vec3d = entity.ae();
        this.i(this.dA().b(vec3d.d, entity.aK() ? 0.0 : vec3d.e, vec3d.f));
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        double d0 = flag ? -0.03 : 0.1;
        this.i(this.dA().b(0.0, d0, 0.0));
        IProjectile.a(this.ai(), blockposition);
    }

    @Override
    public void m(boolean flag) {
        double d0 = flag ? -0.03 : 0.06;
        this.i(this.dA().b(0.0, d0, 0.0));
        this.j();
    }

    public static <T extends IProjectile> T a(a<T> iprojectile_a, WorldServer worldserver, ItemStack itemstack, EntityLiving entityliving, float f2, float f1, float f22) {
        return (T)IProjectile.a(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.a(entityliving, entityliving.dR(), entityliving.dP(), f2, f1, f22));
    }

    public static <T extends IProjectile> T a(a<T> iprojectile_a, WorldServer worldserver, ItemStack itemstack, EntityLiving entityliving, double d0, double d1, double d2, float f2, float f1) {
        return (T)IProjectile.a(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.c(d0, d1, d2, f2, f1));
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack, double d0, double d1, double d2, float f2, float f1) {
        return (T)IProjectile.a(t0, worldserver, itemstack, iprojectile -> t0.c(d0, d1, d2, f2, f1));
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack) {
        return (T)IProjectile.a(t0, worldserver, itemstack, iprojectile -> {});
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack, Consumer<T> consumer) {
        consumer.accept(t0);
        if (worldserver.b(t0)) {
            t0.b(worldserver, itemstack);
        }
        return t0;
    }

    public void b(WorldServer worldserver, ItemStack itemstack) {
        EntityArrow entityarrow;
        ItemStack itemstack1;
        EnchantmentManager.a(worldserver, itemstack, this, (Item item) -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (itemstack1 = (entityarrow = (EntityArrow)iProjectile).ed()) != null && !itemstack1.f() && !itemstack.h().equals(itemstack1.h())) {
            Objects.requireNonNull(entityarrow);
            EnchantmentManager.a(worldserver, itemstack1, this, entityarrow::b);
        }
    }

    protected ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.d() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.b(movingobjectposition);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection b(MovingObjectPosition movingobjectposition) {
        ProjectileDeflection projectiledeflection1;
        MovingObjectPositionBlock movingobjectpositionblock;
        if (movingobjectposition.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.a();
            ProjectileDeflection projectiledeflection = entity.a(this);
            if (projectiledeflection != ProjectileDeflection.a) {
                if (entity != this.f && this.a(projectiledeflection, entity, this.ah_(), false)) {
                    this.f = entity;
                }
                return projectiledeflection;
            }
        } else if (this.w() && movingobjectposition instanceof MovingObjectPositionBlock && (movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition).f() && this.a(projectiledeflection1 = ProjectileDeflection.b, (Entity)null, this.ah_(), false)) {
            this.i(this.dA().c(0.2));
            return projectiledeflection1;
        }
        this.a(movingobjectposition);
        return ProjectileDeflection.a;
    }

    protected boolean w() {
        return false;
    }

    public boolean a(ProjectileDeflection projectiledeflection, @Nullable Entity entity, @Nullable Entity entity1, boolean flag) {
        projectiledeflection.deflect(this, entity, this.ar);
        if (!this.ai().C) {
            this.c(entity1);
            this.c(entity, flag);
        }
        return true;
    }

    protected void c(@Nullable Entity entity, boolean flag) {
    }

    protected void b(Item item) {
    }

    protected void a(MovingObjectPosition movingobjectposition) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = movingobjectposition.d();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.a();
            if (entity.ap().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                iprojectile.a(ProjectileDeflection.c, this.ah_(), this.ah_(), true);
            }
            this.a(movingobjectpositionentity);
            this.ai().a(GameEvent.J, movingobjectposition.g(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.b();
            this.ai().a(GameEvent.J, blockposition, GameEvent.a.a(this, this.ai().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
    }

    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.ai().a_(movingobjectpositionblock.b());
        iblockdata.a(this.ai(), iblockdata, movingobjectpositionblock, this);
    }

    protected boolean b(Entity entity) {
        if (!entity.bJ()) {
            return false;
        }
        Entity entity1 = this.ah_();
        return entity1 == null || this.c || !entity1.A(entity);
    }

    protected void z() {
        Vec3D vec3d = this.dA();
        double d0 = vec3d.i();
        this.w(IProjectile.f(this.ab, (float)(MathHelper.d(vec3d.e, d0) * 57.2957763671875)));
        this.v(IProjectile.f(this.aa, (float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875)));
    }

    protected static float f(float f2, float f1) {
        while (f1 - f2 < -180.0f) {
            f2 -= 360.0f;
        }
        while (f1 - f2 >= 180.0f) {
            f2 += 360.0f;
        }
        return MathHelper.h(0.2f, f2, f1);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.ah_();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? 0 : entity.ar());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        Entity entity = this.ai().a(packetplayoutspawnentity.p());
        if (entity != null) {
            this.c(entity);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        Entity entity = this.ah_();
        return entity instanceof EntityHuman ? entity.c(worldserver, blockposition) : entity == null || worldserver.P().c(GameRules.d);
    }

    public boolean a(WorldServer worldserver) {
        return this.ap().a(TagsEntity.g) && worldserver.P().c(GameRules.h);
    }

    @Override
    public boolean bK() {
        return this.ap().a(TagsEntity.H);
    }

    @Override
    public float bV() {
        return this.bK() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = this.dA().d;
        double d1 = this.dA().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    @Override
    public int ca() {
        return 2;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!this.d(damagesource)) {
            this.bG();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }
}

