/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    public static final Codec<Holder<Item>> e = BuiltInRegistries.g.r().validate(var0 -> var0.a(Items.a.e()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)var0));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> f = ByteBufCodecs.b(Registries.N);
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> g = Maps.newHashMap();
    public static final MinecraftKey h = MinecraftKey.b("base_attack_damage");
    public static final MinecraftKey i = MinecraftKey.b("base_attack_speed");
    public static final int j = 64;
    public static final int k = 99;
    public static final int l = 13;
    protected static final int m = 72000;
    private final Holder.c<Item> b = BuiltInRegistries.g.f(this);
    private final DataComponentMap c;
    @Nullable
    private final Item d;
    protected final String n;
    private final FeatureFlagSet o;

    public static int a(Item var0) {
        return var0 == null ? 0 : BuiltInRegistries.g.a(var0);
    }

    public static Item b(int var0) {
        return BuiltInRegistries.g.a(var0);
    }

    @Deprecated
    public static Item a(Block var0) {
        return g.getOrDefault(var0, Items.a);
    }

    public Item(Info var0) {
        String var1;
        this.n = var0.d();
        this.c = var0.a(IChatBaseComponent.c(this.n), var0.e());
        this.d = var0.d;
        this.o = var0.e;
        if (SharedConstants.aZ && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.c<Item> e() {
        return this.b;
    }

    public DataComponentMap f() {
        return this.c;
    }

    public int g() {
        return this.c.a(DataComponents.c, 1);
    }

    public void a(World var0, EntityLiving var1, ItemStack var2, int var3) {
    }

    public void a(EntityItem var0) {
    }

    public void l(ItemStack var0) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean a(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.a(DataComponents.A);
        if (var5 == null) return true;
        if (var5.d()) return true;
        if (!(var4 instanceof EntityHuman)) return true;
        EntityHuman var6 = (EntityHuman)var4;
        if (var6.gt().d) return false;
        return true;
    }

    @Override
    public Item h() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext var0) {
        return EnumInteractionResult.e;
    }

    public float a(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.a(DataComponents.A);
        return var2 != null ? var2.a(var1) : 1.0f;
    }

    public EnumInteractionResult a(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.b(var2);
        Consumable var4 = var3.a(DataComponents.w);
        if (var4 != null) {
            return var4.a(var1, var3, var2);
        }
        Equippable var5 = var3.a(DataComponents.D);
        if (var5 != null && var5.h()) {
            return var5.a(var3, var1);
        }
        BlocksAttacks var6 = var3.a(DataComponents.I);
        if (var6 != null) {
            var1.c(var2);
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.e;
    }

    public ItemStack a(ItemStack var0, World var1, EntityLiving var2) {
        Consumable var3 = var0.a(DataComponents.w);
        if (var3 != null) {
            return var3.a(var1, var2, var0);
        }
        return var0;
    }

    public boolean d(ItemStack var0) {
        return var0.n();
    }

    public int e(ItemStack var0) {
        return MathHelper.a(Math.round(13.0f - (float)var0.o() * 13.0f / (float)var0.p()), 0, 13);
    }

    public int f(ItemStack var0) {
        int var1 = var0.p();
        float var2 = Math.max(0.0f, ((float)var1 - (float)var0.o()) / (float)var1);
        return MathHelper.g(var2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        return false;
    }

    public boolean a(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        return false;
    }

    public float a(Entity var0, float var1, DamageSource var2) {
        return 0.0f;
    }

    @Nullable
    public DamageSource a(EntityLiving var0) {
        return null;
    }

    public void a(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public void b(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public boolean a(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.a(DataComponents.A);
        if (var5 == null) {
            return false;
        }
        if (!var1.C && var2.e(var1, var3) != 0.0f && var5.c() > 0) {
            var0.a(var5.c(), var4, EnumItemSlot.a);
        }
        return true;
    }

    public boolean b(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.a(DataComponents.A);
        return var2 != null && var2.b(var1);
    }

    public EnumInteractionResult a(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        return EnumInteractionResult.e;
    }

    public String toString() {
        return BuiltInRegistries.g.e(this).g();
    }

    public final ItemStack i() {
        return this.d == null ? ItemStack.l : new ItemStack(this.d);
    }

    public void a(ItemStack var0, WorldServer var1, Entity var2, @Nullable EnumItemSlot var3) {
    }

    public void c(ItemStack var0, EntityHuman var1) {
        this.a(var0, var1.ai());
    }

    public void a(ItemStack var0, World var1) {
    }

    public ItemUseAnimation b(ItemStack var0) {
        Consumable var1 = var0.a(DataComponents.w);
        if (var1 != null) {
            return var1.d();
        }
        BlocksAttacks var2 = var0.a(DataComponents.I);
        if (var2 != null) {
            return ItemUseAnimation.d;
        }
        return ItemUseAnimation.a;
    }

    public int a(ItemStack var0, EntityLiving var1) {
        Consumable var2 = var0.a(DataComponents.w);
        if (var2 != null) {
            return var2.a();
        }
        BlocksAttacks var3 = var0.a(DataComponents.I);
        if (var3 != null) {
            return 72000;
        }
        return 0;
    }

    public boolean a(ItemStack var0, World var1, EntityLiving var2, int var3) {
        return false;
    }

    @Deprecated
    public void a(ItemStack var0, b var1, TooltipDisplay var2, Consumer<IChatBaseComponent> var3, TooltipFlag var4) {
    }

    public Optional<TooltipComponent> k(ItemStack var0) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String j() {
        return this.n;
    }

    public final IChatBaseComponent l() {
        return this.c.a(DataComponents.h, CommonComponents.a);
    }

    public IChatBaseComponent a(ItemStack var0) {
        return var0.a().a(DataComponents.h, CommonComponents.a);
    }

    public boolean d_(ItemStack var0) {
        return var0.F();
    }

    protected static MovingObjectPositionBlock a(World var0, EntityHuman var1, RayTrace.FluidCollisionOption var2) {
        Vec3D var3 = var1.bI();
        Vec3D var4 = var3.e(var1.d(var1.dR(), var1.dP()).c(var1.gV()));
        return var0.a(new RayTrace(var3, var4, RayTrace.BlockCollisionOption.b, var2, var1));
    }

    public boolean e_(ItemStack var0) {
        return false;
    }

    public ItemStack m() {
        return new ItemStack(this);
    }

    public boolean d() {
        return true;
    }

    @Override
    public FeatureFlagSet k() {
        return this.o;
    }

    public boolean a(ItemStack var0, @Nullable EntityHuman var1) {
        return false;
    }

    public static class Info {
        private static final DependantName<Item, String> a = var0 -> SystemUtils.a("block", var0.a());
        private static final DependantName<Item, String> b = var0 -> SystemUtils.a("item", var0.a());
        private final DataComponentMap.a c = DataComponentMap.a().a(DataComponents.aT);
        @Nullable
        Item d;
        FeatureFlagSet e = FeatureFlags.g;
        @Nullable
        private ResourceKey<Item> f;
        private DependantName<Item, String> g = b;
        private DependantName<Item, MinecraftKey> h = ResourceKey::a;

        public Info a(FoodInfo var0) {
            return this.a(var0, Consumables.a);
        }

        public Info a(FoodInfo var0, Consumable var1) {
            return this.a(DataComponents.v, var0).a(DataComponents.w, var1);
        }

        public Info a(Item var0) {
            return this.a(DataComponents.x, new UseRemainder(new ItemStack(var0)));
        }

        public Info a(float var0) {
            return this.a(DataComponents.y, new UseCooldown(var0));
        }

        public Info a(int var0) {
            return this.a(DataComponents.c, var0);
        }

        public Info b(int var0) {
            this.a(DataComponents.d, var0);
            this.a(DataComponents.c, 1);
            this.a(DataComponents.e, 0);
            return this;
        }

        public Info b(Item var0) {
            this.d = var0;
            return this;
        }

        public Info a(EnumItemRarity var0) {
            return this.a(DataComponents.k, var0);
        }

        public Info a() {
            return this.a(DataComponents.z, new DamageResistant(DamageTypeTags.i));
        }

        public Info a(ResourceKey<JukeboxSong> var0) {
            return this.a(DataComponents.ae, new JukeboxPlayable(new EitherHolder<JukeboxSong>(var0)));
        }

        public Info c(int var0) {
            return this.a(DataComponents.C, new Enchantable(var0));
        }

        public Info c(Item var0) {
            return this.a(DataComponents.E, new Repairable(HolderSet.a(var0.e())));
        }

        public Info a(TagKey<Item> var0) {
            HolderGetter<Item> var1 = BuiltInRegistries.a(BuiltInRegistries.g);
            return this.a(DataComponents.E, new Repairable(var1.b(var0)));
        }

        public Info a(EnumItemSlot var0) {
            return this.a(DataComponents.D, Equippable.a(var0).a());
        }

        public Info b(EnumItemSlot var0) {
            return this.a(DataComponents.D, Equippable.a(var0).b(false).a());
        }

        public Info a(ToolMaterial var0, TagKey<Block> var1, float var2, float var3, float var4) {
            return var0.a(this, var1, var2, var3, var4);
        }

        public Info a(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bG, var1, var2, 0.0f);
        }

        public Info b(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bE, var1, var2, 5.0f);
        }

        public Info c(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bF, var1, var2, 0.0f);
        }

        public Info d(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bH, var1, var2, 0.0f);
        }

        public Info e(ToolMaterial var0, float var1, float var2) {
            return var0.a(this, var1, var2);
        }

        public Info a(ArmorMaterial var0, ArmorType var1) {
            return this.b(var1.a(var0.a())).a(var0.a(var1)).c(var0.c()).a(DataComponents.D, Equippable.a(var1.a()).a(var0.d()).a(var0.h()).a()).a(var0.g());
        }

        public Info a(ArmorMaterial var0) {
            return this.b(ArmorType.e.a(var0.a())).a(var0.a(ArmorType.e)).a(var0.g()).a(DataComponents.D, Equippable.a(EnumItemSlot.g).a(var0.d()).a(var0.h()).a(HolderSet.a(EntityTypes.bO.r())).e(true).b(BuiltInRegistries.b.e(SoundEffects.az)).a()).a(DataComponents.au, SoundEffects.El).a(1);
        }

        public Info b(ArmorMaterial var0) {
            HolderGetter<EntityTypes<?>> var1 = BuiltInRegistries.a(BuiltInRegistries.f);
            return this.a(var0.a(ArmorType.e)).a(DataComponents.D, Equippable.a(EnumItemSlot.g).a(SoundEffects.nF).a(var0.h()).a(var1.b(TagsEntity.L)).c(false).e(true).b(SoundEffects.nG).a()).a(1);
        }

        public Info b(ResourceKey<TrimMaterial> var0) {
            return this.a(DataComponents.ac, new ProvidesTrimMaterial(var0));
        }

        public Info a(FeatureFlag ... var0) {
            this.e = FeatureFlags.e.a(var0);
            return this;
        }

        public Info c(ResourceKey<Item> var0) {
            this.f = var0;
            return this;
        }

        public Info a(String var0) {
            this.g = DependantName.fixed(var0);
            return this;
        }

        public Info b() {
            this.g = a;
            return this;
        }

        public Info c() {
            this.g = b;
            return this;
        }

        protected String d() {
            return this.g.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public MinecraftKey e() {
            return this.h.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public <T> Info a(DataComponentType<T> var0, T var1) {
            this.c.a(var0, var1);
            return this;
        }

        public Info a(ItemAttributeModifiers var0) {
            return this.a(DataComponents.o, var0);
        }

        DataComponentMap a(IChatBaseComponent var0, MinecraftKey var1) {
            DataComponentMap var2 = this.c.a(DataComponents.h, var0).a(DataComponents.i, var1).a();
            if (var2.c(DataComponents.e) && var2.a(DataComponents.c, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return var2;
        }
    }

    public static interface b {
        public static final b a = new b(){

            @Override
            @Nullable
            public HolderLookup.a a() {
                return null;
            }

            @Override
            public float b() {
                return 20.0f;
            }

            @Override
            @Nullable
            public WorldMap a(MapId var0) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.a a();

        public float b();

        @Nullable
        public WorldMap a(MapId var1);

        public static b a(final @Nullable World var0) {
            if (var0 == null) {
                return a;
            }
            return new b(){

                @Override
                public HolderLookup.a a() {
                    return var0.K_();
                }

                @Override
                public float b() {
                    return var0.v().f();
                }

                @Override
                public WorldMap a(MapId var02) {
                    return var0.a(var02);
                }
            };
        }

        public static b a(final HolderLookup.a var0) {
            return new b(){

                @Override
                public HolderLookup.a a() {
                    return var0;
                }

                @Override
                public float b() {
                    return 20.0f;
                }

                @Override
                @Nullable
                public WorldMap a(MapId var02) {
                    return null;
                }
            };
        }
    }
}

