/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockAccess
extends LevelHeightAccessor {
    public static final int g = 16;

    @Nullable
    public TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition blockposition, TileEntityTypes<T> tileentitytypes) {
        TileEntity tileentity = this.c_(blockposition);
        return tileentity != null && tileentity.q() == tileentitytypes ? Optional.of(tileentity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int i(BlockPosition blockposition) {
        return this.a_(blockposition).k();
    }

    default public Stream<IBlockData> a(AxisAlignedBB axisalignedbb) {
        return BlockPosition.b(axisalignedbb).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext clipblockstatecontext) {
        return IBlockAccess.a(clipblockstatecontext.b(), clipblockstatecontext.a(), clipblockstatecontext, (C clipblockstatecontext1, BlockPosition blockposition) -> {
            IBlockData iblockdata = this.a_((BlockPosition)blockposition);
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return clipblockstatecontext1.c().test(iblockdata) ? new MovingObjectPositionBlock(clipblockstatecontext1.a(), EnumDirection.a(vec3d.d, vec3d.e, vec3d.f), BlockPosition.a(clipblockstatecontext1.a()), false) : null;
        }, (C clipblockstatecontext1) -> {
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return MovingObjectPositionBlock.a(clipblockstatecontext1.a(), EnumDirection.a(vec3d.d, vec3d.e, vec3d.f), BlockPosition.a(clipblockstatecontext1.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace raytrace1, BlockPosition blockposition) {
        IBlockData iblockdata = this.a_(blockposition);
        Fluid fluid = this.b_(blockposition);
        Vec3D vec3d = raytrace1.b();
        Vec3D vec3d1 = raytrace1.a();
        VoxelShape voxelshape = raytrace1.a(iblockdata, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock = this.a(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.a(fluid, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock1 = voxelshape1.a(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock.g());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock1.g());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public MovingObjectPositionBlock a(RayTrace raytrace) {
        return IBlockAccess.a(raytrace.b(), raytrace.a(), raytrace, (C raytrace1, BlockPosition blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition), (C raytrace1) -> {
            Vec3D vec3d = raytrace1.b().d(raytrace1.a());
            return MovingObjectPositionBlock.a(raytrace1.a(), EnumDirection.a(vec3d.d, vec3d.e, vec3d.f), BlockPosition.a(raytrace1.a()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock a(Vec3D vec3d, Vec3D vec3d1, BlockPosition blockposition, VoxelShape voxelshape, IBlockData iblockdata) {
        MovingObjectPositionBlock movingobjectpositionblock1;
        MovingObjectPositionBlock movingobjectpositionblock = voxelshape.a(vec3d, vec3d1, blockposition);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = iblockdata.i(this, blockposition).a(vec3d, vec3d1, blockposition)) != null && movingobjectpositionblock1.g().d(vec3d).h() < movingobjectpositionblock.g().d(vec3d).h()) {
            return movingobjectpositionblock.a(movingobjectpositionblock1.c());
        }
        return movingobjectpositionblock;
    }

    default public double a(VoxelShape voxelshape, Supplier<VoxelShape> supplier) {
        if (!voxelshape.c()) {
            return voxelshape.c(EnumDirection.EnumAxis.b);
        }
        double d0 = supplier.get().c(EnumDirection.EnumAxis.b);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double j(BlockPosition blockposition) {
        return this.a(this.a_(blockposition).g(this, blockposition), () -> {
            BlockPosition blockposition1 = blockposition.e();
            return this.a_(blockposition1).g(this, blockposition1);
        });
    }

    public static <T, C> T a(Vec3D vec3d, Vec3D vec3d1, C c0, BiFunction<C, BlockPosition, T> bifunction, Function<C, T> function) {
        int k2;
        int j2;
        if (vec3d.equals(vec3d1)) {
            return function.apply(c0);
        }
        double d0 = MathHelper.d(-1.0E-7, vec3d1.d, vec3d.d);
        double d1 = MathHelper.d(-1.0E-7, vec3d1.e, vec3d.e);
        double d2 = MathHelper.d(-1.0E-7, vec3d1.f, vec3d.f);
        double d3 = MathHelper.d(-1.0E-7, vec3d.d, vec3d1.d);
        double d4 = MathHelper.d(-1.0E-7, vec3d.e, vec3d1.e);
        double d5 = MathHelper.d(-1.0E-7, vec3d.f, vec3d1.f);
        int i2 = MathHelper.a(d3);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, j2 = MathHelper.a(d4), k2 = MathHelper.a(d5));
        T t0 = bifunction.apply(c0, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l2 = MathHelper.j(d6);
        int i1 = MathHelper.j(d7);
        int j1 = MathHelper.j(d8);
        double d9 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l2 > 0 ? 1.0 - MathHelper.e(d3) : MathHelper.e(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.e(d4) : MathHelper.e(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - MathHelper.e(d5) : MathHelper.e(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i2 += l2;
                    d12 += d9;
                } else {
                    k2 += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j2 += i1;
                d13 += d10;
            } else {
                k2 += j1;
                d14 += d11;
            }
            if ((t1 = bifunction.apply(c0, blockposition_mutableblockposition.d(i2, j2, k2))) == null) continue;
            return t1;
        }
        return function.apply(c0);
    }

    public static boolean a(Vec3D vec3d, Vec3D vec3d1, AxisAlignedBB axisalignedbb, a iblockaccess_a) {
        Vec3D vec3d2 = vec3d1.d(vec3d);
        if (vec3d2.h() < (double)MathHelper.l(0.99999f)) {
            for (BlockPosition blockposition : BlockPosition.a(axisalignedbb)) {
                if (iblockaccess_a.visit(blockposition, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet longset = new LongOpenHashSet();
        Vec3D vec3d3 = axisalignedbb.h();
        Vec3D vec3d4 = vec3d3.d(vec3d2);
        int i2 = IBlockAccess.a((LongSet)longset, vec3d4, vec3d3, axisalignedbb, iblockaccess_a);
        if (i2 < 0) {
            return false;
        }
        for (BlockPosition blockposition1 : BlockPosition.a(axisalignedbb)) {
            if (longset.contains(blockposition1.a()) || iblockaccess_a.visit(blockposition1, i2 + 1)) continue;
            return false;
        }
        return true;
    }

    private static int a(LongSet longset, Vec3D vec3d, Vec3D vec3d1, AxisAlignedBB axisalignedbb, a iblockaccess_a) {
        Vec3D vec3d2 = vec3d1.d(vec3d);
        int i2 = MathHelper.a(vec3d.d);
        int j2 = MathHelper.a(vec3d.e);
        int k2 = MathHelper.a(vec3d.f);
        int l2 = MathHelper.j(vec3d2.d);
        int i1 = MathHelper.j(vec3d2.e);
        int j1 = MathHelper.j(vec3d2.f);
        double d0 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / vec3d2.d;
        double d1 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / vec3d2.e;
        double d2 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / vec3d2.f;
        double d3 = d0 * (l2 > 0 ? 1.0 - MathHelper.e(vec3d.d) : MathHelper.e(vec3d.d));
        double d4 = d1 * (i1 > 0 ? 1.0 - MathHelper.e(vec3d.e) : MathHelper.e(vec3d.e));
        double d5 = d2 * (j1 > 0 ? 1.0 - MathHelper.e(vec3d.f) : MathHelper.e(vec3d.f));
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        while (d3 <= 1.0 || d4 <= 1.0 || d5 <= 1.0) {
            if (d3 < d4) {
                if (d3 < d5) {
                    i2 += l2;
                    d3 += d0;
                } else {
                    k2 += j1;
                    d5 += d2;
                }
            } else if (d4 < d5) {
                j2 += i1;
                d4 += d1;
            } else {
                k2 += j1;
                d5 += d2;
            }
            if (k1++ > 16) break;
            Optional<Vec3D> optional = AxisAlignedBB.a(i2, j2, k2, i2 + 1, j2 + 1, k2 + 1, vec3d, vec3d1);
            if (optional.isEmpty()) continue;
            Vec3D vec3d3 = optional.get();
            double d6 = MathHelper.a(vec3d3.d, (double)i2 + (double)1.0E-5f, (double)i2 + 1.0 - (double)1.0E-5f);
            double d7 = MathHelper.a(vec3d3.e, (double)j2 + (double)1.0E-5f, (double)j2 + 1.0 - (double)1.0E-5f);
            double d8 = MathHelper.a(vec3d3.f, (double)k2 + (double)1.0E-5f, (double)k2 + 1.0 - (double)1.0E-5f);
            int l1 = MathHelper.a(d6 + axisalignedbb.b());
            int i22 = MathHelper.a(d7 + axisalignedbb.c());
            int j22 = MathHelper.a(d8 + axisalignedbb.d());
            for (int k22 = i2; k22 <= l1; ++k22) {
                for (int l22 = j2; l22 <= i22; ++l22) {
                    for (int i3 = k2; i3 <= j22; ++i3) {
                        if (!longset.add(BlockPosition.a(k22, l22, i3)) || iblockaccess_a.visit(blockposition_mutableblockposition.d(k22, l22, i3), k1)) continue;
                        return -1;
                    }
                }
            }
        }
        return k1;
    }

    @FunctionalInterface
    public static interface a {
        public boolean visit(BlockPosition var1, int var2);
    }
}

