/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
UUIDLookup<Entity>,
AutoCloseable {
    public static final Codec<ResourceKey<World>> h = ResourceKey.a(Registries.bu);
    public static final ResourceKey<World> i = ResourceKey.a(Registries.bu, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.bu, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> k = ResourceKey.a(Registries.bu, MinecraftKey.b("the_end"));
    public static final int l = 30000000;
    public static final int m = 512;
    public static final int n = 32;
    public static final int o = 15;
    public static final int p = 24000;
    public static final int q = 20000000;
    public static final int r = -20000000;
    protected final List<TickingBlockEntity> s = Lists.newArrayList();
    protected final NeighborUpdater t;
    private final List<TickingBlockEntity> a = Lists.newArrayList();
    private boolean b;
    public final Thread c;
    private final boolean d;
    private int e;
    protected int u = RandomSource.a().f();
    protected final int v = 1013904223;
    protected float w;
    public float x;
    protected float y;
    public float z;
    public final RandomSource A = RandomSource.a();
    @Deprecated
    private final RandomSource f = RandomSource.b();
    private final Holder<DimensionManager> E;
    public final WorldDataMutable B;
    public final boolean C;
    private final WorldBorder F;
    private final BiomeManager G;
    private final ResourceKey<World> H;
    private final IRegistryCustom I;
    private final DamageSources J;
    private long K;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).e());
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.B = worlddatamutable;
        this.E = holder;
        DimensionManager dimensionmanager = holder.a();
        this.H = resourcekey;
        this.C = flag;
        this.F = dimensionmanager.k() != 1.0 ? new WorldBorder(this){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.c = Thread.currentThread();
        this.G = new BiomeManager(this, i2);
        this.d = flag1;
        this.t = new CollectingNeighborUpdater(this, j2);
        this.I = iregistrycustom;
        this.J = new DamageSources(iregistrycustom);
        this.F_().world = (WorldServer)this;
        this.F_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean B_() {
        return this.C;
    }

    @Override
    @Nullable
    public MinecraftServer q() {
        return null;
    }

    public boolean k(BlockPosition blockposition) {
        return !this.u(blockposition) && World.g(blockposition);
    }

    public static boolean l(BlockPosition blockposition) {
        return !World.b(blockposition.v()) && World.g(blockposition);
    }

    private static boolean g(BlockPosition blockposition) {
        return blockposition.u() >= -30000000 && blockposition.w() >= -30000000 && blockposition.u() < 30000000 && blockposition.w() < 30000000;
    }

    private static boolean b(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk m(BlockPosition blockposition) {
        return this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public Chunk d(int i2, int j2) {
        return (Chunk)this.a(i2, j2, ChunkStatus.n);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.T().a(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        return this.a(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.j(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i2);
            return true;
        }
        if (this.u(blockposition)) {
            return false;
        }
        if (!this.C && this.ak()) {
            return false;
        }
        Chunk chunk = this.m(blockposition);
        Block block = iblockdata.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.j(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.a(blockposition, iblockdata, i2)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.C || (i2 & 4) == 0) && (this.C || chunk == null || chunk.G() != null && chunk.G().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.a(blockposition, iblockdata1.b());
                if (!this.C && iblockdata.q()) {
                    this.b(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b(this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b(this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.b_(blockposition);
        return this.a(blockposition, fluid.g(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.l()) {
            return false;
        }
        Fluid fluid = this.b_(blockposition);
        if (!(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, blockposition, Block.j(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.x() ? this.c_(blockposition) : null;
            Block.a(iblockdata, this, blockposition, tileentity, entity, ItemStack.l);
        }
        if (flag1 = this.a(blockposition, fluid.g(), 3, i2)) {
            this.a(GameEvent.f, blockposition, GameEvent.a.a(entity, iblockdata));
        }
        return flag1;
    }

    public void b(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void a(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection, @Nullable Orientation orientation) {
    }

    public void b(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    @Override
    public void a(EnumDirection enumdirection, BlockPosition blockposition, BlockPosition blockposition1, IBlockData iblockdata, int i2, int j2) {
        this.t.a(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.b(SectionPosition.a(i2), SectionPosition.a(j2)) ? this.d(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.L_()) : this.Q() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine C_() {
        return this.T().q();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.u(blockposition)) {
            return Blocks.nI.m();
        }
        Chunk chunk = this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
        return chunk.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        if (this.u(blockposition)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.m(blockposition);
        return chunk.b_(blockposition);
    }

    public boolean W() {
        return !this.G_().a() && this.e < 4;
    }

    public boolean X() {
        return !this.G_().a() && !this.W();
    }

    public boolean Y() {
        if (!this.G_().j()) {
            return false;
        }
        int i2 = (int)(this.af() % 24000L);
        return i2 >= 12600 && i2 <= 23400;
    }

    @Override
    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void a(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.a(entity, d0, d1, d2, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void a(@Nullable Entity var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.f.g());
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, holder, soundcategory, f2, f1, this.f.g());
    }

    public void a(@Nullable Entity entity, Entity entity1, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, entity1, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, this.f.g());
    }

    public void a(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void a(Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    public void a(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, boolean flag1, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float a(float f2) {
        float f1 = this.f(f2);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity tickingblockentity) {
        (this.b ? this.a : this.s).add(tickingblockentity);
    }

    protected void Z() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.b = true;
        if (!this.a.isEmpty()) {
            this.s.addAll(this.a);
            this.a.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        boolean flag = this.v().i();
        this.tileLimiter.initTick();
        for (int tilesThisCycle = 0; tilesThisCycle < this.s.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue()); ++tilesThisCycle) {
            this.tileTickPosition = this.tileTickPosition < this.s.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.s.get(this.tileTickPosition);
            if (tickingblockentity.b()) {
                --tilesThisCycle;
                this.s.remove(this.tileTickPosition--);
            } else if (flag && this.n(tickingblockentity.c())) {
                tickingblockentity.a();
            }
            ++this.tileTickPosition;
        }
        this.timings.tileEntityTick.stopTiming();
        this.b = false;
        gameprofilerfiller.c();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void a(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being ticked");
            t0.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean h(Entity entity) {
        return true;
    }

    public boolean a(long i2) {
        return true;
    }

    public boolean n(BlockPosition blockposition) {
        return this.a(ChunkCoordIntPair.a(blockposition));
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, false, world_a, Particles.w, Particles.v, SoundEffects.kR);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, flag, world_a, Particles.w, Particles.v, SoundEffects.kR);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, vec3d.a(), vec3d.b(), vec3d.c(), f2, flag, world_a, Particles.w, Particles.v, SoundEffects.kR);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, Particles.w, Particles.v, SoundEffects.kR);
    }

    public abstract void a(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, Holder<SoundEffect> var15);

    public abstract String K();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.u(blockposition) ? null : (!this.C && Thread.currentThread() != this.c ? null : this.m(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.aA_();
        if (!this.u(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.j(), tileentity);
                return;
            }
            this.m(blockposition).b(tileentity);
        }
    }

    public void o(BlockPosition blockposition) {
        if (!this.u(blockposition)) {
            this.m(blockposition).d(blockposition);
        }
    }

    public boolean p(BlockPosition blockposition) {
        return this.u(blockposition) ? false : this.T().b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public boolean a(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (this.u(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(blockposition).a((IBlockAccess)this, blockposition, entity, enumdirection);
    }

    public boolean a(BlockPosition blockposition, Entity entity) {
        return this.a(blockposition, entity, EnumDirection.b);
    }

    public void aa() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.e = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void a(boolean flag) {
        this.T().b(flag);
    }

    public BlockPosition ab() {
        BlockPosition blockposition = this.B.a();
        if (!this.F_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, BlockPosition.a(this.F_().a(), 0.0, this.F_().b()));
        }
        return blockposition;
    }

    public float ac() {
        return this.B.b();
    }

    protected void ad() {
        if (!this.G_().g()) {
            return;
        }
        if (this.B.i()) {
            this.x = 1.0f;
            if (this.B.g()) {
                this.z = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.T().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.n, false);
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList list = Lists.newArrayList();
        this.I().a(axisalignedbb, (T entity1) -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
        });
        for (EntityComplexPart entitycomplexpart : this.t()) {
            if (entitycomplexpart == entity || entitycomplexpart.a == entity || !predicate.test(entitycomplexpart) || !axisalignedbb.c(entitycomplexpart.cV())) continue;
            list.add(entitycomplexpart);
        }
        return list;
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        Profiler.a().f("getEntities");
        this.I().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.t()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i2) continue;
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<Entity> i(Entity entity, AxisAlignedBB axisalignedbb) {
        return this.a(entity, axisalignedbb, IEntitySelector.a(entity));
    }

    @Nullable
    public abstract Entity a(int var1);

    @Nullable
    public Entity b(UUID uuid) {
        return this.I().a(uuid);
    }

    public abstract Collection<EntityComplexPart> t();

    public void q(BlockPosition blockposition) {
        if (this.D(blockposition)) {
            this.m(blockposition).i();
        }
    }

    public void b(TileEntity tileentity) {
    }

    public long ae() {
        return this.B.c();
    }

    public long af() {
        return this.B.d();
    }

    public boolean a(Entity entity, BlockPosition blockposition) {
        return true;
    }

    public void a(Entity entity, byte b0) {
    }

    public void a(Entity entity, DamageSource damagesource) {
    }

    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.a_(blockposition).a(this, blockposition, i2, j2);
    }

    @Override
    public WorldData D_() {
        return this.B;
    }

    public abstract TickRateManager v();

    public float b(float f2) {
        return MathHelper.h(f2, this.y, this.z) * this.d(f2);
    }

    public void c(float f2) {
        float f1;
        this.y = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.z = f1;
    }

    public float d(float f2) {
        return MathHelper.h(f2, this.w, this.x);
    }

    public void e(float f2) {
        float f1;
        this.w = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.x = f1;
    }

    private boolean a() {
        return this.G_().g() && !this.G_().h();
    }

    public boolean ag() {
        return this.a() && (double)this.b(1.0f) > 0.9;
    }

    public boolean ah() {
        return this.a() && (double)this.d(1.0f) > 0.2;
    }

    public boolean r(BlockPosition blockposition) {
        return this.s(blockposition) == BiomeBase.Precipitation.b;
    }

    public BiomeBase.Precipitation s(BlockPosition blockposition) {
        if (!this.ah()) {
            return BiomeBase.Precipitation.a;
        }
        if (!this.h(blockposition)) {
            return BiomeBase.Precipitation.a;
        }
        if (this.a(HeightMap.Type.e, blockposition).v() > blockposition.v()) {
            return BiomeBase.Precipitation.a;
        }
        BiomeBase biomebase = this.v(blockposition).a();
        return biomebase.a(blockposition, this.Q());
    }

    @Nullable
    public abstract WorldMap a(MapId var1);

    public void b(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            List<? extends EntityHuman> list = this.A();
            int i2 = list.size();
            return i2 + " total; " + list.stream().map(EntityHuman::hb).collect(Collectors.joining(", "));
        });
        IChunkProvider ichunkprovider = this.T();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.aj().a().toString());
        try {
            this.B.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard S();

    public void b(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (!this.D(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.hz)) {
                this.a(iblockdata, blockposition1, block, (Orientation)null, false);
                continue;
            }
            if (!iblockdata.d(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.hz)) continue;
            this.a(iblockdata, blockposition1, block, (Orientation)null, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.D(blockposition)) {
            f2 = this.as();
            i2 = this.m(blockposition).w();
        }
        return new DifficultyDamageScaler(this.an(), this.af(), i2, f2);
    }

    @Override
    public int E_() {
        return this.e;
    }

    public void c(int i2) {
    }

    @Override
    public WorldBorder F_() {
        return this.F;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager G_() {
        return this.E.a();
    }

    public Holder<DimensionManager> ai() {
        return this.E;
    }

    public ResourceKey<World> aj() {
        return this.H;
    }

    @Override
    public RandomSource H_() {
        return this.A;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    public abstract RecipeAccess R();

    public BlockPosition a(int i2, int j2, int k2, int l2) {
        this.u = this.u * 3 + 1013904223;
        int i1 = this.u >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean w() {
        return false;
    }

    @Override
    public BiomeManager I_() {
        return this.G;
    }

    public final boolean ak() {
        return this.d;
    }

    public abstract LevelEntityGetter<Entity> I();

    @Override
    public long J_() {
        return this.K++;
    }

    @Override
    public IRegistryCustom K_() {
        return this.I;
    }

    public DamageSources al() {
        return this.J;
    }

    public abstract PotionBrewer M();

    public abstract FuelValues N();

    public int t(BlockPosition blockposition) {
        return 0;
    }

    public static enum a implements INamable
    {
        a("none"),
        b("block"),
        c("mob"),
        d("tnt"),
        e("trigger"),
        STANDARD("standard");

        public static final Codec<a> f;
        private final String g;

        private a(String s2) {
            this.g = s2;
        }

        @Override
        public String c() {
            return this.g;
        }

        static {
            f = INamable.a(a::values);
        }
    }
}

