/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    public static final MapCodec<BigDripleafBlock> a = BigDripleafBlock.b(BigDripleafBlock::new);
    private static final BlockStateBoolean b = BlockProperties.I;
    private static final BlockStateEnum<Tilt> c = BlockProperties.bp;
    private static final int d = -1;
    private static final Object2IntMap<Tilt> e = (Object2IntMap)SystemUtils.a(new Object2IntArrayMap(), (? super T object2intarraymap) -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.b, 10);
        object2intarraymap.put((Object)Tilt.c, 10);
        object2intarraymap.put((Object)Tilt.d, 100);
    });
    private static final int g = 5;
    private static final int h = 11;
    private static final int i = 13;
    private static final Map<Tilt, VoxelShape> D = Maps.newEnumMap(Map.of(Tilt.a, Block.b(16.0, 11.0, 15.0), Tilt.b, Block.b(16.0, 11.0, 15.0), Tilt.c, Block.b(16.0, 11.0, 13.0), Tilt.d, VoxelShapes.a()));
    private final Function<IBlockData, VoxelShape> R;

    public MapCodec<BigDripleafBlock> a() {
        return a;
    }

    protected BigDripleafBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, false)).b(f, EnumDirection.c)).b(c, Tilt.a));
        this.R = this.q();
    }

    private Function<IBlockData, VoxelShape> q() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.b(6.0, 0.0, 13.0).a(0.0, 0.0, 0.25).d());
        return this.a((IBlockData iblockdata) -> VoxelShapes.a(D.get(iblockdata.c(c)), (VoxelShape)map.get(iblockdata.c(f))), b);
    }

    public static void a(GeneratorAccess generatoraccess, RandomSource randomsource, BlockPosition blockposition, EnumDirection enumdirection) {
        int j2;
        int i2 = MathHelper.a(randomsource, 2, 5);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (j2 = 0; j2 < i2 && BigDripleafBlock.a((LevelHeightAccessor)generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.a_(blockposition_mutableblockposition)); ++j2) {
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        int k2 = blockposition.v() + j2 - 1;
        blockposition_mutableblockposition.q(blockposition.v());
        while (blockposition_mutableblockposition.v() < k2) {
            BigDripleafStemBlock.a(generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.b_(blockposition_mutableblockposition), enumdirection);
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        BigDripleafBlock.a(generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.b_(blockposition_mutableblockposition), enumdirection);
    }

    private static boolean o(IBlockData iblockdata) {
        return iblockdata.l() || iblockdata.a(Blocks.J) || iblockdata.a(Blocks.tq);
    }

    protected static boolean a(LevelHeightAccessor levelheightaccessor, BlockPosition blockposition, IBlockData iblockdata) {
        return !levelheightaccessor.u(blockposition) && BigDripleafBlock.o(iblockdata);
    }

    protected static boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition, Fluid fluid, EnumDirection enumdirection) {
        IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.to.m().b(b, fluid.a(FluidTypes.c))).b(f, enumdirection);
        return generatoraccess.a(blockposition, iblockdata, 3);
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        this.setTiltAndScheduleTick(iblockdata, world, movingobjectpositionblock.b(), Tilt.d, SoundEffects.ii, iprojectile);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(b) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata1 = iworldreader.a_(blockposition1);
        return iblockdata1.a(this) || iblockdata1.a(Blocks.tp) || iblockdata1.a(TagsBlock.bC);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (enumdirection == EnumDirection.a && !iblockdata.a(iworldreader, blockposition)) {
            return Blocks.a.m();
        }
        if (iblockdata.c(b).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return enumdirection == EnumDirection.b && iblockdata1.a(this) ? Blocks.tp.m(iblockdata) : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public boolean a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = iworldreader.a_(blockposition.d());
        return BigDripleafBlock.o(iblockdata1);
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1;
        BlockPosition blockposition1 = blockposition.d();
        if (BigDripleafBlock.a((LevelHeightAccessor)worldserver, blockposition1, iblockdata1 = worldserver.a_(blockposition1))) {
            EnumDirection enumdirection = (EnumDirection)iblockdata.c(f);
            BigDripleafStemBlock.a((GeneratorAccess)worldserver, blockposition, iblockdata.y(), enumdirection);
            BigDripleafBlock.a((GeneratorAccess)worldserver, blockposition1, iblockdata1.y(), enumdirection);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (!world.C && iblockdata.c(c) == Tilt.a && BigDripleafBlock.a(blockposition, entity) && !world.E(blockposition)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(iblockdata, world, blockposition, Tilt.b, null, entity);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.E(blockposition)) {
            BigDripleafBlock.d(iblockdata, worldserver, blockposition);
        } else {
            Tilt tilt = iblockdata.c(c);
            if (tilt == Tilt.b) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.c, SoundEffects.ii, null);
            } else if (tilt == Tilt.c) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.d, SoundEffects.ii, null);
            } else if (tilt == Tilt.d) {
                BigDripleafBlock.d(iblockdata, worldserver, blockposition);
            }
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (world.E(blockposition)) {
            BigDripleafBlock.d(iblockdata, world, blockposition);
        }
    }

    private static void a(World world, BlockPosition blockposition, SoundEffect soundeffect) {
        float f2 = MathHelper.b(world.A, 0.8f, 1.2f);
        world.a((net.minecraft.world.entity.Entity)null, blockposition, soundeffect, SoundCategory.e, 1.0f, f2);
    }

    private static boolean a(BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        return entity.aK() && entity.dv().e > (double)((float)blockposition.v() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable SoundEffect soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i2;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.a(world, blockposition, soundeffect);
        }
        if ((i2 = e.getInt((Object)tilt)) != -1) {
            world.a(blockposition, (Block)this, i2);
        }
    }

    private static void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        BigDripleafBlock.setTilt(iblockdata, world, blockposition, Tilt.a, null);
        if (iblockdata.c(c) != Tilt.a) {
            BigDripleafBlock.a(world, blockposition, SoundEffects.ij);
        }
    }

    private static boolean setTilt(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.b(c, tilt))) {
            return false;
        }
        Tilt tilt1 = iblockdata.c(c);
        world.a(blockposition, (IBlockData)iblockdata.b(c, tilt), 2);
        if (tilt.a() && tilt != tilt1) {
            world.a((net.minecraft.world.entity.Entity)null, GameEvent.c, blockposition);
        }
        return true;
    }

    @Override
    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return D.get(iblockdata.c(c));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.R.apply(iblockdata);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = blockactioncontext.q().a_(blockactioncontext.a().e());
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        boolean flag = iblockdata.a(Blocks.to) || iblockdata.a(Blocks.tp);
        return (IBlockData)((IBlockData)this.m().b(b, fluid.a(FluidTypes.c))).b(f, flag ? (EnumDirection)iblockdata.c(f) : blockactioncontext.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, f, c);
    }
}

