/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPiston
extends BlockDirectional {
    public static final MapCodec<BlockPiston> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(blockpiston -> blockpiston.i), BlockPiston.t()).apply((Applicative)instance, BlockPiston::new));
    public static final BlockStateBoolean c = BlockProperties.j;
    public static final int d = 0;
    public static final int e = 1;
    public static final int f = 2;
    public static final int g = 4;
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.d(Block.c(16.0, 4.0, 16.0));
    private final boolean i;

    public MapCodec<BlockPiston> a() {
        return b;
    }

    public BlockPiston(boolean flag, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(a, EnumDirection.c)).b(c, false));
        this.i = flag;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return iblockdata.c(c) != false ? h.get(iblockdata.c(a)) : VoxelShapes.b();
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityLiving entityliving, ItemStack itemstack) {
        if (!world.C) {
            this.a(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (!world.C) {
            this.a(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.a(iblockdata.b()) && !world.C && world.c_(blockposition) == null) {
            this.a(world, blockposition, iblockdata);
        }
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return (IBlockData)((IBlockData)this.m().b(a, blockactioncontext.d().g())).b(c, false);
    }

    private void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = (EnumDirection)iblockdata.c(a);
        boolean flag = this.a((SignalGetter)world, blockposition, enumdirection);
        if (flag && !iblockdata.c(c).booleanValue()) {
            if (new PistonExtendsChecker(world, blockposition, enumdirection, true).a()) {
                world.a(blockposition, (Block)this, 0, enumdirection.d());
            }
        } else if (!flag && iblockdata.c(c).booleanValue()) {
            TileEntityPiston tileentitypiston;
            TileEntity tileentity;
            BlockPosition blockposition1 = blockposition.a(enumdirection, 2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            int i2 = 1;
            if (iblockdata1.a(Blocks.ca) && iblockdata1.c(a) == enumdirection && (tileentity = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).a() && (tileentitypiston.a(0.0f) < 0.5f || world.ae() == tileentitypiston.v() || ((WorldServer)world).d())) {
                i2 = 2;
            }
            if (!this.i) {
                org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
                BlockPistonRetractEvent event = new BlockPistonRetractEvent(block, (List)ImmutableList.of(), CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            world.a(blockposition, (Block)this, i2, enumdirection.d());
        }
    }

    private boolean a(SignalGetter signalgetter, BlockPosition blockposition, EnumDirection enumdirection) {
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (enumdirection1 == enumdirection || !signalgetter.b(blockposition.a(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (signalgetter.b(blockposition, EnumDirection.a)) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.d();
        for (EnumDirection enumdirection2 : EnumDirection.values()) {
            if (enumdirection2 == EnumDirection.a || !signalgetter.b(blockposition1.a(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        EnumDirection enumdirection = (EnumDirection)iblockdata.c(a);
        IBlockData iblockdata1 = (IBlockData)iblockdata.b(c, true);
        if (!world.C) {
            boolean flag = this.a((SignalGetter)world, blockposition, enumdirection);
            if (flag && (i2 == 1 || i2 == 2)) {
                world.a(blockposition, iblockdata1, 2);
                return false;
            }
            if (!flag && i2 == 0) {
                return false;
            }
        }
        if (i2 == 0) {
            if (!this.a(world, blockposition, enumdirection, true)) {
                return false;
            }
            world.a(blockposition, iblockdata1, 67);
            world.a((Entity)null, blockposition, SoundEffects.vo, SoundCategory.e, 0.5f, world.A.i() * 0.25f + 0.6f);
            world.a(GameEvent.a, blockposition, GameEvent.a.a(iblockdata1));
        } else if (i2 == 1 || i2 == 2) {
            TileEntity tileentity = world.c_(blockposition.a(enumdirection));
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).k();
            }
            IBlockData iblockdata2 = (IBlockData)((IBlockData)Blocks.ca.m().b(BlockPistonMoving.b, enumdirection)).b(BlockPistonMoving.c, this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            world.a(blockposition, iblockdata2, 276);
            world.a(BlockPistonMoving.a(blockposition, iblockdata2, (IBlockData)this.m().b(a, EnumDirection.a(j2 & 7)), enumdirection, false, true));
            world.a(blockposition, iblockdata2.b());
            iblockdata2.a((GeneratorAccess)world, blockposition, 2);
            if (this.i) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                BlockPosition blockposition1 = blockposition.b(enumdirection.j() * 2, enumdirection.k() * 2, enumdirection.l() * 2);
                IBlockData iblockdata3 = world.a_(blockposition1);
                boolean flag1 = false;
                if (iblockdata3.a(Blocks.ca) && (tileentity1 = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).c() == enumdirection && tileentitypiston.a()) {
                    tileentitypiston.k();
                    flag1 = true;
                }
                if (!flag1) {
                    if (i2 != 1 || iblockdata3.l() || !BlockPiston.a(iblockdata3, world, blockposition1, enumdirection.g(), false, enumdirection) || iblockdata3.r() != EnumPistonReaction.a && !iblockdata3.a(Blocks.bI) && !iblockdata3.a(Blocks.by)) {
                        world.a(blockposition.a(enumdirection), false);
                    } else {
                        this.a(world, blockposition, enumdirection, false);
                    }
                }
            } else {
                world.a(blockposition.a(enumdirection), false);
            }
            world.a((Entity)null, blockposition, SoundEffects.vn, SoundCategory.e, 0.5f, world.A.i() * 0.15f + 0.6f);
            world.a(GameEvent.e, blockposition, GameEvent.a.a(iblockdata2));
        }
        return true;
    }

    public static boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection, boolean flag, EnumDirection enumdirection1) {
        if (blockposition.v() >= world.L_() && blockposition.v() <= world.ao() && world.F_().a(blockposition)) {
            if (iblockdata.l()) {
                return true;
            }
            if (!(iblockdata.a(Blocks.cy) || iblockdata.a(Blocks.pT) || iblockdata.a(Blocks.pU) || iblockdata.a(Blocks.tZ))) {
                if (enumdirection == EnumDirection.a && blockposition.v() == world.L_()) {
                    return false;
                }
                if (enumdirection == EnumDirection.b && blockposition.v() == world.ao()) {
                    return false;
                }
                if (!iblockdata.a(Blocks.bI) && !iblockdata.a(Blocks.by)) {
                    if (iblockdata.e(world, blockposition) == -1.0f) {
                        return false;
                    }
                    switch (iblockdata.r()) {
                        case c: {
                            return false;
                        }
                        case b: {
                            return flag;
                        }
                        case e: {
                            return enumdirection == enumdirection1;
                        }
                    }
                } else if (iblockdata.c(c).booleanValue()) {
                    return false;
                }
                return !iblockdata.x();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean a(World world, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        void var21_37;
        void var21_35;
        PistonExtendsChecker pistonextendschecker;
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        if (!flag && world.a_(blockposition1).a(Blocks.bJ)) {
            world.a(blockposition1, Blocks.a.m(), 276);
        }
        if (!(pistonextendschecker = new PistonExtendsChecker(world, blockposition, enumdirection, flag)).a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPosition> list = pistonextendschecker.c();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPosition blockposition2 : list) {
            IBlockData iblockdata = world.a_(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPosition> list2 = pistonextendschecker.d();
        IBlockData[] aiblockdata = new IBlockData[list.size() + list2.size()];
        EnumDirection enumdirection1 = flag ? enumdirection : enumdirection.g();
        int i2 = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
        final List<BlockPosition> moved = pistonextendschecker.c();
        final List<BlockPosition> broken = pistonextendschecker.d();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            }
        };
        Object event = flag ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPosition b2 : broken) {
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
            }
            for (BlockPosition b2 : moved) {
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
                b2 = b2.a(enumdirection1);
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
            }
            return false;
        }
        for (int j2 = list2.size() - 1; j2 >= 0; --j2) {
            BlockPosition blockposition3 = list2.get(j2);
            IBlockData iBlockData = world.a_(blockposition3);
            TileEntity tileentity = iBlockData.x() ? world.c_(blockposition3) : null;
            BlockPiston.a(iBlockData, world, blockposition3, tileentity);
            if (!iBlockData.a(TagsBlock.aQ) && world.B_()) {
                world.c(2001, blockposition3, BlockPiston.j(iBlockData));
            }
            world.a(blockposition3, Blocks.a.m(), 18);
            world.a(GameEvent.f, blockposition3, GameEvent.a.a(iBlockData));
            aiblockdata[i2++] = iBlockData;
        }
        for (int k2 = list.size() - 1; k2 >= 0; --k2) {
            BlockPosition blockposition4 = list.get(k2);
            IBlockData iBlockData = world.a_(blockposition4);
            blockposition4 = blockposition4.a(enumdirection1);
            map.remove(blockposition4);
            IBlockData iblockdata3 = (IBlockData)Blocks.ca.m().b(a, enumdirection);
            world.a(blockposition4, iblockdata3, 324);
            world.a(BlockPistonMoving.a(blockposition4, iblockdata3, (IBlockData)list1.get(k2), enumdirection, flag, false));
            aiblockdata[i2++] = iBlockData;
        }
        if (flag) {
            BlockPropertyPistonType blockpropertypistontype = this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a;
            IBlockData iblockdata4 = (IBlockData)((IBlockData)Blocks.bJ.m().b(BlockPistonExtension.a, enumdirection)).b(BlockPistonExtension.c, blockpropertypistontype);
            IBlockData iBlockData = (IBlockData)((IBlockData)Blocks.ca.m().b(BlockPistonMoving.b, enumdirection)).b(BlockPistonMoving.c, this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            map.remove(blockposition1);
            world.a(blockposition1, iBlockData, 324);
            world.a(BlockPistonMoving.a(blockposition1, iBlockData, iblockdata4, enumdirection, true, true));
        }
        IBlockData iblockdata6 = Blocks.a.m();
        for (BlockPosition blockPosition : map.keySet()) {
            world.a(blockPosition, iblockdata6, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPosition blockposition6 = (BlockPosition)entry.getKey();
            IBlockData iblockdata7 = (IBlockData)entry.getValue();
            iblockdata7.b(world, blockposition6, 2);
            iblockdata6.a((GeneratorAccess)world, blockposition6, 2);
            iblockdata6.b(world, blockposition6, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.a(world, pistonextendschecker.b(), null);
        i2 = 0;
        int n2 = list2.size() - 1;
        while (var21_35 >= 0) {
            IBlockData iblockdata8 = aiblockdata[i2++];
            BlockPosition blockposition7 = list2.get((int)var21_35);
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                iblockdata8.a(worldserver, blockposition7, false);
            }
            iblockdata8.b(world, blockposition7, 2);
            world.a(blockposition7, iblockdata8.b(), orientation);
            --var21_35;
        }
        int n3 = list.size() - 1;
        while (var21_37 >= 0) {
            world.a(list.get((int)var21_37), aiblockdata[i2++].b(), orientation);
            --var21_37;
        }
        if (flag) {
            world.a(blockposition1, Blocks.bJ, orientation);
        }
        return true;
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.b(a, enumblockrotation.a((EnumDirection)iblockdata.c(a)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a((EnumDirection)iblockdata.c(a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(a, c);
    }

    @Override
    protected boolean g_(IBlockData iblockdata) {
        return iblockdata.c(c);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

