/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.storage.WorldDataServer;

public record WorldDimensions(Map<ResourceKey<WorldDimension>, WorldDimension> b) {
    private final Map<ResourceKey<WorldDimension>, WorldDimension> b;
    public static final MapCodec<WorldDimensions> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.unboundedMap(ResourceKey.a(Registries.bv), WorldDimension.a).fieldOf("dimensions").forGetter(WorldDimensions::d)).apply((Applicative)var0, var0.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<WorldDimension>> c = ImmutableSet.of(WorldDimension.b, WorldDimension.c, WorldDimension.d);
    private static final int d = c.size();

    public WorldDimensions {
        WorldDimension var1 = var0.get(WorldDimension.b);
        if (var1 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldDimensions(IRegistry<WorldDimension> var0) {
        this(var0.c().collect(Collectors.toMap(Holder.c::h, Holder.c::a)));
    }

    public static Stream<ResourceKey<WorldDimension>> a(Stream<ResourceKey<WorldDimension>> var02) {
        return Stream.concat(c.stream(), var02.filter(var0 -> !c.contains(var0)));
    }

    public WorldDimensions a(HolderLookup.a var0, ChunkGenerator var1) {
        HolderLookup.b<DimensionManager> var2 = var0.e(Registries.aU);
        Map<ResourceKey<WorldDimension>, WorldDimension> var3 = WorldDimensions.a(var2, this.b, var1);
        return new WorldDimensions(var3);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> a(HolderLookup<DimensionManager> var0, Map<ResourceKey<WorldDimension>, WorldDimension> var1, ChunkGenerator var2) {
        WorldDimension var3 = var1.get(WorldDimension.b);
        Holder<DimensionManager> var4 = var3 == null ? var0.b(BuiltinDimensionTypes.a) : var3.a();
        return WorldDimensions.a(var1, var4, var2);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> a(Map<ResourceKey<WorldDimension>, WorldDimension> var0, Holder<DimensionManager> var1, ChunkGenerator var2) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var3.putAll(var0);
        var3.put(WorldDimension.b, (Object)new WorldDimension(var1, var2));
        return var3.buildKeepingLast();
    }

    public ChunkGenerator a() {
        WorldDimension var0 = this.b.get(WorldDimension.b);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.b();
    }

    public Optional<WorldDimension> a(ResourceKey<WorldDimension> var0) {
        return Optional.ofNullable(this.b.get(var0));
    }

    public ImmutableSet<ResourceKey<World>> b() {
        return (ImmutableSet)this.d().keySet().stream().map(Registries::a).collect(ImmutableSet.toImmutableSet());
    }

    public boolean c() {
        return this.a() instanceof ChunkProviderDebug;
    }

    private static WorldDataServer.a b(IRegistry<WorldDimension> var02) {
        return var02.f(WorldDimension.b).map(var0 -> {
            ChunkGenerator var1 = var0.b();
            if (var1 instanceof ChunkProviderDebug) {
                return WorldDataServer.a.c;
            }
            if (var1 instanceof ChunkProviderFlat) {
                return WorldDataServer.a.b;
            }
            return WorldDataServer.a.a;
        }).orElse(WorldDataServer.a.a);
    }

    static Lifecycle a(ResourceKey<WorldDimension> var0, WorldDimension var1) {
        return WorldDimensions.b(var0, var1) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean b(ResourceKey<WorldDimension> var0, WorldDimension var1) {
        if (var0 == WorldDimension.b) {
            return WorldDimensions.a(var1);
        }
        if (var0 == WorldDimension.c) {
            return WorldDimensions.b(var1);
        }
        if (var0 == WorldDimension.d) {
            return WorldDimensions.c(var1);
        }
        return false;
    }

    private static boolean a(WorldDimension var0) {
        WorldChunkManagerMultiNoise var2;
        Holder<DimensionManager> var1 = var0.a();
        if (!var1.a(BuiltinDimensionTypes.a) && !var1.a(BuiltinDimensionTypes.d)) {
            return false;
        }
        WorldChunkManager worldChunkManager = var0.b().d();
        return !(worldChunkManager instanceof WorldChunkManagerMultiNoise) || (var2 = (WorldChunkManagerMultiNoise)worldChunkManager).a(MultiNoiseBiomeSourceParameterLists.b);
    }

    private static boolean b(WorldDimension var0) {
        WorldChunkManagerMultiNoise var1;
        ChunkGeneratorAbstract var2;
        Object object;
        return var0.a().a(BuiltinDimensionTypes.b) && (object = var0.b()) instanceof ChunkGeneratorAbstract && (var2 = (ChunkGeneratorAbstract)object).a(GeneratorSettingBase.f) && (object = var2.d()) instanceof WorldChunkManagerMultiNoise && (var1 = (WorldChunkManagerMultiNoise)object).a(MultiNoiseBiomeSourceParameterLists.a);
    }

    private static boolean c(WorldDimension var0) {
        ChunkGeneratorAbstract var1;
        ChunkGenerator chunkGenerator;
        return var0.a().a(BuiltinDimensionTypes.c) && (chunkGenerator = var0.b()) instanceof ChunkGeneratorAbstract && (var1 = (ChunkGeneratorAbstract)chunkGenerator).a(GeneratorSettingBase.g) && var1.d() instanceof WorldChunkManagerTheEnd;
    }

    public b a(IRegistry<WorldDimension> var0) {
        final class A
        extends Record {
            final ResourceKey<WorldDimension> a;
            final WorldDimension b;

            A(ResourceKey<WorldDimension> var0, WorldDimension var1) {
                this.a = var0;
                this.b = var1;
            }

            RegistrationInfo c() {
                return new RegistrationInfo(Optional.empty(), WorldDimensions.a(this.a, this.b));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "key;value", "a", "b"}, this, var0);
            }

            public ResourceKey<WorldDimension> a() {
                return this.a;
            }

            public WorldDimension b() {
                return this.b;
            }
        }
        Stream<ResourceKey<WorldDimension>> var12 = Stream.concat(var0.j().stream(), this.b.keySet().stream()).distinct();
        ArrayList var2 = new ArrayList();
        WorldDimensions.a(var12).forEach(var22 -> var0.f((ResourceKey<WorldDimension>)var22).or(() -> Optional.ofNullable(this.b.get(var22))).ifPresent(var2 -> var2.add(new A((ResourceKey<WorldDimension>)var22, (WorldDimension)var2))));
        Lifecycle var3 = var2.size() == d ? Lifecycle.stable() : Lifecycle.experimental();
        RegistryMaterials<WorldDimension> var4 = new RegistryMaterials<WorldDimension>(Registries.bv, var3);
        var2.forEach(var1 -> var4.a(var1.a, var1.b, var1.c()));
        IRegistry<WorldDimension> var5 = var4.n();
        WorldDataServer.a var6 = WorldDimensions.b(var5);
        return new b(var5.n(), var6);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this, var0);
    }

    public Map<ResourceKey<WorldDimension>, WorldDimension> d() {
        return this.b;
    }

    public record b(IRegistry<WorldDimension> a, WorldDataServer.a b) {
        private final IRegistry<WorldDimension> a;
        private final WorldDataServer.a b;

        public Lifecycle a() {
            return this.a.h();
        }

        public IRegistryCustom.Dimension b() {
            return new IRegistryCustom.c(List.of(this.a)).e();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this, var0);
        }

        public IRegistry<WorldDimension> c() {
            return this.a;
        }

        public WorldDataServer.a d() {
            return this.b;
        }
    }
}

