/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R5.util.TransformerGeneratorAccess;
import org.slf4j.Logger;

public class DefinedStructure {
    private static final Logger l = LogUtils.getLogger();
    public static final String a = "palette";
    public static final String b = "palettes";
    public static final String c = "entities";
    public static final String d = "blocks";
    public static final String e = "pos";
    public static final String f = "state";
    public static final String g = "nbt";
    public static final String h = "pos";
    public static final String i = "blockPos";
    public static final String j = "nbt";
    public static final String k = "size";
    public final List<b> m = Lists.newArrayList();
    public final List<EntityInfo> n = Lists.newArrayList();
    private BaseBlockPosition o;
    private String p = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public DefinedStructure() {
        this.o = BaseBlockPosition.i;
    }

    public BaseBlockPosition a() {
        return this.o;
    }

    public void a(String s2) {
        this.p = s2;
    }

    public String b() {
        return this.p;
    }

    public void a(World world, BlockPosition blockposition, BaseBlockPosition baseblockposition, boolean flag, List<Block> list) {
        if (baseblockposition.u() >= 1 && baseblockposition.v() >= 1 && baseblockposition.w() >= 1) {
            BlockPosition blockposition1 = blockposition.a(baseblockposition).b(-1, -1, -1);
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            ArrayList list3 = Lists.newArrayList();
            BlockPosition blockposition2 = new BlockPosition(Math.min(blockposition.u(), blockposition1.u()), Math.min(blockposition.v(), blockposition1.v()), Math.min(blockposition.w(), blockposition1.w()));
            BlockPosition blockposition3 = new BlockPosition(Math.max(blockposition.u(), blockposition1.u()), Math.max(blockposition.v(), blockposition1.v()), Math.max(blockposition.w(), blockposition1.w()));
            this.o = baseblockposition;
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(l);){
                for (BlockPosition blockposition4 : BlockPosition.c(blockposition2, blockposition3)) {
                    BlockInfo definedstructure_blockinfo;
                    BlockPosition blockposition5 = blockposition4.b(blockposition2);
                    IBlockData iblockdata = world.a_(blockposition4);
                    Stream stream = list.stream();
                    Objects.requireNonNull(iblockdata);
                    if (stream.anyMatch(iblockdata::a)) continue;
                    TileEntity tileentity = world.c_(blockposition4);
                    if (tileentity != null) {
                        TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, world.K_());
                        tileentity.d(tagvalueoutput);
                        definedstructure_blockinfo = new BlockInfo(blockposition5, iblockdata, tagvalueoutput.b());
                    } else {
                        definedstructure_blockinfo = new BlockInfo(blockposition5, iblockdata, null);
                    }
                    DefinedStructure.a(definedstructure_blockinfo, list1, list2, list3);
                }
                List<BlockInfo> list4 = DefinedStructure.a(list1, list2, list3);
                this.m.clear();
                this.m.add(new b(list4));
                if (flag) {
                    this.a(world, blockposition2, blockposition3, problemreporter_j);
                } else {
                    this.n.clear();
                }
            }
        }
    }

    private static void a(BlockInfo definedstructure_blockinfo, List<BlockInfo> list, List<BlockInfo> list1, List<BlockInfo> list2) {
        if (definedstructure_blockinfo.c != null) {
            list1.add(definedstructure_blockinfo);
        } else if (!definedstructure_blockinfo.b.b().n() && definedstructure_blockinfo.b.m(BlockAccessAir.a, BlockPosition.c)) {
            list.add(definedstructure_blockinfo);
        } else {
            list2.add(definedstructure_blockinfo);
        }
    }

    private static List<BlockInfo> a(List<BlockInfo> list, List<BlockInfo> list1, List<BlockInfo> list2) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.v()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.u()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.w());
        list.sort(comparator);
        list2.sort(comparator);
        list1.sort(comparator);
        ArrayList list3 = Lists.newArrayList();
        list3.addAll(list);
        list3.addAll(list2);
        list3.addAll(list1);
        return list3;
    }

    private void a(World world, BlockPosition blockposition, BlockPosition blockposition1, ProblemReporter problemreporter) {
        List<Entity> list = world.a(Entity.class, AxisAlignedBB.a(blockposition, blockposition1), (? super T entity) -> !(entity instanceof EntityHuman));
        this.n.clear();
        for (Entity entity2 : list) {
            BlockPosition blockposition2;
            Vec3D vec3d = new Vec3D(entity2.dC() - (double)blockposition.u(), entity2.dE() - (double)blockposition.v(), entity2.dI() - (double)blockposition.w());
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter.a(entity2.ef()), entity2.eb());
            entity2.c(tagvalueoutput);
            if (entity2 instanceof EntityPainting) {
                EntityPainting entitypainting = (EntityPainting)entity2;
                blockposition2 = entitypainting.i().b(blockposition);
            } else {
                blockposition2 = BlockPosition.a(vec3d);
            }
            this.n.add(new EntityInfo(vec3d, blockposition2, tagvalueoutput.b().l()));
        }
    }

    public List<BlockInfo> a(BlockPosition blockposition, DefinedStructureInfo definedstructureinfo, Block block) {
        return this.a(blockposition, definedstructureinfo, block, true);
    }

    public List<a> a(BlockPosition blockposition, EnumBlockRotation enumblockrotation) {
        if (this.m.isEmpty()) {
            return new ArrayList<a>();
        }
        DefinedStructureInfo definedstructureinfo = new DefinedStructureInfo().a(enumblockrotation);
        List<a> list = definedstructureinfo.a(this.m, blockposition).a();
        ArrayList<a> list1 = new ArrayList<a>(list.size());
        for (a definedstructure_a : list) {
            BlockInfo definedstructure_blockinfo = definedstructure_a.a;
            list1.add(definedstructure_a.b(new BlockInfo(DefinedStructure.a(definedstructureinfo, definedstructure_blockinfo.a()).a(blockposition), definedstructure_blockinfo.b.a(definedstructureinfo.d()), definedstructure_blockinfo.c)));
        }
        return list1;
    }

    public ObjectArrayList<BlockInfo> a(BlockPosition blockposition, DefinedStructureInfo definedstructureinfo, Block block, boolean flag) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        StructureBoundingBox structureboundingbox = definedstructureinfo.g();
        if (this.m.isEmpty()) {
            return objectarraylist;
        }
        for (BlockInfo definedstructure_blockinfo : definedstructureinfo.a(this.m, blockposition).a(block)) {
            BlockPosition blockposition1;
            BlockPosition blockPosition = blockposition1 = flag ? DefinedStructure.a(definedstructureinfo, definedstructure_blockinfo.a).a(blockposition) : definedstructure_blockinfo.a;
            if (structureboundingbox != null && !structureboundingbox.b(blockposition1)) continue;
            objectarraylist.add((Object)new BlockInfo(blockposition1, definedstructure_blockinfo.b.a(definedstructureinfo.d()), definedstructure_blockinfo.c));
        }
        return objectarraylist;
    }

    public BlockPosition a(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition, DefinedStructureInfo definedstructureinfo1, BlockPosition blockposition1) {
        BlockPosition blockposition2 = DefinedStructure.a(definedstructureinfo, blockposition);
        BlockPosition blockposition3 = DefinedStructure.a(definedstructureinfo1, blockposition1);
        return blockposition2.b(blockposition3);
    }

    public static BlockPosition a(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition) {
        return DefinedStructure.a(blockposition, definedstructureinfo.c(), definedstructureinfo.d(), definedstructureinfo.e());
    }

    public boolean a(WorldAccess worldaccess, BlockPosition blockposition, BlockPosition blockposition1, DefinedStructureInfo definedstructureinfo, RandomSource randomsource, int i2) {
        List<BlockInfo> list;
        if (this.m.isEmpty()) {
            return false;
        }
        WorldAccess wrappedAccess = worldaccess;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            worldaccess = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = definedstructureinfo.a(this.m, blockposition).b()).isEmpty() && (definedstructureinfo.f() || this.n.isEmpty()) || this.o.u() < 1 || this.o.v() < 1 || this.o.w() < 1)) {
            StructureBoundingBox structureboundingbox = definedstructureinfo.g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.j() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.j() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int j2 = Integer.MAX_VALUE;
            int k2 = Integer.MAX_VALUE;
            int l2 = Integer.MAX_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            int k1 = Integer.MIN_VALUE;
            List<BlockInfo> list4 = DefinedStructure.a(worldaccess, blockposition, blockposition1, definedstructureinfo, list);
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(l);){
                for (BlockInfo definedstructure_blockinfo : list4) {
                    TileEntity tileentity;
                    BlockPosition blockposition2 = definedstructure_blockinfo.a;
                    if (structureboundingbox != null && !structureboundingbox.b(blockposition2)) continue;
                    Fluid fluid = definedstructureinfo.j() ? worldaccess.b_(blockposition2) : null;
                    IBlockData iblockdata = definedstructure_blockinfo.b.a(definedstructureinfo.c()).a(definedstructureinfo.d());
                    if (definedstructure_blockinfo.c != null) {
                        worldaccess.a(blockposition2, Blocks.iy.m(), 820);
                    }
                    if (structureTransformer != null) {
                        NBTTagCompound nBTTagCompound;
                        CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)worldaccess, blockposition2, iblockdata, null);
                        if (definedstructure_blockinfo.c != null && craftBlockState instanceof CraftBlockEntityState) {
                            CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                            entityState.loadData(definedstructure_blockinfo.c);
                            if (craftBlockState instanceof CraftLootable) {
                                CraftLootable craftLootable = (CraftLootable)craftBlockState;
                                craftLootable.setSeed(randomsource.g());
                            }
                        }
                        craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                        iblockdata = craftBlockState.getHandle();
                        if (craftBlockState instanceof CraftBlockEntityState) {
                            CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                            nBTTagCompound = craftBlockEntityState.getSnapshotNBT();
                        } else {
                            nBTTagCompound = null;
                        }
                        definedstructure_blockinfo = new BlockInfo(blockposition2, iblockdata, nBTTagCompound);
                    }
                    if (!worldaccess.a(blockposition2, iblockdata, i2)) continue;
                    j2 = Math.min(j2, blockposition2.u());
                    k2 = Math.min(k2, blockposition2.v());
                    l2 = Math.min(l2, blockposition2.w());
                    i1 = Math.max(i1, blockposition2.u());
                    j1 = Math.max(j1, blockposition2.v());
                    k1 = Math.max(k1, blockposition2.w());
                    list3.add(Pair.of((Object)blockposition2, (Object)definedstructure_blockinfo.c));
                    if (definedstructure_blockinfo.c != null && (tileentity = worldaccess.c_(blockposition2)) != null) {
                        if (tileentity instanceof RandomizableContainer) {
                            definedstructure_blockinfo.c.a("LootTableSeed", randomsource.g());
                        }
                        tileentity.b(TagValueInput.a(problemreporter_j.a(tileentity.t()), (HolderLookup.a)worldaccess.K_(), definedstructure_blockinfo.c));
                    }
                    if (fluid == null) continue;
                    if (iblockdata.y().b()) {
                        list2.add(blockposition2);
                        continue;
                    }
                    if (!(iblockdata.b() instanceof IFluidContainer)) continue;
                    ((IFluidContainer)((Object)iblockdata.b())).a(worldaccess, blockposition2, iblockdata, fluid);
                    if (fluid.b()) continue;
                    list1.add(blockposition2);
                }
                boolean flag = true;
                EnumDirection[] aenumdirection = new EnumDirection[]{EnumDirection.b, EnumDirection.c, EnumDirection.f, EnumDirection.d, EnumDirection.e};
                while (flag && !list1.isEmpty()) {
                    flag = false;
                    Iterator iterator = list1.iterator();
                    while (iterator.hasNext()) {
                        IBlockData iblockdata1;
                        Object block;
                        BlockPosition blockposition3 = (BlockPosition)iterator.next();
                        Fluid fluid1 = worldaccess.b_(blockposition3);
                        for (int l1 = 0; l1 < aenumdirection.length && !fluid1.b(); ++l1) {
                            BlockPosition blockposition4 = blockposition3.a(aenumdirection[l1]);
                            Fluid fluid2 = worldaccess.b_(blockposition4);
                            if (!fluid2.b() || list2.contains(blockposition4)) continue;
                            fluid1 = fluid2;
                        }
                        if (!fluid1.b() || !((block = (iblockdata1 = worldaccess.a_(blockposition3)).b()) instanceof IFluidContainer)) continue;
                        ((IFluidContainer)block).a(worldaccess, blockposition3, iblockdata1, fluid1);
                        flag = true;
                        iterator.remove();
                    }
                }
                if (j2 <= i1) {
                    if (!definedstructureinfo.h()) {
                        VoxelShapeBitSet voxelshapediscrete = new VoxelShapeBitSet(i1 - j2 + 1, j1 - k2 + 1, k1 - l2 + 1);
                        int i22 = j2;
                        int j22 = k2;
                        int k22 = l2;
                        for (Pair pair : list3) {
                            BlockPosition blockposition5 = (BlockPosition)pair.getFirst();
                            ((VoxelShapeDiscrete)voxelshapediscrete).c(blockposition5.u() - i22, blockposition5.v() - j22, blockposition5.w() - k22);
                        }
                        DefinedStructure.a(worldaccess, i2, voxelshapediscrete, i22, j22, k22);
                    }
                    for (Pair pair1 : list3) {
                        TileEntity tileentity1;
                        BlockPosition blockposition6 = (BlockPosition)pair1.getFirst();
                        if (!definedstructureinfo.h()) {
                            IBlockData iblockdata3;
                            IBlockData iblockdata2 = worldaccess.a_(blockposition6);
                            if (iblockdata2 != (iblockdata3 = Block.b(iblockdata2, worldaccess, blockposition6))) {
                                worldaccess.a(blockposition6, iblockdata3, i2 & 0xFFFFFFFE | 0x10);
                            }
                            worldaccess.a(blockposition6, iblockdata3.b());
                        }
                        if (pair1.getSecond() == null || (tileentity1 = worldaccess.c_(blockposition6)) == null) continue;
                        tileentity1.e();
                    }
                }
                if (!definedstructureinfo.f()) {
                    this.a(wrappedAccess, blockposition, definedstructureinfo.c(), definedstructureinfo.d(), definedstructureinfo.e(), structureboundingbox, definedstructureinfo.k(), problemreporter_j);
                }
            }
            return true;
        }
        return false;
    }

    public static void a(GeneratorAccess generatoraccess, int i2, VoxelShapeDiscrete voxelshapediscrete, BlockPosition blockposition) {
        DefinedStructure.a(generatoraccess, i2, voxelshapediscrete, blockposition.u(), blockposition.v(), blockposition.w());
    }

    public static void a(GeneratorAccess generatoraccess, int i2, VoxelShapeDiscrete voxelshapediscrete, int j2, int k2, int l2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
        voxelshapediscrete.a((EnumDirection enumdirection, int i1, int j1, int k1) -> {
            IBlockData iblockdata3;
            blockposition_mutableblockposition.d(j2 + i1, k2 + j1, l2 + k1);
            blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition_mutableblockposition, enumdirection);
            IBlockData iblockdata = generatoraccess.a_(blockposition_mutableblockposition);
            IBlockData iblockdata1 = generatoraccess.a_(blockposition_mutableblockposition1);
            IBlockData iblockdata2 = iblockdata.a(generatoraccess, generatoraccess, blockposition_mutableblockposition, enumdirection, blockposition_mutableblockposition1, iblockdata1, generatoraccess.H_());
            if (iblockdata != iblockdata2) {
                generatoraccess.a((BlockPosition)blockposition_mutableblockposition, iblockdata2, i2 & 0xFFFFFFFE);
            }
            if (iblockdata1 != (iblockdata3 = iblockdata1.a(generatoraccess, generatoraccess, blockposition_mutableblockposition1, enumdirection.g(), blockposition_mutableblockposition, iblockdata2, generatoraccess.H_()))) {
                generatoraccess.a((BlockPosition)blockposition_mutableblockposition1, iblockdata3, i2 & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> a(WorldAccess worldaccess, BlockPosition blockposition, BlockPosition blockposition1, DefinedStructureInfo definedstructureinfo, List<BlockInfo> list) {
        ArrayList<BlockInfo> list1 = new ArrayList<BlockInfo>();
        List<BlockInfo> list2 = new ArrayList<BlockInfo>();
        for (BlockInfo definedstructure_blockinfo : list) {
            BlockPosition blockposition2 = DefinedStructure.a(definedstructureinfo, definedstructure_blockinfo.a).a(blockposition);
            BlockInfo definedstructure_blockinfo1 = new BlockInfo(blockposition2, definedstructure_blockinfo.b, definedstructure_blockinfo.c != null ? definedstructure_blockinfo.c.l() : null);
            Iterator<DefinedStructureProcessor> iterator = definedstructureinfo.i().iterator();
            while (definedstructure_blockinfo1 != null && iterator.hasNext()) {
                definedstructure_blockinfo1 = iterator.next().a((IWorldReader)worldaccess, blockposition, blockposition1, definedstructure_blockinfo, definedstructure_blockinfo1, definedstructureinfo);
            }
            if (definedstructure_blockinfo1 == null) continue;
            list2.add(definedstructure_blockinfo1);
            list1.add(definedstructure_blockinfo);
        }
        for (DefinedStructureProcessor definedstructureprocessor : definedstructureinfo.i()) {
            list2 = definedstructureprocessor.a(worldaccess, blockposition, blockposition1, list1, list2, definedstructureinfo);
        }
        return list2;
    }

    private void a(WorldAccess worldaccess, BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, @Nullable StructureBoundingBox structureboundingbox, boolean flag, ProblemReporter problemreporter) {
        for (EntityInfo definedstructure_entityinfo : this.n) {
            BlockPosition blockposition2 = DefinedStructure.a(definedstructure_entityinfo.b, enumblockmirror, enumblockrotation, blockposition1).a(blockposition);
            if (structureboundingbox != null && !structureboundingbox.b(blockposition2)) continue;
            NBTTagCompound nbttagcompound = definedstructure_entityinfo.c.l();
            Vec3D vec3d = DefinedStructure.a(definedstructure_entityinfo.a, enumblockmirror, enumblockrotation, blockposition1);
            Vec3D vec3d1 = vec3d.b(blockposition.u(), blockposition.v(), blockposition.w());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.add(NBTTagDouble.a(vec3d1.d));
            nbttaglist.add(NBTTagDouble.a(vec3d1.e));
            nbttaglist.add(NBTTagDouble.a(vec3d1.f));
            nbttagcompound.a("Pos", nbttaglist);
            nbttagcompound.r("UUID");
            DefinedStructure.a(problemreporter, worldaccess, nbttagcompound).ifPresent(entity -> {
                float f2 = entity.a(enumblockrotation);
                entity.b(vec3d1.d, vec3d1.e, vec3d1.f, f2 += entity.a(enumblockmirror) - entity.dP(), entity.dR());
                if (flag && entity instanceof EntityInsentient) {
                    ((EntityInsentient)entity).a(worldaccess, worldaccess.d_(BlockPosition.a(vec3d1)), EntitySpawnReason.d, (GroupDataEntity)null);
                }
                worldaccess.a_((Entity)entity);
            });
        }
    }

    private static Optional<Entity> a(ProblemReporter problemreporter, WorldAccess worldaccess, NBTTagCompound nbttagcompound) {
        return EntityTypes.a(TagValueInput.a(problemreporter, (HolderLookup.a)worldaccess.K_(), nbttagcompound), (World)worldaccess.a(), EntitySpawnReason.d);
    }

    public BaseBlockPosition a(EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case d: 
            case b: {
                return new BaseBlockPosition(this.o.w(), this.o.v(), this.o.u());
            }
        }
        return this.o;
    }

    public static BlockPosition a(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition1) {
        int i2 = blockposition.u();
        int j2 = blockposition.v();
        int k2 = blockposition.w();
        boolean flag = true;
        switch (enumblockmirror) {
            case b: {
                k2 = -k2;
                break;
            }
            case c: {
                i2 = -i2;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l2 = blockposition1.u();
        int i1 = blockposition1.w();
        switch (enumblockrotation) {
            case d: {
                return new BlockPosition(l2 - i1 + k2, j2, l2 + i1 - i2);
            }
            case b: {
                return new BlockPosition(l2 + i1 - k2, j2, i1 - l2 + i2);
            }
            case c: {
                return new BlockPosition(l2 + l2 - i2, j2, i1 + i1 - k2);
            }
        }
        return flag ? new BlockPosition(i2, j2, k2) : blockposition;
    }

    public static Vec3D a(Vec3D vec3d, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition) {
        double d0 = vec3d.d;
        double d1 = vec3d.e;
        double d2 = vec3d.f;
        boolean flag = true;
        switch (enumblockmirror) {
            case b: {
                d2 = 1.0 - d2;
                break;
            }
            case c: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i2 = blockposition.u();
        int j2 = blockposition.w();
        switch (enumblockrotation) {
            case d: {
                return new Vec3D((double)(i2 - j2) + d2, d1, (double)(i2 + j2 + 1) - d0);
            }
            case b: {
                return new Vec3D((double)(i2 + j2 + 1) - d2, d1, (double)(j2 - i2) + d0);
            }
            case c: {
                return new Vec3D((double)(i2 + i2 + 1) - d0, d1, (double)(j2 + j2 + 1) - d2);
            }
        }
        return flag ? new Vec3D(d0, d1, d2) : vec3d;
    }

    public BlockPosition a(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation) {
        return DefinedStructure.a(blockposition, enumblockmirror, enumblockrotation, this.a().u(), this.a().w());
    }

    public static BlockPosition a(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, int i2, int j2) {
        int k2 = enumblockmirror == EnumBlockMirror.c ? --i2 : 0;
        int l2 = enumblockmirror == EnumBlockMirror.b ? --j2 : 0;
        BlockPosition blockposition1 = blockposition;
        switch (enumblockrotation) {
            case d: {
                blockposition1 = blockposition.b(l2, 0, i2 - k2);
                break;
            }
            case b: {
                blockposition1 = blockposition.b(j2 - l2, 0, k2);
                break;
            }
            case c: {
                blockposition1 = blockposition.b(i2 - k2, 0, j2 - l2);
                break;
            }
            case a: {
                blockposition1 = blockposition.b(k2, 0, l2);
            }
        }
        return blockposition1;
    }

    public StructureBoundingBox b(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition) {
        return this.a(blockposition, definedstructureinfo.d(), definedstructureinfo.e(), definedstructureinfo.c());
    }

    public StructureBoundingBox a(BlockPosition blockposition, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, EnumBlockMirror enumblockmirror) {
        return DefinedStructure.a(blockposition, enumblockrotation, blockposition1, enumblockmirror, this.o);
    }

    @VisibleForTesting
    protected static StructureBoundingBox a(BlockPosition blockposition, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, EnumBlockMirror enumblockmirror, BaseBlockPosition baseblockposition) {
        BaseBlockPosition baseblockposition1 = baseblockposition.c(-1, -1, -1);
        BlockPosition blockposition2 = DefinedStructure.a(BlockPosition.c, enumblockmirror, enumblockrotation, blockposition1);
        BlockPosition blockposition3 = DefinedStructure.a(BlockPosition.c.a(baseblockposition1), enumblockmirror, enumblockrotation, blockposition1);
        return StructureBoundingBox.a(blockposition2, blockposition3).a((BaseBlockPosition)blockposition);
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound) {
        if (this.m.isEmpty()) {
            nbttagcompound.a(d, new NBTTagList());
            nbttagcompound.a(a, new NBTTagList());
        } else {
            ArrayList list = Lists.newArrayList();
            c definedstructure_c = new c();
            list.add(definedstructure_c);
            for (int i2 = 1; i2 < this.m.size(); ++i2) {
                list.add(new c());
            }
            NBTTagList nbttaglist = new NBTTagList();
            List<BlockInfo> list1 = this.m.get(0).b();
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                BlockInfo definedstructure_blockinfo = list1.get(j2);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.a("pos", this.a(definedstructure_blockinfo.a.u(), definedstructure_blockinfo.a.v(), definedstructure_blockinfo.a.w()));
                int k2 = definedstructure_c.a(definedstructure_blockinfo.b);
                nbttagcompound1.a(f, k2);
                if (definedstructure_blockinfo.c != null) {
                    nbttagcompound1.a("nbt", definedstructure_blockinfo.c);
                }
                nbttaglist.add(nbttagcompound1);
                for (int l2 = 1; l2 < this.m.size(); ++l2) {
                    c definedstructure_c1 = (c)list.get(l2);
                    definedstructure_c1.a(this.m.get((int)l2).b().get((int)j2).b, k2);
                }
            }
            nbttagcompound.a(d, nbttaglist);
            if (list.size() == 1) {
                NBTTagList nbttaglist1 = new NBTTagList();
                for (IBlockData iblockdata : definedstructure_c) {
                    nbttaglist1.add(GameProfileSerializer.a(iblockdata));
                }
                nbttagcompound.a(a, nbttaglist1);
            } else {
                NBTTagList nbttaglist2 = new NBTTagList();
                for (c definedstructure_c2 : list) {
                    NBTTagList nbttaglist3 = new NBTTagList();
                    for (IBlockData iblockdata1 : definedstructure_c2) {
                        nbttaglist3.add(GameProfileSerializer.a(iblockdata1));
                    }
                    nbttaglist2.add(nbttaglist3);
                }
                nbttagcompound.a(b, nbttaglist2);
            }
        }
        NBTTagList nbttaglist4 = new NBTTagList();
        for (EntityInfo definedstructure_entityinfo : this.n) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a("pos", this.a(definedstructure_entityinfo.a.d, definedstructure_entityinfo.a.e, definedstructure_entityinfo.a.f));
            nbttagcompound2.a(i, this.a(definedstructure_entityinfo.b.u(), definedstructure_entityinfo.b.v(), definedstructure_entityinfo.b.w()));
            if (definedstructure_entityinfo.c != null) {
                nbttagcompound2.a("nbt", definedstructure_entityinfo.c);
            }
            nbttaglist4.add(nbttagcompound2);
        }
        nbttagcompound.a(c, nbttaglist4);
        nbttagcompound.a(k, this.a(this.o.u(), this.o.v(), this.o.w()));
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return GameProfileSerializer.e(nbttagcompound);
    }

    public void a(HolderGetter<Block> holdergetter, NBTTagCompound nbttagcompound) {
        this.m.clear();
        this.n.clear();
        NBTTagList nbttaglist = nbttagcompound.p(k);
        this.o = new BaseBlockPosition(nbttaglist.a(0, 0), nbttaglist.a(1, 0), nbttaglist.a(2, 0));
        NBTTagList nbttaglist1 = nbttagcompound.p(d);
        Optional<NBTTagList> optional = nbttagcompound.o(b);
        if (optional.isPresent()) {
            for (int i2 = 0; i2 < optional.get().size(); ++i2) {
                this.a(holdergetter, optional.get().f(i2), nbttaglist1);
            }
        } else {
            this.a(holdergetter, nbttagcompound.p(a), nbttaglist1);
        }
        nbttagcompound.p(c).j().forEach(nbttagcompound1 -> {
            NBTTagList nbttaglist2 = nbttagcompound1.p("pos");
            Vec3D vec3d = new Vec3D(nbttaglist2.a(0, 0.0), nbttaglist2.a(1, 0.0), nbttaglist2.a(2, 0.0));
            NBTTagList nbttaglist3 = nbttagcompound1.p(i);
            BlockPosition blockposition = new BlockPosition(nbttaglist3.a(0, 0), nbttaglist3.a(1, 0), nbttaglist3.a(2, 0));
            nbttagcompound1.m("nbt").ifPresent(nbttagcompound2 -> this.n.add(new EntityInfo(vec3d, blockposition, (NBTTagCompound)nbttagcompound2)));
        });
        NBTBase base = nbttagcompound.a("BukkitValues");
        if (base instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)base);
        }
    }

    private void a(HolderGetter<Block> holdergetter, NBTTagList nbttaglist, NBTTagList nbttaglist1) {
        c definedstructure_c = new c();
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            definedstructure_c.a(GameProfileSerializer.a(holdergetter, nbttaglist.b(i2)), i2);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        nbttaglist1.j().forEach(nbttagcompound -> {
            NBTTagList nbttaglist2 = nbttagcompound.p("pos");
            BlockPosition blockposition = new BlockPosition(nbttaglist2.a(0, 0), nbttaglist2.a(1, 0), nbttaglist2.a(2, 0));
            IBlockData iblockdata = definedstructure_c.a(nbttagcompound.b(f, 0));
            NBTTagCompound nbttagcompound1 = nbttagcompound.m("nbt").orElse(null);
            BlockInfo definedstructure_blockinfo = new BlockInfo(blockposition, iblockdata, nbttagcompound1);
            DefinedStructure.a(definedstructure_blockinfo, list, list1, list2);
        });
        List<BlockInfo> list3 = DefinedStructure.a(list, list1, list2);
        this.m.add(new b(list3));
    }

    private NBTTagList a(int ... aint) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 : aint) {
            nbttaglist.add(NBTTagInt.a(i2));
        }
        return nbttaglist;
    }

    private NBTTagList a(double ... adouble) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : adouble) {
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    public static TileEntityJigsaw.JointType a(NBTTagCompound nbttagcompound, IBlockData iblockdata) {
        return nbttagcompound.a("joint", TileEntityJigsaw.JointType.c).orElseGet(() -> DefinedStructure.a(iblockdata));
    }

    public static TileEntityJigsaw.JointType a(IBlockData iblockdata) {
        return BlockJigsaw.o(iblockdata).o().d() ? TileEntityJigsaw.JointType.b : TileEntityJigsaw.JointType.a;
    }

    public record BlockInfo(BlockPosition a, IBlockData b, @Nullable NBTTagCompound c) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.a, this.b, this.c);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public static final class b {
        private final List<BlockInfo> a;
        private final Map<Block, List<BlockInfo>> b = Maps.newHashMap();
        @Nullable
        private List<a> c;

        b(List<BlockInfo> list) {
            this.a = list;
        }

        public List<a> a() {
            if (this.c == null) {
                this.c = this.a(Blocks.pI).stream().map(a::a).toList();
            }
            return this.c;
        }

        public List<BlockInfo> b() {
            return this.a;
        }

        public List<BlockInfo> a(Block block) {
            return this.b.computeIfAbsent(block, block1 -> this.a.stream().filter(definedstructure_blockinfo -> definedstructure_blockinfo.b.a((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D a;
        public final BlockPosition b;
        public final NBTTagCompound c;

        public EntityInfo(Vec3D vec3d, BlockPosition blockposition, NBTTagCompound nbttagcompound) {
            this.a = vec3d;
            this.b = blockposition;
            this.c = nbttagcompound;
        }
    }

    public record a(BlockInfo a, TileEntityJigsaw.JointType b, MinecraftKey c, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> d, MinecraftKey e, int f, int g) {
        public static a a(BlockInfo definedstructure_blockinfo) {
            NBTTagCompound nbttagcompound = Objects.requireNonNull(definedstructure_blockinfo.c(), () -> String.valueOf(definedstructure_blockinfo) + " nbt was null");
            return new a(definedstructure_blockinfo, DefinedStructure.a(nbttagcompound, definedstructure_blockinfo.b()), nbttagcompound.a("name", MinecraftKey.a).orElse(TileEntityJigsaw.b), nbttagcompound.a("pool", TileEntityJigsaw.a).orElse(WorldGenFeaturePieces.a), nbttagcompound.a("target", MinecraftKey.a).orElse(TileEntityJigsaw.b), nbttagcompound.b("placement_priority", 0), nbttagcompound.b("selection_priority", 0));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.a.a, this.a.b, this.c, this.d.a(), this.e, this.f, this.g, this.a.c);
        }

        public a b(BlockInfo definedstructure_blockinfo) {
            return new a(definedstructure_blockinfo, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this, o2);
        }
    }

    private static class c
    implements Iterable<IBlockData> {
        public static final IBlockData a = Blocks.a.m();
        private final RegistryBlockID<IBlockData> b = new RegistryBlockID(16);
        private int c;

        c() {
        }

        public int a(IBlockData iblockdata) {
            int i2 = this.b.a(iblockdata);
            if (i2 == -1) {
                i2 = this.c++;
                this.b.a(iblockdata, i2);
            }
            return i2;
        }

        @Nullable
        public IBlockData a(int i2) {
            IBlockData iblockdata = this.b.a(i2);
            return iblockdata == null ? a : iblockdata;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.b.iterator();
        }

        public void a(IBlockData iblockdata, int i2) {
            this.b.a(iblockdata, i2);
        }
    }
}

