/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.creaking.Creaking;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Player;

public class CraftCreaking
extends CraftMonster
implements org.bukkit.entity.Creaking {
    public CraftCreaking(CraftServer server, Creaking entity) {
        super(server, entity);
    }

    @Override
    public Creaking getHandle() {
        return (Creaking)this.entity;
    }

    public Location getHome() {
        return CraftLocation.toBukkit(this.getHandle().gI(), this.getHandle().ai());
    }

    public void setHome(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"Home must be in the same world as the creaking");
        this.getHandle().i(CraftLocation.toBlockPosition(location));
    }

    public void activate(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        this.getHandle().g(((CraftPlayer)player).getHandle());
    }

    public void deactivate() {
        this.getHandle().gQ();
    }

    public boolean isActive() {
        return this.getHandle().gR();
    }

    @Override
    public String toString() {
        return "CraftCreaking";
    }
}

