/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R5.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.SerializableMeta;
import org.bukkit.inventory.meta.FireworkMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaFirework
extends CraftMetaItem
implements FireworkMeta {
    static final CraftMetaItem.ItemMetaKeyType<Fireworks> FIREWORKS = new CraftMetaItem.ItemMetaKeyType<Fireworks>(DataComponents.aj, "Fireworks");
    static final ItemMetaKey FLIGHT = new ItemMetaKey("power");
    static final ItemMetaKey EXPLOSIONS = new ItemMetaKey("firework-effects");
    private List<FireworkEffect> effects;
    private Integer power;

    CraftMetaFirework(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaFirework)) {
            return;
        }
        CraftMetaFirework that = (CraftMetaFirework)meta;
        this.power = that.power;
        if (that.hasEffects()) {
            this.effects = new ArrayList<FireworkEffect>(that.effects);
        }
    }

    CraftMetaFirework(DataComponentPatch tag) {
        super(tag);
        CraftMetaFirework.getOrEmpty(tag, FIREWORKS).ifPresent(fireworks -> {
            this.power = fireworks.a();
            List<FireworkExplosion> fireworkEffects = fireworks.b();
            this.effects = new ArrayList<FireworkEffect>(fireworkEffects.size());
            ArrayList<FireworkEffect> effects = this.effects;
            for (int i2 = 0; i2 < fireworkEffects.size(); ++i2) {
                try {
                    effects.add(CraftMetaFirework.getEffect(fireworkEffects.get(i2)));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    CraftMetaFirework(Map<String, Object> map) {
        super(map);
        Integer power = SerializableMeta.getObject(Integer.class, map, CraftMetaFirework.FLIGHT.BUKKIT, true);
        if (power != null) {
            this.power = power;
        }
        Iterable effects = SerializableMeta.getObject(Iterable.class, map, CraftMetaFirework.EXPLOSIONS.BUKKIT, true);
        this.safelyAddEffects(effects);
    }

    static FireworkEffect getEffect(FireworkExplosion explosion) {
        int color;
        FireworkEffect.Builder effect = FireworkEffect.builder().flicker(explosion.e()).trail(explosion.d()).with(CraftMetaFirework.getEffectType(explosion.a()));
        IntList colors = explosion.b();
        if (colors.isEmpty()) {
            effect.withColor(Color.WHITE);
        }
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            color = (Integer)intListIterator.next();
            effect.withColor(Color.fromRGB((int)color));
        }
        intListIterator = explosion.c().iterator();
        while (intListIterator.hasNext()) {
            color = (Integer)intListIterator.next();
            effect.withFade(Color.fromRGB((int)color));
        }
        return effect.build();
    }

    static FireworkExplosion getExplosion(FireworkEffect effect) {
        IntList colors = CraftMetaFirework.addColors(effect.getColors());
        IntList fadeColors = CraftMetaFirework.addColors(effect.getFadeColors());
        return new FireworkExplosion(CraftMetaFirework.getNBT(effect.getType()), colors, fadeColors, effect.hasTrail(), effect.hasFlicker());
    }

    static FireworkExplosion.a getNBT(FireworkEffect.Type type) {
        switch (type) {
            case BALL: {
                return FireworkExplosion.a.a;
            }
            case BALL_LARGE: {
                return FireworkExplosion.a.b;
            }
            case STAR: {
                return FireworkExplosion.a.c;
            }
            case CREEPER: {
                return FireworkExplosion.a.d;
            }
            case BURST: {
                return FireworkExplosion.a.e;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + String.valueOf(type));
    }

    static FireworkEffect.Type getEffectType(FireworkExplosion.a nbt) {
        switch (nbt) {
            case a: {
                return FireworkEffect.Type.BALL;
            }
            case b: {
                return FireworkEffect.Type.BALL_LARGE;
            }
            case c: {
                return FireworkEffect.Type.STAR;
            }
            case d: {
                return FireworkEffect.Type.CREEPER;
            }
            case e: {
                return FireworkEffect.Type.BURST;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + String.valueOf(nbt));
    }

    public boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }

    void safelyAddEffects(Iterable<?> collection) {
        if (collection == null || collection instanceof Collection && ((Collection)collection).isEmpty()) {
            return;
        }
        List<FireworkEffect> effects = this.effects;
        if (effects == null) {
            effects = this.effects = new ArrayList<FireworkEffect>();
        }
        for (Object obj : collection) {
            Preconditions.checkArgument((boolean)(obj instanceof FireworkEffect), (String)"%s in %s is not a FireworkEffect", obj, collection);
            effects.add((FireworkEffect)obj);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemTag) {
        super.applyToItem(itemTag);
        if (this.isFireworkEmpty()) {
            return;
        }
        ArrayList<FireworkExplosion> effects = new ArrayList<FireworkExplosion>();
        if (this.hasEffects()) {
            for (FireworkEffect effect : this.effects) {
                effects.add(CraftMetaFirework.getExplosion(effect));
            }
        }
        itemTag.put(FIREWORKS, new Fireworks(this.getPower(), effects));
    }

    static IntList addColors(List<Color> colors) {
        if (colors.isEmpty()) {
            return IntList.of();
        }
        int[] colorArray = new int[colors.size()];
        int i2 = 0;
        for (Color color : colors) {
            colorArray[i2++] = color.asRGB();
        }
        return IntList.of((int[])colorArray);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isFireworkEmpty();
    }

    boolean isFireworkEmpty() {
        return !this.hasEffects() && !this.hasPower();
    }

    public boolean hasPower() {
        return this.power != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaFirework) {
            CraftMetaFirework that = (CraftMetaFirework)meta;
            return Objects.equals(this.power, that.power) && (this.hasEffects() ? that.hasEffects() && this.effects.equals(that.effects) : !that.hasEffects());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaFirework || this.isFireworkEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasPower()) {
            hash = 61 * hash + this.power;
        }
        if (this.hasEffects()) {
            hash = 61 * hash + 13 * this.effects.hashCode();
        }
        return hash != original ? CraftMetaFirework.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasEffects()) {
            builder.put((Object)CraftMetaFirework.EXPLOSIONS.BUKKIT, (Object)ImmutableList.copyOf(this.effects));
        }
        if (this.hasPower()) {
            builder.put((Object)CraftMetaFirework.FLIGHT.BUKKIT, (Object)this.power);
        }
        return builder;
    }

    @Override
    public CraftMetaFirework clone() {
        CraftMetaFirework meta = (CraftMetaFirework)super.clone();
        if (this.effects != null) {
            meta.effects = new ArrayList<FireworkEffect>(this.effects);
        }
        return meta;
    }

    public void addEffect(FireworkEffect effect) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"FireworkEffect cannot be null");
        if (this.effects == null) {
            this.effects = new ArrayList<FireworkEffect>();
        }
        this.effects.add(effect);
    }

    public void addEffects(FireworkEffect ... effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        if (effects.length == 0) {
            return;
        }
        List<FireworkEffect> list = this.effects;
        if (list == null) {
            list = this.effects = new ArrayList<FireworkEffect>();
        }
        for (FireworkEffect effect : effects) {
            Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"effects cannot contain null FireworkEffect");
            list.add(effect);
        }
    }

    public void addEffects(Iterable<FireworkEffect> effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        this.safelyAddEffects(effects);
    }

    public List<FireworkEffect> getEffects() {
        return this.effects == null ? ImmutableList.of() : ImmutableList.copyOf(this.effects);
    }

    public int getEffectsSize() {
        return this.effects == null ? 0 : this.effects.size();
    }

    public void removeEffect(int index) {
        if (this.effects == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }
        this.effects.remove(index);
    }

    public void clearEffects() {
        this.effects = null;
    }

    public int getPower() {
        return this.hasPower() ? this.power : 0;
    }

    public void setPower(int power) {
        Preconditions.checkArgument((power >= 0 ? 1 : 0) != 0, (String)"power cannot be less than zero: %s", (int)power);
        Preconditions.checkArgument((power <= 255 ? 1 : 0) != 0, (String)"power cannot be more than 255: %s", (int)power);
        this.power = power;
    }
}

