/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;

public record DamagePredicate(MinMaxBounds.Doubles dealtDamage, MinMaxBounds.Doubles takenDamage, Optional<EntityPredicate> sourceEntity, Optional<Boolean> blocked, Optional<DamageSourcePredicate> type) {
    public static final Codec<DamagePredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("dealt", (Object)MinMaxBounds.Doubles.ANY).forGetter(DamagePredicate::dealtDamage), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("taken", (Object)MinMaxBounds.Doubles.ANY).forGetter(DamagePredicate::takenDamage), (App)EntityPredicate.CODEC.optionalFieldOf("source_entity").forGetter(DamagePredicate::sourceEntity), (App)Codec.BOOL.optionalFieldOf("blocked").forGetter(DamagePredicate::blocked), (App)DamageSourcePredicate.CODEC.optionalFieldOf("type").forGetter(DamagePredicate::type)).apply((Applicative)var0, DamagePredicate::new));

    public boolean matches(ServerPlayer var0, DamageSource var1, float var2, float var3, boolean var4) {
        if (!this.dealtDamage.matches(var2)) {
            return false;
        }
        if (!this.takenDamage.matches(var3)) {
            return false;
        }
        if (this.sourceEntity.isPresent() && !this.sourceEntity.get().matches(var0, var1.getEntity())) {
            return false;
        }
        if (this.blocked.isPresent() && this.blocked.get() != var4) {
            return false;
        }
        return !this.type.isPresent() || this.type.get().matches(var0, var1);
    }

    public static class Builder {
        private MinMaxBounds.Doubles dealtDamage = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles takenDamage = MinMaxBounds.Doubles.ANY;
        private Optional<EntityPredicate> sourceEntity = Optional.empty();
        private Optional<Boolean> blocked = Optional.empty();
        private Optional<DamageSourcePredicate> type = Optional.empty();

        public static Builder damageInstance() {
            return new Builder();
        }

        public Builder dealtDamage(MinMaxBounds.Doubles var0) {
            this.dealtDamage = var0;
            return this;
        }

        public Builder takenDamage(MinMaxBounds.Doubles var0) {
            this.takenDamage = var0;
            return this;
        }

        public Builder sourceEntity(EntityPredicate var0) {
            this.sourceEntity = Optional.of(var0);
            return this;
        }

        public Builder blocked(Boolean var0) {
            this.blocked = Optional.of(var0);
            return this;
        }

        public Builder type(DamageSourcePredicate var0) {
            this.type = Optional.of(var0);
            return this;
        }

        public Builder type(DamageSourcePredicate.Builder var0) {
            this.type = Optional.of(var0.build());
            return this;
        }

        public DamagePredicate build() {
            return new DamagePredicate(this.dealtDamage, this.takenDamage, this.sourceEntity, this.blocked, this.type);
        }
    }
}

