/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Optional<T> min();

    public Optional<T> max();

    default public boolean isAny() {
        return this.min().isEmpty() && this.max().isEmpty();
    }

    default public Optional<T> unwrapPoint() {
        Optional<T> var1;
        Optional<T> var0 = this.min();
        return var0.equals(var1 = this.max()) ? var0 : Optional.empty();
    }

    public static <T extends Number, R extends MinMaxBounds<T>> Codec<R> createCodec(Codec<T> var02, BoundsFactory<T, R> var1) {
        Codec var22 = RecordCodecBuilder.create(var2 -> var2.group((App)var02.optionalFieldOf("min").forGetter(MinMaxBounds::min), (App)var02.optionalFieldOf("max").forGetter(MinMaxBounds::max)).apply((Applicative)var2, var1::create));
        return Codec.either((Codec)var22, var02).xmap(var12 -> (MinMaxBounds)var12.map(var0 -> var0, var1 -> var1.create(Optional.of(var1), Optional.of(var1))), var0 -> {
            Optional var1 = var0.unwrapPoint();
            return var1.isPresent() ? Either.right((Object)((Number)var1.get())) : Either.left((Object)var0);
        });
    }

    public static <B extends ByteBuf, T extends Number, R extends MinMaxBounds<T>> StreamCodec<B, R> createStreamCodec(final StreamCodec<B, T> var0, final BoundsFactory<T, R> var1) {
        return new StreamCodec<B, R>(){
            private static final int MIN_FLAG = 1;
            public static final int MAX_FLAG = 2;

            @Override
            public R decode(B var02) {
                byte var12 = var02.readByte();
                Optional var2 = (var12 & 1) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                Optional var3 = (var12 & 2) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                return var1.create(var2, var3);
            }

            @Override
            public void encode(B var02, R var12) {
                Optional<Number> var22 = var12.min();
                Optional<Number> var3 = var12.max();
                var02.writeByte((var22.isPresent() ? 1 : 0) | (var3.isPresent() ? 2 : 0));
                var22.ifPresent(var2 -> var0.encode(var02, var2));
                var3.ifPresent(var2 -> var0.encode(var02, var2));
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (R)((MinMaxBounds)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader var0, BoundsFromReaderFactory<T, R> var1, Function<String, T> var2, Supplier<DynamicCommandExceptionType> var3, Function<T, T> var4) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
        }
        int var5 = var0.getCursor();
        try {
            Optional<T> var7;
            Optional<T> var6 = MinMaxBounds.readNumber(var0, var2, var3).map(var4);
            if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
                var0.skip();
                var0.skip();
                var7 = MinMaxBounds.readNumber(var0, var2, var3).map(var4);
                if (var6.isEmpty() && var7.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
                }
            } else {
                var7 = var6;
            }
            if (var6.isEmpty() && var7.isEmpty()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
            return var1.create(var0, var6, var7);
        }
        catch (CommandSyntaxException var6) {
            var0.setCursor(var5);
            throw new CommandSyntaxException(var6.getType(), var6.getRawMessage(), var6.getInput(), var5);
        }
    }

    private static <T extends Number> Optional<T> readNumber(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
        int var3 = var0.getCursor();
        while (var0.canRead() && MinMaxBounds.isAllowedInputChat(var0)) {
            var0.skip();
        }
        String var4 = var0.getString().substring(var3, var0.getCursor());
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)var1.apply(var4));
        }
        catch (NumberFormatException var5) {
            throw var2.get().createWithContext((ImmutableStringReader)var0, (Object)var4);
        }
    }

    private static boolean isAllowedInputChat(StringReader var0) {
        char var1 = var0.peek();
        if (var1 >= '0' && var1 <= '9' || var1 == '-') {
            return true;
        }
        if (var1 == '.') {
            return !var0.canRead(2) || var0.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public record Doubles(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Optional.empty(), Optional.empty());
        public static final Codec<Doubles> CODEC = MinMaxBounds.createCodec(Codec.DOUBLE, Doubles::new);
        public static final StreamCodec<ByteBuf, Doubles> STREAM_CODEC = MinMaxBounds.createStreamCodec(ByteBufCodecs.DOUBLE, Doubles::new);

        private Doubles(Optional<Double> var0, Optional<Double> var1) {
            this(var0, var1, Doubles.squareOpt(var0), Doubles.squareOpt(var1));
        }

        private static Doubles create(StringReader var0, Optional<Double> var1, Optional<Double> var2) throws CommandSyntaxException {
            if (var1.isPresent() && var2.isPresent() && var1.get() > var2.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new Doubles(var1, var2);
        }

        private static Optional<Double> squareOpt(Optional<Double> var02) {
            return var02.map(var0 -> var0 * var0);
        }

        public static Doubles exactly(double var0) {
            return new Doubles(Optional.of(var0), Optional.of(var0));
        }

        public static Doubles between(double var0, double var2) {
            return new Doubles(Optional.of(var0), Optional.of(var2));
        }

        public static Doubles atLeast(double var0) {
            return new Doubles(Optional.of(var0), Optional.empty());
        }

        public static Doubles atMost(double var0) {
            return new Doubles(Optional.empty(), Optional.of(var0));
        }

        public boolean matches(double var0) {
            if (this.min.isPresent() && this.min.get() > var0) {
                return false;
            }
            return this.max.isEmpty() || !(this.max.get() < var0);
        }

        public boolean matchesSqr(double var0) {
            if (this.minSq.isPresent() && this.minSq.get() > var0) {
                return false;
            }
            return this.maxSq.isEmpty() || !(this.maxSq.get() < var0);
        }

        public static Doubles fromReader(StringReader var02) throws CommandSyntaxException {
            return Doubles.fromReader(var02, var0 -> var0);
        }

        public static Doubles fromReader(StringReader var0, Function<Double, Double> var1) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(var0, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), var1);
        }
    }

    public record Ints(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Optional.empty(), Optional.empty());
        public static final Codec<Ints> CODEC = MinMaxBounds.createCodec(Codec.INT, Ints::new);
        public static final StreamCodec<ByteBuf, Ints> STREAM_CODEC = MinMaxBounds.createStreamCodec(ByteBufCodecs.INT, Ints::new);

        private Ints(Optional<Integer> var02, Optional<Integer> var1) {
            this(var02, var1, var02.map(var0 -> var0.longValue() * var0.longValue()), Ints.squareOpt(var1));
        }

        private static Ints create(StringReader var0, Optional<Integer> var1, Optional<Integer> var2) throws CommandSyntaxException {
            if (var1.isPresent() && var2.isPresent() && var1.get() > var2.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new Ints(var1, var2);
        }

        private static Optional<Long> squareOpt(Optional<Integer> var02) {
            return var02.map(var0 -> var0.longValue() * var0.longValue());
        }

        public static Ints exactly(int var0) {
            return new Ints(Optional.of(var0), Optional.of(var0));
        }

        public static Ints between(int var0, int var1) {
            return new Ints(Optional.of(var0), Optional.of(var1));
        }

        public static Ints atLeast(int var0) {
            return new Ints(Optional.of(var0), Optional.empty());
        }

        public static Ints atMost(int var0) {
            return new Ints(Optional.empty(), Optional.of(var0));
        }

        public boolean matches(int var0) {
            if (this.min.isPresent() && this.min.get() > var0) {
                return false;
            }
            return this.max.isEmpty() || this.max.get() >= var0;
        }

        public boolean matchesSqr(long var0) {
            if (this.minSq.isPresent() && this.minSq.get() > var0) {
                return false;
            }
            return this.maxSq.isEmpty() || this.maxSq.get() >= var0;
        }

        public static Ints fromReader(StringReader var02) throws CommandSyntaxException {
            return Ints.fromReader(var02, var0 -> var0);
        }

        public static Ints fromReader(StringReader var0, Function<Integer, Integer> var1) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(var0, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), var1);
        }
    }
}

