/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class EntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.toomany"));
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_PLAYERS_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.entities"));
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.selector.not_allowed"));
    final boolean single;
    final boolean playersOnly;

    protected EntityArgument(boolean flag, boolean flag1) {
        this.single = flag;
        this.playersOnly = flag1;
    }

    public static EntityArgument entity() {
        return new EntityArgument(true, false);
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        return ((EntitySelector)commandcontext.getArgument(s, EntitySelector.class)).findSingleEntity((CommandSourceStack)commandcontext.getSource());
    }

    public static EntityArgument entities() {
        return new EntityArgument(false, false);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        Collection<? extends Entity> collection = EntityArgument.getOptionalEntities(commandcontext, s);
        if (collection.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> getOptionalEntities(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        return ((EntitySelector)commandcontext.getArgument(s, EntitySelector.class)).findEntities((CommandSourceStack)commandcontext.getSource());
    }

    public static Collection<ServerPlayer> getOptionalPlayers(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        return ((EntitySelector)commandcontext.getArgument(s, EntitySelector.class)).findPlayers((CommandSourceStack)commandcontext.getSource());
    }

    public static EntityArgument player() {
        return new EntityArgument(true, true);
    }

    public static ServerPlayer getPlayer(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        return ((EntitySelector)commandcontext.getArgument(s, EntitySelector.class)).findSinglePlayer((CommandSourceStack)commandcontext.getSource());
    }

    public static EntityArgument players() {
        return new EntityArgument(false, true);
    }

    public static Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> commandcontext, String s) throws CommandSyntaxException {
        List<ServerPlayer> list = ((EntitySelector)commandcontext.getArgument(s, EntitySelector.class)).findPlayers((CommandSourceStack)commandcontext.getSource());
        if (list.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        return list;
    }

    public EntitySelector parse(StringReader stringreader) throws CommandSyntaxException {
        return this.parse(stringreader, true);
    }

    public <S> EntitySelector parse(StringReader stringreader, S s0) throws CommandSyntaxException {
        return this.parse(stringreader, EntitySelectorParser.allowSelectors(s0));
    }

    private EntitySelector parse(StringReader stringreader, boolean flag) throws CommandSyntaxException {
        return this.parse(stringreader, flag, false);
    }

    public EntitySelector parse(StringReader stringreader, boolean flag, boolean overridePermissions) throws CommandSyntaxException {
        boolean i = false;
        EntitySelectorParser argumentparserselector = new EntitySelectorParser(stringreader, flag);
        EntitySelector entityselector = argumentparserselector.parse(overridePermissions);
        if (entityselector.getMaxResults() > 1 && this.single) {
            if (this.playersOnly) {
                stringreader.setCursor(0);
                throw ERROR_NOT_SINGLE_PLAYER.createWithContext((ImmutableStringReader)stringreader);
            }
            stringreader.setCursor(0);
            throw ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)stringreader);
        }
        if (entityselector.includesEntities() && this.playersOnly && !entityselector.isSelfSelector()) {
            stringreader.setCursor(0);
            throw ERROR_ONLY_PLAYERS_ALLOWED.createWithContext((ImmutableStringReader)stringreader);
        }
        return entityselector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandcontext, SuggestionsBuilder suggestionsbuilder) {
        Object object = commandcontext.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider icompletionprovider = (SharedSuggestionProvider)object;
            StringReader stringreader = new StringReader(suggestionsbuilder.getInput());
            stringreader.setCursor(suggestionsbuilder.getStart());
            EntitySelectorParser argumentparserselector = new EntitySelectorParser(stringreader, EntitySelectorParser.allowSelectors(icompletionprovider));
            try {
                argumentparserselector.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return argumentparserselector.fillSuggestions(suggestionsbuilder, suggestionsbuilder1 -> {
                Collection<String> collection = icompletionprovider.getOnlinePlayerNames();
                Collection<String> iterable = this.playersOnly ? collection : Iterables.concat(collection, icompletionprovider.getSelectedEntities());
                SharedSuggestionProvider.suggest(iterable, suggestionsbuilder1);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info
    implements ArgumentTypeInfo<EntityArgument, Template> {
        private static final byte FLAG_SINGLE = 1;
        private static final byte FLAG_PLAYERS_ONLY = 2;

        @Override
        public void serializeToNetwork(Template argumententity_info_template, FriendlyByteBuf packetdataserializer) {
            int i = 0;
            if (argumententity_info_template.single) {
                i |= 1;
            }
            if (argumententity_info_template.playersOnly) {
                i |= 2;
            }
            packetdataserializer.writeByte(i);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf packetdataserializer) {
            byte b0 = packetdataserializer.readByte();
            return new Template((b0 & 1) != 0, (b0 & 2) != 0);
        }

        @Override
        public void serializeToJson(Template argumententity_info_template, JsonObject jsonobject) {
            jsonobject.addProperty("amount", argumententity_info_template.single ? "single" : "multiple");
            jsonobject.addProperty("type", argumententity_info_template.playersOnly ? "players" : "entities");
        }

        @Override
        public Template unpack(EntityArgument argumententity) {
            return new Template(argumententity.single, argumententity.playersOnly);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<EntityArgument> {
            final boolean single;
            final boolean playersOnly;

            Template(boolean flag, boolean flag1) {
                this.single = flag;
                this.playersOnly = flag1;
            }

            @Override
            public EntityArgument instantiate(CommandBuildContext commandbuildcontext) {
                return new EntityArgument(this.single, this.playersOnly);
            }

            @Override
            public ArgumentTypeInfo<EntityArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

