/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;

public class WorldCoordinate {
    private static final char PREFIX_RELATIVE = '~';
    public static final SimpleCommandExceptionType ERROR_EXPECTED_DOUBLE = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.double"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_INT = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.int"));
    private final boolean relative;
    private final double value;

    public WorldCoordinate(boolean var0, double var1) {
        this.relative = var0;
        this.value = var1;
    }

    public double get(double var0) {
        if (this.relative) {
            return this.value + var0;
        }
        return this.value;
    }

    public static WorldCoordinate parseDouble(StringReader var0, boolean var1) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        if (!var0.canRead()) {
            throw ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)var0);
        }
        boolean var2 = WorldCoordinate.isRelative(var0);
        int var3 = var0.getCursor();
        double var4 = var0.canRead() && var0.peek() != ' ' ? var0.readDouble() : 0.0;
        String var6 = var0.getString().substring(var3, var0.getCursor());
        if (var2 && var6.isEmpty()) {
            return new WorldCoordinate(true, 0.0);
        }
        if (!var6.contains(".") && !var2 && var1) {
            var4 += 0.5;
        }
        return new WorldCoordinate(var2, var4);
    }

    public static WorldCoordinate parseInt(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        if (!var0.canRead()) {
            throw ERROR_EXPECTED_INT.createWithContext((ImmutableStringReader)var0);
        }
        boolean var1 = WorldCoordinate.isRelative(var0);
        double var2 = var0.canRead() && var0.peek() != ' ' ? (var1 ? var0.readDouble() : (double)var0.readInt()) : 0.0;
        return new WorldCoordinate(var1, var2);
    }

    public static boolean isRelative(StringReader var0) {
        boolean var1;
        if (var0.peek() == '~') {
            var1 = true;
            var0.skip();
        } else {
            var1 = false;
        }
        return var1;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof WorldCoordinate)) {
            return false;
        }
        WorldCoordinate var1 = (WorldCoordinate)var0;
        if (this.relative != var1.relative) {
            return false;
        }
        return Double.compare(var1.value, this.value) == 0;
    }

    public int hashCode() {
        int var0 = this.relative ? 1 : 0;
        long var1 = Double.doubleToLongBits(this.value);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        return var0;
    }

    public boolean isRelative() {
        return this.relative;
    }
}

