/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;

public record SelectorPattern(String pattern, EntitySelector resolved) {
    public static final Codec<SelectorPattern> CODEC = Codec.STRING.comapFlatMap(SelectorPattern::parse, SelectorPattern::pattern);

    public static DataResult<SelectorPattern> parse(String var0) {
        try {
            EntitySelectorParser var1 = new EntitySelectorParser(new StringReader(var0), true);
            return DataResult.success((Object)new SelectorPattern(var0, var1.parse()));
        }
        catch (CommandSyntaxException var1) {
            return DataResult.error(() -> "Invalid selector component: " + var0 + ": " + var1.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object var0) {
        if (!(var0 instanceof SelectorPattern)) return false;
        SelectorPattern var1 = (SelectorPattern)var0;
        if (!this.pattern.equals(var1.pattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return this.pattern;
    }
}

