/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final StringRepresentable.EnumCodec<Direction> CODEC;
    public static final Codec<Direction> VERTICAL_CODEC;
    public static final IntFunction<Direction> BY_ID;
    public static final StreamCodec<ByteBuf, Direction> STREAM_CODEC;
    @Deprecated
    public static final Codec<Direction> LEGACY_ID_CODEC;
    @Deprecated
    public static final Codec<Direction> LEGACY_ID_CODEC_2D;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    private final Vec3 normalVec3;
    private final Vector3fc normalVec3f;
    private static final Direction[] VALUES;
    private static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;

    private Direction(int var2, int var3, int var4, String var5, AxisDirection var6, Axis var7, Vec3i var8) {
        this.data3d = var2;
        this.data2d = var4;
        this.oppositeIndex = var3;
        this.name = var5;
        this.axis = var7;
        this.axisDirection = var6;
        this.normal = var8;
        this.normalVec3 = Vec3.atLowerCornerOf(var8);
        this.normalVec3f = new Vector3f((float)var8.getX(), (float)var8.getY(), (float)var8.getZ());
    }

    public static Direction[] orderedByNearest(Entity var0) {
        Direction var17;
        float var1 = var0.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float var2 = -var0.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float var3 = Mth.sin(var1);
        float var4 = Mth.cos(var1);
        float var5 = Mth.sin(var2);
        float var6 = Mth.cos(var2);
        boolean var7 = var5 > 0.0f;
        boolean var8 = var3 < 0.0f;
        boolean var9 = var6 > 0.0f;
        float var10 = var7 ? var5 : -var5;
        float var11 = var8 ? -var3 : var3;
        float var12 = var9 ? var6 : -var6;
        float var13 = var10 * var4;
        float var14 = var12 * var4;
        Direction var15 = var7 ? EAST : WEST;
        Direction var16 = var8 ? UP : DOWN;
        Direction direction = var17 = var9 ? SOUTH : NORTH;
        if (var10 > var12) {
            if (var11 > var13) {
                return Direction.makeDirectionArray(var16, var15, var17);
            }
            if (var14 > var11) {
                return Direction.makeDirectionArray(var15, var17, var16);
            }
            return Direction.makeDirectionArray(var15, var16, var17);
        }
        if (var11 > var14) {
            return Direction.makeDirectionArray(var16, var17, var15);
        }
        if (var13 > var11) {
            return Direction.makeDirectionArray(var17, var15, var16);
        }
        return Direction.makeDirectionArray(var17, var16, var15);
    }

    private static Direction[] makeDirectionArray(Direction var0, Direction var1, Direction var2) {
        return new Direction[]{var0, var1, var2, var2.getOpposite(), var1.getOpposite(), var0.getOpposite()};
    }

    public static Direction rotate(Matrix4fc var0, Direction var1) {
        Vector3f var2 = var0.transformDirection(var1.normalVec3f, new Vector3f());
        return Direction.getApproximateNearest(var2.x(), var2.y(), var2.z());
    }

    public static Collection<Direction> allShuffled(RandomSource var0) {
        return Util.shuffledCopy(Direction.values(), var0);
    }

    public static Stream<Direction> stream() {
        return Stream.of(VALUES);
    }

    public static float getYRot(Direction var0) {
        return switch (var0.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(var0));
        };
    }

    public Quaternionf getRotation() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Quaternionf().rotationX((float)Math.PI);
            case 1 -> new Quaternionf();
            case 2 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case 3 -> new Quaternionf().rotationX(1.5707964f);
            case 4 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case 5 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static Direction getFacingAxis(Entity var0, Axis var1) {
        return switch (var1.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (EAST.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield EAST;
                }
                yield WEST;
            }
            case 2 -> {
                if (SOUTH.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield SOUTH;
                }
                yield NORTH;
            }
            case 1 -> var0.getViewXRot(1.0f) < 0.0f ? UP : DOWN;
        };
    }

    public Direction getOpposite() {
        return Direction.from3DDataValue(this.oppositeIndex);
    }

    public Direction getClockWise(Axis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getClockWiseX();
            }
            case 1 -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getClockWise();
            }
            case 2 -> this == NORTH || this == SOUTH ? this : this.getClockWiseZ();
        };
    }

    public Direction getCounterClockWise(Axis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getCounterClockWiseX();
            }
            case 1 -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getCounterClockWise();
            }
            case 2 -> this == NORTH || this == SOUTH ? this : this.getCounterClockWiseZ();
        };
    }

    public Direction getClockWise() {
        return switch (this.ordinal()) {
            case 2 -> EAST;
            case 5 -> SOUTH;
            case 3 -> WEST;
            case 4 -> NORTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseX() {
        return switch (this.ordinal()) {
            case 1 -> NORTH;
            case 2 -> DOWN;
            case 0 -> SOUTH;
            case 3 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getCounterClockWiseX() {
        return switch (this.ordinal()) {
            case 1 -> SOUTH;
            case 3 -> DOWN;
            case 0 -> NORTH;
            case 2 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseZ() {
        return switch (this.ordinal()) {
            case 1 -> EAST;
            case 5 -> DOWN;
            case 0 -> WEST;
            case 4 -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getCounterClockWiseZ() {
        return switch (this.ordinal()) {
            case 1 -> WEST;
            case 4 -> DOWN;
            case 0 -> EAST;
            case 5 -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    public Direction getCounterClockWise() {
        return switch (this.ordinal()) {
            case 2 -> WEST;
            case 5 -> NORTH;
            case 3 -> EAST;
            case 4 -> SOUTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3f step() {
        return new Vector3f(this.normalVec3f);
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static Direction byName(@Nullable String var0) {
        return CODEC.byName(var0);
    }

    public static Direction from3DDataValue(int var0) {
        return BY_3D_DATA[Mth.abs(var0 % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int var0) {
        return BY_2D_DATA[Mth.abs(var0 % BY_2D_DATA.length)];
    }

    public static Direction fromYRot(double var0) {
        return Direction.from2DDataValue(Mth.floor(var0 / 90.0 + 0.5) & 3);
    }

    public static Direction fromAxisAndDirection(Axis var0, AxisDirection var1) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (var1 == AxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (var1 == AxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> var1 == AxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static Direction getRandom(RandomSource var0) {
        return Util.getRandom(VALUES, var0);
    }

    public static Direction getApproximateNearest(double var0, double var2, double var4) {
        return Direction.getApproximateNearest((float)var0, (float)var2, (float)var4);
    }

    public static Direction getApproximateNearest(float var0, float var1, float var2) {
        Direction var3 = NORTH;
        float var4 = Float.MIN_VALUE;
        for (Direction var8 : VALUES) {
            float var9 = var0 * (float)var8.normal.getX() + var1 * (float)var8.normal.getY() + var2 * (float)var8.normal.getZ();
            if (!(var9 > var4)) continue;
            var4 = var9;
            var3 = var8;
        }
        return var3;
    }

    public static Direction getApproximateNearest(Vec3 var0) {
        return Direction.getApproximateNearest(var0.x, var0.y, var0.z);
    }

    @Nullable
    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static Direction getNearest(int var0, int var1, int var2, @Nullable Direction var3) {
        int var4 = Math.abs(var0);
        int var5 = Math.abs(var1);
        int var6 = Math.abs(var2);
        if (var4 > var6 && var4 > var5) {
            return var0 < 0 ? WEST : EAST;
        }
        if (var6 > var4 && var6 > var5) {
            return var2 < 0 ? NORTH : SOUTH;
        }
        if (var5 > var4 && var5 > var6) {
            return var1 < 0 ? DOWN : UP;
        }
        return var3;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    public static Direction getNearest(Vec3i var0, @Nullable Direction var1) {
        return Direction.getNearest(var0.getX(), var0.getY(), var0.getZ(), var1);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<Direction> verifyVertical(Direction var0) {
        return var0.getAxis().isVertical() ? DataResult.success((Object)var0) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static Direction get(AxisDirection var0, Axis var1) {
        for (Direction var5 : VALUES) {
            if (var5.getAxisDirection() != var0 || var5.getAxis() != var1) continue;
            return var5;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)var0) + " " + String.valueOf(var1));
    }

    public Vec3i getUnitVec3i() {
        return this.normal;
    }

    public Vec3 getUnitVec3() {
        return this.normalVec3;
    }

    public Vector3fc getUnitVec3f() {
        return this.normalVec3f;
    }

    public boolean isFacingAngle(float var0) {
        float var1 = var0 * ((float)Math.PI / 180);
        float var2 = -Mth.sin(var1);
        float var3 = Mth.cos(var1);
        return (float)this.normal.getX() * var2 + (float)this.normal.getZ() * var3 > 0.0f;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values);
        VERTICAL_CODEC = CODEC.validate(Direction::verifyVertical);
        BY_ID = ByIdMap.continuous(Direction::get3DDataValue, Direction.values(), ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Direction::get3DDataValue);
        LEGACY_ID_CODEC = Codec.BYTE.xmap(Direction::from3DDataValue, var0 -> (byte)var0.get3DDataValue());
        LEGACY_ID_CODEC_2D = Codec.BYTE.xmap(Direction::from2DDataValue, var0 -> (byte)var0.get2DDataValue());
        VALUES = Direction.values();
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(var0 -> var0.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(var0 -> var0.getAxis().isHorizontal()).sorted(Comparator.comparingInt(var0 -> var0.data2d)).toArray(Direction[]::new);
    }

    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var0;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var0;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var0;
            }

            @Override
            public Direction getPositive() {
                return EAST;
            }

            @Override
            public Direction getNegative() {
                return WEST;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var1;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var2;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var1;
            }

            @Override
            public Direction getPositive() {
                return UP;
            }

            @Override
            public Direction getNegative() {
                return DOWN;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var2;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var4;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var2;
            }

            @Override
            public Direction getPositive() {
                return SOUTH;
            }

            @Override
            public Direction getNegative() {
                return NORTH;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        };

        public static final Axis[] VALUES;
        public static final StringRepresentable.EnumCodec<Axis> CODEC;
        private final String name;

        Axis(String var2) {
            this.name = var2;
        }

        @Nullable
        public static Axis byName(String var0) {
            return CODEC.byName(var0);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public abstract Direction getPositive();

        public abstract Direction getNegative();

        public Direction[] getDirections() {
            return new Direction[]{this.getPositive(), this.getNegative()};
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandom(RandomSource var0) {
            return Util.getRandom(VALUES, var0);
        }

        @Override
        public boolean test(@Nullable Direction var0) {
            return var0 != null && var0.getAxis() == this;
        }

        public Plane getPlane() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> Plane.HORIZONTAL;
                case 1 -> Plane.VERTICAL;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        public abstract boolean choose(boolean var1, boolean var2, boolean var3);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }

        static {
            VALUES = Axis.values();
            CODEC = StringRepresentable.fromEnum(Axis::values);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int var2, String var3) {
            this.step = var2;
            this.name = var3;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] faces;
        private final Axis[] axis;

        private Plane(Direction[] var2, Axis[] var3) {
            this.faces = var2;
            this.axis = var3;
        }

        public Direction getRandomDirection(RandomSource var0) {
            return Util.getRandom(this.faces, var0);
        }

        public Axis getRandomAxis(RandomSource var0) {
            return Util.getRandom(this.axis, var0);
        }

        @Override
        public boolean test(@Nullable Direction var0) {
            return var0 != null && var0.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<Direction> stream() {
            return Arrays.stream(this.faces);
        }

        public List<Direction> shuffledCopy(RandomSource var0) {
            return Util.shuffledCopy(this.faces, var0);
        }

        public int length() {
            return this.faces.length;
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }
    }
}

