/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MinecartDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractMinecart> entityType;

    public MinecartDispenseItemBehavior(EntityType<? extends AbstractMinecart> entitytypes) {
        this.entityType = entitytypes;
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        double d3;
        Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
        ServerLevel worldserver = sourceblock.level();
        Vec3 vec3d = sourceblock.center();
        double d0 = vec3d.x() + (double)enumdirection.getStepX() * 1.125;
        double d1 = Math.floor(vec3d.y()) + (double)enumdirection.getStepY();
        double d2 = vec3d.z() + (double)enumdirection.getStepZ() * 1.125;
        BlockPos blockposition = sourceblock.pos().relative(enumdirection);
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        if (iblockdata.is(BlockTags.RAILS)) {
            d3 = MinecartDispenseItemBehavior.getRailShape(iblockdata).isSlope() ? 0.6 : 0.1;
        } else {
            if (!iblockdata.isAir()) {
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
            BlockState iblockdata1 = worldserver.getBlockState(blockposition.below());
            if (!iblockdata1.is(BlockTags.RAILS)) {
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
            d3 = enumdirection != Direction.DOWN && MinecartDispenseItemBehavior.getRailShape(iblockdata1).isSlope() ? -0.4 : -0.9;
        }
        Vec3 vec3d1 = new Vec3(d0, d1 + d3, d2);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        CraftBlock block2 = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block2, (ItemStack)craftItem.clone(), new Vector(vec3d1.x, vec3d1.y, vec3d1.z));
        if (!DispenserBlock.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
        }
        itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
        AbstractMinecart entityminecartabstract = AbstractMinecart.createMinecart(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.entityType, EntitySpawnReason.DISPENSER, itemstack1, null);
        if (entityminecartabstract != null && !worldserver.addFreshEntity(entityminecartabstract)) {
            itemstack.grow(1);
        }
        return itemstack;
    }

    private static RailShape getRailShape(BlockState iblockdata) {
        RailShape blockpropertytrackposition;
        Block block = iblockdata.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock blockminecarttrackabstract = (BaseRailBlock)block;
            blockpropertytrackposition = iblockdata.getValue(blockminecarttrackabstract.getShapeProperty());
        } else {
            blockpropertytrackposition = RailShape.NORTH_SOUTH;
        }
        return blockpropertytrackposition;
    }

    @Override
    protected void playSound(BlockSource sourceblock) {
        sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
    }
}

