/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.placement;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class VegetationPlacements {
    public static final ResourceKey<PlacedFeature> BAMBOO_LIGHT = PlacementUtils.createKey("bamboo_light");
    public static final ResourceKey<PlacedFeature> BAMBOO = PlacementUtils.createKey("bamboo");
    public static final ResourceKey<PlacedFeature> VINES = PlacementUtils.createKey("vines");
    public static final ResourceKey<PlacedFeature> PATCH_SUNFLOWER = PlacementUtils.createKey("patch_sunflower");
    public static final ResourceKey<PlacedFeature> PATCH_PUMPKIN = PlacementUtils.createKey("patch_pumpkin");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_PLAIN = PlacementUtils.createKey("patch_grass_plain");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_MEADOW = PlacementUtils.createKey("patch_grass_meadow");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_FOREST = PlacementUtils.createKey("patch_grass_forest");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_BADLANDS = PlacementUtils.createKey("patch_grass_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_SAVANNA = PlacementUtils.createKey("patch_grass_savanna");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_NORMAL = PlacementUtils.createKey("patch_grass_normal");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_TAIGA_2 = PlacementUtils.createKey("patch_grass_taiga_2");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_TAIGA = PlacementUtils.createKey("patch_grass_taiga");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_JUNGLE = PlacementUtils.createKey("patch_grass_jungle");
    public static final ResourceKey<PlacedFeature> GRASS_BONEMEAL = PlacementUtils.createKey("grass_bonemeal");
    public static final ResourceKey<PlacedFeature> PATCH_DEAD_BUSH_2 = PlacementUtils.createKey("patch_dead_bush_2");
    public static final ResourceKey<PlacedFeature> PATCH_DEAD_BUSH = PlacementUtils.createKey("patch_dead_bush");
    public static final ResourceKey<PlacedFeature> PATCH_DEAD_BUSH_BADLANDS = PlacementUtils.createKey("patch_dead_bush_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_DRY_GRASS_BADLANDS = PlacementUtils.createKey("patch_dry_grass_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_DRY_GRASS_DESERT = PlacementUtils.createKey("patch_dry_grass_desert");
    public static final ResourceKey<PlacedFeature> PATCH_MELON = PlacementUtils.createKey("patch_melon");
    public static final ResourceKey<PlacedFeature> PATCH_MELON_SPARSE = PlacementUtils.createKey("patch_melon_sparse");
    public static final ResourceKey<PlacedFeature> PATCH_BERRY_COMMON = PlacementUtils.createKey("patch_berry_common");
    public static final ResourceKey<PlacedFeature> PATCH_BERRY_RARE = PlacementUtils.createKey("patch_berry_rare");
    public static final ResourceKey<PlacedFeature> PATCH_WATERLILY = PlacementUtils.createKey("patch_waterlily");
    public static final ResourceKey<PlacedFeature> PATCH_TALL_GRASS_2 = PlacementUtils.createKey("patch_tall_grass_2");
    public static final ResourceKey<PlacedFeature> PATCH_TALL_GRASS = PlacementUtils.createKey("patch_tall_grass");
    public static final ResourceKey<PlacedFeature> PATCH_LARGE_FERN = PlacementUtils.createKey("patch_large_fern");
    public static final ResourceKey<PlacedFeature> PATCH_BUSH = PlacementUtils.createKey("patch_bush");
    public static final ResourceKey<PlacedFeature> PATCH_LEAF_LITTER = PlacementUtils.createKey("patch_leaf_litter");
    public static final ResourceKey<PlacedFeature> PATCH_CACTUS_DESERT = PlacementUtils.createKey("patch_cactus_desert");
    public static final ResourceKey<PlacedFeature> PATCH_CACTUS_DECORATED = PlacementUtils.createKey("patch_cactus_decorated");
    public static final ResourceKey<PlacedFeature> PATCH_SUGAR_CANE_SWAMP = PlacementUtils.createKey("patch_sugar_cane_swamp");
    public static final ResourceKey<PlacedFeature> PATCH_SUGAR_CANE_DESERT = PlacementUtils.createKey("patch_sugar_cane_desert");
    public static final ResourceKey<PlacedFeature> PATCH_SUGAR_CANE_BADLANDS = PlacementUtils.createKey("patch_sugar_cane_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_SUGAR_CANE = PlacementUtils.createKey("patch_sugar_cane");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_SWAMP = PlacementUtils.createKey("patch_firefly_bush_swamp");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_NEAR_WATER_SWAMP = PlacementUtils.createKey("patch_firefly_bush_near_water_swamp");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_NEAR_WATER = PlacementUtils.createKey("patch_firefly_bush_near_water");
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM_NETHER = PlacementUtils.createKey("brown_mushroom_nether");
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM_NETHER = PlacementUtils.createKey("red_mushroom_nether");
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM_NORMAL = PlacementUtils.createKey("brown_mushroom_normal");
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM_NORMAL = PlacementUtils.createKey("red_mushroom_normal");
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM_TAIGA = PlacementUtils.createKey("brown_mushroom_taiga");
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM_TAIGA = PlacementUtils.createKey("red_mushroom_taiga");
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM_OLD_GROWTH = PlacementUtils.createKey("brown_mushroom_old_growth");
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM_OLD_GROWTH = PlacementUtils.createKey("red_mushroom_old_growth");
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM_SWAMP = PlacementUtils.createKey("brown_mushroom_swamp");
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM_SWAMP = PlacementUtils.createKey("red_mushroom_swamp");
    public static final ResourceKey<PlacedFeature> FLOWER_WARM = PlacementUtils.createKey("flower_warm");
    public static final ResourceKey<PlacedFeature> FLOWER_DEFAULT = PlacementUtils.createKey("flower_default");
    public static final ResourceKey<PlacedFeature> FLOWER_FLOWER_FOREST = PlacementUtils.createKey("flower_flower_forest");
    public static final ResourceKey<PlacedFeature> FLOWER_SWAMP = PlacementUtils.createKey("flower_swamp");
    public static final ResourceKey<PlacedFeature> FLOWER_PLAINS = PlacementUtils.createKey("flower_plains");
    public static final ResourceKey<PlacedFeature> FLOWER_MEADOW = PlacementUtils.createKey("flower_meadow");
    public static final ResourceKey<PlacedFeature> FLOWER_CHERRY = PlacementUtils.createKey("flower_cherry");
    public static final ResourceKey<PlacedFeature> FLOWER_PALE_GARDEN = PlacementUtils.createKey("flower_pale_garden");
    public static final ResourceKey<PlacedFeature> WILDFLOWERS_BIRCH_FOREST = PlacementUtils.createKey("wildflowers_birch_forest");
    public static final ResourceKey<PlacedFeature> WILDFLOWERS_MEADOW = PlacementUtils.createKey("wildflowers_meadow");
    public static final ResourceKey<PlacedFeature> TREES_PLAINS = PlacementUtils.createKey("trees_plains");
    public static final ResourceKey<PlacedFeature> DARK_FOREST_VEGETATION = PlacementUtils.createKey("dark_forest_vegetation");
    public static final ResourceKey<PlacedFeature> PALE_GARDEN_VEGETATION = PlacementUtils.createKey("pale_garden_vegetation");
    public static final ResourceKey<PlacedFeature> FLOWER_FOREST_FLOWERS = PlacementUtils.createKey("flower_forest_flowers");
    public static final ResourceKey<PlacedFeature> FOREST_FLOWERS = PlacementUtils.createKey("forest_flowers");
    public static final ResourceKey<PlacedFeature> PALE_GARDEN_FLOWERS = PlacementUtils.createKey("pale_garden_flowers");
    public static final ResourceKey<PlacedFeature> PALE_MOSS_PATCH = PlacementUtils.createKey("pale_moss_patch");
    public static final ResourceKey<PlacedFeature> TREES_FLOWER_FOREST = PlacementUtils.createKey("trees_flower_forest");
    public static final ResourceKey<PlacedFeature> TREES_MEADOW = PlacementUtils.createKey("trees_meadow");
    public static final ResourceKey<PlacedFeature> TREES_CHERRY = PlacementUtils.createKey("trees_cherry");
    public static final ResourceKey<PlacedFeature> TREES_TAIGA = PlacementUtils.createKey("trees_taiga");
    public static final ResourceKey<PlacedFeature> TREES_GROVE = PlacementUtils.createKey("trees_grove");
    public static final ResourceKey<PlacedFeature> TREES_BADLANDS = PlacementUtils.createKey("trees_badlands");
    public static final ResourceKey<PlacedFeature> TREES_SNOWY = PlacementUtils.createKey("trees_snowy");
    public static final ResourceKey<PlacedFeature> TREES_SWAMP = PlacementUtils.createKey("trees_swamp");
    public static final ResourceKey<PlacedFeature> TREES_WINDSWEPT_SAVANNA = PlacementUtils.createKey("trees_windswept_savanna");
    public static final ResourceKey<PlacedFeature> TREES_SAVANNA = PlacementUtils.createKey("trees_savanna");
    public static final ResourceKey<PlacedFeature> BIRCH_TALL = PlacementUtils.createKey("birch_tall");
    public static final ResourceKey<PlacedFeature> TREES_BIRCH = PlacementUtils.createKey("trees_birch");
    public static final ResourceKey<PlacedFeature> TREES_WINDSWEPT_FOREST = PlacementUtils.createKey("trees_windswept_forest");
    public static final ResourceKey<PlacedFeature> TREES_WINDSWEPT_HILLS = PlacementUtils.createKey("trees_windswept_hills");
    public static final ResourceKey<PlacedFeature> TREES_WATER = PlacementUtils.createKey("trees_water");
    public static final ResourceKey<PlacedFeature> TREES_BIRCH_AND_OAK_LEAF_LITTER = PlacementUtils.createKey("trees_birch_and_oak_leaf_litter");
    public static final ResourceKey<PlacedFeature> TREES_SPARSE_JUNGLE = PlacementUtils.createKey("trees_sparse_jungle");
    public static final ResourceKey<PlacedFeature> TREES_OLD_GROWTH_SPRUCE_TAIGA = PlacementUtils.createKey("trees_old_growth_spruce_taiga");
    public static final ResourceKey<PlacedFeature> TREES_OLD_GROWTH_PINE_TAIGA = PlacementUtils.createKey("trees_old_growth_pine_taiga");
    public static final ResourceKey<PlacedFeature> TREES_JUNGLE = PlacementUtils.createKey("trees_jungle");
    public static final ResourceKey<PlacedFeature> BAMBOO_VEGETATION = PlacementUtils.createKey("bamboo_vegetation");
    public static final ResourceKey<PlacedFeature> MUSHROOM_ISLAND_VEGETATION = PlacementUtils.createKey("mushroom_island_vegetation");
    public static final ResourceKey<PlacedFeature> TREES_MANGROVE = PlacementUtils.createKey("trees_mangrove");
    private static final PlacementModifier TREE_THRESHOLD = SurfaceWaterDepthFilter.forMaxDepth(0);

    public static List<PlacementModifier> worldSurfaceSquaredWithCount(int var0) {
        return List.of(CountPlacement.of(var0), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
    }

    private static List<PlacementModifier> getMushroomPlacement(int var0, @Nullable PlacementModifier var1) {
        ImmutableList.Builder var2 = ImmutableList.builder();
        if (var1 != null) {
            var2.add((Object)var1);
        }
        if (var0 != 0) {
            var2.add((Object)RarityFilter.onAverageOnceEvery(var0));
        }
        var2.add((Object)InSquarePlacement.spread());
        var2.add((Object)PlacementUtils.HEIGHTMAP);
        var2.add((Object)BiomeFilter.biome());
        return var2.build();
    }

    private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier var0) {
        return ImmutableList.builder().add((Object)var0).add((Object)InSquarePlacement.spread()).add((Object)TREE_THRESHOLD).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome());
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier var0) {
        return VegetationPlacements.treePlacementBase(var0).build();
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier var0, Block var1) {
        return VegetationPlacements.treePlacementBase(var0).add((Object)BlockPredicateFilter.forPredicate(BlockPredicate.wouldSurvive(var1.defaultBlockState(), BlockPos.ZERO))).build();
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> var0) {
        HolderGetter<ConfiguredFeature<?, ?>> var1 = var0.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference<ConfiguredFeature<?, ?>> var2 = var1.getOrThrow(VegetationFeatures.BAMBOO_NO_PODZOL);
        Holder.Reference<ConfiguredFeature<?, ?>> var3 = var1.getOrThrow(VegetationFeatures.BAMBOO_SOME_PODZOL);
        Holder.Reference<ConfiguredFeature<?, ?>> var4 = var1.getOrThrow(VegetationFeatures.VINES);
        Holder.Reference<ConfiguredFeature<?, ?>> var5 = var1.getOrThrow(VegetationFeatures.PATCH_SUNFLOWER);
        Holder.Reference<ConfiguredFeature<?, ?>> var6 = var1.getOrThrow(VegetationFeatures.PATCH_PUMPKIN);
        Holder.Reference<ConfiguredFeature<?, ?>> var7 = var1.getOrThrow(VegetationFeatures.PATCH_GRASS);
        Holder.Reference<ConfiguredFeature<?, ?>> var8 = var1.getOrThrow(VegetationFeatures.PATCH_GRASS_MEADOW);
        Holder.Reference<ConfiguredFeature<?, ?>> var9 = var1.getOrThrow(VegetationFeatures.PATCH_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> var10 = var1.getOrThrow(VegetationFeatures.PATCH_TAIGA_GRASS);
        Holder.Reference<ConfiguredFeature<?, ?>> var11 = var1.getOrThrow(VegetationFeatures.PATCH_GRASS_JUNGLE);
        Holder.Reference<ConfiguredFeature<?, ?>> var12 = var1.getOrThrow(VegetationFeatures.SINGLE_PIECE_OF_GRASS);
        Holder.Reference<ConfiguredFeature<?, ?>> var13 = var1.getOrThrow(VegetationFeatures.PATCH_DEAD_BUSH);
        Holder.Reference<ConfiguredFeature<?, ?>> var14 = var1.getOrThrow(VegetationFeatures.PATCH_DRY_GRASS);
        Holder.Reference<ConfiguredFeature<?, ?>> var15 = var1.getOrThrow(VegetationFeatures.PATCH_FIREFLY_BUSH);
        Holder.Reference<ConfiguredFeature<?, ?>> var16 = var1.getOrThrow(VegetationFeatures.PATCH_MELON);
        Holder.Reference<ConfiguredFeature<?, ?>> var17 = var1.getOrThrow(VegetationFeatures.PATCH_BERRY_BUSH);
        Holder.Reference<ConfiguredFeature<?, ?>> var18 = var1.getOrThrow(VegetationFeatures.PATCH_WATERLILY);
        Holder.Reference<ConfiguredFeature<?, ?>> var19 = var1.getOrThrow(VegetationFeatures.PATCH_TALL_GRASS);
        Holder.Reference<ConfiguredFeature<?, ?>> var20 = var1.getOrThrow(VegetationFeatures.PATCH_LARGE_FERN);
        Holder.Reference<ConfiguredFeature<?, ?>> var21 = var1.getOrThrow(VegetationFeatures.PATCH_BUSH);
        Holder.Reference<ConfiguredFeature<?, ?>> var22 = var1.getOrThrow(VegetationFeatures.PATCH_CACTUS);
        Holder.Reference<ConfiguredFeature<?, ?>> var23 = var1.getOrThrow(VegetationFeatures.PATCH_SUGAR_CANE);
        Holder.Reference<ConfiguredFeature<?, ?>> var24 = var1.getOrThrow(VegetationFeatures.PATCH_BROWN_MUSHROOM);
        Holder.Reference<ConfiguredFeature<?, ?>> var25 = var1.getOrThrow(VegetationFeatures.PATCH_RED_MUSHROOM);
        Holder.Reference<ConfiguredFeature<?, ?>> var26 = var1.getOrThrow(VegetationFeatures.FLOWER_DEFAULT);
        Holder.Reference<ConfiguredFeature<?, ?>> var27 = var1.getOrThrow(VegetationFeatures.FLOWER_FLOWER_FOREST);
        Holder.Reference<ConfiguredFeature<?, ?>> var28 = var1.getOrThrow(VegetationFeatures.FLOWER_SWAMP);
        Holder.Reference<ConfiguredFeature<?, ?>> var29 = var1.getOrThrow(VegetationFeatures.FLOWER_PLAIN);
        Holder.Reference<ConfiguredFeature<?, ?>> var30 = var1.getOrThrow(VegetationFeatures.FLOWER_MEADOW);
        Holder.Reference<ConfiguredFeature<?, ?>> var31 = var1.getOrThrow(VegetationFeatures.FLOWER_CHERRY);
        Holder.Reference<ConfiguredFeature<?, ?>> var32 = var1.getOrThrow(VegetationFeatures.FLOWER_PALE_GARDEN);
        Holder.Reference<ConfiguredFeature<?, ?>> var33 = var1.getOrThrow(VegetationFeatures.WILDFLOWERS_BIRCH_FOREST);
        Holder.Reference<ConfiguredFeature<?, ?>> var34 = var1.getOrThrow(VegetationFeatures.WILDFLOWERS_MEADOW);
        Holder.Reference<ConfiguredFeature<?, ?>> var35 = var1.getOrThrow(VegetationFeatures.TREES_PLAINS);
        Holder.Reference<ConfiguredFeature<?, ?>> var36 = var1.getOrThrow(VegetationFeatures.DARK_FOREST_VEGETATION);
        Holder.Reference<ConfiguredFeature<?, ?>> var37 = var1.getOrThrow(VegetationFeatures.PALE_GARDEN_VEGETATION);
        Holder.Reference<ConfiguredFeature<?, ?>> var38 = var1.getOrThrow(VegetationFeatures.FOREST_FLOWERS);
        Holder.Reference<ConfiguredFeature<?, ?>> var39 = var1.getOrThrow(VegetationFeatures.PALE_FOREST_FLOWERS);
        Holder.Reference<ConfiguredFeature<?, ?>> var40 = var1.getOrThrow(VegetationFeatures.PALE_MOSS_PATCH);
        Holder.Reference<ConfiguredFeature<?, ?>> var41 = var1.getOrThrow(VegetationFeatures.TREES_FLOWER_FOREST);
        Holder.Reference<ConfiguredFeature<?, ?>> var42 = var1.getOrThrow(VegetationFeatures.MEADOW_TREES);
        Holder.Reference<ConfiguredFeature<?, ?>> var43 = var1.getOrThrow(VegetationFeatures.TREES_TAIGA);
        Holder.Reference<ConfiguredFeature<?, ?>> var44 = var1.getOrThrow(VegetationFeatures.TREES_BADLANDS);
        Holder.Reference<ConfiguredFeature<?, ?>> var45 = var1.getOrThrow(VegetationFeatures.TREES_GROVE);
        Holder.Reference<ConfiguredFeature<?, ?>> var46 = var1.getOrThrow(VegetationFeatures.TREES_SNOWY);
        Holder.Reference<ConfiguredFeature<?, ?>> var47 = var1.getOrThrow(TreeFeatures.CHERRY_BEES_005);
        Holder.Reference<ConfiguredFeature<?, ?>> var48 = var1.getOrThrow(TreeFeatures.SWAMP_OAK);
        Holder.Reference<ConfiguredFeature<?, ?>> var49 = var1.getOrThrow(VegetationFeatures.TREES_SAVANNA);
        Holder.Reference<ConfiguredFeature<?, ?>> var50 = var1.getOrThrow(VegetationFeatures.BIRCH_TALL);
        Holder.Reference<ConfiguredFeature<?, ?>> var51 = var1.getOrThrow(VegetationFeatures.TREES_BIRCH);
        Holder.Reference<ConfiguredFeature<?, ?>> var52 = var1.getOrThrow(VegetationFeatures.TREES_WINDSWEPT_HILLS);
        Holder.Reference<ConfiguredFeature<?, ?>> var53 = var1.getOrThrow(VegetationFeatures.TREES_WATER);
        Holder.Reference<ConfiguredFeature<?, ?>> var54 = var1.getOrThrow(VegetationFeatures.TREES_BIRCH_AND_OAK_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> var55 = var1.getOrThrow(VegetationFeatures.TREES_SPARSE_JUNGLE);
        Holder.Reference<ConfiguredFeature<?, ?>> var56 = var1.getOrThrow(VegetationFeatures.TREES_OLD_GROWTH_SPRUCE_TAIGA);
        Holder.Reference<ConfiguredFeature<?, ?>> var57 = var1.getOrThrow(VegetationFeatures.TREES_OLD_GROWTH_PINE_TAIGA);
        Holder.Reference<ConfiguredFeature<?, ?>> var58 = var1.getOrThrow(VegetationFeatures.TREES_JUNGLE);
        Holder.Reference<ConfiguredFeature<?, ?>> var59 = var1.getOrThrow(VegetationFeatures.BAMBOO_VEGETATION);
        Holder.Reference<ConfiguredFeature<?, ?>> var60 = var1.getOrThrow(VegetationFeatures.MUSHROOM_ISLAND_VEGETATION);
        Holder.Reference<ConfiguredFeature<?, ?>> var61 = var1.getOrThrow(VegetationFeatures.MANGROVE_VEGETATION);
        PlacementUtils.register(var0, BAMBOO_LIGHT, var2, RarityFilter.onAverageOnceEvery(4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, BAMBOO, var3, NoiseBasedCountPlacement.of(160, 80.0, 0.3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, VINES, var4, CountPlacement.of(127), InSquarePlacement.spread(), HeightRangePlacement.uniform(VerticalAnchor.absolute(64), VerticalAnchor.absolute(100)), BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_SUNFLOWER, var5, RarityFilter.onAverageOnceEvery(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_PUMPKIN, var6, RarityFilter.onAverageOnceEvery(300), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_GRASS_PLAIN, var7, NoiseThresholdCountPlacement.of(-0.8, 5, 10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_GRASS_MEADOW, var8, NoiseThresholdCountPlacement.of(-0.8, 5, 10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_GRASS_FOREST, var7, VegetationPlacements.worldSurfaceSquaredWithCount(2));
        PlacementUtils.register(var0, PATCH_LEAF_LITTER, var9, VegetationPlacements.worldSurfaceSquaredWithCount(2));
        PlacementUtils.register(var0, PATCH_GRASS_BADLANDS, var7, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_GRASS_SAVANNA, var7, VegetationPlacements.worldSurfaceSquaredWithCount(20));
        PlacementUtils.register(var0, PATCH_GRASS_NORMAL, var7, VegetationPlacements.worldSurfaceSquaredWithCount(5));
        PlacementUtils.register(var0, PATCH_GRASS_TAIGA_2, var10, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_GRASS_TAIGA, var10, VegetationPlacements.worldSurfaceSquaredWithCount(7));
        PlacementUtils.register(var0, PATCH_GRASS_JUNGLE, var11, VegetationPlacements.worldSurfaceSquaredWithCount(25));
        PlacementUtils.register(var0, GRASS_BONEMEAL, var12, PlacementUtils.isEmpty());
        PlacementUtils.register(var0, PATCH_DEAD_BUSH_2, var13, VegetationPlacements.worldSurfaceSquaredWithCount(2));
        PlacementUtils.register(var0, PATCH_DEAD_BUSH, var13, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_DEAD_BUSH_BADLANDS, var13, VegetationPlacements.worldSurfaceSquaredWithCount(20));
        PlacementUtils.register(var0, PATCH_DRY_GRASS_BADLANDS, var14, RarityFilter.onAverageOnceEvery(6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_DRY_GRASS_DESERT, var14, RarityFilter.onAverageOnceEvery(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_MELON, var16, RarityFilter.onAverageOnceEvery(6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_MELON_SPARSE, var16, RarityFilter.onAverageOnceEvery(64), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_BERRY_COMMON, var17, RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_BERRY_RARE, var17, RarityFilter.onAverageOnceEvery(384), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_WATERLILY, var18, VegetationPlacements.worldSurfaceSquaredWithCount(4));
        PlacementUtils.register(var0, PATCH_TALL_GRASS_2, var19, NoiseThresholdCountPlacement.of(-0.8, 0, 7), RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_TALL_GRASS, var19, RarityFilter.onAverageOnceEvery(5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_LARGE_FERN, var20, RarityFilter.onAverageOnceEvery(5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_BUSH, var21, RarityFilter.onAverageOnceEvery(4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_CACTUS_DESERT, var22, RarityFilter.onAverageOnceEvery(6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_CACTUS_DECORATED, var22, RarityFilter.onAverageOnceEvery(13), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_SUGAR_CANE_SWAMP, var23, RarityFilter.onAverageOnceEvery(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_SUGAR_CANE_DESERT, var23, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_SUGAR_CANE_BADLANDS, var23, RarityFilter.onAverageOnceEvery(5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_SUGAR_CANE, var23, RarityFilter.onAverageOnceEvery(6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, PATCH_FIREFLY_BUSH_NEAR_WATER, var15, CountPlacement.of(2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_NO_LEAVES, BiomeFilter.biome(), VegetationFeatures.nearWaterPredicate(Blocks.FIREFLY_BUSH));
        PlacementUtils.register(var0, PATCH_FIREFLY_BUSH_NEAR_WATER_SWAMP, var15, CountPlacement.of(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), VegetationFeatures.nearWaterPredicate(Blocks.FIREFLY_BUSH));
        PlacementUtils.register(var0, PATCH_FIREFLY_BUSH_SWAMP, var15, RarityFilter.onAverageOnceEvery(8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, BROWN_MUSHROOM_NETHER, var24, RarityFilter.onAverageOnceEvery(2), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome());
        PlacementUtils.register(var0, RED_MUSHROOM_NETHER, var25, RarityFilter.onAverageOnceEvery(2), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome());
        PlacementUtils.register(var0, BROWN_MUSHROOM_NORMAL, var24, VegetationPlacements.getMushroomPlacement(256, null));
        PlacementUtils.register(var0, RED_MUSHROOM_NORMAL, var25, VegetationPlacements.getMushroomPlacement(512, null));
        PlacementUtils.register(var0, BROWN_MUSHROOM_TAIGA, var24, VegetationPlacements.getMushroomPlacement(4, null));
        PlacementUtils.register(var0, RED_MUSHROOM_TAIGA, var25, VegetationPlacements.getMushroomPlacement(256, null));
        PlacementUtils.register(var0, BROWN_MUSHROOM_OLD_GROWTH, var24, VegetationPlacements.getMushroomPlacement(4, CountPlacement.of(3)));
        PlacementUtils.register(var0, RED_MUSHROOM_OLD_GROWTH, var25, VegetationPlacements.getMushroomPlacement(171, null));
        PlacementUtils.register(var0, BROWN_MUSHROOM_SWAMP, var24, VegetationPlacements.getMushroomPlacement(0, CountPlacement.of(2)));
        PlacementUtils.register(var0, RED_MUSHROOM_SWAMP, var25, VegetationPlacements.getMushroomPlacement(64, null));
        PlacementUtils.register(var0, FLOWER_WARM, var26, RarityFilter.onAverageOnceEvery(16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_DEFAULT, var26, RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_FLOWER_FOREST, var27, CountPlacement.of(3), RarityFilter.onAverageOnceEvery(2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_SWAMP, var28, RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_PLAINS, var29, NoiseThresholdCountPlacement.of(-0.8, 15, 4), RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_CHERRY, var31, NoiseThresholdCountPlacement.of(-0.8, 5, 10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_MEADOW, var30, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_PALE_GARDEN, var32, RarityFilter.onAverageOnceEvery(32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, WILDFLOWERS_BIRCH_FOREST, var33, CountPlacement.of(3), RarityFilter.onAverageOnceEvery(2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, WILDFLOWERS_MEADOW, var34, NoiseThresholdCountPlacement.of(-0.8, 5, 10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        SurfaceWaterDepthFilter var62 = SurfaceWaterDepthFilter.forMaxDepth(0);
        PlacementUtils.register(var0, TREES_PLAINS, var35, PlacementUtils.countExtra(0, 0.05f, 1), InSquarePlacement.spread(), var62, PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate(BlockPredicate.wouldSurvive(Blocks.OAK_SAPLING.defaultBlockState(), BlockPos.ZERO)), BiomeFilter.biome());
        PlacementUtils.register(var0, DARK_FOREST_VEGETATION, var36, CountPlacement.of(16), InSquarePlacement.spread(), var62, PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome());
        PlacementUtils.register(var0, PALE_GARDEN_VEGETATION, var37, CountPlacement.of(16), InSquarePlacement.spread(), var62, PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome());
        PlacementUtils.register(var0, FLOWER_FOREST_FLOWERS, var38, RarityFilter.onAverageOnceEvery(7), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, CountPlacement.of(ClampedInt.of(UniformInt.of(-1, 3), 0, 3)), BiomeFilter.biome());
        PlacementUtils.register(var0, FOREST_FLOWERS, var38, RarityFilter.onAverageOnceEvery(7), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, CountPlacement.of(ClampedInt.of(UniformInt.of(-3, 1), 0, 1)), BiomeFilter.biome());
        PlacementUtils.register(var0, PALE_GARDEN_FLOWERS, var39, RarityFilter.onAverageOnceEvery(8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_NO_LEAVES, BiomeFilter.biome());
        PlacementUtils.register(var0, PALE_MOSS_PATCH, var40, CountPlacement.of(1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_NO_LEAVES, BiomeFilter.biome());
        PlacementUtils.register(var0, TREES_FLOWER_FOREST, var41, VegetationPlacements.treePlacement(PlacementUtils.countExtra(6, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_MEADOW, var42, VegetationPlacements.treePlacement(RarityFilter.onAverageOnceEvery(100)));
        PlacementUtils.register(var0, TREES_CHERRY, var47, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1), Blocks.CHERRY_SAPLING));
        PlacementUtils.register(var0, TREES_TAIGA, var43, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_GROVE, var45, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_BADLANDS, var44, VegetationPlacements.treePlacement(PlacementUtils.countExtra(5, 0.1f, 1), Blocks.OAK_SAPLING));
        PlacementUtils.register(var0, TREES_SNOWY, var46, VegetationPlacements.treePlacement(PlacementUtils.countExtra(0, 0.1f, 1), Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(var0, TREES_SWAMP, var48, PlacementUtils.countExtra(2, 0.1f, 1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth(2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate(BlockPredicate.wouldSurvive(Blocks.OAK_SAPLING.defaultBlockState(), BlockPos.ZERO)));
        PlacementUtils.register(var0, TREES_WINDSWEPT_SAVANNA, var49, VegetationPlacements.treePlacement(PlacementUtils.countExtra(2, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_SAVANNA, var49, VegetationPlacements.treePlacement(PlacementUtils.countExtra(1, 0.1f, 1)));
        PlacementUtils.register(var0, BIRCH_TALL, var50, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_BIRCH, var51, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1), Blocks.BIRCH_SAPLING));
        PlacementUtils.register(var0, TREES_WINDSWEPT_FOREST, var52, VegetationPlacements.treePlacement(PlacementUtils.countExtra(3, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_WINDSWEPT_HILLS, var52, VegetationPlacements.treePlacement(PlacementUtils.countExtra(0, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_WATER, var53, VegetationPlacements.treePlacement(PlacementUtils.countExtra(0, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_BIRCH_AND_OAK_LEAF_LITTER, var54, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_SPARSE_JUNGLE, var55, VegetationPlacements.treePlacement(PlacementUtils.countExtra(2, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_OLD_GROWTH_SPRUCE_TAIGA, var56, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_OLD_GROWTH_PINE_TAIGA, var57, VegetationPlacements.treePlacement(PlacementUtils.countExtra(10, 0.1f, 1)));
        PlacementUtils.register(var0, TREES_JUNGLE, var58, VegetationPlacements.treePlacement(PlacementUtils.countExtra(50, 0.1f, 1)));
        PlacementUtils.register(var0, BAMBOO_VEGETATION, var59, VegetationPlacements.treePlacement(PlacementUtils.countExtra(30, 0.1f, 1)));
        PlacementUtils.register(var0, MUSHROOM_ISLAND_VEGETATION, var60, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, TREES_MANGROVE, var61, CountPlacement.of(25), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth(5), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate(BlockPredicate.wouldSurvive(Blocks.MANGROVE_PROPAGULE.defaultBlockState(), BlockPos.ZERO)));
    }
}

