/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.serialization.Codec;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.SignatureUpdater;

public record LastSeenMessages(List<MessageSignature> entries) {
    public static final Codec<LastSeenMessages> CODEC = MessageSignature.CODEC.listOf().xmap(LastSeenMessages::new, LastSeenMessages::entries);
    public static LastSeenMessages EMPTY = new LastSeenMessages(List.of());
    public static final int LAST_SEEN_MESSAGES_MAX_LENGTH = 20;

    public void updateSignature(SignatureUpdater.Output var0) throws SignatureException {
        var0.update(Ints.toByteArray((int)this.entries.size()));
        for (MessageSignature var2 : this.entries) {
            var0.update(var2.bytes());
        }
    }

    public Packed pack(MessageSignatureCache var0) {
        return new Packed(this.entries.stream().map(var1 -> var1.pack(var0)).toList());
    }

    public byte computeChecksum() {
        int var0 = 1;
        for (MessageSignature var2 : this.entries) {
            var0 = 31 * var0 + var2.checksum();
        }
        byte var1 = (byte)var0;
        return var1 == 0 ? (byte)1 : var1;
    }

    public record Packed(List<MessageSignature.Packed> entries) {
        public static final Packed EMPTY = new Packed(List.of());

        public Packed(FriendlyByteBuf var0) {
            this(var0.readCollection(FriendlyByteBuf.limitValue(ArrayList::new, 20), MessageSignature.Packed::read));
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeCollection(this.entries, MessageSignature.Packed::write);
        }

        public Optional<LastSeenMessages> unpack(MessageSignatureCache var0) {
            ArrayList<MessageSignature> var1 = new ArrayList<MessageSignature>(this.entries.size());
            for (MessageSignature.Packed var3 : this.entries) {
                Optional<MessageSignature> var4 = var3.unpack(var0);
                if (var4.isEmpty()) {
                    return Optional.empty();
                }
                var1.add(var4.get());
            }
            return Optional.of(new LastSeenMessages(var1));
        }
    }

    public record Update(int offset, BitSet acknowledged, byte checksum) {
        public static final byte IGNORE_CHECKSUM = 0;

        public Update(FriendlyByteBuf var0) {
            this(var0.readVarInt(), var0.readFixedBitSet(20), var0.readByte());
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeVarInt(this.offset);
            var0.writeFixedBitSet(this.acknowledged, 20);
            var0.writeByte(this.checksum);
        }

        public boolean verifyChecksum(LastSeenMessages var0) {
            return this.checksum == 0 || this.checksum == var0.computeChecksum();
        }
    }
}

