/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import org.jetbrains.annotations.VisibleForTesting;

public class MessageSignatureCache {
    public static final int NOT_FOUND = -1;
    private static final int DEFAULT_CAPACITY = 128;
    private final MessageSignature[] entries;

    public MessageSignatureCache(int var0) {
        this.entries = new MessageSignature[var0];
    }

    public static MessageSignatureCache createDefault() {
        return new MessageSignatureCache(128);
    }

    public int pack(MessageSignature var0) {
        for (int var1 = 0; var1 < this.entries.length; ++var1) {
            if (!var0.equals(this.entries[var1])) continue;
            return var1;
        }
        return -1;
    }

    @Nullable
    public MessageSignature unpack(int var0) {
        return this.entries[var0];
    }

    public void push(SignedMessageBody var0, @Nullable MessageSignature var1) {
        List<MessageSignature> var2 = var0.lastSeen().entries();
        ArrayDeque<MessageSignature> var3 = new ArrayDeque<MessageSignature>(var2.size() + 1);
        var3.addAll(var2);
        if (var1 != null) {
            var3.add(var1);
        }
        this.push(var3);
    }

    @VisibleForTesting
    void push(List<MessageSignature> var0) {
        this.push(new ArrayDeque<MessageSignature>(var0));
    }

    private void push(ArrayDeque<MessageSignature> var0) {
        ObjectOpenHashSet var1 = new ObjectOpenHashSet(var0);
        for (int var2 = 0; !var0.isEmpty() && var2 < this.entries.length; ++var2) {
            MessageSignature var3 = this.entries[var2];
            this.entries[var2] = var0.removeLast();
            if (var3 == null || var1.contains(var3)) continue;
            var0.addFirst(var3);
        }
    }
}

