/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import org.slf4j.Logger;

public class PacketUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T t0, ServerLevel worldserver) throws RunningOnDifferentThreadException {
        PacketUtils.ensureRunningOnSameThread(packet, t0, worldserver.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T t0, BlockableEventLoop<?> iasynctaskhandler) throws RunningOnDifferentThreadException {
        if (!iasynctaskhandler.isSameThread()) {
            iasynctaskhandler.executeIfPossible(() -> {
                if (t0 instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)t0;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (t0.shouldHandleMessage(packet)) {
                    try {
                        packet.handle(t0);
                    }
                    catch (Exception exception) {
                        ReportedException reportedexception;
                        if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                            throw PacketUtils.makeReportedException(exception, packet, t0);
                        }
                        t0.onPacketError(packet, exception);
                    }
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                }
            });
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception exception, Packet<T> packet, T t0) {
        if (exception instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)exception;
            PacketUtils.fillCrashReport(reportedexception.getReport(), t0, packet);
            return reportedexception;
        }
        CrashReport crashreport = CrashReport.forThrowable(exception, "Main thread packet handler");
        PacketUtils.fillCrashReport(crashreport, t0, packet);
        return new ReportedException(crashreport);
    }

    public static <T extends PacketListener> void fillCrashReport(CrashReport crashreport, T t0, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Incoming Packet");
            crashreportsystemdetails.setDetail("Type", () -> packet.type().toString());
            crashreportsystemdetails.setDetail("Is Terminal", () -> Boolean.toString(packet.isTerminal()));
            crashreportsystemdetails.setDetail("Is Skippable", () -> Boolean.toString(packet.isSkippable()));
        }
        t0.fillCrashReport(crashreport);
    }
}

